/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.List;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateEJB;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AValidateRemote
extends AValidateEJB {
    public final Object getTarget(Object parent, Object clazz) {
        if (parent == null) {
            return null;
        }
        return ((EnterpriseBean)parent).getRemoteInterface();
    }

    public final List[] getMethodsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        JavaClass beanClass = bean.getEjbClass();
        List[] result = new List[]{beanClass == null ? null : beanClass.getMethodsExtended()};
        return result;
    }

    public final List[] getFieldsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        return null;
    }

    protected boolean isValid(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedList) throws InvalidInputException {
        if (super.isValid(vc, bean, clazz, method2, methodsExtendedList)) {
            if (ValidationRuleUtility.isEJBObjectMethod(bean, method2)) {
                return false;
            }
            if (this.isEjbRelationshipRoleMethod(vc, bean, clazz, method2)) {
                return false;
            }
            return !ValidationRuleUtility.isClinitMethod(bean, method2);
        }
        return false;
    }

    public void primValidate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method riMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        this.validateLegalRMIMethod(vc, bean, clazz, riMethod);
        this.validateMethod_beanDep(vc, bean, clazz, riMethod);
    }

    protected void primValidateExistence(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method ejbMethod) throws InvalidInputException {
    }

    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        JavaHelpers javaxEjbObject;
        vc.terminateIfCancelled();
        if (!clazz.isInterface()) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2012", 1, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!ValidationRuleUtility.isAssignableFrom(clazz, javaxEjbObject = ValidationRuleUtility.getType("javax.ejb.EJBObject", bean))) {
            String[] msgParm = new String[]{"javax.ejb.EJBObject"};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2017", 1, bean, clazz, msgParm, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (ValidationRuleUtility.isUnnamedPackage(clazz.getJavaPackage())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2041", 4, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateAppendixB(vc, bean, clazz);
    }

    public void validateMatchingBeanMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method remoteMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (remoteMethod == null) {
            return;
        }
        JavaClass beanClass = bean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(bean, beanClass);
        Method beanMethod = ValidationRuleUtility.getMethodExtended(beanClass, remoteMethod, remoteMethod.getName());
        if (beanMethod == null) {
            String[] msgParm = new String[]{beanClass.getName()};
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2023", 1, bean, clazz, remoteMethod, msgParm, (IValidationRule)this);
            vc.addMessage(message);
            return;
        }
        ValidationRuleUtility.isValidType(ValidationRuleUtility.getType(remoteMethod.getReturnType()));
        try {
            ValidationRuleUtility.isValidType(ValidationRuleUtility.getType(beanMethod.getReturnType()));
        }
        catch (InvalidInputException e) {
            return;
        }
        vc.terminateIfCancelled();
        if (!ValidationRuleUtility.isAssignableFrom(remoteMethod.getReturnType(), beanMethod.getReturnType())) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2415", 1, bean, clazz, remoteMethod, new String[]{beanMethod.getReturnType().getJavaName(), beanClass.getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateMethod_beanDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method riMethod) throws InvalidInputException {
        vc.terminateIfCancelled();
        this.validateMatchingBeanMethod(vc, bean, clazz, riMethod);
    }

    protected void validateMethodExists(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
    }

    protected void validateAppendixB(IEJBValidationContext vc, EnterpriseBean bean, JavaClass thisRemote) {
        if (bean == null) {
            return;
        }
        EnterpriseBean supertype = this.getSuperType(bean);
        JavaClass parentRemote = null;
        if (supertype != null) {
            parentRemote = supertype.getRemoteInterface();
            try {
                ValidationRuleUtility.isValidType(thisRemote);
                ValidationRuleUtility.isValidType(parentRemote);
                if (!ValidationRuleUtility.isAssignableFrom(thisRemote, parentRemote)) {
                    String[] msgParm = new String[]{thisRemote.getQualifiedName(), parentRemote.getQualifiedName()};
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2105", 1, bean, thisRemote, msgParm, (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            catch (InvalidInputException e) {
                String[] msgParm = new String[]{e.getJavaClass().getQualifiedName(), bean.getName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2849", 2, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }
}

