/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deploy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistryReader;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IRuntime;

public class DeployerRegistry {
    private static DeployerRegistry INSTANCE;
    private HashMap deployModuleExtensions = new HashMap();

    public void register(IConfigurationElement deployer, List serverTargets, List natures) {
        Iterator iter = natures.iterator();
        while (iter.hasNext()) {
            String natureID = (String)iter.next();
            Iterator iterator = serverTargets.iterator();
            while (iterator.hasNext()) {
                String runtimeID = (String)iterator.next();
                HashMap targetDeployers = this.getDeployModuleExtensions(natureID);
                this.getTargetDeployers(targetDeployers, runtimeID).add(deployer);
            }
        }
    }

    private List getDeployers(String natureID, String serverTarget) {
        HashMap targetDeployers = this.getDeployModuleExtensions(natureID);
        return this.getTargetDeployers(targetDeployers, serverTarget);
    }

    public static DeployerRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new DeployerRegistry();
            DeployerRegistry.readRegistry();
        }
        return INSTANCE;
    }

    private static void readRegistry() {
        DeployerRegistryReader reader = new DeployerRegistryReader();
        reader.readRegistry();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getSelectedModules(Object[] mySelections) {
        ArrayList<EObject> modules = new ArrayList<EObject>();
        int i = 0;
        while (i < mySelections.length) {
            block10: {
                Object var7_7;
                Object object = mySelections[i];
                if (object instanceof EObject) {
                    object = ProjectUtilities.getProject(object);
                }
                if (!(object instanceof IProject)) break block10;
                IVirtualComponent component2 = ComponentCore.createComponent((IProject)((IProject)object));
                EnterpriseArtifactEdit edit = null;
                try {
                    EObject root;
                    block13: {
                        block12: {
                            block11: {
                                edit = (EnterpriseArtifactEdit)ComponentUtilities.getArtifactEditForRead((IVirtualComponent)component2);
                                if (edit != null) break block11;
                                break block12;
                            }
                            root = edit.getDeploymentDescriptorRoot();
                            if (root != null && !modules.contains(root)) break block13;
                        }
                        var7_7 = null;
                        if (edit != null) {
                            edit.dispose();
                        }
                        break block10;
                    }
                    if (J2EEProjectUtilities.isEARProject(component2.getProject())) {
                        modules.add(0, root);
                    } else {
                        modules.add(root);
                    }
                    var7_7 = null;
                    if (edit == null) break block10;
                }
                catch (Throwable throwable) {
                    var7_7 = null;
                    if (edit != null) {
                        edit.dispose();
                    }
                    throw throwable;
                }
                edit.dispose();
            }
            ++i;
        }
        return modules;
    }

    private List getTargetDeployers(HashMap targetDeployers, String serverTarget) {
        if (targetDeployers.get(serverTarget) == null) {
            targetDeployers.put(serverTarget, new ArrayList());
        }
        return (List)targetDeployers.get(serverTarget);
    }

    private HashMap getDeployModuleExtensions(String natureID) {
        if (this.getDeployModuleExtensions().get(natureID) == null) {
            this.getDeployModuleExtensions().put(natureID, new HashMap());
        }
        return (HashMap)this.getDeployModuleExtensions().get(natureID);
    }

    public HashMap getDeployModuleExtensions() {
        return this.deployModuleExtensions;
    }

    public void setDeployModuleExtensions(HashMap deployExtensions) {
        this.deployModuleExtensions = deployExtensions;
    }

    public List getDeployModuleExtensions(EObject module, IRuntime runtime2) {
        IVirtualComponent comp = ComponentUtilities.findComponent((EObject)module);
        String typeID = "";
        if (J2EEProjectUtilities.isEARProject(comp.getProject())) {
            typeID = "jst.ear";
        } else if (J2EEProjectUtilities.isApplicationClientProject(comp.getProject())) {
            typeID = "jst.appclient";
        } else if (J2EEProjectUtilities.isDynamicWebProject(comp.getProject())) {
            typeID = "jst.web";
        } else if (J2EEProjectUtilities.isStaticWebProject(comp.getProject())) {
            typeID = "wst.web";
        } else if (J2EEProjectUtilities.isEJBProject(comp.getProject())) {
            typeID = "jst.ejb";
        } else if (J2EEProjectUtilities.isJCAProject(comp.getProject())) {
            typeID = "jst.connector";
        } else if (J2EEProjectUtilities.isUtilityProject(comp.getProject())) {
            typeID = "jst.utility";
        }
        String runtimeID = runtime2.getRuntimeType().getId();
        return this.getDeployers(typeID, runtimeID);
    }
}

