/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfiguration;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseModule;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigFactory;

public class LooseConfigRegister {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    private static String className = LooseConfigRegister.class.getName();
    protected static LooseConfigRegister singleton;
    private Map looseApplicationMap;
    protected boolean loadAttempted = false;
    protected LooseConfiguration looseConfiguration;
    public static final String LOOSE_CONFIG_PROPERTY = "was.loose.config";
    protected static final boolean DO_LOAD = true;

    public static LooseConfigRegister singleton() {
        String methodName = "singleton";
        logger.entering(className, methodName);
        if (singleton == null) {
            singleton = new LooseConfigRegister();
            logger.logp(Level.FINER, className, methodName, "Constructed register singleton.");
        }
        logger.exiting(className, methodName, singleton);
        return singleton;
    }

    protected LooseConfigRegister() {
    }

    public List getLooseChildren(LooseArchive looseArchive) {
        String methodName = "getLooseChildren";
        logger.entering(className, methodName, looseArchive);
        if (looseArchive != null) {
            if (looseArchive.isEAR()) {
                EList list = ((LooseApplication)looseArchive).getLooseArchives();
                String listSize = Integer.toString(list.size());
                logger.logp(Level.FINER, className, methodName, "RETURN - list of [ {0} ] EAR file loose children", listSize);
                return list;
            }
            if (looseArchive.isWAR()) {
                EList list = ((LooseWARFile)looseArchive).getLooseLibs();
                String listSize = Integer.toString(list.size());
                logger.logp(Level.FINER, className, methodName, "RETURN - list of [ {0} ] WAR file loose children", listSize);
                return list;
            }
        }
        logger.exiting(className, methodName, "Empty list of loose children");
        return Collections.EMPTY_LIST;
    }

    public LooseArchive findFirstLooseChild(String path, LooseArchive looseArchive) {
        String methodName = "findFirstLooseChild";
        logger.entering(className, methodName, path);
        String path_platform = LooseConfigRegister.normalize(path);
        Iterator children = this.getLooseChildren(looseArchive).iterator();
        LooseArchive selectedChild = null;
        while (selectedChild == null && children.hasNext()) {
            LooseArchive nextChild = (LooseArchive)children.next();
            String nextChildPath = nextChild.getUri();
            String nextChildPath_platform = LooseConfigRegister.normalize(nextChildPath);
            if (!LooseConfigRegister.stringsEqual(path_platform, nextChildPath_platform)) continue;
            if (!LooseConfigRegister.stringsEqual(path, nextChildPath)) {
                logger.logp(Level.FINER, className, methodName, "WARNING Normalized match of [ {0} ]  with [ {1} ]", new Object[]{path, nextChildPath});
            }
            selectedChild = nextChild;
        }
        if (selectedChild != null) {
            logger.exiting(className, methodName, selectedChild.getUri());
        } else {
            logger.exiting(className, methodName, null);
        }
        return selectedChild;
    }

    public LooseModule findLooseModule(Module module, EARFile ear) {
        String methodName = "findLooseModule";
        logger.entering(className, methodName, module.getUri());
        LooseApplication looseApplication = this.findLooseApplication(ear.getURI());
        if (looseApplication == null) {
            logger.exiting(className, methodName, null);
            return null;
        }
        LooseModule mod = this.findLooseModule(looseApplication, module.getUri(), module.getAltDD());
        if (mod != null) {
            logger.exiting(className, methodName, mod.getUri());
        } else {
            logger.exiting(className, methodName, null);
        }
        return mod;
    }

    public LooseModule findLooseModule(LooseApplication looseApplication, String modulePath, String altDD) {
        String methodName = "findLooseModule";
        logger.entering(className, methodName, new Object[]{looseApplication.getUri(), modulePath, altDD});
        String modulePath_platform = LooseConfigRegister.normalize(modulePath);
        Iterator archives = looseApplication.getLooseArchives().iterator();
        LooseModule selectedModule = null;
        while (selectedModule == null && archives.hasNext()) {
            LooseModule nextModule;
            String nextModulePath;
            String nextModulePath_platform;
            LooseArchive nextElement = (LooseArchive)archives.next();
            if (!nextElement.isModule() || !LooseConfigRegister.stringsEqual(modulePath_platform, nextModulePath_platform = LooseConfigRegister.normalize(nextModulePath = (nextModule = (LooseModule)nextElement).getUri())) || !LooseConfigRegister.stringsEqual(altDD, nextModule.getAltDD())) continue;
            if (!LooseConfigRegister.stringsEqual(modulePath, nextModulePath)) {
                logger.logp(Level.FINER, className, methodName, "WARNING Normalized match of [ {0} ]  with [ {1} ]", new Object[]{modulePath, nextModulePath});
            }
            selectedModule = nextModule;
        }
        logger.exiting(className, methodName, selectedModule);
        return selectedModule;
    }

    public Map getLooseEarMap() {
        return this.getLooseApplicationMap();
    }

    public Map getLooseApplicationMap() {
        if (this.looseApplicationMap == null) {
            this.looseApplicationMap = new HashMap();
        }
        return this.looseApplicationMap;
    }

    public void removeLooseMapping(String applicationPath) {
        this.removeLooseMapping_platform(applicationPath, LooseConfigRegister.normalize(applicationPath));
    }

    protected void removeLooseMapping_platform(String applicationPath, String applicationPath_platform) {
        String methodName = "removeLooseMapping_platform";
        logger.entering(className, methodName, new Object[]{applicationPath, applicationPath_platform});
        if (this.haveDocumentURI() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "Warning: Use of loose mapping APIs with a set loose configuration property.\nThe use of loose mapping APIs is not supported when a loose configuration\nproperty has been set.");
        }
        if (applicationPath_platform == null) {
            logger.exiting(className, methodName);
            return;
        }
        LooseApplication looseApplication = this.findLooseApplicationIfLoaded_platform(applicationPath, applicationPath_platform);
        if (looseApplication != null) {
            logger.logp(Level.FINER, className, methodName, "Loose data was loaded for that application; removing.");
            this.removeLooseApplication(looseApplication);
        } else {
            logger.logp(Level.FINER, className, methodName, "Loose data was not loaded for that application.");
        }
        URI looseConfigURI = (URI)this.getLooseApplicationMap().remove(applicationPath_platform);
        if (looseConfigURI == null) {
            logger.logp(Level.FINER, className, methodName, "No loose mapping was found.");
        } else {
            logger.logp(Level.FINER, className, methodName, "Removed loose mapping [ {0} ]", looseConfigURI);
        }
        logger.exiting(className, methodName);
    }

    public void addLooseMapping(String applicationPath, String looseApplicationURI) {
        String methodName = "addLooseMapping";
        logger.entering(className, methodName, new Object[]{applicationPath, looseApplicationURI});
        String applicationPath_platform = LooseConfigRegister.normalize(applicationPath);
        if (applicationPath_platform == null) {
            logger.exiting(className, methodName, "Null URI; no mapping was adding.");
            return;
        }
        this.removeLooseMapping_platform(applicationPath, applicationPath_platform);
        this.getLooseApplicationMap().put(applicationPath_platform, URI.createURI(looseApplicationURI));
        logger.logp(Level.FINER, className, methodName, "Added loose mapping [ {0} ]", looseApplicationURI);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public void addLooseMapping(Container container, String looseApplicationURI) {
        String methodName = "addLooseMapping";
        logger.entering(className, methodName, new Object[]{container, looseApplicationURI});
        if (container == null) {
            logger.exiting(className, methodName, "Null container; no addition was performed.");
            return;
        }
        this.addLooseMapping(container.getURI(), looseApplicationURI);
        logger.exiting(className, methodName);
    }

    public LooseApplication findLooseApplication(String applicationPath) {
        String methodName = "findLooseApplication";
        logger.entering(className, methodName, applicationPath);
        String applicationPath_platform = LooseConfigRegister.normalize(applicationPath);
        LooseApplication looseApplication = this.findLooseApplicationIfLoaded_platform(applicationPath, applicationPath_platform);
        if (looseApplication != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Loose application [ {0} ] was previously loaded.", applicationPath);
            return looseApplication;
        }
        logger.logp(Level.FINER, className, methodName, "Loose application [ {0} ] not already loaded.", applicationPath);
        if (this.haveDocumentURI()) {
            logger.exiting(className, methodName, "A loose configuration document was specified; no load will be attempted.");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "No loose configuration document for [ {0} ]; attempting load ...", applicationPath);
        URI looseConfigURI = (URI)this.getLooseApplicationMap().get(applicationPath_platform);
        if (looseConfigURI == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN No mapping was set for application [ {0} ]; answering null.", applicationPath);
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "Application mapped to loose configuration URI [ {0} ]", looseConfigURI);
        looseApplication = this.loadLooseApplication(looseConfigURI);
        if (looseApplication == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Load of [ {0} ] was not successful; answering null.", looseConfigURI);
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "Load of [ {0} ] successful ... adding and returning loose application.", looseConfigURI);
        this.addLooseApplication(looseApplication);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", looseApplication);
        return looseApplication;
    }

    public boolean isLooselyMapped(String applicationPath) {
        String methodName = "isLooselyMapped";
        logger.entering(className, methodName, applicationPath);
        boolean isLooselyMappedPath = false;
        String normalizedPath = LooseConfigRegister.normalize(applicationPath);
        if (this.looseApplicationMap != null && this.looseApplicationMap.containsKey(normalizedPath)) {
            isLooselyMappedPath = true;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", Boolean.toString(isLooselyMappedPath));
        return isLooselyMappedPath;
    }

    public boolean getLoadAttempted() {
        return this.loadAttempted;
    }

    public LooseConfiguration primGetLooseConfiguration() {
        return this.looseConfiguration;
    }

    public void flush() {
        String methodName = "flush";
        logger.entering(className, methodName);
        this.loadAttempted = false;
        this.looseConfiguration = null;
        logger.exiting(className, methodName, "Loose configuration has been flushed.");
    }

    public void setLooseConfiguration(LooseConfiguration looseConfiguration) {
        String methodName = "setLooseConfiguration";
        logger.entering(className, methodName, looseConfiguration);
        this.looseConfiguration = looseConfiguration;
        logger.exiting(className, methodName);
    }

    public LooseConfiguration getLooseConfiguration() {
        String methodName = "getLooseConfiguration";
        logger.entering(className, methodName);
        if (this.looseConfiguration == null && !this.loadAttempted) {
            LooseConfiguration useLooseConfiguration;
            logger.logp(Level.FINER, className, methodName, "Loading loose configuration ...");
            Resource res = this.loadLooseConfigurationResource();
            if (res != null && !res.getContents().isEmpty()) {
                logger.logp(Level.FINER, className, methodName, "Loading loose configuration ... retrieving from loaded resource ...");
                useLooseConfiguration = (LooseConfiguration)res.getContents().get(0);
            } else {
                logger.logp(Level.FINER, className, methodName, "Loading loose configuration ... creating new empty configuration ...");
                useLooseConfiguration = LooseconfigFactory.eINSTANCE.createLooseConfiguration();
            }
            this.looseConfiguration = useLooseConfiguration;
            this.loadAttempted = true;
        }
        logger.exiting(className, methodName, this.looseConfiguration);
        return this.looseConfiguration;
    }

    public void addLooseApplication(LooseApplication looseApplication) {
        String methodName = "addLooseApplication";
        logger.entering(className, methodName, looseApplication.getUri());
        this.getLooseConfiguration().getApplications().add(looseApplication);
        logger.exiting(className, methodName);
    }

    public void removeLooseApplication(LooseApplication looseApplication) {
        String methodName = "removeLooseApplication";
        logger.entering(className, methodName, looseApplication.getUri());
        this.getLooseConfiguration().getApplications().remove(looseApplication);
        logger.exiting(className, methodName);
    }

    public Iterator getLooseApplications() {
        return this.getLooseConfiguration().getApplications().iterator();
    }

    public LooseApplication findLooseApplicationIfLoaded(String applicationPath) {
        return this.findLooseApplicationIfLoaded_platform(applicationPath, LooseConfigRegister.normalize(applicationPath));
    }

    protected LooseApplication findLooseApplicationIfLoaded_platform(String applicationPath, String applicationPath_platform) {
        String methodName = "findLooseApplicationIfLoaded_platform";
        logger.entering(className, methodName);
        EList LooseApplications = this.getLooseConfiguration().getApplications();
        if (logger.isLoggable(Level.FINEST)) {
            Iterator i = LooseApplications.iterator();
            String msg = "List of registered loose application URIs:";
            while (i.hasNext()) {
                LooseApplication nextLA = (LooseApplication)i.next();
                msg = msg + "\n   URI: " + nextLA.getUri();
                msg = msg + "\n       Binaries Path : " + nextLA.getBinariesPath();
                msg = msg + "\n       Resources Path: " + nextLA.getResourcesPath();
            }
            logger.logp(Level.FINEST, className, methodName, msg);
        }
        Iterator useLooseApplications = this.getLooseApplications();
        LooseApplication selectedApplication = null;
        while (selectedApplication == null && useLooseApplications.hasNext()) {
            LooseApplication nextLooseApplication = (LooseApplication)useLooseApplications.next();
            String nextApplicationPath = nextLooseApplication.getUri();
            String nextApplicationPath_platform = LooseConfigRegister.normalize(nextApplicationPath);
            if (!LooseConfigRegister.stringsEqual(applicationPath_platform, nextApplicationPath_platform)) continue;
            if (!LooseConfigRegister.stringsEqual(applicationPath, nextApplicationPath)) {
                logger.logp(Level.FINER, className, methodName, "WARNING Normalized match of [ {0} ] with [ {1} ]", new Object[]{applicationPath, nextApplicationPath});
            }
            selectedApplication = nextLooseApplication;
        }
        logger.exiting(className, methodName, selectedApplication);
        return selectedApplication;
    }

    protected LooseApplication loadLooseApplication(URI looseApplicationURI) {
        String methodName = "loadLooseApplication";
        logger.entering(className, methodName, looseApplicationURI);
        Resource res = null;
        try {
            res = this.loadResource(looseApplicationURI);
        }
        catch (ArchiveRuntimeException ae) {
            logger.exiting(className, methodName, "RETURN null - application could not be loaded");
            return null;
        }
        if (res != null && !res.getContents().isEmpty()) {
            LooseApplication looseapp = (LooseApplication)res.getContents().get(0);
            logger.exiting(className, methodName, looseapp);
            return looseapp;
        }
        logger.exiting(className, methodName, "RETURN null - application could not be loaded");
        return null;
    }

    protected String getDocumentURI() {
        String methodName = "getDocumentURI";
        logger.entering(className, methodName, "looking for loose config property");
        String prop = System.getProperty(LOOSE_CONFIG_PROPERTY);
        logger.exiting(className, methodName, prop);
        return prop;
    }

    protected boolean haveDocumentURI() {
        return !ArchiveUtil.isNullOrEmpty(this.getDocumentURI());
    }

    protected Resource loadLooseConfigurationResource() {
        String methodName = "loadLooseConfigurationResource";
        logger.entering(className, methodName);
        if (!this.haveDocumentURI()) {
            logger.logp(Level.FINER, className, methodName, "RETURN Loose configuration property [ {0} ] not set.  Load result is null", LOOSE_CONFIG_PROPERTY);
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "Loading loose configuration file.  Property [ {0} ] set.", LOOSE_CONFIG_PROPERTY);
        Resource resource = this.loadResource(URI.createURI(this.getDocumentURI()));
        logger.exiting(className, methodName, resource);
        return resource;
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    protected Resource loadResource(URI uri) {
        String methodName = "loadResource";
        logger.entering(className, methodName, uri);
        if (uri == null) {
            logger.exiting(className, methodName, "RETURN URI null, returning null resource.");
            return null;
        }
        try {
            Resource resource = this.createResourceSet().getResource(uri, true);
            logger.exiting(className, methodName, resource);
            return resource;
        }
        catch (Exception ex) {
            logger.logp(Level.SEVERE, className, methodName, "", new Object[]{uri, ex.getMessage()});
            logger.exiting(className, methodName, "Loading loose application resource failed");
            throw new ArchiveRuntimeException("Exception occurred loading loose application from [ " + uri + " ] ", ex);
        }
    }

    public static String normalize(String path) {
        String methodName = "normalize";
        String path_platform = null;
        if (path != null) {
            char sep = File.separatorChar;
            char otherSep = sep == '/' ? (char)'\\' : '/';
            path_platform = path.replace(otherSep, sep);
            if (logger.isLoggable(Level.FINER) && path.compareTo(path_platform) != 0) {
                logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN Normalized [ {0} ] to [ {1} ]", new Object[]{path, path_platform});
            }
        }
        return path_platform;
    }

    public static boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }
}

