/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.logging.Level;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.War25ExportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class War25NoDDImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    static final String className = War25NoDDImportStrategyImpl.class.getName();
    protected static Discriminator discriminator;

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return War25NoDDImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public WARFile getWARFile() {
        return (WARFile)this.getArchive();
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    public void loadDeploymentDescriptor() throws Exception {
        String methodName = "loadDeploymentDescriptor";
        logger.logp(Level.FINER, className, methodName, "Creating a web.xml for the Web Module");
        WARFile warFile = this.getWARFile();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "WAR file = [ {0} ]", warFile);
            logger.logp(Level.FINER, className, methodName, "WAR file binaries path = [ {0} ]", warFile.getBinariesPath());
        }
        XMLResource resource = (XMLResource)warFile.makeDeploymentDescriptorResource();
        resource.setModuleVersionID(25);
        WebApp webapp = (WebApp)this.primLoadDeploymentDescriptor();
        webapp.setVersion("2.5");
        webapp.setMetadataComplete(false);
        XMLResource xmlRes = (XMLResource)webapp.eResource();
        if (xmlRes != null) {
            xmlRes.setModuleVersionID(25);
        }
        this.versionCheck(webapp);
        warFile.setExportStrategy(new War25ExportStrategyImpl());
        warFile.setGeneratedDD(true);
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        static final String className = Discriminator.class.getName();
        boolean canImportUninitialized = true;
        boolean canImport;

        public boolean canImport(Archive anArchive) {
            String methodName = "canImport";
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", anArchive);
            Archive.ModuleVersionEnum version = Archive.ModuleVersionEnum.WAR25;
            String archiveURI = anArchive.getURI();
            if (anArchive.isSetCanImportAs(version)) {
                boolean canImport = anArchive.getCanImportAs(version);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN cached WAR25 value [ {0} ]", Boolean.toString(canImport));
                return canImport;
            }
            boolean canImport = this.determineCanImport(anArchive, archiveURI);
            anArchive.setCanImportAs(version, canImport);
            anArchive.closeArchiveZipFile();
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN WAR25 [ {0} ]", Boolean.toString(canImport));
            return canImport;
        }

        private boolean determineCanImport(Archive anArchive, String archiveURI) {
            String methodName = "determineCanImport";
            XmlBasedImportStrategyImpl.logger.entering(className, methodName, archiveURI);
            if (!XmlBasedImportStrategyImpl.validFilename(anArchive, archiveURI, Archive.ModuleTypeEnum.WAR)) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false - not valid WAR filename");
                return false;
            }
            if (XmlBasedImportStrategyImpl.markedDeleted(anArchive, Archive.ModuleTypeEnum.WAR)) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false - archive marked deleted");
                return false;
            }
            if (XmlBasedImportStrategyImpl.containsBlockingDescriptor(anArchive, Archive.ModuleTypeEnum.WAR)) {
                XmlBasedImportStrategyImpl.logger.exiting(className, methodName, "false - Blocking descriptor found");
                return false;
            }
            for (File nextFile : anArchive.getFiles()) {
                String filename = nextFile.getURI();
                if (filename.endsWith(".class")) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false -  Found .class file [ {0} ]", filename);
                    return false;
                }
                if (filename.endsWith(".jar")) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false -  Found .jar file [ {0} ]", filename);
                    return false;
                }
                if (filename.endsWith(".war")) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false -  Found .war file [ {0} ]", filename);
                    return false;
                }
                if (filename.endsWith(".rar")) {
                    XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false -  Found .rar file [ {0} ]", filename);
                    return false;
                }
                if (!filename.endsWith(".ear")) continue;
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false -  Found .ear file [ {0} ]", filename);
                return false;
            }
            XmlBasedImportStrategyImpl.logger.exiting(className, methodName, "true");
            return true;
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            return new War25NoDDImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.WAR_File, "WEB-INF/web.xml");
        }

        public Archive createConvertedArchive() {
            return ImportStrategyImpl.getArchiveFactory().createWARFile();
        }
    }
}

