/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.NestedJarException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.NestedArchiveIteratorDirect;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;

public class NestedArchiveLoadStrategyImpl
extends LoadStrategyImpl {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = NestedArchiveLoadStrategyImpl.class.getName();
    protected Map urisToPositions;
    protected LoadStrategy parent;

    public NestedArchiveLoadStrategyImpl(LoadStrategy parentStrategy) {
        this.setParent(parentStrategy);
    }

    protected void buildIndex() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            ZipInputStream zis = this.getZipInputStream();
            ZipEntry entry = null;
            long position = 0L;
            while ((entry = zis.getNextEntry()) != null) {
                map.put(entry.getName(), new Long(++position));
            }
        }
        catch (IOException iox) {
            this.throwNestedJarException(iox);
        }
        this.setUrisToPositions(map);
    }

    protected boolean primContains(String uri) {
        if (this.usingIndex()) {
            return this.containsUsingIndex(uri);
        }
        return this.containsSequentially(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsSequentially(String uri) {
        ZipInputStream zis = null;
        try {
            zis = this.getZipInputStreamSkippedTo(uri);
            boolean bl = zis != null;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected boolean containsUsingIndex(String uri) {
        return this.getUrisToPositions().containsKey(uri);
    }

    public FileIterator getFileIterator() throws IOException {
        FileIterator result;
        String methodName = "getFileIterator";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY [ {0} ]", this.getContainer().getURI());
        if (((Archive)this.getContainer()).getOptions().isReadOnly()) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Selecting direct iterator");
            result = new NestedArchiveIteratorDirect(this.getContainer().getFiles(), this.getZipInputStream());
        } else {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Selecting normal file iterator");
            result = super.getFileIterator();
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN [ {0} ]", result);
        return result;
    }

    public void closeFileIteratorDirect(NestedArchiveIteratorDirect it) throws IOException, FileNotFoundException {
        if (!(this.parent instanceof ZipFileLoadStrategyImpl)) {
            it.closeInputStream();
        }
    }

    public FileIterator getFileIteratorDirect() throws IOException {
        return this.getFileIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFiles() {
        ArrayList<File> list = new ArrayList<File>(500);
        ZipInputStream zis = null;
        try {
            zis = this.getZipInputStream();
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    File aFile = this.createFile(entry.getName());
                    aFile.setSize(entry.getSize());
                    aFile.setLastModified(entry.getTime());
                    list.add(aFile);
                }
                entry = zis.getNextEntry();
            }
        }
        catch (IOException iox) {
            this.throwNestedJarException(iox);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        if (this.usingIndex()) {
            return this.getInputStreamUsingIndex(uri);
        }
        return this.getInputStreamSequentially(uri);
    }

    protected InputStream getInputStreamSequentially(String uri) throws IOException, FileNotFoundException {
        return new BufferedInputStream(this.getZipInputStreamSkippedTo(uri));
    }

    protected InputStream getInputStreamUsingIndex(String uri) throws IOException, FileNotFoundException {
        Long position = (Long)this.getUrisToPositions().get(uri);
        if (position == null) {
            throw new FileNotFoundException();
        }
        ZipInputStream zis = this.getZipInputStream();
        long pos = position;
        for (long i = 0L; i < pos; ++i) {
            zis.getNextEntry();
        }
        return new BufferedInputStream(zis);
    }

    public LoadStrategy getParent() {
        return this.parent;
    }

    public Map getUrisToPositions() {
        if (this.usingIndex() && this.urisToPositions == null) {
            this.buildIndex();
        }
        return this.urisToPositions;
    }

    protected ZipInputStream getZipInputStream() throws IOException, FileNotFoundException {
        String uri = this.getContainer().getURI();
        InputStream in = this.getParent().getInputStream(uri);
        return new ZipInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZipInputStream getZipInputStreamSkippedTo(String uri) throws IOException, FileNotFoundException {
        if (uri == null) {
            throw new NullPointerException(CommonArchiveResourceHandler.Null_uri_EXC_);
        }
        ZipInputStream zis = null;
        ZipEntry entry = null;
        try {
            zis = this.getZipInputStream();
            entry = zis.getNextEntry();
            while (entry != null) {
                if (uri.equals(entry.getName())) {
                    ZipInputStream zipInputStream = zis;
                    return zipInputStream;
                }
                entry = zis.getNextEntry();
            }
        }
        finally {
            if (entry == null && zis != null) {
                try {
                    zis.close();
                }
                catch (IOException ioe) {}
            }
        }
        throw new FileNotFoundException(uri);
    }

    public void setParent(LoadStrategy newParent) {
        this.parent = newParent;
    }

    public void setUrisToPositions(Map newUrisToPositions) {
        this.urisToPositions = newUrisToPositions;
    }

    protected void throwNestedJarException(Exception caughtException) {
        throw new NestedJarException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_jar_EXC_, new Object[]{this.getContainer().getURI(), this.getParent().getContainer().getURI()}), caughtException);
    }

    public boolean usingIndex() {
        return false;
    }
}

