/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ModuleLocatorClassAdapter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class ModuleLocator {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    private static final String className = ModuleLocator.class.getName();

    public boolean isEJBModule(Archive jarArchive) {
        String methodName = "isEJBModule";
        String aURI = jarArchive.getURI();
        logger.entering(className, methodName, aURI);
        if (this.jarArchiveContainsAnnotations(jarArchive)) {
            logger.exiting(className, methodName, "true");
            logger.logp(Level.FINER, className, methodName, "RETURN true - annotation found in archive [ {0} ]", aURI);
            return true;
        }
        boolean isDirectory = jarArchive.getLoadStrategy() instanceof DirectoryArchiveLoadStrategyImpl;
        if (isDirectory) {
            boolean found = this.binariesPathContainsAnnotations(jarArchive);
            if (found) {
                logger.logp(Level.FINER, className, methodName, "RETURN true - annotation found in archive [ {0} ]", aURI);
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN false - no annotations found in archive [ {0} ]", aURI);
            }
            return found;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN false - no annotations found in archive [ {0} ]", aURI);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jarArchiveContainsAnnotations(Archive jarArchive) {
        FileIterator it;
        String methodName = "jarArchiveContainsAnnotations";
        String aURI = jarArchive.getURI();
        logger.entering(className, methodName, aURI);
        LoadStrategy ls = jarArchive.getLoadStrategy();
        try {
            it = ls.getFileIteratorDirect();
        }
        catch (IOException e1) {
            logger.logp(Level.FINER, className, methodName, "RETURN false - error creating iterator for archive [ {0} ]", aURI);
            return false;
        }
        try {
            while (it.hasNext()) {
                File file = it.next();
                String name = file.getURI();
                if (!name.endsWith(".class") || !this.classContainsAnnotations(it, file)) continue;
                logger.logp(Level.FINER, className, methodName, "RETURN true - annotation found in jar archive [ {0} ]", aURI);
                jarArchive.setCanImportAs(Archive.ModuleVersionEnum.EJB30, true);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                ls.closeFileIteratorDirect(it);
            }
            catch (IOException e) {
                logger.logp(Level.FINER, className, methodName, "Ignoring IOException while closing iterator for archive [ {0} ]", aURI);
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN false - no annotations found in jar archive [ {0} ]", aURI);
        return false;
    }

    private boolean classContainsAnnotations(FileIterator it, File file) {
        InputStream is;
        String methodName = "classContainsAnnotations";
        String name = file.getURI();
        logger.entering(className, methodName, name);
        try {
            is = it.getInputStream(file);
            logger.logp(Level.FINER, className, methodName, "Created input stream for class [ {0} ]", name);
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.FINEST, className, methodName, e.getMessage());
            logger.logp(Level.FINER, className, methodName, "RETURN false - Could not get file inputstream for class [ {0} ]", name);
            return false;
        }
        catch (IOException e) {
            logger.logp(Level.FINEST, className, methodName, e.getMessage());
            logger.logp(Level.FINER, className, methodName, "RETURN false - Could not get file inputstream for class [ {0} ]", name);
            return false;
        }
        boolean foundAnnotations = this.inputStreamContainsEJBAnnotations(is);
        try {
            is.close();
            logger.logp(Level.FINER, className, methodName, "Closed input stream for class [ {0} ]", name);
        }
        catch (IOException e) {
            logger.logp(Level.FINEST, className, methodName, e.getMessage());
            logger.logp(Level.FINER, className, methodName, "Ignoring IOException - Could not close file inputstream for class [ {0} ]", name);
        }
        if (foundAnnotations) {
            logger.logp(Level.FINER, className, methodName, "RETURN true - annotation found in class [ {0} ]", name);
            return true;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN false - no annotations found in class [ {0} ]", name);
        return false;
    }

    private boolean binariesPathContainsAnnotations(Archive jarArchive) {
        String methodName = "binariesPathContainsAnnotations";
        String aURI = jarArchive.getURI();
        logger.logp(Level.FINER, className, methodName, aURI);
        if (logger.isLoggable(Level.FINEST)) {
            this.describeArchive(jarArchive);
        }
        String binariesPath = null;
        ArchiveOptions ao = jarArchive.getOptions();
        Archive parentArchive = (Archive)jarArchive.getContainer();
        if (parentArchive == null) {
            parentArchive = ao.getParentEarFile();
            logger.logp(Level.FINER, className, methodName, "Archive returned NULL for getContainer() - using parent EARFile: [ {0} ]", parentArchive);
        } else {
            logger.logp(Level.FINER, className, methodName, "Archive returned valid Container: [ {0} ]", parentArchive);
        }
        binariesPath = ao.getAltBinariesPath();
        if (binariesPath != null) {
            logger.logp(Level.FINER, className, methodName, "Got alternate binaries path from options [ {0} ]", binariesPath);
        } else if (parentArchive != null) {
            logger.logp(Level.FINER, className, methodName, "Parent archive is [ {0} ]", parentArchive.getURI());
            try {
                binariesPath = parentArchive.getBinariesPath();
            }
            catch (FileNotFoundException e) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.throwing(className, methodName, e);
                }
                logger.logp(Level.FINER, className, methodName, "RETURN false - Ignoring IOException - Could not find parent archive binaries path");
                return false;
            }
            logger.logp(Level.FINER, className, methodName, "Got parent archive binaries path [ {0} ]", binariesPath);
        } else {
            binariesPath = ao.getParentEarBinariesPath();
            if (binariesPath == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN false - Could not find parent archive binaries path in archive options");
                return false;
            }
            logger.logp(Level.FINER, className, methodName, "Got parent archive binaries path from options [ {0} ]", binariesPath);
        }
        String jarFileName = binariesPath + java.io.File.separator + aURI;
        java.io.File jarFile = new java.io.File(jarFileName);
        if (jarFile.exists()) {
            String triggerClass;
            if (jarFile.isDirectory()) {
                logger.logp(Level.FINER, className, methodName, "Scanning target binaries directory [ {0} ]", jarFileName);
                try {
                    triggerClass = this.archiveDirectoryContainsEJBAnnotations(jarFile);
                }
                catch (IOException e) {
                    logger.throwing(className, methodName, e);
                    logger.logp(Level.FINER, className, methodName, "RETURN false - Exception scanning binaries directory [ {0} ]", jarFileName);
                    return false;
                }
            }
            logger.logp(Level.FINER, className, methodName, "Scanning target binaries file [ {0} ]", jarFileName);
            try {
                triggerClass = this.archiveFileContainsEJBAnnotations(jarFile);
            }
            catch (IOException e) {
                logger.throwing(className, methodName, e);
                logger.logp(Level.FINER, className, methodName, "RETURN false - Exception scanning binaries file [ {0} ]", jarFileName);
                return false;
            }
            if (triggerClass != null) {
                logger.logp(Level.FINER, className, methodName, "RETURN true - annotation found in input stream for class [ {0} ]", triggerClass);
                return true;
            }
            logger.logp(Level.FINER, className, methodName, "RETURN false - no annotations found in jar archive [ {0} ]", jarFileName);
            return false;
        }
        logger.logp(Level.FINER, className, methodName, "The target jar is not present in binaries location [ {0} ]", jarFileName);
        if (parentArchive == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN false - no parent archive is available for archive [ {0} ]", aURI);
            return false;
        }
        try {
            String triggerClass = this.archiveEntryContainsEJBAnnotations(parentArchive, aURI);
            if (triggerClass != null) {
                logger.logp(Level.FINER, className, methodName, "RETURN true - annotation found in input stream for class [ {0} ]", triggerClass);
                return true;
            }
            logger.logp(Level.FINER, className, methodName, "RETURN false - no annotations found in jar archive [ {0} ]", jarFileName);
            return false;
        }
        catch (IOException e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.FINER, className, methodName, "RETURN false - failed to process target jar file [ {0} ] under parent [ {1} ]", new Object[]{aURI, parentArchive.getURI()});
            return false;
        }
    }

    private String archiveDirectoryContainsEJBAnnotations(java.io.File archiveDirectory) throws IOException {
        return this.archiveDirectoryContainsEJBAnnotations(archiveDirectory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String archiveDirectoryContainsEJBAnnotations(java.io.File archiveDirectory, String prefix) throws IOException {
        java.io.File[] archiveChildren = archiveDirectory.listFiles();
        if (archiveChildren == null) {
            throw new IOException("Strange: Unable to list directory [ " + archiveDirectory.getPath() + " ]");
        }
        String triggerClass = null;
        for (int childNo = 0; triggerClass == null && childNo < archiveChildren.length; ++childNo) {
            java.io.File nextChild = archiveChildren[childNo];
            String nextChildName = nextChild.getName();
            if (nextChild.isDirectory()) {
                String nextPrefix = prefix == null ? nextChildName : prefix + java.io.File.separator + nextChildName;
                triggerClass = this.archiveDirectoryContainsEJBAnnotations(nextChild, nextPrefix);
                continue;
            }
            if (!this.isClassFile(nextChild)) continue;
            FileInputStream nextChildStream = new FileInputStream(nextChild);
            try {
                if (!this.inputStreamContainsEJBAnnotations(nextChildStream)) continue;
                triggerClass = prefix == null ? nextChildName : prefix + java.io.File.separator + nextChildName;
                continue;
            }
            finally {
                ((InputStream)nextChildStream).close();
            }
        }
        return triggerClass;
    }

    private boolean isClassFile(java.io.File file) {
        return file.getName().endsWith(".class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String archiveEntryContainsEJBAnnotations(Archive parentArchive, String childURI) throws IOException {
        InputStream is = parentArchive.getInputStream(childURI);
        try {
            String string = this.archiveStreamContainsEJBAnnotations(is);
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String archiveFileContainsEJBAnnotations(java.io.File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            String string = this.archiveStreamContainsEJBAnnotations(inputStream);
            return string;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    private String archiveStreamContainsEJBAnnotations(InputStream is) throws IOException {
        ZipEntry nextEntry;
        ZipInputStream zis = new ZipInputStream(is);
        String triggerClass = null;
        while (triggerClass == null && (nextEntry = zis.getNextEntry()) != null) {
            if (!this.isClassEntry(nextEntry) || !this.inputStreamContainsEJBAnnotations(zis)) continue;
            triggerClass = nextEntry.getName();
        }
        return triggerClass;
    }

    private boolean isClassEntry(ZipEntry zipEntry) {
        return zipEntry.getName().endsWith(".class");
    }

    private boolean inputStreamContainsEJBAnnotations(InputStream is) {
        ClassReader cr;
        String methodName = "inputStreamContainsEJBAnnotations";
        logger.logp(Level.FINER, className, methodName, "ENTER");
        try {
            cr = new ClassReader(is);
        }
        catch (IOException e) {
            logger.logp(Level.FINEST, className, methodName, e.getMessage());
            logger.logp(Level.FINER, className, methodName, "RETURN false - Ignoring IOException - Could not create ClassReader");
            return false;
        }
        ClassWriter cw = new ClassWriter(true);
        ModuleLocatorClassAdapter classAdapter = new ModuleLocatorClassAdapter(cw);
        cr.accept(classAdapter, false);
        if (classAdapter.isEJBModule()) {
            logger.logp(Level.FINER, className, methodName, "RETURN true - EJB-defining annotation found in input stream [ {0} ]", is);
            return true;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN false - no EJB-defining annotations found in input stream [ {0} ]", is);
        return false;
    }

    protected void describeArchive(Archive archive) {
        String useAbsolutePath;
        String useResourcesPath;
        String useBinariesPath;
        StringBuffer msg = new StringBuffer("\n    \nDescribing archive [ " + archive.getURI() + " ]\n");
        ArchiveOptions ao = archive.getOptions();
        String altBinariesPath = ao.getAltBinariesPath();
        msg.append("\n    Archive options altBinariesPath [ " + altBinariesPath + " ]");
        String binariesPath = ao.getParentEarBinariesPath();
        msg.append("\n    Archive options parent EAR binariesPath [ " + binariesPath + " ]");
        try {
            useBinariesPath = archive.getBinariesPath();
        }
        catch (IOException e) {
            useBinariesPath = "*** UNAVAILABLE ***";
        }
        msg.append("\n    Archive Binaries Path [ " + useBinariesPath + " ]");
        try {
            useResourcesPath = archive.getBinariesPath();
        }
        catch (IOException e) {
            useResourcesPath = "*** UNAVAILABLE ***";
        }
        msg.append("\n    Archive Resources Path [ " + useResourcesPath + " ]");
        try {
            useAbsolutePath = archive.getAbsolutePath();
        }
        catch (IOException e) {
            useAbsolutePath = "*** UNAVAILABLE ***";
        }
        msg.append("\n    Archive Absolute Path [ " + useAbsolutePath + " ]");
        Container useContainer = archive.getContainer();
        if (useContainer == null) {
            msg.append("\n    Container [ *** NULL *** ]");
        } else {
            msg.append("\n    Container [ " + useContainer.getURI() + " ]");
            if (!(useContainer instanceof Archive)) {
                msg.append("\n    Container is not an archive");
            } else {
                String parentAbsolutePath;
                String parentResourcesPath;
                String parentBinariesPath;
                Archive parentArchive = (Archive)useContainer;
                LooseConfigRegister lcr = LooseConfigRegister.singleton();
                LooseApplication la = lcr.findLooseApplication(parentArchive.getURI());
                if (la != null) {
                    msg.append("\n    Container is a loose application");
                    msg.append("\n    Container loose Binaries Path [ " + la.getBinariesPath() + " ]");
                    msg.append("\n    Container loose Resources Path [ " + la.getResourcesPath() + " ]");
                } else {
                    msg.append("\n    Container is NOT a loose application");
                }
                try {
                    parentBinariesPath = parentArchive.getBinariesPath();
                }
                catch (IOException e) {
                    parentBinariesPath = "*** UNAVAILABLE ***";
                }
                msg.append("\n    Container Binaries Path [ " + parentBinariesPath + " ]");
                try {
                    parentResourcesPath = parentArchive.getResourcesPath();
                }
                catch (IOException e) {
                    parentResourcesPath = "*** UNAVAILABLE ***";
                }
                msg.append("\n    Container Resources Path [ " + parentResourcesPath + " ]");
                try {
                    parentAbsolutePath = parentArchive.getAbsolutePath();
                }
                catch (IOException e) {
                    parentAbsolutePath = "*** UNAVAILABLE ***";
                }
                msg.append("\n    Container Absolute Path [ " + parentAbsolutePath + " ]");
            }
        }
        msg.append("\n");
        logger.finest(msg.toString());
    }
}

