/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EOperationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.java.adapters.IJavaMethodAdapter;
import org.eclipse.jem.internal.java.adapters.ReadAdaptor;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;

public class MethodImpl
extends EOperationImpl
implements Method {
    protected String signature;
    protected static final boolean ABSTRACT_EDEFAULT = false;
    protected static final int ABSTRACT_EFLAG = 1024;
    protected static final boolean NATIVE_EDEFAULT = false;
    protected static final int NATIVE_EFLAG = 2048;
    protected static final boolean SYNCHRONIZED_EDEFAULT = false;
    protected static final int SYNCHRONIZED_EFLAG = 4096;
    protected static final boolean FINAL_EDEFAULT = false;
    protected static final int FINAL_EFLAG = 8192;
    protected static final boolean CONSTRUCTOR_EDEFAULT = false;
    protected static final int CONSTRUCTOR_EFLAG = 16384;
    protected static final boolean STATIC_EDEFAULT = false;
    protected static final int STATIC_EFLAG = 32768;
    protected static final JavaVisibilityKind JAVA_VISIBILITY_EDEFAULT = JavaVisibilityKind.PUBLIC_LITERAL;
    private transient boolean isGenerated = false;
    protected JavaVisibilityKind javaVisibility = JAVA_VISIBILITY_EDEFAULT;
    protected EList parameters = null;
    protected EList javaExceptions = null;
    protected Block source = null;
    private static final int NOT_REFLECTED = 0;
    private static final int REFLECTED_BASE = 1;
    private static final int REFLECTED_GENERATED = 2;
    protected int reflectionStatus = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected MethodImpl() {
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.eINSTANCE.getMethod();
    }

    public boolean isAbstractGen() {
        return (this.eFlags & 0x400) != 0;
    }

    public void setAbstract(boolean newAbstract) {
        boolean oldAbstract;
        boolean bl = oldAbstract = (this.eFlags & 0x400) != 0;
        this.eFlags = newAbstract ? (this.eFlags |= 0x400) : (this.eFlags &= 0xFFFFFBFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 12, oldAbstract, newAbstract));
        }
    }

    public boolean isNativeGen() {
        return (this.eFlags & 0x800) != 0;
    }

    public void setNative(boolean newNative) {
        boolean oldNative;
        boolean bl = oldNative = (this.eFlags & 0x800) != 0;
        this.eFlags = newNative ? (this.eFlags |= 0x800) : (this.eFlags &= 0xFFFFF7FF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 13, oldNative, newNative));
        }
    }

    public boolean isSynchronizedGen() {
        return (this.eFlags & 0x1000) != 0;
    }

    public void setSynchronized(boolean newSynchronized) {
        boolean oldSynchronized;
        boolean bl = oldSynchronized = (this.eFlags & 0x1000) != 0;
        this.eFlags = newSynchronized ? (this.eFlags |= 0x1000) : (this.eFlags &= 0xFFFFEFFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 14, oldSynchronized, newSynchronized));
        }
    }

    public boolean isFinalGen() {
        return (this.eFlags & 0x2000) != 0;
    }

    public void setFinal(boolean newFinal) {
        boolean oldFinal;
        boolean bl = oldFinal = (this.eFlags & 0x2000) != 0;
        this.eFlags = newFinal ? (this.eFlags |= 0x2000) : (this.eFlags &= 0xFFFFDFFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 15, oldFinal, newFinal));
        }
    }

    public boolean isConstructorGen() {
        return (this.eFlags & 0x4000) != 0;
    }

    public void setConstructor(boolean newConstructor) {
        boolean oldConstructor;
        boolean bl = oldConstructor = (this.eFlags & 0x4000) != 0;
        this.eFlags = newConstructor ? (this.eFlags |= 0x4000) : (this.eFlags &= 0xFFFFBFFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 16, oldConstructor, newConstructor));
        }
    }

    public boolean isStaticGen() {
        return (this.eFlags & 0x8000) != 0;
    }

    public void setStatic(boolean newStatic) {
        boolean oldStatic;
        boolean bl = oldStatic = (this.eFlags & 0x8000) != 0;
        this.eFlags = newStatic ? (this.eFlags |= 0x8000) : (this.eFlags &= 0xFFFF7FFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 17, oldStatic, newStatic));
        }
    }

    public JavaClass getContainingJavaClass() {
        return this.getJavaClass();
    }

    public boolean isAbstract() {
        this.reflectValues();
        return this.isAbstractGen();
    }

    public boolean isConstructor() {
        this.reflectValues();
        return this.isConstructorGen();
    }

    public boolean isFinal() {
        this.reflectValues();
        return this.isFinalGen();
    }

    public boolean isNative() {
        this.reflectValues();
        return this.isNativeGen();
    }

    public boolean isStatic() {
        this.reflectValues();
        return this.isStaticGen();
    }

    public boolean isSynchronized() {
        this.reflectValues();
        return this.isSynchronizedGen();
    }

    public EList getJavaExceptions() {
        this.reflectValues();
        return this.getJavaExceptionsGen();
    }

    public JavaVisibilityKind getJavaVisibility() {
        this.reflectValues();
        return this.getJavaVisibilityGen();
    }

    public EList getParameters() {
        this.reflectValues();
        return this.getParametersGen();
    }

    public EClassifier getEType() {
        this.reflectValues();
        return super.getEType();
    }

    public String getMethodElementSignature() {
        StringBuffer sb = new StringBuffer(75);
        sb.append(this.getName());
        sb.append("(");
        EList params = this.getParameters();
        int parmSize = params.size();
        int commaTest = 0;
        int j = 0;
        while (j < parmSize) {
            if (j > commaTest) {
                sb.append(",");
            }
            JavaParameter param = (JavaParameter)params.get(j);
            sb.append(((JavaHelpers)param.getEType()).getQualifiedName());
            ++j;
        }
        sb.append(")");
        return sb.toString();
    }

    public JavaParameter getParameter(String parameterName) {
        EList parms = this.getParameters();
        int parmSize = parms.size();
        int j = 0;
        while (j < parmSize) {
            JavaParameter parm = (JavaParameter)parms.get(j);
            if (parm.getName().equals(parameterName)) {
                return parm;
            }
            ++j;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectValues() {
        ReadAdaptor readAdaptor = null;
        MethodImpl methodImpl = this;
        synchronized (methodImpl) {
            if ((this.reflectionStatus & 1) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = readAdaptor.reflectValuesIfNecessary();
            MethodImpl methodImpl2 = this;
            synchronized (methodImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 1;
                }
            }
        }
    }

    public synchronized ReadAdaptor getReadAdapter() {
        return (ReadAdaptor)EcoreUtil.getRegisteredAdapter(this, (Object)"JavaReflection");
    }

    public synchronized void setReflected(boolean reflected) {
        if (!reflected) {
            this.reflectionStatus = 0;
        }
    }

    public JavaHelpers getReturnType() {
        return (JavaHelpers)this.getEType();
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = this.doGetSignature();
        }
        return this.signature;
    }

    protected String doGetSignature() {
        StringBuffer sb = new StringBuffer();
        switch (this.getJavaVisibility().getValue()) {
            case 0: {
                sb.append("Public ");
                break;
            }
            case 2: {
                sb.append("Protected ");
                break;
            }
            case 1: {
                sb.append("Private ");
                break;
            }
            case 3: {
                sb.append("Package ");
            }
        }
        if (this.isAbstract()) {
            sb.append("abstract ");
        }
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isFinal()) {
            sb.append("final ");
        }
        if (this.isSynchronized()) {
            sb.append("synchronized ");
        }
        if (this.isNative()) {
            sb.append("native ");
        }
        if (this.isVoid()) {
            sb.append("void ");
        } else {
            sb.append(String.valueOf(this.getReturnType().getQualifiedName()) + " ");
        }
        sb.append(String.valueOf(this.getContainingJavaClass().getJavaName()) + ".");
        sb.append(String.valueOf(this.getName()) + "(");
        EList params = this.getParameters();
        int parmSize = params.size();
        int j = 0;
        while (j < parmSize) {
            JavaParameter param = (JavaParameter)params.get(j);
            sb.append(((JavaHelpers)param.getEType()).getQualifiedName());
            if (j < params.size() - 1) {
                sb.append(",");
            }
            ++j;
        }
        sb.append(")");
        EList exceptions2 = this.getJavaExceptions();
        if (exceptions2.size() > 0) {
            sb.append(" throws ");
            int k = 0;
            while (k < exceptions2.size()) {
                JavaClass exception = (JavaClass)exceptions2.get(k);
                sb.append(exception.getJavaName());
                if (k < exceptions2.size() - 1) {
                    sb.append(",");
                }
                ++k;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectGenerated() {
        ReadAdaptor readAdaptor = null;
        MethodImpl methodImpl = this;
        synchronized (methodImpl) {
            if ((this.reflectionStatus & 2) == 0) {
                readAdaptor = this.getReadAdapter();
            }
        }
        if (readAdaptor != null) {
            boolean setReflected = ((IJavaMethodAdapter)((Object)readAdaptor)).reflectGeneratedIfNecessary();
            MethodImpl methodImpl2 = this;
            synchronized (methodImpl2) {
                if (setReflected) {
                    this.reflectionStatus |= 3;
                }
            }
        }
    }

    public boolean isGenerated() {
        this.reflectGenerated();
        return this.isGenerated;
    }

    public boolean isGeneratedGen() {
        throw new UnsupportedOperationException();
    }

    public boolean isVoid() {
        return this.getReturnType() == null || "void".equals(this.getReturnType().getName());
    }

    public JavaParameter[] listParametersWithoutReturn() {
        EList v = this.getParameters();
        JavaParameter[] result = new JavaParameter[v.size()];
        v.toArray(result);
        return result;
    }

    public EList eContents() {
        BasicEList results = new BasicEList();
        results.addAll(this.getParametersGen());
        return results;
    }

    public void setIsGenerated(boolean generated) {
        this.isGenerated = generated;
    }

    public void setReturnType(JavaHelpers type) {
        this.setEType(type);
    }

    public JavaVisibilityKind getJavaVisibilityGen() {
        return this.javaVisibility;
    }

    public void setJavaVisibility(JavaVisibilityKind newJavaVisibility) {
        JavaVisibilityKind oldJavaVisibility = this.javaVisibility;
        JavaVisibilityKind javaVisibilityKind = this.javaVisibility = newJavaVisibility == null ? JAVA_VISIBILITY_EDEFAULT : newJavaVisibility;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldJavaVisibility, (Object)this.javaVisibility));
        }
    }

    public JavaClass getJavaClass() {
        if (this.eContainerFeatureID != 21) {
            return null;
        }
        return (JavaClass)((Object)this.eContainer);
    }

    public void setJavaClass(JavaClass newJavaClass) {
        if (newJavaClass != this.eContainer || this.eContainerFeatureID != 21 && newJavaClass != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newJavaClass)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newJavaClass != null) {
                InternalEObject internalEObject = (InternalEObject)((Object)newJavaClass);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jem.java.JavaClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd(this, 27, clazz, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)((Object)newJavaClass), 21, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 21, (Object)newJavaClass, (Object)newJavaClass));
        }
    }

    public Block getSource() {
        if (this.source != null && this.source.eIsProxy()) {
            Block oldSource = this.source;
            this.source = (Block)this.eResolveProxy((InternalEObject)((Object)this.source));
            if (this.source != oldSource && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 22, (Object)oldSource, (Object)this.source));
            }
        }
        return this.source;
    }

    public Block basicGetSource() {
        return this.source;
    }

    public void setSource(Block newSource) {
        Block oldSource = this.source;
        this.source = newSource;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldSource, (Object)this.source));
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return (this.eFlags & 0x100) == 0;
            }
            case 3: {
                return (this.eFlags & 0x200) == 0;
            }
            case 4: {
                return this.lowerBound != 0;
            }
            case 5: {
                return this.upperBound != 1;
            }
            case 6: {
                return this.isMany();
            }
            case 7: {
                return this.isRequired();
            }
            case 8: {
                return this.eType != null;
            }
            case 9: {
                return this.getEContainingClass() != null;
            }
            case 10: {
                return this.eParameters != null && !this.eParameters.isEmpty();
            }
            case 11: {
                return this.eExceptions != null && !this.eExceptions.isEmpty();
            }
            case 12: {
                return (this.eFlags & 0x400) != 0;
            }
            case 13: {
                return (this.eFlags & 0x800) != 0;
            }
            case 14: {
                return (this.eFlags & 0x1000) != 0;
            }
            case 15: {
                return (this.eFlags & 0x2000) != 0;
            }
            case 16: {
                return (this.eFlags & 0x4000) != 0;
            }
            case 17: {
                return (this.eFlags & 0x8000) != 0;
            }
            case 18: {
                return this.javaVisibility != JAVA_VISIBILITY_EDEFAULT;
            }
            case 19: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
            case 20: {
                return this.javaExceptions != null && !this.javaExceptions.isEmpty();
            }
            case 21: {
                return this.getJavaClass() != null;
            }
            case 22: {
                return this.source != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setOrdered((Boolean)newValue);
                return;
            }
            case 3: {
                this.setUnique((Boolean)newValue);
                return;
            }
            case 4: {
                this.setLowerBound((Integer)newValue);
                return;
            }
            case 5: {
                this.setUpperBound((Integer)newValue);
                return;
            }
            case 8: {
                this.setEType((EClassifier)newValue);
                return;
            }
            case 10: {
                this.getEParameters().clear();
                this.getEParameters().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getEExceptions().clear();
                this.getEExceptions().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setAbstract((Boolean)newValue);
                return;
            }
            case 13: {
                this.setNative((Boolean)newValue);
                return;
            }
            case 14: {
                this.setSynchronized((Boolean)newValue);
                return;
            }
            case 15: {
                this.setFinal((Boolean)newValue);
                return;
            }
            case 16: {
                this.setConstructor((Boolean)newValue);
                return;
            }
            case 17: {
                this.setStatic((Boolean)newValue);
                return;
            }
            case 18: {
                this.setJavaVisibility((JavaVisibilityKind)newValue);
                return;
            }
            case 19: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.getJavaExceptions().clear();
                this.getJavaExceptions().addAll((Collection)newValue);
                return;
            }
            case 21: {
                this.setJavaClass((JavaClass)newValue);
                return;
            }
            case 22: {
                this.setSource((Block)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setOrdered(true);
                return;
            }
            case 3: {
                this.setUnique(true);
                return;
            }
            case 4: {
                this.setLowerBound(0);
                return;
            }
            case 5: {
                this.setUpperBound(1);
                return;
            }
            case 8: {
                this.setEType(null);
                return;
            }
            case 10: {
                this.getEParameters().clear();
                return;
            }
            case 11: {
                this.getEExceptions().clear();
                return;
            }
            case 12: {
                this.setAbstract(false);
                return;
            }
            case 13: {
                this.setNative(false);
                return;
            }
            case 14: {
                this.setSynchronized(false);
                return;
            }
            case 15: {
                this.setFinal(false);
                return;
            }
            case 16: {
                this.setConstructor(false);
                return;
            }
            case 17: {
                this.setStatic(false);
                return;
            }
            case 18: {
                this.setJavaVisibility(JAVA_VISIBILITY_EDEFAULT);
                return;
            }
            case 19: {
                this.getParameters().clear();
                return;
            }
            case 20: {
                this.getJavaExceptions().clear();
                return;
            }
            case 21: {
                this.setJavaClass(null);
                return;
            }
            case 22: {
                this.setSource(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (abstract: ");
        result.append((this.eFlags & 0x400) != 0);
        result.append(", native: ");
        result.append((this.eFlags & 0x800) != 0);
        result.append(", synchronized: ");
        result.append((this.eFlags & 0x1000) != 0);
        result.append(", final: ");
        result.append((this.eFlags & 0x2000) != 0);
        result.append(", constructor: ");
        result.append((this.eFlags & 0x4000) != 0);
        result.append(", static: ");
        result.append((this.eFlags & 0x8000) != 0);
        result.append(", javaVisibility: ");
        result.append(this.javaVisibility);
        result.append(')');
        return result.toString();
    }

    public EList getParametersGen() {
        if (this.parameters == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jem.java.JavaParameter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.parameters = new EObjectContainmentEList(clazz, this, 19);
        }
        return this.parameters;
    }

    public EList getJavaExceptionsGen() {
        if (this.javaExceptions == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jem.java.JavaClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.javaExceptions = new EObjectResolvingEList(clazz, this, 20);
        }
        return this.javaExceptions;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
                }
                case 9: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 9, msgs);
                }
                case 10: {
                    return ((InternalEList)this.getEParameters()).basicAdd(otherEnd, msgs);
                }
                case 21: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 21, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
                }
                case 9: {
                    return this.eBasicSetContainer(null, 9, msgs);
                }
                case 10: {
                    return ((InternalEList)this.getEParameters()).basicRemove(otherEnd, msgs);
                }
                case 19: {
                    return ((InternalEList)this.getParameters()).basicRemove(otherEnd, msgs);
                }
                case 21: {
                    return this.eBasicSetContainer(null, 21, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block10: {
            if (this.eContainerFeatureID < 0) break block10;
            switch (this.eContainerFeatureID) {
                case 9: {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.emf.ecore.EClass");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove(this, 9, clazz, msgs);
                }
                case 21: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jem.java.JavaClass");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove(this, 27, clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove(this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.isOrdered() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.isUnique() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return new Integer(this.getLowerBound());
            }
            case 5: {
                return new Integer(this.getUpperBound());
            }
            case 6: {
                return this.isMany() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isRequired() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                if (resolve) {
                    return this.getEType();
                }
                return this.basicGetEType();
            }
            case 9: {
                return this.getEContainingClass();
            }
            case 10: {
                return this.getEParameters();
            }
            case 11: {
                return this.getEExceptions();
            }
            case 12: {
                return this.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.isNative() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return this.isSynchronized() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 15: {
                return this.isFinal() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.isConstructor() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.isStatic() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return this.getJavaVisibility();
            }
            case 19: {
                return this.getParameters();
            }
            case 20: {
                return this.getJavaExceptions();
            }
            case 21: {
                return this.getJavaClass();
            }
            case 22: {
                if (resolve) {
                    return this.getSource();
                }
                return this.basicGetSource();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }
}

