/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.BaseConfigManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.ConfigManager;

public class DefaultConfigManager
extends BaseConfigManager
implements ConfigManager {
    protected String filename = "DeployedServices.ds";

    public void setOptions(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        String string = (String)hashtable.get("filename");
        if (string != null && !"".equals(string)) {
            this.filename = string;
        }
    }

    public void loadRegistry() throws SOAPException {
        this.dds = null;
        try {
            File file = ServerHTTPUtils.getFileFromNameAndContext(this.filename, this.context);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.dds = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.dds = new Hashtable();
            System.err.println("SOAP Service Manager: Unable to read '" + this.filename + "': assuming fresh start");
        }
    }

    public void saveRegistry() throws SOAPException {
        try {
            File file = ServerHTTPUtils.getFileFromNameAndContext(this.filename, this.context);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.dds);
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error saving services registry: " + exception.getMessage());
        }
    }
}

