/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.encoding.soapenc;

import java.io.IOException;
import java.io.Writer;
import org.apache.soap.Constants;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.NSStack;
import org.apache.soap.util.xml.PrefixedName;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Element;

public class SoapEncUtils {
    public static void generateNullStructure(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, null, null, true);
    }

    public static void generateNullArray(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, qName, string2, true);
    }

    public static void generateArrayHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, qName, string2, false);
    }

    public static void generateStructureHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry) throws IllegalArgumentException, IOException {
        SoapEncUtils.generateStructureHeader(string, clazz, object, writer, nSStack, xMLJavaMappingRegistry, null, null, false);
    }

    private static void generateStructureHeader(String string, Class clazz, Object object, Writer writer, NSStack nSStack, XMLJavaMappingRegistry xMLJavaMappingRegistry, QName qName, String string2, boolean bl) throws IllegalArgumentException, IOException {
        String string3;
        String string4;
        String string5;
        Object object2;
        Object object3;
        QName qName2 = xMLJavaMappingRegistry.queryElementType(clazz, "http://schemas.xmlsoap.org/soap/encoding/");
        String string6 = "";
        if (object instanceof PrefixedName && (object3 = ((PrefixedName)(object2 = (PrefixedName)object)).getQName()) != null && (string5 = ((QName)object3).getNamespaceURI()) != null && !string5.equals("") && ((PrefixedName)object2).getPrefix() == null) {
            string4 = nSStack.getPrefixFromURI(string5);
            if (string4 == null) {
                string4 = nSStack.addNSDeclaration(string5);
                string6 = " xmlns:" + string4 + "=\"" + string5 + '\"';
            }
            ((PrefixedName)object2).setPrefix(string4);
        }
        writer.write('<' + object.toString() + string6);
        object2 = qName2.getNamespaceURI();
        object3 = "http://www.w3.org/2001/XMLSchema-instance";
        if (((String)object2).startsWith("http://www.w3.org/") && ((String)object2).endsWith("/XMLSchema")) {
            object3 = (String)object2 + "-instance";
        }
        string5 = nSStack.getPrefixFromURI((String)object3, writer);
        string4 = nSStack.getPrefixFromURI((String)object2, writer);
        writer.write(' ' + string5 + ':' + "type" + "=\"" + string4 + ':' + qName2.getLocalPart() + '\"');
        if (string == null || !string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            string3 = nSStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/envelope/", writer);
            writer.write(' ' + string3 + ':' + "encodingStyle" + "=\"" + "http://schemas.xmlsoap.org/soap/encoding/" + '\"');
        }
        if (qName != null) {
            string3 = nSStack.getPrefixFromURI(qName.getNamespaceURI(), writer);
            String string7 = string3 + ':' + qName.getLocalPart() + '[' + string2 + ']';
            String string8 = nSStack.getPrefixFromURI("http://schemas.xmlsoap.org/soap/encoding/", writer);
            writer.write(' ' + string8 + ':' + "arrayType" + "=\"" + string7 + '\"');
        }
        if (bl) {
            writer.write(' ' + string5 + ':' + SoapEncUtils.nilName((String)object3) + "=\"" + Constants.ATTRVAL_TRUE + "\"/");
        }
        writer.write(62);
    }

    private static String nilName(String string) {
        return string.equals("http://www.w3.org/2001/XMLSchema-instance") ? "nil" : "null";
    }

    public static boolean isNull(Element element) {
        String string = DOMUtils.getAttributeNS(element, "http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (string == null) {
            string = DOMUtils.getAttributeNS(element, "http://www.w3.org/2000/10/XMLSchema-instance", "null");
        }
        if (string == null) {
            string = DOMUtils.getAttributeNS(element, "http://www.w3.org/1999/XMLSchema-instance", "null");
        }
        return string != null && SoapEncUtils.decodeBooleanValue(string);
    }

    public static boolean decodeBooleanValue(String string) {
        switch (string.charAt(0)) {
            case '0': 
            case 'F': 
            case 'f': {
                return false;
            }
            case '1': 
            case 'T': 
            case 't': {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid boolean value: " + string);
    }

    public static QName getAttributeValue(Element element, String string, String string2, String string3, boolean bl) throws IllegalArgumentException {
        String string4 = DOMUtils.getAttributeNS(element, string, string2);
        if (string4 != null) {
            int n = string4.indexOf(58);
            if (n != -1) {
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                String string7 = DOMUtils.getNamespaceURIFromPrefix(element, string5);
                if (string7 != null) {
                    return new QName(string7, string6);
                }
                throw new IllegalArgumentException("Unable to resolve namespace URI for '" + string5 + "'.");
            }
            throw new IllegalArgumentException("The value of the '" + string + ':' + string2 + "' attribute must be " + "namespace-qualified.");
        }
        if (bl) {
            throw new IllegalArgumentException("The '" + string + ':' + string2 + "' attribute must be " + "specified for every " + string3 + '.');
        }
        return null;
    }

    public static QName getTypeQName(Element element) throws IllegalArgumentException {
        QName qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema-instance", "type", null, false);
        if (qName != null) {
            return qName;
        }
        qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/2000/10/XMLSchema-instance", "type", null, false);
        if (qName != null) {
            return qName;
        }
        qName = SoapEncUtils.getAttributeValue(element, "http://www.w3.org/1999/XMLSchema-instance", "type", null, false);
        return qName;
    }
}

