/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class LengthValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.Length";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private Integer maximum;
    private Integer minimum;
    private boolean transientValue = false;

    public LengthValidator() {
    }

    public LengthValidator(int maximum) {
        this.setMaximum(maximum);
    }

    public LengthValidator(int maximum, int minimum) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.maximum != null ? this.maximum : 0;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public int getMinimum() {
        return this.minimum != null ? this.minimum : 0;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    @Override
    public void validate(FacesContext context, UIComponent component2, Object value) throws ValidatorException {
        if (context == null || component2 == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            String converted = LengthValidator.stringValue(value);
            if (this.isMaximumSet() && converted.length() > this.maximum) {
                throw new ValidatorException(MessageFactory.getMessage(context, MAXIMUM_MESSAGE_ID, LengthValidator.integerToString(component2, this.maximum, context), MessageFactory.getLabel(context, component2)));
            }
            if (this.isMinimumSet() && converted.length() < this.minimum) {
                throw new ValidatorException(MessageFactory.getMessage(context, MINIMUM_MESSAGE_ID, LengthValidator.integerToString(component2, this.minimum, context), MessageFactory.getLabel(context, component2)));
            }
        }
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof LengthValidator)) {
            return false;
        }
        LengthValidator other = (LengthValidator)otherObj;
        return this.getMaximum() == other.getMaximum() && this.getMinimum() == other.getMinimum() && this.isMinimumSet() == other.isMinimumSet() && this.isMaximumSet() == other.isMaximumSet();
    }

    public int hashCode() {
        int hashCode = Integer.valueOf(this.getMinimum()).hashCode() + Integer.valueOf(this.getMaximum()).hashCode() + Boolean.valueOf(this.isMaximumSet()).hashCode() + Boolean.valueOf(this.isMinimumSet()).hashCode();
        return hashCode;
    }

    private static String stringValue(Object attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof String) {
            return (String)attributeValue;
        }
        return attributeValue.toString();
    }

    private static String integerToString(UIComponent component2, Integer toConvert, FacesContext context) {
        Converter converter = context.getApplication().createConverter("javax.faces.Number");
        return converter.getAsString(context, component2, toConvert);
    }

    private boolean isMaximumSet() {
        return this.maximum != null;
    }

    private boolean isMinimumSet() {
        return this.minimum != null;
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maximum, this.minimum};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Integer)values[0];
        this.minimum = (Integer)values[1];
    }

    @Override
    public boolean isTransient() {
        return this.transientValue;
    }

    @Override
    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

