/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ListDataModel
extends DataModel {
    private int index = -1;
    private List list;

    public ListDataModel() {
        this(null);
    }

    public ListDataModel(List list) {
        this.setWrappedData(list);
    }

    @Override
    public boolean isRowAvailable() {
        if (this.list == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.list.size();
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    @Override
    public Object getRowData() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.list.get(this.index);
    }

    @Override
    public int getRowIndex() {
        return this.index;
    }

    @Override
    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.list == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event2 = new DataModelEvent(this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event2);
            }
        }
    }

    @Override
    public Object getWrappedData() {
        return this.list;
    }

    @Override
    public void setWrappedData(Object data) {
        if (data == null) {
            this.list = null;
            this.setRowIndex(-1);
        } else {
            this.list = (List)data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

