/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.util;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class CertificateUtil {
    public static X509DataUtil[] getX509Data(Element signature) throws XSignatureException {
        try {
            KeyInfo keyInfo = CertificateUtil.getKeyInfo(signature);
            KeyInfo.X509Data[] x5data = keyInfo.getX509Data();
            if (x5data == null || x5data.length == 0) {
                throw new SignatureStructureException("No X509Data elements.");
            }
            Key k = keyInfo.getKeyValue();
            X509DataUtil[] x5u = new X509DataUtil[x5data.length];
            for (int i = 0; i < x5data.length; ++i) {
                x5u[i] = new X509DataUtil(x5data[i], k);
            }
            return x5u;
        }
        catch (SignatureStructureException sse) {
            throw new XSignatureException((Exception)((Object)sse));
        }
    }

    private static KeyInfo getKeyInfo(Element signature) throws SignatureStructureException, XSignatureException {
        Element keyInfoElement = KeyInfo.searchForKeyInfo((Element)signature);
        if (keyInfoElement == null) {
            throw new SignatureStructureException("No KeyInfo element.");
        }
        return new KeyInfo(keyInfoElement);
    }

    public static class X509DataUtil {
        KeyInfo.X509Data x5data;
        CertStore docStore = null;
        Key publicKey;

        public X509DataUtil(KeyInfo.X509Data x5d, Key k) {
            this.x5data = x5d;
            this.publicKey = k;
        }

        private CertStore createCertStore() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
            Vector<X509Certificate> certs = new Vector<X509Certificate>();
            X509Certificate[] srccerts = this.x5data.getCertificates();
            if (srccerts != null) {
                for (int j = 0; j < srccerts.length; ++j) {
                    certs.addElement(srccerts[j]);
                }
            }
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(certs));
        }

        public Key validate(PKIXBuilderParameters params) throws XSignatureException {
            return this.validateAndGetCert(params).getPublicKey();
        }

        public X509Certificate validateAndGetCert(PKIXBuilderParameters params) throws XSignatureException {
            CertPath path;
            List<CertStore> storeList = params.getCertStores();
            ArrayList<CertStore> newList = new ArrayList<CertStore>((storeList == null ? 0 : storeList.size()) + 1);
            for (int i = 0; i < storeList.size(); ++i) {
                newList.add(storeList.get(i));
            }
            try {
                newList.add(this.createCertStore());
                params.setCertStores(newList);
                CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
                CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                path = builder.build(params).getCertPath();
                validator.validate(path, params);
            }
            catch (InvalidAlgorithmParameterException iape) {
                params.setCertStores(storeList);
                throw new XSignatureException((Exception)iape);
            }
            catch (NoSuchAlgorithmException nsae) {
                params.setCertStores(storeList);
                throw new XSignatureException((Exception)nsae);
            }
            catch (CertPathBuilderException cpbe) {
                params.setCertStores(storeList);
                throw new XSignatureException((Exception)cpbe);
            }
            catch (CertPathValidatorException cpve) {
                params.setCertStores(storeList);
                throw new XSignatureException((Exception)cpve);
            }
            List<? extends Certificate> certs = path.getCertificates();
            return certs.isEmpty() ? null : (X509Certificate)certs.get(0);
        }

        public X509CertSelector createSelector() throws IOException {
            X509Certificate[] certs;
            String[] subjects;
            X509CertSelector selector = new X509CertSelector();
            String[] issuers = this.x5data.getIssuerNames();
            if (issuers != null && issuers.length > 0) {
                BigInteger[] serials = this.x5data.getSerialNumbers();
                selector.setIssuer(issuers[0]);
                selector.setSerialNumber(serials[0]);
            }
            if ((subjects = this.x5data.getSubjectNames()) != null && subjects.length > 0) {
                selector.setSubject(subjects[0]);
            } else {
                X509Certificate[] certs2 = this.x5data.getCertificates();
                if (certs2 != null && certs2.length > 0) {
                    selector.setSubject(certs2[0].getSubjectDN().getName());
                }
            }
            Object[] skis = this.x5data.getSKIs();
            if (skis != null && skis.length > 0) {
                selector.setSubjectKeyIdentifier((byte[])skis[0]);
            }
            if ((certs = this.x5data.getCertificates()) != null && certs.length == 1) {
                selector.setCertificate(certs[0]);
            }
            if (this.publicKey != null) {
                selector.setSubjectPublicKey(this.publicKey.getEncoded());
            }
            return selector;
        }
    }
}

