/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.auth.token.TokenId;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameTokenGenerator
implements TokenGeneratorComponent {
    private static final TraceComponent tc = Tr.register(UsernameTokenGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UsernameTokenGenerator.class.getName();
    private boolean _initialized = false;
    private static final WSSecurityPlatformContext _contextManager = WSSecurityPlatformContextFactory.getInstance();
    private static final String WSSECURITY_SEND_REALM = "com.ibm.wsspi.wssecurity.token.IDAssertion.sendRealm";

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document doc, Element parent, Map context) throws SoapSecurityException {
        boolean alreadyExist;
        UsernameToken tokenPriv;
        UsernameToken token;
        QName vtype;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        TokenGeneratorConfig config = (TokenGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenGeneratorConfig [" + config + "]."));
        }
        if (!com.ibm.ws.webservices.wssecurity.Constants.UNTOKEN.equals(vtype = config.getType())) {
            throw new SoapSecurityException("Unsupported value type: " + vtype);
        }
        NonceManager nmanager = (NonceManager)context.remove(NonceManager.class);
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int wssVersion = 0;
        Object obj2 = null;
        obj2 = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj2 != null && obj2 instanceof Integer) {
            wssVersion = (Integer)obj2;
        }
        String nsWsse = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[0][wssVersion];
        String nsWsu = com.ibm.ws.webservices.wssecurity.Constants.NAMESPACES[1][wssVersion];
        boolean isStandAlone = config.isStandAlone();
        CallbackHandlerConfig cbhconf = config.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CallbackHandlerConfig [" + config + "]."));
        }
        boolean identityAssertion = false;
        boolean useRunAsSubject = false;
        boolean sendRealm = false;
        if (cbhconf != null) {
            obj2 = cbhconf.getProperties().get(Constants.WSSECURITY_USE_IDASSERTION);
            if (obj2 != null) {
                identityAssertion = ConfigUtil.isTrue((String)obj2.toString());
            }
            if ((obj2 = cbhconf.getProperties().get(Constants.WSSECURITY_USE_RUNASIDENTITY)) != null) {
                useRunAsSubject = ConfigUtil.isTrue((String)obj2.toString());
            }
            if ((obj2 = cbhconf.getProperties().get(WSSECURITY_SEND_REALM)) != null) {
                sendRealm = ConfigUtil.isTrue((String)obj2.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("identityAssertion is [" + identityAssertion + "]."));
            Tr.debug((TraceComponent)tc, (String)("useRunAsSubject is [" + useRunAsSubject + "]."));
            Tr.debug((TraceComponent)tc, (String)("sendRealm is [" + sendRealm + "]."));
        }
        String username = null;
        char[] password = null;
        if (useRunAsSubject) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Getting the RunAs identity...");
            }
            username = TokenManager.getRunAsIdentity(sendRealm);
        }
        if (username == null && identityAssertion) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the identifier of initial sender...");
            }
            if (messageContext != null && (obj2 = messageContext.getProperty("com.ibm.wsspi.wssecurity.username.initialSenderId")) != null && obj2 instanceof UsernameToken) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The identifier of initial sender is used.");
                }
                token = (UsernameToken)obj2;
                username = token.getUsername();
                tokenPriv = token;
                password = (char[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return tokenPriv.getPassword();
                    }
                });
            }
        }
        if (username == null && !identityAssertion) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the cached username token...");
            }
            if (messageContext != null && !_contextManager.isServer() && (obj2 = messageContext.getProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken")) != null && obj2 instanceof UsernameToken) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The cached username token is used.");
                }
                token = (UsernameToken)obj2;
                username = token.getUsername();
                tokenPriv = token;
                password = (char[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return tokenPriv.getPassword();
                    }
                });
            }
        }
        if (username == null && cbhconf != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invoking callback handler...");
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String cbhname = cbhconf.getClassName();
            CallbackHandler handler = cbhconf.getInstance();
            if (handler == null) {
                block49: {
                    try {
                        String unStr = cbhconf.getUserId();
                        char[] pwChr = cbhconf.getUserPassword();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Default username is [" + unStr + "]."));
                            Tr.debug((TraceComponent)tc, (String)"password is [XXXXXXXX].");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Instantiating the callback handler [" + cbhname + "]..."));
                        }
                        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Class<?> cls = null;
                        cls = loader != null ? loader.loadClass(cbhname) : Class.forName(cbhname);
                        if (CallbackHandler.class.isAssignableFrom(cls)) {
                            properties.put("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey", cbhconf);
                            Constructor<?> con = cls.getConstructor(String.class, char[].class, Map.class);
                            handler = (CallbackHandler)con.newInstance(unStr, pwChr, properties);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Succeeded to Instantiate the callback handler [" + cbhname + "]."));
                            }
                            break block49;
                        }
                        throw SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", cbhname, CallbackHandler.class.getName());
                    }
                    catch (SoapSecurityException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"357");
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s01", (Object)new Object[]{cbhname, e});
                        throw SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s01", cbhname, (Throwable)e);
                    }
                }
                cbhconf.setInstance(handler);
            }
            properties = new HashMap();
            if (messageContext != null) {
                properties.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
            }
            Callback[] callbacks = new Callback[]{new NameCallback(ConfigUtil.getMessage((String)"security.wssecurity.SenderLogin.token29")), new PasswordCallback(ConfigUtil.getMessage((String)"security.wssecurity.SenderLogin.token30"), false), new PropertyCallback(properties)};
            try {
                handler.handle(callbacks);
            }
            catch (UnsupportedCallbackException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"393");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s02", (Object)new Object[]{cbhname, e});
                SoapSecurityException sse = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", cbhname, (Throwable)e);
                sse.initCause(e);
                throw sse;
            }
            catch (IOException e) {
                Throwable th = e;
                if (e.getCause() != null) {
                    th = e.getCause();
                }
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"402");
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509TokenGenerator.s02", (Object)new Object[]{cbhname, th});
                SoapSecurityException sse = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s02", cbhname, th);
                sse.initCause(e);
                throw sse;
            }
            username = ((NameCallback)callbacks[0]).getName();
            password = ((PasswordCallback)callbacks[1]).getPassword();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Succeeded to invoke the callback handler [" + cbhname + "]."));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Acquired username is [" + username + "]."));
            Tr.debug((TraceComponent)tc, (String)("Acuqired password is [" + (password == null ? "null" : "XXXXXXXX") + "]."));
        }
        if (username == null || username.length() == 0) {
            throw SoapSecurityException.format("security.wssecurity.WSEC5199E");
        }
        context.remove(Constants.WSSECURITY_KEY_EMBID);
        context.remove(Constants.WSSECURITY_KEY_REFERENCE);
        context.remove(Constants.WSSECURITY_KEY_ID);
        context.remove(Constants.WSSECURITY_KEY_NAME);
        context.remove(Constants.WSSECURITY_KEY_ISSUERNAME);
        context.remove(Constants.WSSECURITY_KEY_ISSUERSERIAL);
        String tokenId = null;
        if (isStandAlone && messageContext != null && (obj2 = messageContext.getProperty(Constants.WSSECURITY_TOKEN_PROPERGATION)) != null && obj2 instanceof Set) {
            for (Object obj2 : (Set)obj2) {
                if (!(obj2 instanceof TokenId)) continue;
                TokenId tid = (TokenId)obj2;
                if (!config.getType().equals(tid.getType())) continue;
                if (tokenId == null) {
                    tokenId = tid.getId();
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("More than one TokenId objects are found. Since the runtime tentatively uses the first identifier + \"" + tokenId + "\"," + " it neglects the identifier \"" + tid.getId() + "\"."));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenIdentifier [" + tokenId + "]."));
        }
        if (!(alreadyExist = UsernameTokenGenerator.checkToken(context, config, username, password))) {
            password = identityAssertion ? null : password;
            Element elem = UsernameTokenGenerator.createTokenElement(doc, parent, username, password, tokenId, wssVersion, nsWsse, nsWsu);
            boolean isTimestampRequired = false;
            boolean isNonceRequired = false;
            obj2 = config.getProperties().get(Constants.WSSECURITY_ADD_TIMESTAMP);
            if (obj2 != null) {
                isTimestampRequired = ConfigUtil.isTrue((String)obj2.toString());
            }
            if ((obj2 = config.getProperties().get(Constants.WSSECURITY_ADD_NONCE)) != null) {
                isNonceRequired = ConfigUtil.isTrue((String)obj2.toString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isTimestampRequired is [" + isTimestampRequired + "]."));
                Tr.debug((TraceComponent)tc, (String)("isNonceRequired [" + isNonceRequired + "]."));
            }
            if (isTimestampRequired) {
                NonceUtil.addCreated(doc, elem, nsWsu);
            }
            if (isNonceRequired) {
                NonceUtil.createNonce(doc, elem, nsWsse, nmanager, null);
            }
            elem = (Element)parent.insertBefore(elem, parent.getFirstChild());
            UsernameTokenGenerator.setTokenToSubject(messageContext, context, config, username, password, tokenId, elem, identityAssertion);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    private static boolean checkToken(Map context, TokenGeneratorConfig config, String username, char[] password) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkToken(Map context,TokenGeneratorConfig config,String username[" + username + "]," + "char[] password[XXXXXXXX])"));
        }
        boolean ret = false;
        Set tokens = TokenManager.getTokens(context);
        if (tokens != null && tokens.size() > 0) {
            int hash = username.hashCode();
            if (password != null) {
                hash += new String(password).hashCode();
            }
            String uniqueId = String.valueOf(hash);
            for (Object o : tokens) {
                UsernameToken t;
                if (!(o instanceof UsernameToken) || !(t = (UsernameToken)o).getUsedTokenGenerator().equals(config) || !t.getUniqueID().equals(uniqueId)) continue;
                ret = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkToken(Map context,TokenGeneratorConfig config,String username,char[] password[XXXXXXXX]) returns boolean[" + ret + "]"));
        }
        return ret;
    }

    private static Element createTokenElement(Document doc, Element parent, String username, char[] password, String id, int wssVersion, String nsWsse, String nsWsu) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTokenElement(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String username[" + username + "]," + "char[] password[" + (password == null ? "null" : "XXXXXXXX") + "]," + "String id[" + id + "]," + "int wssVersion[" + wssVersion + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        boolean isDecl = false;
        String pWsse = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsse);
        if (pWsse == null) {
            isDecl = true;
            pWsse = "wsse:";
        } else if (pWsse.length() > 0) {
            pWsse = pWsse + ":";
        }
        Element tokenElem = doc.createElementNS(nsWsse, pWsse + "UsernameToken");
        if (isDecl) {
            tokenElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", nsWsse);
        }
        if (id != null) {
            isDecl = false;
            String pWsu = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsu);
            if (pWsu == null) {
                isDecl = true;
                pWsu = "wsu:";
            } else if (pWsse.length() > 0) {
                pWsu = pWsu + ":";
            }
            if (isDecl) {
                tokenElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", nsWsu);
            }
            tokenElem.setAttributeNS(com.ibm.ws.webservices.wssecurity.Constants.NS_WSU, pWsu + "Id", id);
        }
        Element un = doc.createElementNS(com.ibm.ws.webservices.wssecurity.Constants.NS_WSSE, pWsse + "Username");
        un.appendChild(doc.createTextNode(username));
        un = (Element)tokenElem.appendChild(un);
        if (password != null && password.length > 0) {
            Element pwd = doc.createElementNS(com.ibm.ws.webservices.wssecurity.Constants.NS_WSSE, pWsse + "Password");
            DOMUtil.setQNameAttr(pwd, null, "Type", com.ibm.ws.webservices.wssecurity.Constants.PASSWORD_TEXT, wssVersion);
            pwd.appendChild(doc.createTextNode(new String(password)));
            pwd = (Element)tokenElem.appendChild(pwd);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTokenElement(Document doc,Element parent,String username,char[] password,String id,int wssVersion,String nsWsse,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)tokenElem) + "]"));
        }
        return tokenElem;
    }

    private static void setTokenToSubject(SOAPMessageContext mcontext, Map context, TokenGeneratorConfig config, String username, char[] password, String id, Element elem, boolean identityAssertion) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setTokenToSubject(SOAPMessageContext mcontext,Map context,TokenGeneratorConfig config,String username[" + username + "]," + "char[] password," + "String id[" + id + "]," + "Element elem[" + DOMUtil.getDisplayName((Node)elem) + "]," + "boolean identityAssertion[" + identityAssertion + "])"));
        }
        UsernameToken token = new UsernameToken(id, username, password);
        token.setElement(elem);
        token.setReferenced(!config.isStandAlone());
        token.setUsedTokenGenerator(config);
        TokenManager.setToken(context, token);
        if (mcontext != null && !identityAssertion) {
            mcontext.setProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken", token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTokenToSubject(SOAPMessageContext mcontext,Map context,TokenGeneratorConfig config,String username,char[] password,String id,Element elem)boolean identityAssertion");
        }
    }
}

