/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.KRBConstants;
import com.ibm.ws.webservices.wssecurity.config.KRBSPN;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.PropertyCallback;
import com.ibm.wsspi.wssecurity.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.token.KRBDerivedKeyToken;
import com.ibm.wsspi.wssecurity.token.KRBTokenInfo;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KRBTokenGenerator
implements TokenGeneratorComponent {
    private static final String comp = "security.wssecurity";
    private static TraceComponent tc = Tr.register(KRBTokenGenerator.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String STR_CLIENT_NAME = "clientName";
    private static final String STR_CLIENT_PASSWORD = "clientPassword";

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void invoke(Document doc, Element parent, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke()");
        }
        KRBTokenGenerator.invoke(doc, parent, context, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke()");
        }
    }

    private static void invoke(Document doc, Element parent, Map context, boolean insertToken) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke()");
        }
        TokenGeneratorConfig config = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "config:" + config);
        }
        try {
            KRBSPN spnObj;
            boolean addBinarySecurityTokenHeader = false;
            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            KRBTokenInfo krbTokenInfo = (KRBTokenInfo)messageContext.getProperty("com.ibm.wsspi.wssecurity.kerberosTokenInfo");
            String valueType = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ";
            QName vType = config.getType();
            if (vType != null) {
                valueType = vType.toString();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "valueType:" + valueType);
            }
            if (krbTokenInfo == null && (addBinarySecurityTokenHeader = KRBTokenGenerator.generateKRBToken(context, valueType, spnObj = KRB5Util.getSPNList().getSPN(config.getProperties(), 2)))) {
                krbTokenInfo = (KRBTokenInfo)messageContext.getProperty("com.ibm.wsspi.wssecurity.kerberosTokenInfo");
            }
            String keyType = KRBTokenGenerator.getKeyType(context, config);
            KRBTokenGenerator.addKRBSOAPHeaders(doc, context, addBinarySecurityTokenHeader, keyType, valueType);
            KRBTokenGenerator.updateReferenceInContext(context, krbTokenInfo);
        }
        catch (Throwable e) {
            Tr.error(tc, "security.wssecurity.kerberos.unexpected.exception", KRB5Util.stackToString(e));
            throw new JAXRPCException(KRB5Util.getFormattedMessage(KRB5Util.getNLS(), "security.wssecurity.kerberos.unexpected.exception", new Object[]{e}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke()");
        }
    }

    public static void addKRBSOAPHeaders(Document doc, Map context, boolean addBinarySecurityTokenHeader, String keyType, String valueType) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addKRBSOAPHeaders()");
        }
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        KRBTokenInfo krbTokenInfo = (KRBTokenInfo)messageContext.getProperty("com.ibm.wsspi.wssecurity.kerberosTokenInfo");
        SOAPEnvelope se = KRBTokenGenerator.getSecurityEnvelope(context);
        if (se == null) {
            throw new SoapSecurityException(ConfigUtil.getMessage((String)"security.wssecurity.kerberos.secenv.unavailable"));
        }
        se.addNamespaceDeclaration("wsse", KRBConstants.STR_WSSE_NS);
        se.addNamespaceDeclaration("wsu", KRBConstants.STR_VALUE_TYPE_NS);
        SOAPHeaderElement she = KRBTokenGenerator.getSecurityHeader(se);
        if (keyType != null) {
            KRBDerivedKeyToken derivedKeyTokenForDecrypting = (KRBDerivedKeyToken)messageContext.getProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.DecryptingKey");
            KRBDerivedKeyToken derivedKeyTokenForVerifying = (KRBDerivedKeyToken)messageContext.getProperty("com.ibm.wsspi.wssecurity.derivedKeyToken.VerifyingKey");
            KRBDerivedKeyToken krbDeriveKeyToken = null;
            boolean requestGenerator = true;
            String algorithm = null;
            algorithm = (String)context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "derivedKeyTokenForDecrypting:" + derivedKeyTokenForDecrypting);
                Tr.debug(tc, "derivedKeyTokenForVerifying:" + derivedKeyTokenForVerifying);
                Tr.debug(tc, "Algorithm to use = " + algorithm);
            }
            if (keyType.equalsIgnoreCase("EncryptingKey") && derivedKeyTokenForDecrypting != null) {
                krbDeriveKeyToken = KRB5Util.generateDerivedKeyTokenForResponse(derivedKeyTokenForDecrypting);
                requestGenerator = false;
            } else if (keyType.equalsIgnoreCase("SigningKey") && derivedKeyTokenForVerifying != null) {
                krbDeriveKeyToken = KRB5Util.generateDerivedKeyTokenForResponse(derivedKeyTokenForVerifying);
                requestGenerator = false;
            } else {
                krbDeriveKeyToken = KRB5Util.generateDerivedKeyTokenForRequest(keyType, valueType, algorithm);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requestGenerator:" + requestGenerator);
            }
            KRB5Util.addDerivedkeyTokenToContext(messageContext, krbDeriveKeyToken);
            context.put(Constants.WSSECURITY_KEY_REFERENCE, "#" + krbDeriveKeyToken.getId());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating derived key token element in the response.");
            }
            KRBTokenGenerator.addDerivedKeyTokenHeader(doc, se, she, krbDeriveKeyToken, krbTokenInfo, requestGenerator);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Done creating the derived key token element in the response.");
            }
        }
        if (addBinarySecurityTokenHeader) {
            KRBTokenGenerator.addBinarySecurityTokenHeader(doc, se, she, krbTokenInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addKRBSOAPHeaders()");
        }
    }

    private static SOAPEnvelope getSecurityEnvelope(Map context) throws Throwable {
        SOAPMessageContext messageContext;
        SOAPEnvelope se = null;
        SOAPMessageContext smc = messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        SOAPMessage msg = smc.getMessage();
        SOAPPart sp = msg.getSOAPPart();
        se = sp.getEnvelope();
        return se;
    }

    private static SOAPHeaderElement getSecurityHeader(SOAPEnvelope se) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityHeader()");
        }
        SOAPHeaderElement she = null;
        SOAPHeader sh = se.getHeader();
        Name securityHeader = se.createName("Security", "wsse", KRBConstants.STR_WSSE_NS);
        if (sh == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security header doesn't exists");
            }
            sh = se.addHeader();
            she = sh.addHeaderElement(securityHeader);
        } else {
            Iterator securityElementsIter = sh.getChildElements(securityHeader);
            if (securityElementsIter.hasNext()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security header already exists");
                }
                she = (SOAPHeaderElement)securityElementsIter.next();
            } else {
                Tr.debug(tc, "Security header doesn't match with waht is being created");
                she = sh.addHeaderElement(securityHeader);
            }
        }
        she.setMustUnderstand(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityHeader()");
        }
        return she;
    }

    private static void addDerivedKeyTokenHeader(Document doc, SOAPEnvelope se, SOAPHeaderElement she, KRBDerivedKeyToken krbDeriveKeyToken, KRBTokenInfo krbTokenInfo, boolean requestGenerator) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDerivedKeyTokenHeader()");
        }
        Name dkt = se.createName("DerivedKeyToken", "wssc", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        SOAPElement dktSoapElement = she.addChildElement(dkt);
        KRBTokenGenerator.fixupSOAPHeaderOrder(she, dktSoapElement);
        dktSoapElement.addNamespaceDeclaration("Security", KRBConstants.STR_VALUE_TYPE_NS);
        dktSoapElement.addAttribute(se.createName("wsu:Id"), krbDeriveKeyToken.getId());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "wsu:Id" + krbDeriveKeyToken.getId());
        }
        dktSoapElement.addAttribute(se.createName("Algorithm"), krbDeriveKeyToken.getAlgorithm());
        dktSoapElement.addAttribute(se.createName("ValueType"), krbDeriveKeyToken.getType().toString());
        Name securityTokenReference = se.createName("SecurityTokenReference", "wsse", KRBConstants.STR_WSSE_NS);
        SOAPElement securityTokenReferenceSoapElement = dktSoapElement.addChildElement(securityTokenReference);
        if (requestGenerator) {
            Name referenceIdentifier = se.createName("Reference", "wsse", KRBConstants.STR_WSSE_NS);
            SOAPElement referenceIdentifierSoapElement = securityTokenReferenceSoapElement.addChildElement(referenceIdentifier);
            referenceIdentifierSoapElement.addAttribute(se.createName("ValueType"), krbTokenInfo.getType().toString());
            referenceIdentifierSoapElement.addAttribute(se.createName("URI"), "#" + krbTokenInfo.getId());
        } else {
            Name keyIdentifier = se.createName("KeyIdentifier", "wsse", KRBConstants.STR_WSSE_NS);
            SOAPElement keyIdentifierSoapElement = securityTokenReferenceSoapElement.addChildElement(keyIdentifier);
            keyIdentifierSoapElement.addAttribute(se.createName("ValueType"), "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            keyIdentifierSoapElement.addAttribute(se.createName("EncodingType"), KRBConstants.STR_BASE64_ENCODING);
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                sha1.update(krbTokenInfo.getKerberosToken());
                byte[] sha1Result = sha1.digest();
                if (sha1Result != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SHA-1 result  :  " + KRB5Util.showHex(sha1Result));
                    }
                    keyIdentifierSoapElement.appendChild((Node)doc.createTextNode(new String(Base64Coder.base64Encode(sha1Result))));
                }
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SHA1 provider needed");
                }
                Tr.error(tc, "security.wssecurity.kerberos.unexpected.exception", KRB5Util.stackToString(ex));
            }
        }
        Name generation = se.createName("Generation", "wssc", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        SOAPElement generationSoapElement = dktSoapElement.addChildElement(generation);
        generationSoapElement.addTextNode(Integer.toString(krbDeriveKeyToken.getGeneration()));
        Name length = se.createName("Length", "wssc", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        SOAPElement lengthSoapElement = dktSoapElement.addChildElement(length);
        lengthSoapElement.addTextNode(Integer.toString(krbDeriveKeyToken.getLength()));
        Name label = se.createName("Label", "wssc", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        SOAPElement labelSoapElement = dktSoapElement.addChildElement(label);
        labelSoapElement.addTextNode(krbDeriveKeyToken.getLabel());
        Name nonce = se.createName("Nonce", "wssc", "http://schemas.xmlsoap.org/ws/2005/02/sc");
        SOAPElement nonceSoapElement = dktSoapElement.addChildElement(nonce);
        nonceSoapElement.addTextNode(new String(krbDeriveKeyToken.getNonce()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDerivedKeyTokenHeader()");
        }
    }

    private static void addBinarySecurityTokenHeader(Document doc, SOAPEnvelope se, SOAPHeaderElement she, KRBTokenInfo krbTokenInfo) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addBinarySecurityTokenHeader()");
        }
        Name dkt = se.createName("<wsse:BinarySecurityToken", "wsse", KRBConstants.STR_WSSE_NS);
        SOAPElement bstSoapElement = she.addChildElement(dkt);
        Node dktNode = she.removeChild((Node)bstSoapElement);
        she.insertBefore(dktNode, she.getFirstChild());
        bstSoapElement.addAttribute(se.createName("ValueType"), krbTokenInfo.getType().toString());
        bstSoapElement.addAttribute(se.createName("EncodingType"), KRBConstants.STR_BASE64_ENCODING);
        bstSoapElement.addAttribute(se.createName("wsu:Id"), krbTokenInfo.getId());
        bstSoapElement.addTextNode(new String(Base64Coder.base64Encode(krbTokenInfo.getKerberosToken())));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addBinarySecurityTokenHeader()");
        }
    }

    private static void fixupSOAPHeaderOrder(SOAPHeaderElement she, SOAPElement dktSoapElement) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupSOAPHeaderOrder()");
        }
        NodeList childList = she.getChildNodes();
        for (int idx = 0; idx < childList.getLength(); ++idx) {
            Node currentChild = childList.item(idx);
            if (!currentChild.getNodeName().equals("wsse:BinarySecurityToken")) continue;
            if (idx == 0) break;
            Node bstNode = she.removeChild(currentChild);
            she.insertBefore(bstNode, she.getFirstChild());
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "The BinarySecurityToken header is re-inserted again as the first node.");
            break;
        }
        Node dktNode = she.removeChild((Node)dktSoapElement);
        Node firstNode = she.getFirstChild();
        if (firstNode.getNodeName().equals("wsse:BinarySecurityToken")) {
            Node secondNode;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The BinarySecurityToken header is the first node.");
            }
            if ((secondNode = firstNode.getNextSibling()) == null) {
                she.appendChild(firstNode);
            } else {
                she.insertBefore(dktNode, secondNode);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The BinarySecurityToken header is not the first node.");
            }
            she.insertBefore(dktNode, firstNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupSOAPHeaderOrder()");
        }
    }

    public static String getKeyType(Map context, TokenGeneratorConfig config) {
        String keyType;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyType()");
        }
        if ((keyType = (String)context.get(Constants.WSSECURITY_KEY_TYPE)) == null && config != null) {
            keyType = (String)config.getProperties().get(Constants.WSSECURITY_KEY_TYPE);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Key type: " + keyType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyType()");
        }
        return keyType;
    }

    private static boolean generateKRBToken(Map context, String valueType, KRBSPN spnObj) throws Throwable {
        boolean bTokenGenerated = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKRBToken()");
        }
        try {
            MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "messageContext:" + messageContext);
            }
            Subject callerSubject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Subject callerSubject;
                    block2: {
                        callerSubject = null;
                        try {
                            callerSubject = WSSubject.getCallerSubject();
                        }
                        catch (Throwable t) {
                            if (!tc.isDebugEnabled()) break block2;
                            Tr.debug(tc, "Exception in WSSUbject.getCallerSubject(). ");
                        }
                    }
                    return callerSubject;
                }
            });
            String was_principal = null;
            char[] clientPassword = null;
            was_principal = KRB5Util.getKerberosPrincipalFromSubject(callerSubject);
            if (was_principal == null) {
                HashMap loginProperties = KRBTokenGenerator.getLoginProperties(context);
                was_principal = (String)loginProperties.get(STR_CLIENT_NAME);
                clientPassword = (char[])loginProperties.get(STR_CLIENT_PASSWORD);
                if (was_principal == null || was_principal.length() == 0) {
                    was_principal = KRB5Util.getCurrentLoggedOnUser();
                }
            }
            HashMap krbTokenInfoProperties = KRB5Util.generateKerberosToken(callerSubject, valueType, spnObj, was_principal, clientPassword);
            KRBTokenInfo krbTokenInfo = new KRBTokenInfo(krbTokenInfoProperties);
            messageContext.setProperty("com.ibm.wsspi.wssecurity.kerberosTokenInfo", krbTokenInfo);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Message context is updated with kerberos token.");
            }
            bTokenGenerated = true;
        }
        catch (Exception e) {
            throw new JAXRPCException("WSSecurityException - unable to generate Kerberos token", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKRBToken()");
        }
        return bTokenGenerated;
    }

    private static HashMap getLoginProperties(Map context) throws Throwable {
        HashMap<String, Object> loginProperties = new HashMap<String, Object>();
        MessageContext messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        TokenGeneratorConfig config = (TokenGeneratorConfig)context.get("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TokenGeneratorConfig [" + config + "].");
        }
        String username = null;
        char[] password = null;
        CallbackHandlerConfig cbhconf = config.getCallbackHandler();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerConfig [" + cbhconf + "].");
        }
        if (cbhconf != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking callback handler...");
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String cbhname = cbhconf.getClassName();
            CallbackHandler handler = cbhconf.getInstance();
            if (handler == null) {
                block20: {
                    try {
                        String unStr = cbhconf.getUserId();
                        char[] pwChr = cbhconf.getUserPassword();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Default username is [" + unStr + "].");
                            Tr.debug(tc, "Default password is [" + (pwChr == null ? "null" : "XXXXXXXX") + "].");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Instantiating the callback handler [" + cbhname + "]...");
                        }
                        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Class<?> cls = null;
                        cls = loader != null ? loader.loadClass(cbhname) : Class.forName(cbhname);
                        if (CallbackHandler.class.isAssignableFrom(cls)) {
                            properties.put("com.ibm.wsspi.wssecurity.config.callbackHandler.configKey", cbhconf);
                            Constructor<?> con = cls.getConstructor(String.class, char[].class, Map.class);
                            handler = (CallbackHandler)con.newInstance(unStr, pwChr, properties);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + cbhname + "].");
                            }
                            break block20;
                        }
                        throw SoapSecurityException.format("security.wssecurity.KRBTokenGenerator.s01", cbhname, CallbackHandler.class.getName());
                    }
                    catch (SoapSecurityException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Tr.error(tc, "security.wssecurity.KRBTokenGenerator.s01", new Object[]{cbhname, e.toString()});
                        throw SoapSecurityException.format("security.wssecurity.KRBTokenGenerator.s02", cbhname, e.toString());
                    }
                }
                cbhconf.setInstance(handler);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Callback handler [" + cbhname + "] already exists...");
            }
            properties = new HashMap();
            if (messageContext != null) {
                properties.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
            }
            Callback[] callbacks = new Callback[]{new NameCallback(ConfigUtil.getMessage((String)"security.wssecurity.SenderLogin.token29")), new PasswordCallback(ConfigUtil.getMessage((String)"security.wssecurity.SenderLogin.token30"), false), new PropertyCallback(properties)};
            try {
                handler.handle(callbacks);
            }
            catch (UnsupportedCallbackException e) {
                Tr.error(tc, "security.wssecurity.KRBTokenGenerator.s02", new Object[]{cbhname, e});
                throw SoapSecurityException.format("security.wssecurity.KRBTokenGenerator.s02", cbhname, (Throwable)e);
            }
            catch (IOException e) {
                Tr.error(tc, "security.wssecurity.KRBTokenGenerator.s02", new Object[]{cbhname, e});
                throw SoapSecurityException.format("security.wssecurity.KRBTokenGenerator.s02", cbhname, (Throwable)e);
            }
            username = ((NameCallback)callbacks[0]).getName();
            password = ((PasswordCallback)callbacks[1]).getPassword();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeeded to invoke the callback handler [" + cbhname + "].");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Acquired username is [" + username + "].");
            Tr.debug(tc, "Acuqired password is [" + (password == null ? "null" : "XXXXXXXX") + "].");
        }
        loginProperties.put(STR_CLIENT_NAME, username);
        loginProperties.put(STR_CLIENT_PASSWORD, password);
        return loginProperties;
    }

    public static void updateReferenceInContext(Map context, KRBTokenInfo krbTokenInfo) throws Throwable {
        String contextRef = (String)context.get(Constants.WSSECURITY_KEY_REFERENCE);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Current context reference:" + contextRef);
        }
        if (contextRef == null && krbTokenInfo != null) {
            String newReference = "#" + krbTokenInfo.getId();
            context.put(Constants.WSSECURITY_KEY_REFERENCE, newReference);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security Reference " + newReference + " is put in the message context.");
            }
        }
    }
}

