/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.KRBConstants;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.KRBTokenCallbackHandler;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.KRBDerivedKeyToken;
import com.ibm.wsspi.wssecurity.token.KRBMappedIdentityToken;
import com.ibm.wsspi.wssecurity.token.KRBToken;
import com.ibm.wsspi.wssecurity.token.KRBTokenInfo;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KRBTokenConsumer
implements TokenConsumerComponent {
    private static final String comp = "security.wssecurity";
    private static TraceComponent tc = null;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (KRBTokenConsumer.tc.isEntryEnabled()) {
            Tr.entry(KRBTokenConsumer.tc, "invoke()");
        }
        config = (TokenConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        messageContext = (MessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        if (KRBTokenConsumer.tc.isDebugEnabled()) {
            Tr.debug(KRBTokenConsumer.tc, "Consuming the token " + target.getNodeName());
        }
        if (target.getNodeName().equals("wssc:DerivedKeyToken")) {
            try {
                dktProperties = KRB5Util.consumeDerivedKeyToken((Element)target);
                if (KRBTokenConsumer.tc.isDebugEnabled()) {
                    Tr.debug(KRBTokenConsumer.tc, "Creating the derived key token ");
                }
                derivedKeyToken = new KRBDerivedKeyToken(dktProperties);
                KRB5Util.addDerivedkeyTokenToContext(messageContext, derivedKeyToken);
                if (KRB5Util.addCredentialToSubject(subject, derivedKeyToken)) {
                    if (!KRBTokenConsumer.tc.isDebugEnabled()) ** GOTO lbl74
                    Tr.debug(KRBTokenConsumer.tc, "Subject is updated with dervied key token.");
                }
                if (!KRBTokenConsumer.tc.isDebugEnabled()) ** GOTO lbl74
                Tr.debug(KRBTokenConsumer.tc, "Subject is not updated with dervied key token.");
            }
            catch (Throwable t) {
                throw SoapSecurityException.format(new QName(KRBConstants.STR_WSSE_NS, "Failed to consume Kerberos token."), "security.wssecurity.KRBTokenConsumer.s01", t.toString());
            }
        } else if (target.getNodeType() == 1) {
            try {
                spnObj = KRB5Util.getSPNList().getSPN(config.getProperties(), 1);
                bstProperties = KRB5Util.consumeBinarySecurityToken((Element)target);
                bstProperties.put("com.ibm.wsspi.wssecurity.auth.SPNObj", spnObj);
                bstProperties.put("com.ibm.wsspi.wssecurity.core.messageContext", messageContext);
                if (KRBTokenConsumer.tc.isDebugEnabled()) {
                    Tr.debug(KRBTokenConsumer.tc, "Creating KerberosToken callback handler");
                }
                handler = new KRBTokenCallbackHandler(bstProperties);
                lcontext = null;
                jconfig = config.getJAASConfig();
                if (KRBTokenConsumer.tc.isDebugEnabled()) {
                    Tr.debug(KRBTokenConsumer.tc, "Creating the loginContext for " + jconfig);
                }
                lcontext = new LoginContext(jconfig, subject, handler);
                if (KRBTokenConsumer.tc.isDebugEnabled()) {
                    Tr.debug(KRBTokenConsumer.tc, "Starting the Kerberos login  ");
                }
                lcontext.login();
                if (KRBTokenConsumer.tc.isDebugEnabled()) {
                    Tr.debug(KRBTokenConsumer.tc, "After Kerberos login  ");
                }
                if ((krbTokenInfo = (KRBTokenInfo)messageContext.getProperty("com.ibm.wsspi.wssecurity.kerberosTokenInfo")) != null) {
                    KRBTokenConsumer.addKerberosTokenToSubject(subject, krbTokenInfo);
                }
                if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
                    auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "TokenId", krbTokenInfo.getId());
                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "Username", krbTokenInfo.getPrincipal());
                    WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, jconfig, "SUCCESS");
                    WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                }
                if (!KRBTokenConsumer.tc.isDebugEnabled()) ** GOTO lbl74
                Tr.debug(KRBTokenConsumer.tc, "Auditing SECURITY_AUTHN event not enabled.");
            }
            catch (LoginException e) {
                if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                    auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, e.toString());
                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                    WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, config.getJAASConfig(), "SUCCESS");
                    WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                }
                throw SoapSecurityException.format(new QName(KRBConstants.STR_WSSE_NS, "FailedAuthentication"), "security.wssecurity.KRBTokenConsumer.s01", e.toString());
            }
            catch (Throwable t) {
                if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.ERROR)) {
                    auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, t.toString());
                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "AuthnType", config.getType().toString());
                    WSSAuditEventGeneratorImpl.getInstance().addProviderData(auditContext, config.getJAASConfig(), "FAILURE");
                    WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, messageContext, context);
                }
                throw SoapSecurityException.format(new QName(KRBConstants.STR_WSSE_NS, "FailedAuthentication"), "security.wssecurity.KRBTokenConsumer.s01", t.toString());
            }
        } else {
            throw SoapSecurityException.format("WARNING: Unsupported node type: " + target.getNodeName());
        }
lbl74:
        // 7 sources

        if (KRBTokenConsumer.tc.isEntryEnabled()) {
            Tr.exit(KRBTokenConsumer.tc, "invoke()");
        }
    }

    public static void addKerberosTokenToSubject(Subject subject, KRBTokenInfo krbTokenInfo) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addKerberosTokenToSubject()");
        }
        HashMap<String, String> krbTokenProperties = new HashMap<String, String>();
        krbTokenProperties.put("tokenID", krbTokenInfo.getId());
        krbTokenProperties.put("WASPrincipal", krbTokenInfo.getPrincipal());
        krbTokenProperties.put("uniqueID", krbTokenInfo.getUniqueID());
        krbTokenProperties.put("ExpiryTime", Long.toString(krbTokenInfo.getExpiration()));
        krbTokenProperties.put("ValueType", krbTokenInfo.getType().toString());
        KRBToken krbToken = new KRBToken(krbTokenProperties);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KRBToken created.");
        }
        if (KRB5Util.isTokenInSubject(subject, KRBMappedIdentityToken.class) && krbToken != null) {
            krbToken.setProcessed();
        }
        if (KRB5Util.addCredentialToSubject(subject, krbToken)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Subject is updated with kerberos token.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Subject is not updated with kerberos token.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addKerberosTokenToSubject()");
        }
    }

    static {
        tc = Tr.register(KRBTokenConsumer.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

