/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import java.util.Date;
import java.util.HashMap;

public class KRBToken
extends WSSToken {
    private static TraceComponent tc = null;
    private String principal = "";
    private String uniqueID = "";
    private boolean valid = true;
    private boolean readOnly = false;
    private long expiration = -1L;

    public KRBToken(HashMap properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBToken");
        }
        if (properties != null) {
            String valueType;
            this._tokenId = (String)properties.get("tokenID");
            this.principal = (String)properties.get("WASPrincipal");
            this.uniqueID = (String)properties.get("uniqueID");
            String expiryTime = (String)properties.get("ExpiryTime");
            if (expiryTime != null && !expiryTime.equals("")) {
                try {
                    this.expiration = Long.parseLong(expiryTime);
                }
                catch (NumberFormatException n) {
                    this.expiration = -1L;
                }
            }
            if ((valueType = (String)properties.get("ValueType")) == null || valueType.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "valueType is not passed.");
                }
                valueType = "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ";
            }
            this.setType("", valueType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tokenID:" + this._tokenId);
            Tr.debug(tc, "principal:" + this.principal);
            Tr.debug(tc, "uniqueID:" + this.uniqueID);
            if (this.expiration != -1L) {
                Tr.debug(tc, "expiryTime:" + new Date(this.expiration).toString());
            } else {
                Tr.debug(tc, "expiryTime: -1");
            }
            if (this.getType() != null) {
                Tr.debug(tc, "valueType:" + this.getType().toString());
            } else {
                Tr.debug(tc, "valueType: null");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBToken");
        }
    }

    public void setProcessed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProcessed");
        }
        this.setProcessed(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProcessed");
        }
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public long getExpiration() {
        return this.expiration;
    }

    static {
        tc = Tr.register(KRBToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

