/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class WSSToken
implements Token {
    protected static final short _version = 1;
    protected HashMap _attributes = new HashMap();
    private static final String setTrustedpermission = "wssecurity.WSSToken.setTrusted";
    private static final String addAttributePermission = "wssecurity.WSSToken.addAttribute";
    private static final String setUsedTokenConsumerPermission = "wssecurity.WSSToken.setUsedTokenConsumer";
    protected String _tokenId = null;
    protected Element _tokenelem = null;
    protected QName _vtype = null;
    protected String _keyInfoType = null;
    protected boolean _trusted = false;
    protected boolean _usedToLogin = false;
    protected boolean _callerChecked = false;
    protected boolean _referenced = false;
    private boolean _isReadOnly = false;
    protected TokenGeneratorConfig _usedTokenGenerator = null;
    protected TokenConsumerConfig _usedTokenConsumer = null;
    protected boolean _processed = false;
    protected SoapSecurityException _error = null;
    private static final TraceComponent tc = Tr.register(WSSToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final WebSphereRuntimePermission SETTRUSTED_PERM = new WebSphereRuntimePermission("wssecurity.WSSToken.setTrusted");
    private static final WebSphereRuntimePermission ADDATRIBUTE_PERM = new WebSphereRuntimePermission("wssecurity.WSSToken.addAttribute");
    private static final WebSphereRuntimePermission SETUSEDTOKENCONSUMER_PERM = new WebSphereRuntimePermission("wssecurity.WSSToken.setUsedTokenConsumer");

    public String getId() {
        if (this.isReadOnly()) {
            String thisID = new String(this._tokenId);
            return thisID;
        }
        return this._tokenId;
    }

    public void setId(String tid) {
        if (this.isReadOnly()) {
            return;
        }
        this._tokenId = tid;
    }

    public Element getElement() {
        if (this.isReadOnly()) {
            Element tokenElement = (Element)this._tokenelem.cloneNode(true);
            return tokenElement;
        }
        return this._tokenelem;
    }

    public void setElement(Element elem) {
        if (this.isReadOnly()) {
            return;
        }
        this._tokenelem = elem;
    }

    public QName getType() {
        if (this.isReadOnly()) {
            QName type = new QName(this._vtype.getNamespaceURI(), this._vtype.getLocalPart());
            return type;
        }
        return this._vtype;
    }

    public void setType(QName type) {
        if (this.isReadOnly()) {
            return;
        }
        this._vtype = type;
    }

    public void setType(String uri, String localName) {
        if (this.isReadOnly()) {
            return;
        }
        this._vtype = new QName(uri, localName);
    }

    public String getKeyInfoType() {
        if (this.isReadOnly()) {
            String keyInfoType = new String(this._keyInfoType);
            return keyInfoType;
        }
        return this._keyInfoType;
    }

    public void setKeyInfoType(String keyInfoType) {
        if (this.isReadOnly()) {
            return;
        }
        this._keyInfoType = keyInfoType;
    }

    public byte[] getBytes() {
        return null;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public short getVersion() {
        return 1;
    }

    public boolean isForwardable() {
        return false;
    }

    public Object clone() {
        return this.clone();
    }

    public void setTrusted(boolean trusted) {
        Tr.entry(tc, "setTrusted");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETTRUSTED_PERM.toString());
            }
            sm.checkPermission(SETTRUSTED_PERM);
        }
        Tr.exit(tc, "setTrusted");
        if (this.isReadOnly()) {
            return;
        }
        this._trusted = trusted;
    }

    public boolean isTrusted() {
        return this._trusted;
    }

    public void setUsedToLogin(boolean usedToLogin) {
        this._usedToLogin = usedToLogin;
    }

    public boolean getUsedToLogin() {
        return this._usedToLogin;
    }

    public Enumeration getAttributeNames() {
        Iterator itr = this._attributes.keySet().iterator();
        return itr == null ? null : new AttributesEnumerator(itr);
    }

    public String[] getAttributes(String key) {
        ArrayList list = (ArrayList)this._attributes.get(key);
        return list == null ? null : list.toArray(new String[0]);
    }

    public String[] addAttribute(String key, String value) {
        Tr.entry(tc, "addAttribute");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + ADDATRIBUTE_PERM.toString());
            }
            sm.checkPermission(ADDATRIBUTE_PERM);
        }
        if (this.isReadOnly()) {
            return null;
        }
        ArrayList<String> list = (ArrayList<String>)this._attributes.get(key);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(value);
        Tr.exit(tc, "addAttribute");
        return list.toArray(new String[0]);
    }

    public void setCallerChecked(boolean isCallerChecked) {
        if (this.isReadOnly()) {
            return;
        }
        this._callerChecked = isCallerChecked;
    }

    public boolean getCallerChecked() {
        return this._callerChecked;
    }

    public boolean isReferenced() {
        return this._referenced;
    }

    public void setReferenced(boolean isReferenced) {
        this._referenced = isReferenced;
    }

    public TokenGeneratorConfig getUsedTokenGenerator() {
        return this._usedTokenGenerator;
    }

    public void setUsedTokenGenerator(TokenGeneratorConfig usedConfig) {
        if (this.isReadOnly()) {
            return;
        }
        this._usedTokenGenerator = usedConfig;
    }

    public TokenConsumerConfig getUsedTokenConsumer() {
        return this._usedTokenConsumer;
    }

    public void setUsedTokenConsumer(TokenConsumerConfig usedConfig) {
        Tr.entry(tc, "setUsedTokenConsumer");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSEDTOKENCONSUMER_PERM.toString());
            }
            sm.checkPermission(SETUSEDTOKENCONSUMER_PERM);
        }
        Tr.exit(tc, "setUsedTokenConsumer");
        if (this.isReadOnly()) {
            return;
        }
        this._usedTokenConsumer = usedConfig;
    }

    public boolean isProcessed() {
        return this._processed;
    }

    public void setProcessed(boolean isProcessed) {
        if (this.isReadOnly()) {
            return;
        }
        this._processed = isProcessed;
    }

    public SoapSecurityException getError() {
        return this._error;
    }

    public void setError(SoapSecurityException error) {
        this._error = error;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly() {
        this._isReadOnly = true;
    }

    protected class AttributesEnumerator
    implements Enumeration {
        protected Iterator _it;

        public AttributesEnumerator(Iterator it) {
            this._it = it;
        }

        public boolean hasMoreElements() {
            return this._it.hasNext();
        }

        public Object nextElement() throws NoSuchElementException {
            return this._it.next();
        }
    }
}

