/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.auth.token.WSSToken;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameToken
extends WSSToken {
    private String uid = null;
    private String _username = null;
    private char[] _password = null;
    private Date _date = null;
    private volatile int hashCode = 0;
    private static final String setUsernamePermission = "wssecurity.UsernameToken.setUsername";
    private static final String getPasswordPermission = "wssecurity.UsernameToken.getPassword";
    private static final String setPasswordPermission = "wssecurity.UsernameToken.setPassword";
    private static final String setExpirationPermission = "wssecurity.UsernameToken.setExpiration";
    private static final TraceComponent tc = Tr.register(UsernameToken.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final WebSphereRuntimePermission SETUSERNAME_PERM = new WebSphereRuntimePermission("wssecurity.UsernameToken.setUsername");
    private static final WebSphereRuntimePermission GETPASSWORD_PERM = new WebSphereRuntimePermission("wssecurity.UsernameToken.getPassword");
    private static final WebSphereRuntimePermission SETPASSWORD_PERM = new WebSphereRuntimePermission("wssecurity.UsernameToken.setPassword");
    private static final WebSphereRuntimePermission SETEXPIRATION_PERM = new WebSphereRuntimePermission("wssecurity.UsernameToken.setExpiration");
    private long _expiration;

    public UsernameToken(String tokenId, String username, char[] password) {
        this(tokenId, username, password, null);
    }

    public UsernameToken(String tokenId, String username, char[] password, Element elem) {
        this._tokenId = tokenId == null ? "" : tokenId;
        this._username = username;
        this._password = password;
        this._tokenelem = elem;
        this._vtype = Constants.UNTOKEN;
    }

    public void setDate(Date date) {
        if (this.isReadOnly()) {
            return;
        }
        this._date = date;
    }

    public Date getDate() {
        if (this.isReadOnly()) {
            Date thisDate = (Date)this._date.clone();
            return thisDate;
        }
        return this._date;
    }

    public void setUsername(String username) {
        Tr.entry(tc, "setUsername");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSERNAME_PERM.toString());
            }
            sm.checkPermission(SETUSERNAME_PERM);
        }
        Tr.exit(tc, "setUsername", username);
        if (this.isReadOnly()) {
            return;
        }
        this._username = username;
    }

    public String getUsername() {
        if (this.isReadOnly()) {
            String thisUsername = new String(this._username);
            return thisUsername;
        }
        return this._username;
    }

    public void setPassword(char[] password) {
        Tr.entry(tc, "setPassword");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETPASSWORD_PERM.toString());
            }
            sm.checkPermission(SETPASSWORD_PERM);
        }
        Tr.exit(tc, "setPassword");
        if (this.isReadOnly()) {
            return;
        }
        this._password = password;
    }

    public char[] getPassword() {
        Tr.entry(tc, "getPassword");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETPASSWORD_PERM.toString());
            }
            sm.checkPermission(GETPASSWORD_PERM);
        }
        Tr.exit(tc, "getPassword");
        if (this.isReadOnly()) {
            char[] password = new char[this._password.length];
            System.arraycopy(this._password, 0, password, 0, this._password.length);
            return password;
        }
        return this._password;
    }

    public long getExpiration() {
        if (this.isReadOnly()) {
            long thisExpiration = this._expiration;
            return thisExpiration;
        }
        return this._expiration;
    }

    public void setExpiration(long expiration) {
        Tr.entry(tc, "setExpiration");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETEXPIRATION_PERM.toString());
            }
            sm.checkPermission(SETEXPIRATION_PERM);
        }
        Tr.exit(tc, "setExpiration");
        if (this.isReadOnly()) {
            return;
        }
        this._expiration = expiration;
    }

    public String getPrincipal() {
        if (this.isReadOnly()) {
            String thisUsername = new String(this._username);
            return thisUsername;
        }
        return this._username;
    }

    public String getUniqueID() {
        if (this.uid == null) {
            this.uid = String.valueOf(this.hashCode());
        }
        if (this.isReadOnly()) {
            String thisuid = new String(this.uid);
            return thisuid;
        }
        return this.uid;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 0;
            if (this._username != null) {
                hash += new String(this._username).hashCode();
            }
            if (this._password != null) {
                hash += new String(this._password).hashCode();
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsernameToken)) {
            return false;
        }
        UsernameToken tok = (UsernameToken)o;
        return tok.hashCode() == this.hashCode();
    }

    public boolean isValid() {
        return this._username != null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("UsernameToken[tokenId=[").append(this._tokenId);
        buf.append("], element=[").append(DOMUtil.getDisplayName((Node)this._tokenelem));
        buf.append("], username=[").append(this._username);
        buf.append("], password=[xxx]");
        return buf.toString();
    }
}

