/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.config.KRBConfig;
import com.ibm.ws.webservices.wssecurity.config.KRBSPN;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import com.ibm.wsspi.wssecurity.auth.callback.KRBTokenCallback;
import com.ibm.wsspi.wssecurity.token.KRBTokenInfo;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class KRBLoginModule
implements LoginModule {
    private static final String comp = "auth.KRBLoginModule";
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private Map sharedState = null;
    private Map options = null;
    private boolean loginSucceeded = false;
    private static TraceComponent tc = null;
    private KRBConfig config = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize()");
        }
        this.loginSucceeded = false;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        this.loginSucceeded = false;
        if (this.callbackHandler == null) {
            throw new LoginException(KRB5Util.getNLS().getString("security.wssecurity.kerberos.login.nocallbackhandler"));
        }
        Callback[] callbacks = new Callback[]{new KRBTokenCallback()};
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking the callbacks");
            }
            this.callbackHandler.handle(callbacks);
            byte[] token = ((KRBTokenCallback)callbacks[0]).getKerberosToken();
            String tokenValueType = ((KRBTokenCallback)callbacks[0]).getKerberosTokenValueType();
            String tokenID = ((KRBTokenCallback)callbacks[0]).getKerberosTokenID();
            KRBSPN spnObj = ((KRBTokenCallback)callbacks[0]).getSPN();
            MessageContext messageContext = ((KRBTokenCallback)callbacks[0]).getMessageContext();
            this.config = KRB5Util.getSPNList().getSPNConfig(spnObj, this.options);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token length= " + token.length);
                Tr.debug(tc, "token valueType= " + tokenValueType);
                Tr.debug(tc, "tokenID= " + tokenID);
            }
            if (token == null || token.length == 0) {
                throw new LoginException(KRB5Util.getNLS().getString("security.wssecurity.kerberos.token.unavailable"));
            }
            this.loginSucceeded = this.validate(token, tokenID, tokenValueType, spnObj, messageContext);
        }
        catch (UnsupportedCallbackException uce) {
            Tr.error(tc, "security.wssecurity.kerberos.unexpected.exception", uce.getMessage());
            throw new LoginException(comp + uce.getCallback().toString());
        }
        catch (Throwable t) {
            Tr.error(tc, "security.wssecurity.kerberos.unexpected.exception", KRB5Util.stackToString(t));
            throw new LoginException(comp + t.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.loginSucceeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        if (this.loginSucceeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Login successful");
            }
        } else {
            this.abort();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return this.loginSucceeded;
    }

    private boolean validate(byte[] token, String tokenID, String tokenValueType, KRBSPN spnObj, MessageContext messageContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
        }
        boolean result = false;
        String userPrincipal = "";
        String was_principal = "";
        try {
            HashMap krbTokenInfoProperties = KRB5Util.consumeKerberosToken(this.subject, token, tokenValueType, spnObj);
            krbTokenInfoProperties.put("tokenID", tokenID);
            KRBTokenInfo krbTokenInfo = new KRBTokenInfo(krbTokenInfoProperties);
            messageContext.setProperty("com.ibm.wsspi.wssecurity.kerberosTokenInfo", krbTokenInfo);
            userPrincipal = (String)krbTokenInfoProperties.get("WASPrincipal");
            if (userPrincipal != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAuthenticatedUsername: WebSphere Security principal = " + userPrincipal);
                }
                was_principal = KRB5Util.stripOutPrincipalName(userPrincipal);
                String realmName = KRB5Util.stripOutRealmName(userPrincipal);
                if (was_principal != null) {
                    this.sharedState.put("com.ibm.wsspi.wssecurity.Constants.DN", was_principal);
                    result = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Kerberos client principal: " + was_principal);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WAS principal is not available after the mapping.");
                }
                if (realmName != null) {
                    this.sharedState.put("com.ibm.wsspi.wssecurity.Constants.KerberosRealm", realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Kerberos realm: " + realmName);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "User principal is not available.");
            }
        }
        catch (Throwable e2) {
            FFDCFilter.processException(e2, KRBLoginModule.class.getName(), "1");
            result = false;
        }
        if (tc.isAuditEnabled()) {
            if (result) {
                Tr.audit(tc, "security.wssecurity.kerberos.authorization.success", new Object[]{was_principal, this.config.getServiceName()});
            } else {
                Tr.audit(tc, "security.wssecurity.kerberos.authorization.failed", new Object[]{was_principal, this.config.getServiceName()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate()");
        }
        return result;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.loginSucceeded = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    static {
        tc = Tr.register(KRBLoginModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

