/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel;

import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpChannelUtils {
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] ZERO_BYTEARRAY = new byte[]{HEX_BYTES[0]};
    private static final int SIZE_MAXINT = 10;

    private HttpChannelUtils() {
    }

    public static byte[] asByteArray(int value) {
        int index;
        if (0 == value) {
            return ZERO_BYTEARRAY;
        }
        byte[] bytes = new byte[10];
        boolean bNegative = false;
        if (0 > value) {
            bNegative = true;
            value = -value;
        }
        for (index = 9; 0 <= index && 0 != value; value /= 10, --index) {
            bytes[index] = HEX_BYTES[value % 10];
        }
        int len = 9 - index;
        if (bNegative) {
            ++len;
        }
        byte[] realBytes = new byte[len];
        int i = len - 1;
        int x = 9;
        while (0 <= i) {
            realBytes[i] = bytes[x];
            --i;
            --x;
        }
        if (bNegative) {
            realBytes[0] = 45;
        }
        return realBytes;
    }

    public static int asIntValue(byte[] array) {
        int i;
        if (null == array) {
            return -1;
        }
        int intVal = 0;
        int mark = 1;
        for (i = array.length - 1; 0 <= i; --i) {
            int digit = array[i] - HEX_BYTES[0];
            if (0 > digit || 9 < digit) {
                if (45 == array[i]) break;
                throw new NumberFormatException("Invalid digit: " + array[i]);
            }
            intVal += digit * mark;
            mark *= 10;
        }
        if (0 <= i && array[i] == 45) {
            intVal = -intVal;
        }
        return intVal;
    }

    public static byte[] getEnglishBytes(String data) {
        if (null == data) {
            return null;
        }
        char[] chars = data.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static String getEnglishString(byte[] data) {
        if (null == data) {
            return null;
        }
        char[] chars = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            chars[i] = (char)(data[i] & 0xFF);
        }
        return new String(chars);
    }

    public static String getEnglishString(byte[] data, int start, int end) {
        int len = end - start;
        if (0 >= len || null == data) {
            return null;
        }
        char[] chars = new char[len];
        for (int i = start; i < end; ++i) {
            chars[i] = (char)(data[i] & 0xFF);
        }
        return new String(chars);
    }

    public static byte[] getBytes(StringBuffer data) {
        if (null == data) {
            return null;
        }
        int len = data.length();
        char[] chars = new char[len];
        data.getChars(0, len, chars, 0);
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static byte[] getBytes(StringBuilder data) {
        if (null == data) {
            return null;
        }
        int len = data.length();
        char[] chars = new char[len];
        data.getChars(0, len, chars, 0);
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    private static String parseName(char[] ch, int start, int end) {
        int len = 0;
        char[] name = new char[end - start];
        block4: for (int i = start; i < end; ++i) {
            switch (ch[i]) {
                case '+': {
                    name[len++] = 32;
                    continue block4;
                }
                case '%': {
                    if (i + 2 < end) {
                        int num2;
                        int num1;
                        if (-1 == (num1 = Character.digit(ch[++i], 16))) {
                            throw new IllegalArgumentException("" + ch[i]);
                        }
                        if (-1 == (num2 = Character.digit(ch[++i], 16))) {
                            throw new IllegalArgumentException("" + ch[i]);
                        }
                        name[len++] = (char)(num1 << 4 | num2);
                        continue block4;
                    }
                    while (i < end) {
                        name[len++] = ch[i];
                        ++i;
                    }
                    continue block4;
                }
                default: {
                    name[len++] = ch[i];
                }
            }
        }
        return new String(name, 0, len);
    }

    public static Map<String, String[]> parseQueryString(String data, String encoding) {
        if (null == data) {
            throw new NullPointerException("query data");
        }
        Hashtable<String, String[]> map = new Hashtable<String, String[]>();
        String[] valArray = null;
        char[] chars = data.toCharArray();
        int key_start = 0;
        for (int i = 0; i < chars.length; ++i) {
            if ('=' != chars[i]) continue;
            if (i == key_start) {
                throw new IllegalArgumentException("Missing key name: " + i);
            }
            String key = HttpChannelUtils.parseName(chars, key_start, i);
            int value_start = ++i;
            while (i < chars.length && '&' != chars[i]) {
                ++i;
            }
            if (i > value_start) {
                String value = HttpChannelUtils.parseName(chars, value_start, i);
                if (map.containsKey(key)) {
                    String[] oldVals = (String[])map.get(key);
                    valArray = new String[oldVals.length + 1];
                    System.arraycopy(oldVals, 0, valArray, 0, oldVals.length);
                    valArray[oldVals.length] = value;
                } else {
                    valArray = new String[]{value};
                }
                map.put(key, valArray);
            }
            key_start = i + 1;
        }
        return map;
    }
}

