/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ws390.sm.smf.SmfProperty;
import com.ibm.ws390.sm.smf.SmfPropertyVector;
import java.util.Vector;

public final class SmfServletData {
    private String m_name = "";
    private long m_loadedSince = 0L;
    private int m_responseTime = 0;
    private int m_loadCount = 0;
    private int m_errorCount = 0;
    private Vector m_properties = new Vector(5);
    private boolean m_propertiesInSync = false;
    private int m_propertiesByteSize = 0;
    private long m_cpuStartTime = 0L;
    private long m_cpuEndTime = 0L;
    private String m_cpuTimeString = "";

    protected SmfServletData(String aName) {
        if (aName != null) {
            this.m_name = aName.length() > 128 ? aName.substring(0, 128) : aName;
        }
    }

    private void addProperty(SmfProperty aProperty) {
        this.m_properties.addElement(aProperty);
        this.m_propertiesByteSize += aProperty.getByteSize();
    }

    protected boolean addTo(SmfPropertyVector aVector) {
        this.resyncProperties();
        if (aVector.getRemainingByteArraySize() >= this.m_propertiesByteSize) {
            int size = this.m_properties.size();
            for (int i = 0; i < size; ++i) {
                aVector.addElement(this.m_properties.elementAt(i));
            }
            this.reset();
            return true;
        }
        return false;
    }

    protected int getErrorCount() {
        return this.m_errorCount;
    }

    protected int getLoadCount() {
        return this.m_loadCount;
    }

    protected long getLoadedSince() {
        return this.m_loadedSince;
    }

    protected String getName() {
        return this.m_name;
    }

    protected int getResponseTime() {
        return this.m_responseTime;
    }

    protected long getCpuStartTime() {
        return this.m_cpuStartTime;
    }

    protected long getCpuEndTime() {
        return this.m_cpuEndTime;
    }

    protected void incrementErrorCount() {
        ++this.m_errorCount;
        this.m_propertiesInSync = false;
    }

    protected void incrementLoadCount() {
        ++this.m_loadCount;
        this.m_propertiesInSync = false;
    }

    private void reset() {
        this.m_errorCount = 0;
        this.m_loadCount = 0;
        this.m_loadedSince = 0L;
        this.m_responseTime = 0;
        this.m_propertiesInSync = false;
        this.resyncProperties();
    }

    protected void calculateCpuTime(long aCpuEndTime) {
        long diff;
        this.m_cpuEndTime = aCpuEndTime;
        if (aCpuEndTime > 0L && (diff = aCpuEndTime - this.m_cpuStartTime) > 0L) {
            this.m_cpuTimeString = Long.toHexString(diff);
        }
    }

    private void resyncProperties() {
        if (!this.m_propertiesInSync) {
            this.m_properties.clear();
            this.m_propertiesByteSize = 0;
            if (this.m_name.length() > 0 && (this.m_responseTime > 0 || this.m_loadedSince > 0L || this.m_loadCount > 0 || this.m_errorCount > 0)) {
                this.addProperty(new SmfProperty(11, this.m_name, null));
                if (this.m_responseTime > 0) {
                    this.addProperty(new SmfProperty(12, this.m_responseTime));
                }
                if (this.m_loadedSince > 0L) {
                    this.addProperty(new SmfProperty(8, Long.toHexString(this.m_loadedSince), SmfProperty.getEbcdicEncoding()));
                }
                if (this.m_loadCount > 0) {
                    this.addProperty(new SmfProperty(9, this.m_loadCount));
                }
                if (this.m_errorCount > 0) {
                    this.addProperty(new SmfProperty(10, this.m_errorCount));
                }
                if (this.m_cpuTimeString.length() > 0) {
                    this.addProperty(new SmfProperty(15, this.m_cpuTimeString, SmfProperty.getEbcdicEncoding()));
                }
            }
            this.m_propertiesInSync = true;
        }
    }

    protected void setLoadedSince(long aMillisecondDate) {
        if (aMillisecondDate > 0L) {
            this.m_loadedSince = aMillisecondDate;
            this.m_propertiesInSync = false;
        }
    }

    protected void setResponseTime(int aNewResponseTime) {
        if (aNewResponseTime >= 0) {
            this.m_responseTime = aNewResponseTime;
            this.m_propertiesInSync = false;
        }
    }

    protected void setCpuStartTime(long aCpuStartTime) {
        if (aCpuStartTime > 0L) {
            this.m_cpuStartTime = aCpuStartTime;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SmfServletData(");
        sb.append(this.m_name).append(", ");
        sb.append("loadCount=").append(this.m_loadCount).append(", ");
        sb.append("errorCount=").append(this.m_errorCount).append(", ");
        sb.append("responseTime=").append(this.m_responseTime).append(", ");
        sb.append("loadedSince=").append(this.m_loadedSince).append(")");
        return sb.toString();
    }
}

