/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.wsdl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.wsdl.BaseWSDLLocator;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class ModuleWSDLLocator
extends BaseWSDLLocator
implements WSDLLocator,
Constants {
    private static TraceComponent _tc = Tr.register(ModuleWSDLLocator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected LoadStrategy loadStrategy;
    protected ClassLoader classLoader;

    public ModuleWSDLLocator(String uri, InputStream stream, LoadStrategy strategy) {
        this(uri, stream, strategy, null);
    }

    public ModuleWSDLLocator(String uri, InputStream stream, ClassLoader classLoader) {
        this(uri, stream, classLoader, null);
    }

    public ModuleWSDLLocator(String uri, InputStream stream, LoadStrategy strategy, JaxWSCatalogAccessor catalogAccessor) {
        this.baseURI = this.convertURI(uri);
        this.baseInputStream = stream;
        this.loadStrategy = strategy;
        this.catalogAccessor = catalogAccessor;
    }

    public ModuleWSDLLocator(String uri, InputStream stream, ClassLoader classLoader, JaxWSCatalogAccessor catalogAccessor) {
        this.baseURI = this.convertURI(uri);
        this.baseInputStream = stream;
        this.classLoader = classLoader;
        this.catalogAccessor = catalogAccessor;
    }

    public InputStream getInputStream(String importPath) throws IOException {
        URL importURL = null;
        InputStream is = null;
        try {
            importURL = new URL(importPath);
            is = importURL.openStream();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is == null && this.loadStrategy != null) {
            try {
                is = this.loadStrategy.getResourceInputStream(importPath);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null && this.classLoader != null) {
            try {
                is = this.classLoader.getResourceAsStream(importPath);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                File file = new File(importPath);
                is = file.toURL().openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                URI uri = new URI(importPath);
                is = uri.toURL().openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null && this.loadStrategy != null) {
            try {
                is = WSModels.getJavaWSDLInputStream(importPath, this.loadStrategy);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return is;
    }

    public URL getWsdlUrl(String wsdlLocation) {
        URI pathURI;
        InputStream is;
        URL streamURL;
        block11: {
            streamURL = null;
            is = null;
            pathURI = null;
            try {
                wsdlLocation = this.catalogAccessor != null ? this.catalogAccessor.resolveLocation(wsdlLocation) : wsdlLocation;
            }
            catch (Throwable t) {
                if (!_tc.isDebugEnabled()) break block11;
                Tr.debug(_tc, "The wsdlLocation " + wsdlLocation + " was not resolved via " + "the JAX-WS catalog because of the following error: " + t.toString() + ". Normal resolution will continue.");
            }
        }
        try {
            streamURL = new URL(wsdlLocation);
            is = streamURL.openStream();
            is.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (is == null) {
            try {
                pathURI = new URI(wsdlLocation);
                streamURL = pathURI.toURL();
                is = streamURL.openStream();
                is.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                File file = new File(wsdlLocation);
                streamURL = file.toURL();
                is = streamURL.openStream();
                is.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (_tc.isDebugEnabled() && streamURL == null) {
            Tr.debug(_tc, "Absolute wsdlLocation could not be determined: " + wsdlLocation);
        }
        return streamURL;
    }

    public void close() {
    }
}

