/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.MetaDataChannelHelper;
import com.ibm.ws.webservices.deploy.MetaDataLoader;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.deploy.JAXRPCModuleDataImpl;
import com.ibm.ws.websvcs.deploy.JAXWSModuleDataImpl;
import com.ibm.ws.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class DualMetaDataLoaderImpl
implements MetaDataLoader {
    private static TraceComponent tc = Tr.register(DualMetaDataLoaderImpl.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.deploy.resources.deployMessages");
    private static final String SERVLET_URL_PATTERN_ROOT = "services/";
    private Map nodeHostNames = new HashMap();
    private ConfigScope configScope;
    private static ConfigService configService;
    private RepositoryContext appDeployCtx = null;
    private List moduleDataList = new LinkedList();
    private List whirlModuleDataList = new LinkedList();
    WSDescriptionBuilder WSDescBuilder = null;
    private String earFileLocation;
    private EARFile earFile;
    private ConfigObject appDeployment = null;
    private List deployedModules;
    private static final String uriPathSeparator = "/";
    private URIConverterImpl uci;
    private List targets;

    public List getModuleDataList() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getModuleDataList returning " + this.moduleDataList.size() + " moduleDataList members");
            Tr.debug(tc, "                        and " + this.whirlModuleDataList.size() + " whirlModuleDataList members");
        }
        if (this.whirlModuleDataList.isEmpty()) {
            return this.moduleDataList;
        }
        if (this.moduleDataList.isEmpty()) {
            return this.whirlModuleDataList;
        }
        LinkedList combinedModuleDataList = new LinkedList();
        combinedModuleDataList.addAll(this.moduleDataList);
        combinedModuleDataList.addAll(this.whirlModuleDataList);
        return combinedModuleDataList;
    }

    public List getWhirlModuleDataList() {
        return this.whirlModuleDataList;
    }

    public List getMaelstromModuleDataList() {
        return this.moduleDataList;
    }

    public void setRepositoryContext(RepositoryContext appDeployCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRepositoryContext appDeployCtx=" + appDeployCtx);
        }
        if (appDeployCtx != null) {
            this.appDeployCtx = appDeployCtx;
            configService = DeployUtils.getConfigService();
            this.configScope = configService.createScope(1);
            this.configScope.set(0, appDeployCtx.getParent().getParent().getName());
            this.configScope.set(1, appDeployCtx.getParent().getName() + "/deployments/" + appDeployCtx.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRepositoryContext configScope=" + this.configScope);
        }
    }

    public void setConfigScope(ConfigService configService, ConfigScope configScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setConfigScope configScope=" + configScope);
        }
        DualMetaDataLoaderImpl.configService = configService;
        this.configScope = configScope;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setConfigScope");
        }
    }

    public void setEARFileLocation(String binariesUrl) {
        this.earFileLocation = binariesUrl;
    }

    public boolean isWebServiceEnabled() {
        if (tc.isDebugEnabled()) {
            String fullUri = this.configScope != null ? this.configScope.get(1) : "unknown";
            Tr.debug(tc, "isWebServiceEnabled for application URI: " + fullUri);
        }
        boolean enabled = false;
        EARFile earFile = this.getEAR();
        Application app = null;
        if (earFile != null) {
            app = earFile.getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isWebServiceEnabled on ear: " + earFile.getName());
            }
            List depMods = this.getDeployedModules();
            for (int i = 0; i < depMods.size(); ++i) {
                WSModuleDescriptor WSmd;
                ConfigObject md2 = (ConfigObject)depMods.get(i);
                Module m = app.getModule(md2.getString("uri", "__null__"), md2.getString("altDD", "__null__"));
                if (m == null) continue;
                ModuleFile mf = earFile.getModuleRef(m).getModuleFile();
                if (this.WSDescBuilder == null) {
                    this.WSDescBuilder = WSDescriptionBuilderFactory.getBuilder();
                }
                if (!(enabled = (WSmd = this.WSDescBuilder.getModuleDescriptor(mf)).containsJAXRPCWebServices())) {
                    enabled = WSmd.containsJAXWSWebServices();
                }
                if (enabled) break;
            }
        }
        if (tc.isDebugEnabled()) {
            String fullUri2 = this.configScope != null ? this.configScope.get(1) : "unknown";
            Tr.debug(tc, "isWebServiceEnabled:  Application " + fullUri2 + " is " + (enabled ? "enabled." : "not enabled."));
        }
        return enabled;
    }

    public boolean isModuleEnabled(ModuleDeployment module, boolean checkClient) {
        if (tc.isEntryEnabled()) {
            String moduleUri = module != null ? module.getUri() : "Module Is Null.";
            Tr.entry(tc, "isModuleEnabled for module URI " + moduleUri);
        }
        boolean enabled = false;
        String targetUri = module.getUri();
        EARFile earFile = this.getEAR();
        if (earFile != null) {
            Application app = earFile.getDeploymentDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isModuleEnabled on app: " + (app != null ? app.getDisplayName() : "unknown"));
            }
            List depMods = this.getDeployedModules();
            if (tc.isDebugEnabled()) {
                if (module != null) {
                    Tr.debug(tc, "isModuleEnabled on app: " + app.getDisplayName() + " for module " + module.getUri());
                } else {
                    Tr.debug(tc, "isModuleEnabled on app: " + app.getDisplayName());
                }
            }
            for (int i = 0; i < depMods.size(); ++i) {
                Module m;
                ConfigObject md2 = (ConfigObject)depMods.get(i);
                String thisUri = md2.getString("uri", "__null__");
                if (!thisUri.equals(targetUri) || (m = app.getModule(md2.getString("uri", "__null__"), md2.getString("altDD", "__null__"))) == null) continue;
                String filePath = null;
                filePath = checkClient ? (m.isWebModule() ? "WEB-INF/ibm-webservicesclient-bnd.xmi" : "META-INF/ibm-webservicesclient-bnd.xmi") : (m.isWebModule() ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi");
                ModuleFile mf = earFile.getModuleRef(m).getModuleFile();
                try {
                    if (this.WSDescBuilder == null) {
                        this.WSDescBuilder = WSDescriptionBuilderFactory.getBuilder();
                    }
                    WSModuleDescriptor wsmDesc = this.WSDescBuilder.getModuleDescriptor(mf);
                    LoadStrategy loadStrategy = mf.getLoadStrategy();
                    if (filePath.equals("WEB-INF/ibm-webservicesclient-bnd.xmi") || filePath.equals("META-INF/ibm-webservicesclient-bnd.xmi")) {
                        enabled = loadStrategy.getContainer().containsFile(filePath);
                        break;
                    }
                    if (checkClient && wsmDesc != null && wsmDesc.containsWebServiceClients()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The module: " + mf.getName() + " contains web service " + "clients");
                        }
                        enabled = true;
                        break;
                    }
                    if (!loadStrategy.getContainer().containsFile(filePath) || wsmDesc == null || !wsmDesc.containsJAXRPCWebServices()) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The module: " + mf.getName() + " contains JAX-RPC " + "web services");
                    }
                    enabled = true;
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.isModuleEnabled", "320");
                }
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isModuleEnabled:  Module " + targetUri + (enabled ? " is enabled" : " is not enabled."));
        }
        return enabled;
    }

    public void cleanup() {
        this.nodeHostNames.clear();
        this.moduleDataList.clear();
        this.whirlModuleDataList.clear();
        if (this.earFile != null) {
            this.earFile.close();
        }
    }

    public void load() throws Exception {
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    DualMetaDataLoaderImpl.this._load();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.load", "402", this);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.deploy.DualMetaDataLoaderImpl.load", "408", this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _load() throws Exception {
        boolean enabled;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load");
        }
        if (!(enabled = this.isWebServiceEnabled())) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "load: no webservices information found");
            return;
        }
        this.configScope.setDepth(0);
        List depMods = this.getDeployedModules();
        EARFile earFile = this.getEAR();
        if (earFile == null) {
            if (!tc.isDebugEnabled()) return;
            Tr.debug(tc, "load: no EARFile found");
            return;
        }
        Application app = earFile.getDeploymentDescriptor();
        for (int i = 0; i < depMods.size(); ++i) {
            JAXRPCMetaDataHelper helper;
            JAXRPCMetaDataWrapper wrapper;
            boolean containsJAXWSClients;
            boolean containsJAXRPCClients;
            WSModuleDescriptor WSmd;
            ModuleFile mf;
            String httpRouterModuleName = null;
            boolean hasHTTPRouter = false;
            ConfigObject md2 = (ConfigObject)depMods.get(i);
            Module m = app.getModule(md2.getString("uri", "__null__"), md2.getString("altDD", "__null__"));
            if (m == null) continue;
            ModuleData moduleData = null;
            ModuleData whirlModuleData = null;
            if (m.isWebModule()) {
                mf = earFile.getModuleRef(m).getModuleFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: starting to process WEB module " + mf.getName());
                }
                if (this.WSDescBuilder == null) {
                    this.WSDescBuilder = WSDescriptionBuilderFactory.getBuilder();
                }
                WSmd = this.WSDescBuilder.getModuleDescriptor(mf);
                containsJAXRPCClients = this.containsJAXRPCClients(WSmd);
                containsJAXWSClients = this.containsJAXWSClients(WSmd);
                if (WSmd.containsJAXWSWebServices() || containsJAXWSClients) {
                    whirlModuleData = this.loadJAXWSModuleData(earFile, mf, md2, (WebModule)m, WSmd, false);
                }
                if (!((wrapper = (helper = new JAXRPCMetaDataHelper(mf, mf.getArchiveClassLoader())).loadJAXRPCMetaData()) != null && wrapper.containsJAXRPCServices() || containsJAXRPCClients)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load: loadJAXRPCMetaData returned null");
                    }
                    if (whirlModuleData == null) continue;
                    this.whirlModuleDataList.add(whirlModuleData);
                    continue;
                }
                WebModule wm = (WebModule)m;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: calling loadJAXRPCModuleData for module " + mf.getName());
                }
                moduleData = this.loadJAXRPCModuleData(earFile, mf, md2, wm, wrapper.getWebServices(), false, wrapper.getJaxrpcPortComponents());
            } else if (m.isEjbModule()) {
                mf = earFile.getModuleRef(m).getModuleFile();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: starting to process EJB module " + mf.getName());
                }
                if (this.WSDescBuilder == null) {
                    this.WSDescBuilder = WSDescriptionBuilderFactory.getBuilder();
                }
                WSmd = this.WSDescBuilder.getModuleDescriptor(mf);
                containsJAXRPCClients = this.containsJAXRPCClients(WSmd);
                containsJAXWSClients = this.containsJAXWSClients(WSmd);
                helper = new JAXRPCMetaDataHelper(mf, mf.getArchiveClassLoader());
                wrapper = helper.loadJAXRPCMetaData();
                if (!(wrapper != null && wrapper.containsJAXRPCServices() || WSmd.containsJAXWSWebServices() || containsJAXRPCClients || containsJAXWSClients)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load: There was no JAX-RPC or JAX-WS metadata in module: " + mf.getName());
                    }
                    if (whirlModuleData == null) continue;
                    this.whirlModuleDataList.add(whirlModuleData);
                    continue;
                }
                WSBinding wsb = WSModels.getWSBinding(mf.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                if (wsb != null) {
                    for (RouterModule router : wsb.getRouterModules()) {
                        String transport = router.getTransport();
                        if (transport == null || !transport.equals("http")) continue;
                        httpRouterModuleName = router.getName();
                        hasHTTPRouter = true;
                        break;
                    }
                }
                if (httpRouterModuleName != null) {
                    boolean routerMD = false;
                    for (int l = 0; l < depMods.size(); ++l) {
                        ConfigObject md1 = (ConfigObject)depMods.get(l);
                        if (!md1.getString("uri", "__null__").equals(httpRouterModuleName)) continue;
                        routerMD = true;
                        break;
                    }
                    if (!routerMD) {
                        throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{md2.getString("uri", "__null__")}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    }
                    Module m1 = app.getModule(httpRouterModuleName, null);
                    if (m1 == null) {
                        throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{md2.getString("uri", "__null__")}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    }
                    if (!m1.isWebModule()) throw new Exception(nls.getFormattedMessage("WSWS0043E", new Object[]{md2.getString("uri", "__null__")}, "WSWS0043E: The EJB module {0} does not have an associated router module"));
                    if (wrapper != null && wrapper.containsJAXRPCServices() || containsJAXRPCClients) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "load: calling loadJAXRPCModuleData for module " + mf.getName() + " with routerModule: " + httpRouterModuleName);
                        }
                        moduleData = this.loadJAXRPCModuleData(earFile, mf, md2, (WebModule)m1, wrapper.getWebServices(), hasHTTPRouter, wrapper.getJaxrpcPortComponents());
                    }
                    if (WSmd.containsJAXWSWebServices() || containsJAXWSClients) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "load: calling loadJAXWSModuleData for module " + mf.getName() + " with routerModule: " + httpRouterModuleName);
                        }
                        whirlModuleData = this.loadJAXWSModuleData(earFile, mf, md2, (WebModule)m1, WSmd, hasHTTPRouter);
                    }
                } else {
                    if (wrapper != null && wrapper.containsJAXRPCServices() || containsJAXRPCClients) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "load: calling loadJAXRPCModuleData for module " + mf.getName());
                        }
                        moduleData = this.loadJAXRPCModuleData(earFile, mf, md2, null, wrapper.getWebServices(), hasHTTPRouter, wrapper.getJaxrpcPortComponents());
                    }
                    if (WSmd.containsJAXWSWebServices() || containsJAXWSClients) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "load: calling loadJAXWSModuleData for module " + mf.getName());
                        }
                        whirlModuleData = this.loadJAXWSModuleData(earFile, mf, md2, null, WSmd, hasHTTPRouter);
                    }
                }
            }
            if (moduleData != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load: adding moduleData to list.");
                }
                this.moduleDataList.add(moduleData);
            }
            if (whirlModuleData == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "load: adding whrilModuleData to list.");
            }
            this.whirlModuleDataList.add(whirlModuleData);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "load");
    }

    boolean containsJAXRPCClients(WSModuleDescriptor wsModDesc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsJAXRPCClients, module= " + wsModDesc.getModuleName());
        }
        boolean contains = false;
        Iterator serviceRefsIter = wsModDesc.getServiceRefs();
        if (serviceRefsIter != null) {
            while (serviceRefsIter.hasNext()) {
                WSClientServiceDescriptor clientDesc = (WSClientServiceDescriptor)serviceRefsIter.next();
                if (clientDesc.getClientType() == null || !clientDesc.getClientType().equals((Object)WSClientType.JAX_RPC)) continue;
                contains = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsJAXRPCClients, module= " + wsModDesc.getModuleName() + ": " + String.valueOf(contains));
        }
        return contains;
    }

    boolean containsJAXWSClients(WSModuleDescriptor wsModDesc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsJAXWSClients, module= " + wsModDesc.getModuleName());
        }
        boolean contains = false;
        Iterator serviceRefsIter = wsModDesc.getServiceRefs();
        if (serviceRefsIter != null) {
            while (serviceRefsIter.hasNext()) {
                WSClientServiceDescriptor clientDesc = (WSClientServiceDescriptor)serviceRefsIter.next();
                if (clientDesc.getClientType() == null || !clientDesc.getClientType().equals((Object)WSClientType.JAX_WS)) continue;
                contains = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsJAXWSClients, module= " + wsModDesc.getModuleName() + ": " + String.valueOf(contains));
        }
        return contains;
    }

    private ConfigObject getApplicationDeployment() {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getApplicationDeployment", "appDeployment=" + this.appDeployment);
            }
            if (this.appDeployment == null) {
                try {
                    if (this.configScope != null && configService != null) {
                        ConfigObject d;
                        if (configService.getCellName() != null && DeployUtils.isNormalServer()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting cell name on ConfigScope: " + configService.getCellName());
                            }
                            this.configScope.set(0, configService.getCellName());
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Not setting cell name on ConfigScope");
                        }
                        this.configScope.setDepth(1);
                        List r = configService.getDocumentObjects(this.configScope, "deployment.xml");
                        if (r != null && (d = (ConfigObject)r.get(0)) != null) {
                            this.appDeployment = d.getObject("deployedObject");
                        }
                    }
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "getApplicationDeployment: caught exception ", ex);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationDeployment", "appDeployment=" + this.appDeployment);
        }
        return this.appDeployment;
    }

    private List getDeployedModules() {
        if (this.deployedModules == null) {
            block6: {
                try {
                    ConfigObject appDeploy = this.getApplicationDeployment();
                    if (appDeploy != null) {
                        this.deployedModules = appDeploy.getObjectList("modules");
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.MetaDataLoader.getDeployedModules", "864");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "getDeploymentModules: caught exception ", ex);
                }
            }
            if (this.deployedModules == null) {
                this.deployedModules = new ArrayList();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDeploymentModules: no modules found");
                }
            }
        }
        return this.deployedModules;
    }

    private EARFile getEAR() {
        block29: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEAR");
            }
            String binURL = null;
            if (this.earFile == null) {
                ConfigObject depl = this.getApplicationDeployment();
                boolean isZeroBinary = false;
                boolean isZeroEar = false;
                boolean useMetadataFromBinaries = false;
                boolean binURLValid = false;
                if (depl == null) {
                    return this.earFile;
                }
                isZeroBinary = depl.getBoolean("zeroBinaryCopy", false);
                isZeroEar = depl.getBoolean("zeroEarCopy", false);
                useMetadataFromBinaries = depl.getBoolean("useMetadataFromBinaries", false);
                if (this.earFileLocation == null) {
                    this.configScope.setDepth(1);
                    this.earFileLocation = this.configScope.getAbsolutePath("");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got EAR location from ConfigScope: " + this.earFileLocation);
                    }
                }
                try {
                    Hashtable<String, Locale> prefs = new Hashtable<String, Locale>();
                    prefs.put("app.client.locale", Locale.getDefault());
                    ResourceBundle resBundle = AppUtils.getBundle(prefs);
                    if (!isZeroBinary && !isZeroEar && (binURL = depl.getString("binariesURL", "binariesURL")) != null) {
                        java.io.File binURLFile = new java.io.File(binURL);
                        if (!WebServiceUtils.fileExists(binURLFile)) {
                            binURL = null;
                            if (this.appDeployCtx != null && this.appDeployCtx.getParent() != null) {
                                String extractedPath;
                                String earName = this.appDeployCtx.getName() + ".ear";
                                if (this.appDeployCtx.getParent().isAvailable(earName)) {
                                    this.appDeployCtx.getParent().extract(earName, false);
                                }
                                if (WebServiceUtils.fileExists(binURLFile = new java.io.File(extractedPath = this.appDeployCtx.getParent().getPath() + java.io.File.separator + earName))) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "EARFile: " + extractedPath + " exists in application's " + "RepositoryContext");
                                    }
                                    binURL = extractedPath;
                                    binURLValid = true;
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "EARFile: " + extractedPath + " does not exist in " + "application's RepositoryContext");
                                }
                            }
                        } else {
                            binURLValid = true;
                        }
                    }
                    if (this.appDeployCtx != null && !binURLValid) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to load EARFile using ConfigRepoHelper");
                        }
                        if (!useMetadataFromBinaries) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Loading EAR from config repository");
                            }
                            this.earFile = ConfigRepoHelper.getEarFileForApp(this.appDeployCtx.getWorkSpace(), this.appDeployCtx, resBundle, true);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Loading EAR from binaries");
                            }
                            this.earFile = ConfigRepoHelper.getEarFileFromBinaries(this.appDeployCtx, this.appDeployCtx.getWorkSpace(), resBundle, true);
                        }
                    }
                    if (this.earFile == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to load EARFile using location: " + this.earFileLocation);
                        }
                        CommonarchiveFactory archiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                        ArchiveOptions options = new ArchiveOptions();
                        if (binURL != null && !"".equals(binURL)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Opening EARFile using binariesURL: " + binURL);
                            }
                            options.setAltBinariesPath(binURL);
                            if (useMetadataFromBinaries) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Using metadata from binaries location");
                                }
                                this.earFileLocation = binURL;
                            }
                        }
                        options.setIsReadOnly(true);
                        options.setUseJavaReflection(true);
                        this.earFile = archiveFactory.openEARFile(options, this.earFileLocation);
                        this.earFile.getDeploymentDescriptor();
                        this.earFile.getBindings();
                        this.earFile.getExtensions();
                    }
                }
                catch (Throwable th) {
                    FFDCFilter.processException(th, "com.ibm.ws.webservices.deploy.MetaDataLoader.getEAR", "534");
                    if (this.earFile == null) break block29;
                    this.earFile.close();
                    this.earFile = null;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEAR");
        }
        return this.earFile;
    }

    private String findServletUrl(WebApp webApp, String ServletLink2) {
        String url = null;
        Servlet servlet = webApp.getServletNamed(ServletLink2);
        ServletMapping mapping = webApp.getServletMapping(servlet);
        if (mapping != null) {
            url = mapping.getUrlPattern();
        }
        return url;
    }

    private static String getHostName(ConfigScope nodeScope) {
        String host = null;
        nodeScope.setDepth(3);
        try {
            ConfigObject si = (ConfigObject)configService.getDocumentObjects(nodeScope, "serverindex.xml").get(0);
            host = si.getString("hostName", "__null__");
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.deploy.MetaDataLoader.getHostName", "586");
            Tr.error(tc, "internal.error", e);
        }
        return host;
    }

    private ModuleData loadJAXWSModuleData(EARFile earFile, ModuleFile moduleFile, ConfigObject md2, WebModule wm, WSModuleDescriptor WSmd, boolean hasHTTPRouter) throws Exception {
        String mdUri = md2.getString("uri", "__null__");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadJAXWSModuleData for ", mdUri + ", application: " + earFile.getName());
        }
        ModuleData moduleData = new JAXWSModuleDataImpl();
        moduleData = this.loadCommonModuleData(moduleData, earFile, moduleFile, md2, wm, hasHTTPRouter);
        WebApp webApp = null;
        if (wm != null) {
            webApp = earFile.getDeploymentDescriptor(wm);
        }
        Iterator webservicesIterator = WSmd.getServices();
        LinkedList modulesWsdlFiles = new LinkedList();
        while (webservicesIterator.hasNext()) {
            WSServiceDescriptor WSsd = (WSServiceDescriptor)webservicesIterator.next();
            String webServicesDescriptionName = WSsd.getName();
            String theWSDLFileName = WSsd.getWSDLLocationBaseName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "webServicesDescriptionName=" + webServicesDescriptionName);
            }
            if (!WSsd.deployedWithWSDL()) {
                List generatedWsdlXsdFiles;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "looking for generated WSDL files.");
                }
                if ((generatedWsdlXsdFiles = this.getGeneratedWSDLFile(WSsd.getWSDLDefinition())) != null) {
                    modulesWsdlFiles.addAll(generatedWsdlXsdFiles);
                    theWSDLFileName = this.getGeneratedWsdlFileName(WSsd.getWSDLDefinition());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "generated WSDL file name: " + theWSDLFileName);
                    }
                }
            }
            WebserviceDescriptionInfo wsdInfo = new WebserviceDescriptionInfo(theWSDLFileName, webServicesDescriptionName);
            wsdInfo.setWebserviceDescriptionQName(WSsd.getQName());
            Iterator endpointIterator = WSsd.getEndpoints();
            while (endpointIterator.hasNext()) {
                WSEndpointDescriptor WSep = (WSEndpointDescriptor)endpointIterator.next();
                QName qname = WSep.getQName();
                String url = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "endpoint qname " + qname.toString());
                }
                if (webApp != null) {
                    url = WSep.getURLPattern();
                }
                if (url != null) {
                    url = DeployUtils.trimSlash(url);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "url is " + url);
                    }
                }
                if (moduleFile.isWARFile()) {
                    if (url != null) {
                        wsdInfo.addQnameToUrlPattern(qname, url);
                    } else {
                        String manufacturdUrl = SERVLET_URL_PATTERN_ROOT + WSep.getName();
                        wsdInfo.addQnameToUrlPattern(qname, manufacturdUrl);
                    }
                } else if (url != null) {
                    wsdInfo.addQnameToUrlPattern(qname, url);
                } else {
                    String uri = "null";
                    if (wm != null) {
                        uri = wm.getUri();
                    }
                    Tr.error(tc, "WSWS0045E", new Object[]{mdUri, uri, WSep.getName()});
                }
                wsdInfo.addQnameToPortComponentName(qname, WSep.getName());
            }
            moduleData.addWebservicesDescription(wsdInfo);
        }
        if (moduleFile.isWARFile()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is a WAR, getting war WSDL files.");
            }
            modulesWsdlFiles.addAll(moduleFile.getLoadStrategy().getFiles("WEB-INF/wsdl"));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This is an EJB jar, getting ejb WSDL files.");
            }
            modulesWsdlFiles.addAll(moduleFile.getLoadStrategy().getFiles("META-INF/wsdl"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "saving " + (modulesWsdlFiles != null ? Integer.valueOf(modulesWsdlFiles.size()) : "zero") + " WSDL files to the moduleData.");
        }
        moduleData.setModulesWsdlFiles(modulesWsdlFiles);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadJAXWSModuleData");
        }
        return moduleData;
    }

    private ModuleData loadJAXRPCModuleData(EARFile earFile, ModuleFile moduleFile, ConfigObject md2, WebModule wm, WebServices webservices, boolean hasHTTPRouter, List jaxrpcPortComponents) throws Exception {
        String mdUri = md2.getString("uri", "__null__");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadJAXRPCModuleData for ", mdUri + ", application: " + earFile.getName());
        }
        ModuleData moduleData = new JAXRPCModuleDataImpl();
        moduleData = this.loadCommonModuleData(moduleData, earFile, moduleFile, md2, wm, hasHTTPRouter);
        WebApp webApp = null;
        if (wm != null) {
            webApp = earFile.getDeploymentDescriptor(wm);
        }
        int count0 = webservices != null && webservices.getWebServiceDescriptions() != null ? webservices.getWebServiceDescriptions().size() : 0;
        for (int j = 0; j < count0; ++j) {
            String wsdName;
            WebServiceDescription wsd = (WebServiceDescription)webservices.getWebServiceDescriptions().get(j);
            String webServicesDescriptionName = wsdName = wsd.getWebServiceDescriptionName();
            String theWSDLFileName = wsd.getWsdlFile();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "webServicesDescriptionName=" + webServicesDescriptionName);
                Tr.debug(tc, "theWSDLFileName=" + theWSDLFileName);
            }
            WebserviceDescriptionInfo wsdInfo = new WebserviceDescriptionInfo(theWSDLFileName, webServicesDescriptionName);
            int count1 = wsd.getPortComponents().size();
            for (int k = 0; k < count1; ++k) {
                PortComponent pc = (PortComponent)wsd.getPortComponents().get(k);
                if (!jaxrpcPortComponents.contains(pc.getPortComponentName())) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "The port component: " + pc.getPortComponentName() + " is not a JAX-RPC port component");
                    break;
                }
                WSDLPort port = pc.getWsdlPort();
                QName qname = new QName(port.getNamespaceURI(), port.getLocalPart());
                ServletLink link = pc.getServiceImplBean().getEServletLink();
                String servletName = link != null ? link.getServletLink() : pc.getPortComponentName();
                String url = null;
                if (webApp != null) {
                    url = this.findServletUrl(webApp, servletName);
                }
                if (url != null) {
                    url = DeployUtils.trimSlash(url);
                }
                if (moduleFile.isWARFile()) {
                    if (url != null) {
                        wsdInfo.addQnameToUrlPattern(qname, url);
                    } else {
                        String manufacturdUrl = SERVLET_URL_PATTERN_ROOT + pc.getPortComponentName();
                        wsdInfo.addQnameToUrlPattern(qname, manufacturdUrl);
                    }
                } else if (url != null) {
                    wsdInfo.addQnameToUrlPattern(qname, url);
                } else {
                    String uri = "null";
                    if (wm != null) {
                        uri = wm.getUri();
                    }
                    Tr.error(tc, "WSWS0045E", new Object[]{mdUri, uri, pc.getPortComponentName()});
                }
                wsdInfo.addQnameToPortComponentName(qname, pc.getPortComponentName());
                if (!moduleFile.isEJBJarFile()) continue;
                ServiceImplBean serviceImplBean = pc.getServiceImplBean();
                EJBLink ejbl = serviceImplBean.getEEJBLink();
                String nameOfOurImplementingEJB = ejbl.getEjbLink();
                String nameOfEJBHomeInterface = null;
                List jars = earFile.getEJBJarFiles();
                for (EJBJarFile ejbJarFile : jars) {
                    EJBJar deploymentDescriptor = null;
                    if (ejbJarFile.getName().equals(moduleData.getName())) {
                        deploymentDescriptor = ejbJarFile.getDeploymentDescriptor();
                    }
                    if (deploymentDescriptor == null) continue;
                    for (EnterpriseBean ejb : deploymentDescriptor.getEnterpriseBeans()) {
                        if (!ejb.getName().equals(nameOfOurImplementingEJB)) continue;
                        nameOfEJBHomeInterface = ejb.getHomeInterfaceName();
                    }
                }
                String jndiName = null;
                Application app = earFile.getDeploymentDescriptor();
                Module m = app.getModule(mdUri, md2.getString("altDD", "__null__"));
                EjbModule ejbModule = (EjbModule)m;
                EJBJarBinding binding = earFile.getBindings(ejbModule);
                EList bindings = binding.getEjbBindings();
                for (EnterpriseBeanBinding oneBinding : bindings) {
                    String eBeanName;
                    EnterpriseBean eBean;
                    if (oneBinding == null || (eBean = oneBinding.getEnterpriseBean()) == null || (eBeanName = eBean.getName()) == null || !eBeanName.equals(nameOfOurImplementingEJB)) continue;
                    jndiName = oneBinding.getJndiName();
                }
                StringBuffer URLFragment = new StringBuffer();
                URLFragment.append("wsejb:/");
                URLFragment.append(nameOfEJBHomeInterface);
                URLFragment.append('?');
                URLFragment.append("jndiName=").append(jndiName);
                wsdInfo.addQNameToEJBUrlPrefix(qname, URLFragment.toString());
            }
            moduleData.addWebservicesDescription(wsdInfo);
        }
        List modulesWsdlFiles = moduleFile.isWARFile() ? moduleFile.getLoadStrategy().getFiles("WEB-INF/wsdl") : moduleFile.getLoadStrategy().getFiles("META-INF/wsdl");
        moduleData.setModulesWsdlFiles(modulesWsdlFiles);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadJAXRPCModuleData");
        }
        return moduleData;
    }

    private ModuleData loadCommonModuleData(ModuleData moduleData, EARFile earFile, ModuleFile moduleFile, ConfigObject md2, WebModule wm, boolean hasHTTPRouter) throws Exception {
        Application app;
        String mdUri = md2.getString("uri", "__null__");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCommonModuleData for ", mdUri + ", application: " + earFile.getName());
        }
        moduleData.setApplicationName(earFile.getName());
        moduleData.setIsWebModule(moduleFile.isWARFile());
        moduleData.setHasHTTPRouter(hasHTTPRouter);
        moduleData.setModuleFile(moduleFile);
        moduleData.setName(mdUri);
        this.uci = new URIConverterImpl(){

            public URI normalize(URI uri) {
                return uri.resolve(URI.createFileURI(DualMetaDataLoaderImpl.this.configScope.getAbsolutePath("") + java.io.File.separator));
            }
        };
        if (this.appDeployCtx != null) {
            String path = this.appDeployCtx.getPath();
            int index = path.lastIndexOf(java.io.File.separatorChar);
            String appName = path.substring(index + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadCommonModuleData: Display app name from appDeployCtx is " + appName);
            }
            moduleData.setDisplayApplicationName(appName);
        } else if (earFile != null && (app = earFile.getDeploymentDescriptor()) != null) {
            String DDAppName = app.getDisplayName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadCommonModuleData: Display app name is " + DDAppName);
            }
            moduleData.setDisplayApplicationName(DDAppName);
        }
        if (wm == null) {
            moduleData.setVirtualHost((ConfigObject)null);
        } else {
            this.configScope.setDepth(1);
            WASResourceSetImpl rs = new WASResourceSetImpl();
            rs.setURIConverter(this.uci);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Java EE version 50  this module's version " + earFile.getDeploymentDescriptor().getJ2EEVersionID());
            }
            String virtualHostName = null;
            if (moduleFile.isWARFile()) {
                WARFile wf = (WARFile)moduleFile;
                WebAppBinding webAppBinding = wf.getBindings();
                virtualHostName = webAppBinding.getVirtualHostName();
            } else if (wm != null) {
                ModuleFile mf;
                ModuleFile moduleFile2 = mf = earFile.getModuleRef(wm) != null ? earFile.getModuleRef(wm).getModuleFile() : null;
                if (mf != null && mf.isWARFile()) {
                    WARFile wf = (WARFile)mf;
                    WebAppBinding webAppBinding = wf.getBindings();
                    virtualHostName = webAppBinding.getVirtualHostName();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got virtual host name of " + virtualHostName);
            }
            this.configScope.setDepth(0);
            List vhs = configService.getDocumentObjects(this.configScope, "virtualhosts.xml");
            for (ConfigObject vh : vhs) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RCS virtual host name  " + vh.getString("name", "__null__"));
                }
                if (!vh.getString("name", "__null__").equals(virtualHostName)) continue;
                moduleData.setVirtualHost(vh);
                break;
            }
        }
        this.targets = md2.getObjectList("targetMappings");
        if (this.targets.isEmpty()) {
            throw new Exception(nls.getFormattedMessage("WSWS0044E", new Object[]{mdUri}, "WSWS0044E: Can not locate the deploy target for module: {0}"));
        }
        ConfigObject mapping = (ConfigObject)this.targets.get(0);
        ConfigObject target = mapping.getObject("target");
        String targetName = target.getString("name", "__null__");
        if (target.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi", "ServerTarget")) {
            String node = target.getString("nodeName", "__null__");
            String server = targetName;
            String host = (String)this.nodeHostNames.get(node);
            ConfigScope nodeScope = this.configScope;
            nodeScope.set(3, node);
            if (host == null) {
                host = DualMetaDataLoaderImpl.getHostName(nodeScope);
                this.nodeHostNames.put(node, host);
            }
            this.configScope.set(4, server);
            this.configScope.setDepth(4);
            Map ports = DualMetaDataLoaderImpl.loadWebContainerPorts(this.configScope);
            moduleData.setNode(node);
            moduleData.setHost(host);
            moduleData.setServer(server);
            for (String port : ports.keySet()) {
                String protocol = (String)ports.get(port);
                moduleData.addPrefix(protocol, port);
            }
        } else {
            block59: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deployment Target (server)" + targetName + " is a cluster");
                }
                try {
                    this.configScope.set(2, targetName);
                    this.configScope.setDepth(2);
                    ConfigObject cluster = (ConfigObject)configService.getDocumentObjects(this.configScope, "cluster.xml").get(0);
                    for (ConfigObject member : cluster.getObjectList("members")) {
                        String clusterNodeName = member.getString("nodeName", "__null__");
                        String clusterServerName = member.getString("memberName", "__null__");
                        String host = (String)this.nodeHostNames.get(clusterNodeName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "find configScope for nodes/" + clusterNodeName + ", configScope=" + this.configScope);
                        }
                        this.configScope.set(3, clusterNodeName);
                        if (host == null) {
                            host = DualMetaDataLoaderImpl.getHostName(this.configScope);
                            this.nodeHostNames.put(clusterNodeName, host);
                        }
                        Map ports = null;
                        if (this.configScope.list("") != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "configScope for servers/" + clusterServerName + ", configScope=" + this.configScope);
                            }
                            this.configScope.set(4, clusterServerName);
                            this.configScope.setDepth(4);
                            ports = DualMetaDataLoaderImpl.loadWebContainerPorts(this.configScope);
                        }
                        moduleData.setNode(clusterNodeName);
                        moduleData.setHost(host);
                        moduleData.setServer(clusterServerName);
                        if (ports == null) continue;
                        for (String port : ports.keySet()) {
                            String protocol = (String)ports.get(port);
                            moduleData.addPrefix(protocol, host, port);
                        }
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.deploy.MetaDataLoader.loadModuleData", "985", this);
                    if (!tc.isDebugEnabled()) break block59;
                    Tr.debug(tc, "Failed to load cluster context while determining application status: {0}", ex);
                }
            }
            moduleData.setServer("MODULE_ASSIGNED_TO_CLUSTER_TAG");
        }
        if (wm == null) {
            moduleData.setContextRoot("");
        } else {
            String contextRoot = wm.getContextRoot();
            moduleData.setContextRoot(contextRoot);
        }
        moduleData.setDefaultJMSPrefix("");
        moduleData.setDefaultEJBPrefix("");
        moduleData.setHasJMSRouter(false);
        HashMap urlPrefixMap = null;
        if (this.appDeployCtx != null) {
            RepositoryContext cellContext = this.appDeployCtx.getParent().getParent();
            String userName = cellContext.getWorkSpace().getUserName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadCommonModuleData: creating Session for userName " + userName);
            }
            Session session = new Session(userName, false);
            urlPrefixMap = moduleData.getPersistentPrefixHashMap(session);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadCommonModuleData: not creating Session, RepositoryContext is null");
        }
        if (urlPrefixMap != null && !urlPrefixMap.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found URL prefix information: " + urlPrefixMap.toString());
            }
            String s = null;
            s = (String)urlPrefixMap.get("http");
            if (s != null && s != "") {
                moduleData.setDefaultPrefix(s);
            }
            if ((s = (String)urlPrefixMap.get("https")) != null && s != "") {
                moduleData.setDefaultPrefix(s);
            }
            if ((s = (String)urlPrefixMap.get("jms")) != null && s != "") {
                moduleData.setDefaultJMSPrefix(s);
            }
            if ((s = (String)urlPrefixMap.get("ejb")) != null && s != "") {
                moduleData.setDefaultEJBPrefix(s);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No URL prefix information found for this module.");
        }
        if (moduleFile.isEJBJarFile()) {
            StringBuffer bindFileBuffer = new StringBuffer(moduleData.getName());
            bindFileBuffer.append(uriPathSeparator).append("META-INF/ibm-webservices-bnd.xmi");
            this.configScope.setDepth(1);
            WASResourceSetImpl resourceSet = new WASResourceSetImpl();
            resourceSet.setURIConverter(this.uci);
            WSBinding wsb = WSModels.getWSBindingFromResourceSet(resourceSet, bindFileBuffer.toString());
            if (wsb == null) {
                wsb = WSModels.getWSBinding(moduleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
            }
            if (wsb != null) {
                EList wsDescBindings = wsb.getWsdescBindings();
                if (wsDescBindings.size() > 0) {
                    EList routerModules = wsb.getRouterModules();
                    String jmsRouterName = null;
                    for (RouterModule router : routerModules) {
                        String transport = router.getTransport();
                        if (!transport.equals("jms")) continue;
                        jmsRouterName = router.getName();
                        break;
                    }
                    if (jmsRouterName != null) {
                        moduleData.setHasJMSRouter(true);
                        String jmsPrefix = moduleData.getDefaultJMSPrefix();
                        if (jmsPrefix == null || jmsPrefix.isEmpty()) {
                            this.configScope.setDepth(0);
                            String defaultJMSURLPrefix = this.buildDefaultJMSUrlFromconfig(earFile, this.targets, jmsRouterName);
                            moduleData.setDefaultJMSPrefix(defaultJMSURLPrefix);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Did not find a JMS router module for this EJB jar.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Module " + moduleFile.getName() + " contains a Web Services binding, but it contains no WSDescBindings");
                }
            } else {
                WSModuleDescriptor WSmd;
                if (this.WSDescBuilder == null) {
                    this.WSDescBuilder = WSDescriptionBuilderFactory.getBuilder();
                }
                if ((WSmd = this.WSDescBuilder.getModuleDescriptor(moduleFile)).containsJAXRPCWebServices() || WSmd.containsJAXWSWebServices()) {
                    Tr.error(tc, "WSWS0018E", new Object[]{moduleFile.getName(), "ibm-webservices-bnd.xmi"});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCommonModuleData");
        }
        return moduleData;
    }

    private String buildDefaultJMSUrlFromconfig(EARFile earFile, List targets, String jmsRouterName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildDefaultJMSUrlFromconfig, jmsRouterName=" + jmsRouterName);
        }
        String destination = null;
        String connectionFactory = null;
        String defaultJMSURLPrefixForModuleData = "";
        String activationSpecJndiName = null;
        String destinationJndiName = null;
        ConfigObject lp = null;
        List ejbJars = earFile.getEJBJarFiles();
        String listenerInputPortName = null;
        for (EJBJarFile ejbJarFile : ejbJars) {
            if (!ejbJarFile.getName().equals(jmsRouterName)) continue;
            EJBJarBinding ejbBinding = ejbJarFile.getBindings();
            EList ejbBindings = ejbBinding.getEjbBindings();
            if (ejbBindings.size() > 0 && ejbBindings.get(0) instanceof MessageDrivenBeanBinding) {
                MessageDrivenBeanBinding jmsBinding = (MessageDrivenBeanBinding)ejbBindings.get(0);
                activationSpecJndiName = jmsBinding.getActivationSpecJndiName();
                if (activationSpecJndiName != null) continue;
                listenerInputPortName = jmsBinding.getListenerInputPortName();
                continue;
            }
            Tr.error(tc, "WSWS0046E", jmsRouterName);
        }
        ConfigObject mapping = (ConfigObject)targets.get(0);
        ConfigObject target = mapping.getObject("target");
        if (target.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi", "ServerTarget")) {
            String node = target.getString("nodeName", "__null__");
            String server = target.getString("name", "__null__");
            if (activationSpecJndiName != null) {
                String[] destinationArray = this.getActivationSpecFromCellConfig(activationSpecJndiName, node);
                destinationJndiName = destinationArray[0];
            } else {
                lp = this.getListenerPortFromCellConfig(listenerInputPortName, node, server);
            }
            if (activationSpecJndiName != null) {
                destination = destinationJndiName;
            } else if (lp != null) {
                destination = lp.getString("destinationJNDIName", "__null__");
                connectionFactory = lp.getString("connectionFactoryJNDIName", "__null__");
            }
            if (destination == null) {
                destination = "??undefinedDestinationJndiName??";
            }
            if (connectionFactory == null) {
                connectionFactory = "??connectionFactoryJndiName??";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("jms");
            sb.append(":jndi:");
            sb.append(destination);
            sb.append('?');
            sb.append("jndiConnectionFactoryName");
            sb.append("=");
            sb.append(connectionFactory);
            defaultJMSURLPrefixForModuleData = sb.toString();
        }
        return defaultJMSURLPrefixForModuleData;
    }

    private String[] getActivationSpecFromCellConfig(String activationSpecJndiName, String node) {
        String[] destinationArray;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getActivationSpecFromCellConfig  jndiName = " + activationSpecJndiName);
            }
            String jndiName = null;
            destinationArray = new String[3];
            try {
                this.configScope.setDepth(3);
                List resources = configService.getDocumentObjects(this.configScope, "resources.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resources size is " + resources.size());
                }
                Iterator iter = resources.iterator();
                ConfigObject j2cResourceAdapter = null;
                while (iter.hasNext()) {
                    ConfigObject resourceCO = (ConfigObject)iter.next();
                    if (resourceCO.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi", "J2CResourceAdapter") && resourceCO.getString("name", "__null__").equals("SIB JMS Resource Adapter")) {
                        j2cResourceAdapter = resourceCO;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "resource is a J2CResourceAdapter");
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "resource is not a J2CResourceAdapter");
                }
                if (j2cResourceAdapter == null) break block14;
                List activationSpecArray = j2cResourceAdapter.getObjectList("j2cActivationSpec");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "activationSpecArray size is " + activationSpecArray.size());
                }
                for (int i = 0; i < activationSpecArray.size(); ++i) {
                    String propName;
                    ConfigObject activationSpec = (ConfigObject)activationSpecArray.get(i);
                    jndiName = activationSpec.getString("jndiName", "__null__");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "activationSpec jndiName is " + jndiName);
                    }
                    if (!jndiName.equals(activationSpecJndiName)) continue;
                    destinationArray[0] = activationSpec.getString("destinationJndiName", "__null__");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "destination " + destinationArray[0]);
                    }
                    List resourceProperties = activationSpec.getObjectList("resourceProperties");
                    ConfigObject resourceProperty = null;
                    for (int j = 0; j < resourceProperties.size() && !(propName = (resourceProperty = (ConfigObject)resourceProperties.get(j)).getString("name", "__null__")).equals("destinationType"); ++j) {
                    }
                    if (resourceProperty != null) {
                        String value = resourceProperty.getString("value", "__null__");
                        int index = value.lastIndexOf(".");
                        destinationArray[1] = value.substring(index + 1);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "destinationType " + destinationArray[1]);
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.deploy.MetaDataLoader.getActivationSpecFromCellConfig", "1271");
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "getActivationSpecFromCellConfig caught exception:", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActivationSpecFromCellConfig");
        }
        return destinationArray;
    }

    private ConfigObject getListenerPortFromCellConfig(String listenerInputPortName, String node, String server) {
        ConfigObject listenerPort;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getListenerPortFromCellConfig");
            }
            listenerPort = null;
            try {
                this.configScope.set(3, node);
                this.configScope.set(4, server);
                this.configScope.setDepth(4);
                ConfigObject s = (ConfigObject)configService.getDocumentObjects(this.configScope, "server.xml").get(0);
                List components = s.getObjectList("components");
                for (ConfigObject component2 : components) {
                    if (!component2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi", "ApplicationServer")) continue;
                    List components1 = component2.getObjectList("components");
                    for (ConfigObject component1 : components1) {
                        if (!component1.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.ejbcontainer.xmi", "EJBContainer")) continue;
                        List components2 = component1.getObjectList("services");
                        for (ConfigObject obj : components2) {
                            if (!obj.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.ejbcontainer.messagelistener.xmi", "MessageListenerService")) continue;
                            List listenerPorts = obj.getObjectList("listenerPorts");
                            for (ConfigObject lp : listenerPorts) {
                                String name = lp.getString("name", "__null__");
                                if (!name.equals(listenerInputPortName)) continue;
                                listenerPort = lp;
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "found listenerInputPortName: " + listenerInputPortName);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.deploy.MetaDataLoader.getListenerPortFromCellConfig", "2112");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "getListenerPortFromCellConfig caught exception:", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListenerPortFromCellConfig");
        }
        return listenerPort;
    }

    private static Map loadWebContainerPorts(ConfigScope aConfigScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadWebContainerPorts");
        }
        Map portMap = new HashMap();
        if (aConfigScope.list("") == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadWebContainerPorts: no ports mapped");
            }
        } else {
            try {
                aConfigScope.setDepth(4);
                ConfigObject s = (ConfigObject)configService.getDocumentObjects(aConfigScope, "server.xml").get(0);
                String s_serverName = s.getString("name", "__null__");
                List s_servicesList = s.getObjectList("services");
                ConfigObject s_tcs = null;
                boolean s_found = false;
                Iterator s_it = s_servicesList.iterator();
                while (s_it.hasNext() && !s_found) {
                    ConfigObject s_service = (ConfigObject)s_it.next();
                    if (!s_service.instanceOf("http://www.ibm.com/websphere/appserver/schemas/6.0/channelservice.xmi", "TransportChannelService")) continue;
                    s_tcs = s_service;
                    List transportChannelsList = s_service.getObjectList("transportChannels");
                    if (transportChannelsList.isEmpty()) break;
                    s_found = true;
                    break;
                }
                List components = s.getObjectList("components");
                ConfigObject webContainer = null;
                boolean found = false;
                Iterator it = components.iterator();
                block3: while (it.hasNext() && !found) {
                    ConfigObject component2 = (ConfigObject)it.next();
                    if (!component2.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.xmi", "ApplicationServer")) continue;
                    ConfigObject as = component2;
                    List components1 = as.getObjectList("components");
                    for (ConfigObject component1 : components1) {
                        if (!component1.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi", "WebContainer")) continue;
                        webContainer = component1;
                        found = true;
                        continue block3;
                    }
                }
                if (webContainer != null && found) {
                    portMap = DualMetaDataLoaderImpl.loadHTTPPortsFromV5Template(s, components, webContainer, portMap);
                }
                if (s_tcs != null && s_found) {
                    aConfigScope.setDepth(3);
                    portMap = DualMetaDataLoaderImpl.loadHTTPPortsFromV6Template(s_tcs, aConfigScope, s, s_serverName, portMap);
                } else {
                    Tr.error(tc, "loadWebContainerPorts could not find any http or https ports");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.webservices.deploy.MetaDataLoader.loadWebContainerPorts", "1523");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadWebContainerPorts");
        }
        return portMap;
    }

    private static Map loadHTTPPortsFromV6Template(ConfigObject s_tcs, ConfigScope nodeContext, ConfigObject s, String s_serverName, Map portMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadHTTPPortsFromV6Template");
        }
        MetaDataChannelHelper mdcHelper = new MetaDataChannelHelper(s_tcs);
        Map endPointMap = mdcHelper.getEndPointMap();
        portMap = DualMetaDataLoaderImpl.mapV6EndPoints2Ports(endPointMap, nodeContext, s, s_serverName, portMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadHTTPPortsFromV6Template");
        }
        return portMap;
    }

    private static Map mapV6EndPoints2Ports(Map endPointMap, ConfigScope nodeConfigScope, ConfigObject s, String s_serverName, Map portMap) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "mapV6EndPoints2Ports");
            }
            try {
                ConfigObject si = (ConfigObject)configService.getDocumentObjects(nodeConfigScope, "serverindex.xml").get(0);
                List si_serverEntries = si.getObjectList("serverEntries");
                boolean si_found = false;
                ConfigObject si_serverEntry2 = null;
                for (ConfigObject si_serverEntry2 : si_serverEntries) {
                    String si_serverName = si_serverEntry2.getString("serverName", "__null__");
                    if (si_serverName == null || !si_serverName.equals(s_serverName)) continue;
                    si_found = true;
                    break;
                }
                if (si_found) {
                    List si_specialEndPointsList = si_serverEntry2.getObjectList("specialEndpoints");
                    ConfigObject si_specialEndPoint2 = null;
                    String si_specialEndPointName = null;
                    for (ConfigObject si_specialEndPoint2 : si_specialEndPointsList) {
                        si_specialEndPointName = si_specialEndPoint2.getString("endPointName", "__null__");
                        ConfigObject si_endPoint = null;
                        String port = null;
                        String protocol = (String)endPointMap.get(si_specialEndPointName);
                        if (protocol == null || protocol.length() <= 0) continue;
                        si_endPoint = si_specialEndPoint2.getObject("endPoint");
                        port = new Integer(si_endPoint.getInt("port", 0)).toString();
                        portMap.put(port, protocol);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.deploy.MetaDataLoader.mapV6EndPoints2Ports", "1866");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "mapV6EndPoints2Ports caught exeption ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapV6EndPoints2Ports");
        }
        return portMap;
    }

    private static Map loadHTTPPortsFromV5Template(ConfigObject s, List components, ConfigObject webContainer, Map portMap) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadHTTPPortsFromV5Template");
            }
            try {
                List transports = webContainer.getObjectList("transports");
                for (ConfigObject transport : transports) {
                    ConfigObject ep;
                    if (!transport.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/applicationserver.webcontainer.xmi", "HTTPTransport") || (ep = transport.getObject("address")) == null) continue;
                    String port = new Integer(ep.getInt("port", 0)).toString();
                    String protocol = transport.getBoolean("sslEnabled", false) ? "https" : "http";
                    portMap.put(port, protocol);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadHTTPPortsFromV5Template: for server \"" + s.getString("name", "__null__") + "\" the container is [" + webContainer.getString("name", "__null__") + "] and the portMap being returned has " + portMap.size() + " elements, which are:\n");
                    for (String port : portMap.keySet()) {
                        String protocol = (String)portMap.get(port);
                        Tr.debug(tc, "\tport=" + port + " protocol=" + protocol);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.deploy.MetaDataLoader.loadHTTPPortsFromV5Template", "1694");
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "loadHTTPPortsFromV5Template caught exeption ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadHTTPPortsfromV5Template");
        }
        return portMap;
    }

    private List getGeneratedWSDLFile(Definition definition) throws Exception {
        if (definition != null) {
            String wsdlPath = definition.getDocumentBaseURI();
            if (wsdlPath != null) {
                java.net.URI uri = new java.net.URI(wsdlPath);
                wsdlPath = uri.getPath();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found WSDL location for generated WSDL: " + wsdlPath);
                }
                if (wsdlPath != null && wsdlPath.indexOf(uriPathSeparator) != -1) {
                    String wsdlParentDir = this.getGeneratedWsdlXsdDirectory(definition);
                    if (wsdlParentDir != null) {
                        CommonarchiveFactory archiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                        ReadOnlyDirectory rod = archiveFactory.openReadOnlyDirectory(wsdlParentDir);
                        EList fileList = rod.getFiles();
                        if (fileList != null && !fileList.isEmpty()) {
                            LinkedList<File> returnFiles = new LinkedList<File>();
                            for (Object obj : fileList) {
                                File file = (File)obj;
                                if (!file.getName().endsWith(".xsd") && !file.getName().endsWith(".wsdl")) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Adding genereated WSLD/XSD file: " + file.getName());
                                }
                                returnFiles.add(file);
                            }
                            return returnFiles;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not determine path to generated WSDL/XSD files");
                        }
                        return null;
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not determine path to generated WSDL/XSD files");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine path to generated WSDL/XSD files");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Generated WSDL definition is not available");
        }
        return null;
    }

    private String getGeneratedWsdlXsdDirectory(Definition definition) throws Exception {
        String docBaseURI = definition.getDocumentBaseURI();
        if (docBaseURI != null) {
            java.net.URI uri = new java.net.URI(docBaseURI);
            if ((docBaseURI = uri.getPath()) != null) {
                return docBaseURI.substring(0, docBaseURI.lastIndexOf(uriPathSeparator) + 1);
            }
            return null;
        }
        return null;
    }

    private String getGeneratedWsdlFileName(Definition definition) throws Exception {
        String docBaseURI = definition.getDocumentBaseURI();
        if (docBaseURI != null) {
            java.net.URI uri = new java.net.URI(docBaseURI);
            if ((docBaseURI = uri.getPath()) != null) {
                return docBaseURI.substring(docBaseURI.lastIndexOf(uriPathSeparator) + 1, docBaseURI.length());
            }
            return null;
        }
        return null;
    }
}

