/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NonceUtil {
    private static final TraceComponent tc = Tr.register(NonceUtil.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = NonceUtil.class.getName();
    private static final long minForwardClockSkew = 90000L;
    private static final String HTTP_STR = "http://".intern();

    public static Element getTimestamp(Element parent, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestamp(Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        Element timestamp = null;
        timestamp = DOMUtil.equals((Node)parent, (String)nsWsu, (String)"Timestamp") ? parent : DOMUtil.getLastElement((Node)parent, (String)nsWsu, (String)"Timestamp");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimestamp(Element parent,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)timestamp) + "]"));
        }
        return timestamp;
    }

    public static Element getNonce(Element parent, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNonce(Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        Element nonce = null;
        nonce = DOMUtil.equals((Node)parent, (String)nsWsse, (String)"Nonce") ? parent : DOMUtil.getLastElement((Node)parent, (String)nsWsse, (String)"Nonce");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNonce(Element parent,String nsWsse) returns Element[" + DOMUtil.getDisplayName((Node)nonce) + "]"));
        }
        return nonce;
    }

    public static Element getChildTimestamp(Element parent, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestamp(Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        Element timestamp = DOMUtil.getOneChildElement((Element)parent, (String)nsWsu, (String)"Timestamp");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimestamp(Element parent,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)timestamp) + "]"));
        }
        return timestamp;
    }

    public static Element getChildNonce(Element parent, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNonce(Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String nsWsse[" + nsWsse + "])"));
        }
        Element nonce = DOMUtil.getOneChildElement((Element)parent, (String)nsWsse, (String)"Nonce");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNonce(Element parent,String nsWsse) returns Element[" + DOMUtil.getDisplayName((Node)nonce) + "]"));
        }
        return nonce;
    }

    public static Element createTimestamp(Document doc, Element parent, String nsWsu, String extType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTimestamp(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String nsWsu[" + nsWsu + "]," + "String extType[" + extType + "])"));
        }
        String prefix = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsu);
        Element timestamp = null;
        if (prefix == null) {
            timestamp = doc.createElementNS(nsWsu, "wsu:Timestamp");
            timestamp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", nsWsu);
        } else {
            timestamp = doc.createElementNS(nsWsu, prefix + ":Timestamp");
        }
        if ("wedsig".equals(extType) || "weenc".equals(extType)) {
            timestamp.setAttribute("wasextention", extType);
        }
        timestamp = (Element)parent.appendChild(timestamp);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTimestamp(Document doc,Element parent,String nsWsu,boolean extention) returns Element[" + DOMUtil.getDisplayName((Node)timestamp) + "]"));
        }
        return timestamp;
    }

    public static Element addCreated(Document doc, Element parent, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addCreated(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        boolean nsDecl = false;
        String prefix = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsu);
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsu:";
        } else if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        Date now = new Date();
        String dt = UTC.format((Date)now);
        Element created = doc.createElementNS(nsWsu, prefix + "Created");
        created.appendChild(doc.createTextNode(dt));
        created = (Element)parent.appendChild(created);
        if (nsDecl) {
            created.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", nsWsu);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addCreated(Document doc,Element parent,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)created) + "]"));
        }
        return created;
    }

    public static Element addExpires(Document doc, Element parent, Duration duration, String nsWsu) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addExpires(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Duration duration[" + duration + "]," + "String nsWsu[" + nsWsu + "])"));
        }
        boolean nsDecl = false;
        String prefix = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsu);
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsu:";
        } else if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        duration.addTo(cal);
        String dt = UTC.format((Date)cal.getTime());
        Element expires = doc.createElementNS(nsWsu, prefix + "Expires");
        expires.appendChild(doc.createTextNode(dt));
        expires = (Element)parent.appendChild(expires);
        if (nsDecl) {
            expires.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", nsWsu);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addExpires(Document doc,Element parent,Duration duration,String nsWsu) returns Element[" + DOMUtil.getDisplayName((Node)expires) + "]"));
        }
        return expires;
    }

    public static Element createNonce(Document doc, Element parent, String nsWsse, NonceManager nmanager, String extType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createNonce(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "String nsWsse[" + nsWsse + "]," + "NonceManager nmanager[" + nmanager + "]," + "String extType[" + extType + "])"));
        }
        boolean nsDecl = false;
        String prefix = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsse);
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsse:";
        } else if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        Element nonce = doc.createElementNS(nsWsse, prefix + "Nonce");
        if (nsDecl) {
            nonce.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", nsWsse);
        }
        if ("wedsig".equals(extType) || "weenc".equals(extType)) {
            nonce.setAttribute("wasextention", extType);
        }
        nonce.appendChild(doc.createTextNode(NonceUtil.generateNonce(nmanager)));
        nonce = (Element)parent.appendChild(nonce);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createNonce(Document doc,Element parent,String nsWsse,String nmanager) returns Element[" + DOMUtil.getDisplayName((Node)nonce) + "]"));
        }
        return nonce;
    }

    public static String generateNonce(NonceManager nmanager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateNonce(NonceManager nmanager[" + nmanager + "])"));
        }
        byte[] nonce = nmanager.generate();
        String nvalue = Base64.encode((byte[])nonce);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateNonce(NonceManager nmanager) returns String[" + nvalue + "]"));
        }
        return nvalue;
    }

    public static void checkNonce(Element element, String nsWsse, NonceManager nmanager) throws SoapSecurityException {
        String value;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkNonce(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsse[" + nsWsse + "]," + "NonceManager nmanager[" + nmanager + "])"));
        }
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s06");
        }
        String ln = element.getLocalName();
        String ns = element.getNamespaceURI();
        if (!nsWsse.equals(ns) || !"Nonce".equals(ln)) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)element));
        }
        QName etype = Constants.BASE64_BINARY;
        if (element.hasAttribute("EncodingType")) {
            value = element.getAttribute("EncodingType");
            etype = DOMUtil.getQName((Element)element, (String)value);
        }
        value = DOMUtil.getStringValue((Node)element);
        byte[] nonce = null;
        if (Constants.BASE64_BINARY.equals(etype)) {
            nonce = Base64.decode((String)value);
        } else if (Constants.HEX_BINARY.equals(etype)) {
            try {
                nonce = Hex.decode((String)value);
            }
            catch (ParseException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".checkNonce"), (String)"371");
                throw SoapSecurityException.format("security.wssecurity.NonceUtil.s01", e);
            }
        }
        if (!nmanager.validate(nonce)) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s02", value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkNonce(Element element,String nsWsse,NonceManager nmanager)");
        }
    }

    public static void checkTimestamp(Node node, String nsWsu, int maxAge, int clockSkew, boolean logError) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkTimestamp(Node node[" + DOMUtil.getDisplayName((Node)node) + "]," + "String nsWsu[" + nsWsu + "]," + "int maxAge[" + maxAge + "]," + "int clockSkew[" + clockSkew + "]," + "boolean logError[" + logError + "])"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s07");
        }
        String ln = node.getLocalName();
        String ns = node.getNamespaceURI();
        if (node.getNodeType() != 1 || !nsWsu.equals(ns) || !"Timestamp".equals(ln)) {
            if (logError) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s03", (Object)new Object[]{DOMUtil.getQualifiedName((Node)node)});
            }
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)node));
        }
        Element element = (Element)node;
        Date created = null;
        Date expires = null;
        try {
            Element eel;
            Element cel = DOMUtil.getFirstElement((Node)element, (String)nsWsu, (String)"Created");
            if (cel != null) {
                NonceUtil.checkType(cel);
                created = UTC.parse((String)DOMUtil.getStringValue((Node)cel));
            }
            if ((eel = DOMUtil.getFirstElement((Node)element, (String)nsWsu, (String)"Expires")) != null) {
                NonceUtil.checkType(eel);
                expires = UTC.parse((String)DOMUtil.getStringValue((Node)eel));
            }
        }
        catch (ParseException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".checkTimestamp"), (String)"437");
            if (logError) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.NonceUtil.s03", (Object)new Object[]{e});
            }
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s03", e);
        }
        long current = System.currentTimeMillis();
        Date now = new Date(current);
        if (expires != null && now.after(expires)) {
            String cstr = created != null ? created.toString() : "";
            String estr = expires != null ? expires.toString() : "";
            String nstr = now.toString();
            if (logError) {
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.NonceUtil.s04", (Object)new Object[]{cstr, estr, nstr});
            }
            throw SoapSecurityException.format(Constants.MESSAGE_EXPIRED, "security.wssecurity.NonceUtil.s04", new String[]{cstr, estr, nstr});
        }
        if (created != null) {
            Long machine_time = new Long(current);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("current time = " + current + " ms"));
            }
            if (maxAge < 0) {
                maxAge = 300;
            }
            long maxAgeMillis = maxAge * 1000;
            long skewedback = current - maxAgeMillis;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Max age = " + maxAgeMillis + " ms, (current - max age) = " + skewedback + " ms"));
            }
            if (clockSkew < 0) {
                clockSkew = 0;
            }
            long clockSkewMillis = clockSkew * 1000;
            skewedback -= clockSkewMillis;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Clock skew = " + clockSkewMillis + " ms, (current - clock skew) = " + skewedback + " ms"));
            }
            long createdTime = created.getTime();
            Long created_time = new Long(createdTime);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created time (timestamp) = " + createdTime + " ms"));
            }
            if (createdTime < skewedback) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Timestamp is not fresh, creation timestamp " + UTC.format((Date)created) + " too old"));
                }
                String msgKey_generator = "security.wssecurity.WSEC5205E";
                String msgKey_consumer = "security.wssecurity.WSEC5206E";
                String cstr = created != null ? created.toString() : "";
                String[] inserts = new String[]{now.toString(), cstr};
                Tr.error((TraceComponent)tc, (String)msgKey_consumer, (Object)inserts);
                String msgStr = ConfigUtil.getMessage((String)msgKey_generator) + "(" + ConfigUtil.getMessage((String)msgKey_consumer, (String[])inserts) + ")";
                throw new SoapSecurityException(msgStr);
            }
            if (clockSkewMillis < 90000L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Clock skew increased to 90000ms for forward timestamp check.");
                }
                clockSkewMillis = 90000L;
            }
            long skewedforward = current + clockSkewMillis;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Clock skew = " + clockSkewMillis + " ms, (current + clock skew) = " + skewedforward + " ms"));
            }
            if (createdTime > skewedforward) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Timestamp is not valid, creation timestamp " + UTC.format((Date)created) + " too far in future"));
                }
                String msgKey_generator = "security.wssecurity.WSEC5208E";
                String msgKey_consumer = "security.wssecurity.WSEC5206E";
                String cstr = created != null ? created.toString() : "";
                String[] inserts = new String[]{now.toString(), cstr};
                Tr.error((TraceComponent)tc, (String)msgKey_consumer, (Object)inserts);
                String msgStr = ConfigUtil.getMessage((String)msgKey_generator) + "(" + ConfigUtil.getMessage((String)msgKey_consumer, (String[])inserts) + ")";
                throw new SoapSecurityException(msgStr);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Timestamp is fresh");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTimestamp(Node node,String nsWsu,int maxAge,int clockSkew,boolean logError)");
        }
    }

    private static void checkType(Element timestamp) throws SoapSecurityException {
        String value;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkType(Element timestamp[" + DOMUtil.getDisplayName((Node)timestamp) + "])"));
        }
        if ((value = timestamp.getAttribute("ValueType")) != null && value.length() > 0) {
            if (value.startsWith(HTTP_STR)) {
                if (!value.equals(Constants.XSD_DATETIME)) {
                    throw SoapSecurityException.format("security.wssecurity.NonceUtil.s05", value);
                }
            } else {
                QName valueType = DOMUtil.getQName((Element)timestamp, (String)value);
                if (!valueType.equals(Constants.DATETIME)) {
                    throw SoapSecurityException.format("security.wssecurity.NonceUtil.s05", valueType.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkType(Element timestamp)");
        }
    }

    public static boolean isNonceFirst(Element parent, Element nonce, Element timestamp) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isNonceFirst(Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Element nonce[" + DOMUtil.getDisplayName((Node)nonce) + "]," + "Element timestamp[" + DOMUtil.getDisplayName((Node)timestamp) + "])"));
        }
        boolean ret = false;
        if (nonce != null) {
            if (timestamp == null) {
                ret = true;
            } else {
                Element node = DOMUtil.getFirstElement((Node)parent);
                while (node != null) {
                    if (node.equals(nonce)) {
                        ret = true;
                        break;
                    }
                    if (node.equals(timestamp)) break;
                    node = DOMUtil.getNextElement((Node)node);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isNonceFirst(Element parent,Element nonce,Element timestamp) return boolean[" + ret + "]"));
        }
        return ret;
    }

    public static Date checkNonceTimestamp(Element element, String nsWsu, int maxAge, int clockSkew) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkNonceTimestamp(Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "String nsWsu[" + nsWsu + "]," + "int maxAge[" + maxAge + "]," + "int clockSkew[" + clockSkew + "])"));
        }
        if (element == null) {
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s08");
        }
        String ln = element.getLocalName();
        String ns = element.getNamespaceURI();
        if (!nsWsu.equals(ns) || !"Created".equals(ln)) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)element));
        }
        Date created = null;
        try {
            NonceUtil.checkType(element);
            created = UTC.parse((String)DOMUtil.getStringValue((Node)element));
        }
        catch (ParseException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".checkNonceTimestamp"), (String)"626");
            throw SoapSecurityException.format("security.wssecurity.NonceUtil.s03", e);
        }
        long current = System.currentTimeMillis();
        Date now = new Date(current);
        Long server_time = new Long(current);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current time = " + current + " ms"));
        }
        if (maxAge < 0) {
            maxAge = 300;
        }
        long maxAgeMillis = maxAge * 1000;
        long skewedback = current - maxAgeMillis;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce max age = " + maxAgeMillis + " ms, (current - Nonce max age) = " + skewedback + " ms"));
        }
        if (clockSkew < 0) {
            clockSkew = 0;
        }
        long clockSkewMillis = clockSkew * 1000;
        skewedback -= clockSkewMillis;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce clock skew = " + clockSkewMillis + " ms, (current - Nonce clock skew) = " + skewedback + " ms"));
        }
        long createdTime = created.getTime();
        Long created_time = new Long(createdTime);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce created time (timestamp) = " + createdTime + " ms"));
        }
        if (createdTime < skewedback) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nonce timestamp is not fresh, creation timestamp " + UTC.format((Date)created) + " too old"));
            }
            String msgKey_client = "security.wssecurity.WSEC5193E";
            String msgKey_server = "security.wssecurity.WSEC5200E";
            Tr.error((TraceComponent)tc, (String)msgKey_server, (Object)new Object[]{server_time.toString(), created_time.toString()});
            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, msgKey_client);
        }
        if (clockSkewMillis < 90000L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Clock skew increased to 90000ms for forward timestamp check.");
            }
            clockSkewMillis = 90000L;
        }
        long skewedforward = current + clockSkewMillis;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clock skew = " + clockSkewMillis + " ms, (current + clock skew) = " + skewedforward + " ms"));
        }
        if (createdTime > skewedforward) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Nonce timestamp is not valid, creation timestamp " + UTC.format((Date)created) + " too far in advance"));
            }
            String msgKey_generator = "security.wssecurity.WSEC5209E";
            String msgKey_consumer = "security.wssecurity.WSEC5200E";
            Tr.error((TraceComponent)tc, (String)msgKey_consumer, (Object)new Object[]{server_time.toString(), created_time.toString()});
            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, msgKey_generator);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Nonce Timestamp is fresh");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkNonceTimestamp(Element element,String nsWsu,int maxAge,int clockSkew) returns Date[" + created + "]"));
        }
        return created;
    }
}

