/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandlerFactory;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKey;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKey;
import com.ibm.etools.webservice.wscommonbnd.TokenValueType;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator;
import com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluatorRef;
import com.ibm.etools.webservice.wscommonext.AuthMethod;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.ConfidentialPartPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wsext.LoginConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import java.security.AlgorithmParameters;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.spec.AlgorithmParameterSpec;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ConfigValidation {
    private VariableMap varMap = null;
    private WSSecurityDefaultConfiguration config = null;
    private static String isFipsEnabled = null;
    private static boolean rsaoaepInitialized = false;
    private static boolean rsaoaepSupported = false;
    private static byte[] lock = new byte[0];
    protected final Set allowedEncAlgos = new HashSet();
    protected final Set allowedKeyEncAlgos = new HashSet();
    protected final Set allowedC14nAlgos = new HashSet();
    protected final Set allowedSignAlgos = new HashSet();
    protected final Set allowedDigestAlgos = new HashSet();
    private static final String comp = "security.wssecurity";
    private static final String clsName = ConfigValidation.class.getName();
    private static final TraceComponent tc = Tr.register(ConfigValidation.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public ConfigValidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigValidation()");
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigValidation()");
        }
    }

    public ConfigValidation(VariableMap varMap, WSSecurityService wsService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigValidation(VariableMap, WSSecurityService):", new Object[]{varMap, wsService});
        }
        this.init();
        this.varMap = varMap;
        this.config = wsService != null ? (WSSecurityDefaultConfiguration)wsService.getConfig() : null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigValidation()");
        }
    }

    public ConfigValidation(VariableMap varMap, WSSecurityDefaultConfiguration config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigValidation(VariableMap, WSSecurityDefaultConfiguration):", new Object[]{varMap, config});
        }
        this.init();
        this.varMap = varMap;
        this.config = config;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigValidation()");
        }
    }

    private void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        this.processAllowedAlgorithms(DOMUtil.getConfigValidation());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void initVarMap(VariableMap varMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initVarMap(VariableMap):", new Object[]{varMap});
        }
        this.varMap = varMap;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initVarMap()");
        }
    }

    public void initDefaultConfig(WSSecurityDefaultConfiguration config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initDefaultConfig(WSSecurityDefaultConfiguration):", new Object[]{config});
        }
        this.config = config;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initDefaultConfig()");
        }
    }

    public void initWsService(WSSecurityService wsService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initWsService(WSSecurityService):", new Object[]{wsService});
        }
        if (wsService != null) {
            this.config = (WSSecurityDefaultConfiguration)wsService.getConfig();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initWsService()");
        }
    }

    public boolean requiredIntegrityValid(RequiredIntegrity requiredIntegrity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requiredIntegrityValid(" + requiredIntegrity + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (requiredIntegrity != null) {
            int count = requiredIntegrity.getReferences().size();
            for (int i = 0; i < count; ++i) {
                Reference ref = (Reference)requiredIntegrity.getReferences().get(i);
                ReferencePart refPart = ref.getPart();
                String name = null;
                if (refPart != null) {
                    name = refPart.getName();
                }
                if ("body".equals(name) || "timestamp".equals(name) || "securitytoken".equals(name)) continue;
                valid = false;
                String msg = "security.wssecurity.ConfigValidation.required.integrity.invalid";
                Tr.error(tc, msg, new Object[]{name});
                String str = MessageFormat.format(ConfigConstants.getMessage(msg), name);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requiredIntegrityValid() returns " + valid);
        }
        return valid;
    }

    public boolean requiredConfidentialityValid(RequiredConfidentiality requiredConfidentiality) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requiredConfidentialityValid(" + requiredConfidentiality + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (requiredConfidentiality != null) {
            int count = requiredConfidentiality.getConfidentialParts().size();
            for (int i = 0; i < count; ++i) {
                ConfidentialPart confPart = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confPartPart = confPart.getPart();
                String name = null;
                if (confPartPart != null) {
                    name = confPartPart.getName();
                }
                if ("bodycontent".equals(name) || "usernametoken".equals(name)) continue;
                valid = false;
                String msg = "security.wssecurity.ConfigValidation.required.conf.invalid";
                Tr.error(tc, msg, new Object[]{name});
                String str = MessageFormat.format(ConfigConstants.getMessage(msg), name);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requiredConfidentialityValid() returns " + valid);
        }
        return valid;
    }

    public boolean integrityValid(Integrity integrity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integrityValid(" + integrity + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (integrity != null) {
            int count = integrity.getReferences().size();
            for (int i = 0; i < count; ++i) {
                Reference ref = (Reference)integrity.getReferences().get(i);
                ReferencePart refPart = ref.getPart();
                String name = null;
                if (refPart != null) {
                    name = refPart.getName();
                }
                if ("body".equals(name) || "timestamp".equals(name) || "securitytoken".equals(name)) continue;
                valid = false;
                String msg = "security.wssecurity.ConfigValidation.integrity.invalid";
                Tr.error(tc, msg, new Object[]{name});
                String str = MessageFormat.format(ConfigConstants.getMessage(msg), name);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "integrityValid() returns " + valid);
        }
        return valid;
    }

    public boolean confidentialityValid(Confidentiality confidentiality) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "confidentialityValid(" + confidentiality + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (confidentiality != null) {
            int count = confidentiality.getConfidentialParts().size();
            for (int i = 0; i < count; ++i) {
                ConfidentialPart confPart = (ConfidentialPart)confidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confPartPart = confPart.getPart();
                String name = null;
                if (confPartPart != null) {
                    name = confPartPart.getName();
                }
                if ("bodycontent".equals(name) || "usernametoken".equals(name)) continue;
                valid = false;
                String msg = "security.wssecurity.ConfigValidation.conf.invalid";
                Tr.error(tc, msg, new Object[]{name});
                String str = MessageFormat.format(ConfigConstants.getMessage(msg), name);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "confidentialityValid() returns " + valid);
        }
        return valid;
    }

    public boolean idAssertionValid(IDAssertion idAssertion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "idAssertionValid(" + idAssertion + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (idAssertion != null) {
            String trustMode;
            String idType = idAssertion.getIdType();
            if (!("Username".equals(idType) || "DN".equals(idType) || "X509Certificate".equals(idType))) {
                valid = false;
                String msg = "security.wssecurity.ConfigValidation.idassertion.type.invalid";
                Tr.error(tc, msg, new Object[]{idType});
                String str = MessageFormat.format(ConfigConstants.getMessage(msg), idType);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
            if ((trustMode = idAssertion.getTrustMode()) != null && !"Signature".equals(trustMode) && !"BasicAuth".equals(trustMode)) {
                valid = false;
                String msg = "security.wssecurity.ConfigValidation.idassertion.mode.invalid";
                Tr.error(tc, msg, new Object[]{trustMode});
                String str = MessageFormat.format(ConfigConstants.getMessage(msg), trustMode);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "idAssertionValid() returns " + valid);
        }
        return valid;
    }

    public boolean scopeValid(String scope) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scopeValid(" + scope + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (!(scope == null || "Session".equals(scope) || "Request".equals(scope) || "Application".equals(scope))) {
            valid = false;
            String msg = "security.wssecurity.ConfigValidation.scope.invalid";
            Tr.error(tc, msg, new Object[]{scope});
            String str = MessageFormat.format(ConfigConstants.getMessage(msg), scope);
            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scopeValid() returns " + valid);
        }
        return valid;
    }

    private boolean signingInfoValid(SigningInfo signingInfo, EList trustAnchors, CertStoreList certStoreList, boolean isReceiver, boolean signingInfoRequired) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signingInfoValid(" + signingInfo + ", " + trustAnchors + ", " + certStoreList + ", " + (isReceiver ? "receiver" : "sender") + ", " + "signingInfoRequired=" + signingInfoRequired + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (signingInfo != null) {
            String msg;
            SigningKey sk;
            String str;
            String msg2;
            CertPathSettings cps;
            String str2;
            String msg3;
            TrustAnchorRef trustAnchorRef = null;
            CertStoreRef certStoreRef = null;
            TrustAnyCertificate trustAnyCert = null;
            CanonicalizationMethod cm = signingInfo.getCanonicalizationMethod();
            String c14nAlgo = null;
            if (cm != null) {
                c14nAlgo = cm.getAlgorithm();
            }
            DigestMethod dm = signingInfo.getDigestMethod();
            String digestAlgo = null;
            if (dm != null) {
                digestAlgo = dm.getAlgorithm();
            }
            SignatureMethod sm = signingInfo.getSignatureMethod();
            String signAlgo = null;
            if (sm != null) {
                signAlgo = sm.getAlgorithm();
            }
            if (cm != null && !this.canonicalizationMethodValid(c14nAlgo)) {
                valid = false;
                msg3 = "security.wssecurity.ConfigValidation.canon.method.invalid";
                Tr.error(tc, msg3, new Object[]{c14nAlgo});
                str2 = MessageFormat.format(ConfigConstants.getMessage(msg3), c14nAlgo);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str2) : new String(allMessages + " ; " + str2);
            }
            if (dm != null && !this.digestMethodValid(digestAlgo)) {
                valid = false;
                msg3 = "security.wssecurity.ConfigValidation.digest.method.invalid";
                Tr.error(tc, msg3, new Object[]{digestAlgo});
                str2 = MessageFormat.format(ConfigConstants.getMessage(msg3), digestAlgo);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str2) : new String(allMessages + " ; " + str2);
            }
            if (sm != null && !this.signatureMethodValid(signAlgo)) {
                valid = false;
                msg3 = "security.wssecurity.ConfigValidation.sign.method.invalid";
                Tr.error(tc, msg3, new Object[]{signAlgo});
                str2 = MessageFormat.format(ConfigConstants.getMessage(msg3), signAlgo);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str2) : new String(allMessages + " ; " + str2);
            }
            if ((cps = signingInfo.getCertPathSettings()) != null) {
                trustAnchorRef = cps.getTrustAnchorRef();
                certStoreRef = cps.getCertStoreRef();
                trustAnyCert = cps.getTrustAnyCertificate();
                if (trustAnyCert == null && trustAnchorRef == null) {
                    valid = false;
                    msg2 = "security.wssecurity.ConfigValidation.cps.missing.refs";
                    Tr.error(tc, msg2);
                    str = ConfigConstants.getMessage(msg2);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
                }
            } else if (isReceiver) {
                valid = false;
                msg2 = "security.wssecurity.ConfigValidation.cps.missing";
                Tr.error(tc, msg2);
                str = ConfigConstants.getMessage(msg2);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
            if ((sk = signingInfo.getSigningKey()) != null) {
                String str3;
                String skname = sk.getName();
                String skref = sk.getLocatorRef();
                if (skname == null || skname.length() == 0) {
                    valid = false;
                    msg = "security.wssecurity.ConfigValidation.sk.missing.name";
                    Tr.error(tc, msg);
                    str3 = ConfigConstants.getMessage(msg);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str3) : new String(allMessages + " ; " + str3);
                }
                if (skref == null || skref.length() == 0) {
                    valid = false;
                    msg = "security.wssecurity.ConfigValidation.sk.missing.ref";
                    Tr.error(tc, msg);
                    str3 = ConfigConstants.getMessage(msg);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str3) : new String(allMessages + " ; " + str3);
                }
            } else if (!isReceiver) {
                valid = false;
                String msg4 = "security.wssecurity.ConfigValidation.sk.missing";
                Tr.error(tc, msg4);
                String str4 = ConfigConstants.getMessage(msg4);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str4) : new String(allMessages + " ; " + str4);
            }
            if (trustAnyCert != null) {
                String tarname = null;
                if (trustAnchorRef != null) {
                    tarname = trustAnchorRef.getRef();
                }
                if (tarname != null && tarname.length() != 0) {
                    boolean foundTaRef = false;
                    if (trustAnchors != null && !trustAnchors.isEmpty()) {
                        KeyStore keyStore = null;
                        int tacount = trustAnchors.size();
                        for (int j = 0; j < tacount; ++j) {
                            TrustAnchor ta = (TrustAnchor)trustAnchors.get(j);
                            if (!tarname.equals(ta.getName())) continue;
                            foundTaRef = true;
                            com.ibm.etools.webservice.wscommonbnd.KeyStore keyStoreData = ta.getKeyStore();
                            String keyStoreName = keyStoreData.getKeyStoreRef();
                            if (keyStoreName != null) {
                                keyStore = ConfigUtil.getKeyStore((String)keyStoreName);
                            } else {
                                String file = null;
                                file = this.varMap == null ? keyStoreData.getPath() : this.varMap.expand(keyStoreData.getPath());
                                try {
                                    keyStore = ConfigUtil.getKeyStore((String)keyStoreData.getType(), (String)file, (char[])keyStoreData.getStorepass().toCharArray());
                                }
                                catch (SoapSecurityException sse) {
                                    // empty catch block
                                }
                            }
                            if (keyStore != null || !tc.isDebugEnabled()) break;
                            Tr.debug(tc, "Unable to open keystore \"" + keyStoreData.getPath() + "\".");
                            break;
                        }
                        if (keyStore == null && this.config != null) {
                            keyStore = this.config.getTrustAnchor(tarname);
                        }
                        if (keyStore == null) {
                            valid = false;
                            String msg5 = "security.wssecurity.ConfigValidation.keystore.taref.open";
                            Tr.error(tc, msg5, new Object[]{tarname});
                            String str5 = MessageFormat.format(ConfigConstants.getMessage(msg5), tarname);
                            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str5) : new String(allMessages + " ; " + str5);
                        }
                    }
                    if (!foundTaRef && isReceiver) {
                        valid = false;
                        msg = "security.wssecurity.ConfigValidation.taref.notfound";
                        Tr.error(tc, msg, new Object[]{tarname});
                        String str6 = MessageFormat.format(ConfigConstants.getMessage(msg), tarname);
                        allMessages = allMessages == null || allMessages.length() == 0 ? new String(str6) : new String(allMessages + " ; " + str6);
                    }
                }
            }
            if (trustAnyCert != null) {
                String csname = null;
                if (certStoreRef != null) {
                    csname = certStoreRef.getRef();
                }
                if (csname != null && csname.length() != 0) {
                    CertStore cs;
                    boolean foundCsRef = false;
                    if (certStoreList != null) {
                        EList ldapCertStores;
                        String str7;
                        String msg6;
                        String str8;
                        String msg7;
                        EList collCertStores = certStoreList.getCollectionCertStores();
                        if (collCertStores != null && !collCertStores.isEmpty()) {
                            int ccscount = collCertStores.size();
                            for (int k = 0; k < ccscount; ++k) {
                                EList x509certs;
                                String provider;
                                CollectionCertStore ccs = (CollectionCertStore)collCertStores.get(k);
                                String name = ccs.getName();
                                if (!csname.equals(name)) continue;
                                foundCsRef = true;
                                String cssname = ccs.getName();
                                if (cssname == null || cssname.length() == 0) {
                                    valid = false;
                                    String msg8 = "security.wssecurity.ConfigValidation.ccs.missing.name";
                                    Tr.error(tc, msg8);
                                    String str9 = ConfigConstants.getMessage(msg8);
                                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str9) : new String(allMessages + " ; " + str9);
                                }
                                if ((provider = ccs.getProvider()) == null || provider.length() == 0) {
                                    valid = false;
                                    msg7 = "security.wssecurity.ConfigValidation.ccs.missing.provider";
                                    Tr.error(tc, msg7);
                                    str8 = ConfigConstants.getMessage(msg7);
                                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str8) : new String(allMessages + " ; " + str8);
                                }
                                if ((x509certs = ccs.getX509Certificates()) != null && x509certs.size() >= 1) break;
                                valid = false;
                                msg6 = "security.wssecurity.ConfigValidation.ccs.missing.cert";
                                Tr.error(tc, msg6);
                                str7 = ConfigConstants.getMessage(msg6);
                                if (allMessages == null || allMessages.length() == 0) {
                                    allMessages = new String(str7);
                                    break;
                                }
                                allMessages = new String(allMessages + " ; " + str7);
                                break;
                            }
                        }
                        if ((ldapCertStores = certStoreList.getLdapCertStores()) != null && !ldapCertStores.isEmpty()) {
                            int lcscount = ldapCertStores.size();
                            for (int m = 0; m < lcscount; ++m) {
                                String port;
                                LDAPServer server;
                                String provider;
                                LDAPCertStore lcs = (LDAPCertStore)ldapCertStores.get(m);
                                String name = lcs.getName();
                                if (!csname.equals(name)) continue;
                                foundCsRef = true;
                                String cssname = lcs.getName();
                                if (cssname == null || cssname.length() == 0) {
                                    valid = false;
                                    msg7 = "security.wssecurity.ConfigValidation.lcs.missing.name";
                                    Tr.error(tc, msg7);
                                    str8 = ConfigConstants.getMessage(msg7);
                                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str8) : new String(allMessages + " ; " + str8);
                                }
                                if ((provider = lcs.getProvider()) == null || provider.length() == 0) {
                                    valid = false;
                                    msg6 = "security.wssecurity.ConfigValidation.lcs.missing.provider";
                                    Tr.error(tc, msg6);
                                    str7 = ConfigConstants.getMessage(msg6);
                                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str7) : new String(allMessages + " ; " + str7);
                                }
                                if ((server = lcs.getLdapServer()) == null) {
                                    valid = false;
                                    String msg9 = "security.wssecurity.ConfigValidation.lcs.missing.server";
                                    Tr.error(tc, msg9);
                                    String str10 = ConfigConstants.getMessage(msg9);
                                    if (allMessages == null || allMessages.length() == 0) {
                                        allMessages = new String(str10);
                                        break;
                                    }
                                    allMessages = new String(allMessages + " ; " + str10);
                                    break;
                                }
                                String host = server.getHost();
                                if (host == null || host.length() == 0) {
                                    valid = false;
                                    String msg10 = "security.wssecurity.ConfigValidation.ldap.missing.host";
                                    Tr.error(tc, msg10);
                                    String str11 = ConfigConstants.getMessage(msg10);
                                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str11) : new String(allMessages + " ; " + str11);
                                }
                                if ((port = server.getPort()) != null && port.length() != 0) break;
                                valid = false;
                                String msg11 = "security.wssecurity.ConfigValidation.ldap.missing.port";
                                Tr.error(tc, msg11);
                                String str12 = ConfigConstants.getMessage(msg11);
                                if (allMessages == null || allMessages.length() == 0) {
                                    allMessages = new String(str12);
                                    break;
                                }
                                allMessages = new String(allMessages + " ; " + str12);
                                break;
                            }
                        }
                    }
                    if (!foundCsRef && this.config != null && (cs = this.config.getCertStore(csname)) != null) {
                        foundCsRef = true;
                    }
                    if (!foundCsRef && isReceiver) {
                        valid = false;
                        msg = "security.wssecurity.ConfigValidation.csref.notfound";
                        Tr.error(tc, msg, new Object[]{csname});
                        String str13 = MessageFormat.format(ConfigConstants.getMessage(msg), csname);
                        allMessages = allMessages == null || allMessages.length() == 0 ? new String(str13) : new String(allMessages + " ; " + str13);
                    }
                }
            }
        } else if (signingInfoRequired) {
            valid = false;
            String msg = "security.wssecurity.ConfigValidation.sign.info.required";
            Tr.error(tc, msg);
            String str = ConfigConstants.getMessage(msg);
            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signingInfoValid() returns " + valid);
        }
        return valid;
    }

    public boolean receiverSigningInfoValid(EList signingInfos, EList trustAnchors, CertStoreList certStoreList, RequiredIntegrity requiredIntegrity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiverSigningInfoValid(" + signingInfos + ", " + trustAnchors + ", " + certStoreList + ", " + requiredIntegrity + ")");
        }
        String allMessages = null;
        boolean siRequired = false;
        if (requiredIntegrity != null) {
            int count = requiredIntegrity.getReferences().size();
            for (int i = 0; i < count; ++i) {
                Reference ref = (Reference)requiredIntegrity.getReferences().get(i);
                ReferencePart refPart = ref.getPart();
                String name = null;
                if (refPart != null) {
                    name = refPart.getName();
                }
                if (name == null || name.length() == 0) continue;
                siRequired = true;
                break;
            }
        }
        boolean valid = true;
        if (signingInfos != null && !signingInfos.isEmpty()) {
            boolean foundAllMethods = false;
            int count = signingInfos.size();
            for (int i = 0; i < count; ++i) {
                SigningInfo si = (SigningInfo)signingInfos.get(i);
                boolean tmpValid = this.signingInfoValid(si, trustAnchors, certStoreList, true, siRequired);
                if (!tmpValid) {
                    valid = false;
                }
                if (!siRequired || si == null || si.getSignatureMethod() == null || si.getDigestMethod() == null || si.getCanonicalizationMethod() == null) continue;
                foundAllMethods = true;
            }
            if (siRequired && !foundAllMethods) {
                valid = false;
                String msg = "security.wssecurity.ConfigValidation.sign.algos.required";
                Tr.error(tc, msg);
                String str = ConfigConstants.getMessage(msg);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
        } else if (siRequired) {
            valid = false;
            String msg = "security.wssecurity.ConfigValidation.sign.info.required";
            Tr.error(tc, msg);
            String str = ConfigConstants.getMessage(msg);
            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiverSigningInfoValid() returns " + valid);
        }
        return valid;
    }

    public boolean senderSigningInfoValid(SigningInfo signingInfo, EList trustAnchors, CertStoreList certStoreList, Integrity integrity) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "senderSigningInfoValid(" + signingInfo + ", " + trustAnchors + ", " + certStoreList + ", " + integrity + ")");
        }
        String allMessages = null;
        boolean siRequired = false;
        if (integrity != null) {
            int count = integrity.getReferences().size();
            for (int i = 0; i < count; ++i) {
                Reference ref = (Reference)integrity.getReferences().get(i);
                ReferencePart refPart = ref.getPart();
                String name = null;
                if (refPart != null) {
                    name = refPart.getName();
                }
                if (name == null || name.length() == 0) continue;
                siRequired = true;
                break;
            }
        }
        boolean valid = this.signingInfoValid(signingInfo, trustAnchors, certStoreList, false, siRequired);
        if (siRequired && signingInfo != null && (signingInfo.getSignatureMethod() == null || signingInfo.getDigestMethod() == null || signingInfo.getCanonicalizationMethod() == null)) {
            valid = false;
            String msg = "security.wssecurity.ConfigValidation.sign.algos.required";
            Tr.error(tc, msg);
            String str = ConfigConstants.getMessage(msg);
            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "senderSigningInfoValid() returns " + valid);
        }
        return valid;
    }

    public boolean encryptionInfosValid(EList encryptionInfos, EList keyLocators, RequiredConfidentiality requiredConfidentiality) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptionInfosValid(" + encryptionInfos + ", " + keyLocators + ", " + requiredConfidentiality + ")");
        }
        String allMessages = null;
        boolean eiRequired = false;
        if (requiredConfidentiality != null) {
            int count = requiredConfidentiality.getConfidentialParts().size();
            for (int i = 0; i < count; ++i) {
                ConfidentialPart confPart = (ConfidentialPart)requiredConfidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confPartPart = confPart.getPart();
                String name = null;
                if (confPartPart != null) {
                    name = confPartPart.getName();
                }
                if (name == null || name.length() == 0) continue;
                eiRequired = true;
                break;
            }
        }
        boolean valid = true;
        if (encryptionInfos != null && !encryptionInfos.isEmpty()) {
            int count = encryptionInfos.size();
            for (int i = 0; i < count; ++i) {
                EncryptionInfo ei = (EncryptionInfo)encryptionInfos.get(i);
                boolean tmpValid = this.privateEncInfoValid(ei, keyLocators, eiRequired);
                if (tmpValid) continue;
                valid = false;
            }
        } else if (eiRequired) {
            valid = false;
            String msg = "security.wssecurity.ConfigValidation.enc.info.required";
            Tr.error(tc, msg);
            String str = ConfigConstants.getMessage(msg);
            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptionInfosValid() returns " + valid);
        }
        return valid;
    }

    public boolean encryptionInfoValid(EncryptionInfo encryptionInfo, EList keyLocators, Confidentiality confidentiality) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptionInfoValid(" + encryptionInfo + ", " + keyLocators + ", " + confidentiality + ")");
        }
        boolean eiRequired = false;
        if (confidentiality != null) {
            int count = confidentiality.getConfidentialParts().size();
            for (int i = 0; i < count; ++i) {
                ConfidentialPart confPart = (ConfidentialPart)confidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confPartPart = confPart.getPart();
                String name = null;
                if (confPartPart != null) {
                    name = confPartPart.getName();
                }
                if (name == null || name.length() == 0) continue;
                eiRequired = true;
                break;
            }
        }
        boolean valid = true;
        valid = this.privateEncInfoValid(encryptionInfo, keyLocators, eiRequired);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptionInfoValid() returns " + valid);
        }
        return valid;
    }

    private boolean privateEncInfoValid(EncryptionInfo encryptionInfo, EList keyLocators, boolean encryptionInfoRequired) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "privateEncInfoValid(" + encryptionInfo + ", " + keyLocators + ", " + encryptionInfoRequired + ")");
        }
        ClassLoader appClassLoader = null;
        String allMessages = null;
        boolean valid = true;
        if (encryptionInfo != null) {
            String str;
            String msg;
            String algo;
            String str2;
            String msg2;
            String keyLocatorRef = null;
            EncryptionKey encKey = encryptionInfo.getEncryptionKey();
            DataEncryptionMethod encMethod = encryptionInfo.getEncryptionMethod();
            KeyEncryptionMethod keyEncMethod = encryptionInfo.getKeyEncryptionMethod();
            if (encKey == null) {
                valid = false;
                msg2 = "security.wssecurity.ConfigValidation.ei.missing.key";
                Tr.error(tc, msg2);
                str2 = ConfigConstants.getMessage(msg2);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str2) : new String(allMessages + " ; " + str2);
            } else {
                keyLocatorRef = encKey.getLocatorRef();
                if (keyLocatorRef == null || keyLocatorRef.length() == 0) {
                    valid = false;
                    msg2 = "security.wssecurity.ConfigValidation.ei.missing.key.loc.ref";
                    Tr.error(tc, msg2);
                    str2 = ConfigConstants.getMessage(msg2);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str2) : new String(allMessages + " ; " + str2);
                }
            }
            if (encMethod == null) {
                valid = false;
                msg2 = "security.wssecurity.ConfigValidation.ei.missing.enc.method";
                Tr.error(tc, msg2);
                str2 = ConfigConstants.getMessage(msg2);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str2) : new String(allMessages + " ; " + str2);
            } else {
                algo = encMethod.getAlgorithm();
                if (!this.encryptionMethodValid(algo)) {
                    valid = false;
                    msg = "security.wssecurity.ConfigValidation.enc.method.invalid";
                    Tr.error(tc, msg, new Object[]{algo});
                    str = MessageFormat.format(ConfigConstants.getMessage(msg), algo);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
                }
            }
            if (keyEncMethod != null && !this.keyEncryptionMethodValid(algo = keyEncMethod.getAlgorithm())) {
                valid = false;
                msg = "security.wssecurity.ConfigValidation.keyenc.method.invalid";
                Tr.error(tc, msg, new Object[]{algo});
                str = MessageFormat.format(ConfigConstants.getMessage(msg), algo);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
            if (keyLocatorRef != null && keyLocatorRef.length() > 0) {
                com.ibm.wsspi.wssecurity.config.KeyLocator locator;
                boolean foundKeyLocRef = false;
                if (keyLocators != null && !keyLocators.isEmpty()) {
                    int klcount = keyLocators.size();
                    for (int j = 0; j < klcount; ++j) {
                        EList keys;
                        KeyLocator kl = (KeyLocator)keyLocators.get(j);
                        if (!keyLocatorRef.equals(kl.getName())) continue;
                        foundKeyLocRef = true;
                        if (kl.getClassname() == null || kl.getClassname().length() == 0) {
                            valid = false;
                            String msg3 = "security.wssecurity.ConfigValidation.keyloc.missing.classname";
                            Tr.error(tc, msg3);
                            String str3 = ConfigConstants.getMessage(msg3);
                            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str3) : new String(allMessages + " ; " + str3);
                        }
                        com.ibm.etools.webservice.wscommonbnd.KeyStore keyStoreData = kl.getKeyStore();
                        KeyStore keyStore = null;
                        if (keyStoreData != null) {
                            String keyStoreName = keyStoreData.getKeyStoreRef();
                            if (keyStoreName != null) {
                                keyStore = ConfigUtil.getKeyStore((String)keyStoreName);
                            } else {
                                String file = null;
                                file = this.varMap == null ? keyStoreData.getPath() : this.varMap.expand(keyStoreData.getPath());
                                try {
                                    keyStore = ConfigUtil.getKeyStore((String)keyStoreData.getType(), (String)file, (char[])keyStoreData.getStorepass().toCharArray());
                                }
                                catch (SoapSecurityException sse) {
                                    // empty catch block
                                }
                            }
                            if (keyStore == null) {
                                valid = false;
                                String msg4 = "security.wssecurity.ConfigValidation.keystore.open";
                                Tr.error(tc, msg4, new Object[]{keyStoreData.getPath()});
                                String str4 = MessageFormat.format(ConfigConstants.getMessage(msg4), keyStoreData.getPath());
                                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str4) : new String(allMessages + " ; " + str4);
                            }
                        }
                        if ((keys = kl.getKeys()) == null || keys.isEmpty()) break;
                        int keycount = keys.size();
                        for (int k = 0; k < keycount; ++k) {
                            String str5;
                            String msg5;
                            Key key = (Key)keys.get(k);
                            String alias = key.getAlias();
                            String keypass = key.getKeypass();
                            String name = key.getName();
                            if (alias == null || alias.length() == 0) {
                                valid = false;
                                msg5 = "security.wssecurity.ConfigValidation.key.missing.alias";
                                Tr.error(tc, msg5);
                                str5 = ConfigConstants.getMessage(msg5);
                                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str5) : new String(allMessages + " ; " + str5);
                            }
                            if (keypass == null || keypass.length() == 0) {
                                valid = false;
                                msg5 = "security.wssecurity.ConfigValidation.key.missing.keypass";
                                Tr.error(tc, msg5);
                                str5 = ConfigConstants.getMessage(msg5);
                                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str5) : new String(allMessages + " ; " + str5);
                            }
                            if (name != null && name.length() != 0) continue;
                            valid = false;
                            msg5 = "security.wssecurity.ConfigValidation.key.missing.name";
                            Tr.error(tc, msg5);
                            str5 = ConfigConstants.getMessage(msg5);
                            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str5) : new String(allMessages + " ; " + str5);
                        }
                        break;
                    }
                }
                if (!foundKeyLocRef && this.config != null && (locator = this.config.getKeyLocator(keyLocatorRef).getKeyLocator5(appClassLoader)) != null) {
                    foundKeyLocRef = true;
                }
                if (!foundKeyLocRef) {
                    valid = false;
                    String msg6 = "security.wssecurity.ConfigValidation.keylocref.notfound";
                    Tr.error(tc, msg6, new Object[]{keyLocatorRef});
                    String str6 = MessageFormat.format(ConfigConstants.getMessage(msg6), keyLocatorRef);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str6) : new String(allMessages + " ; " + str6);
                }
            }
        } else if (encryptionInfoRequired) {
            valid = false;
            String msg = "security.wssecurity.ConfigValidation.enc.info.required";
            Tr.error(tc, msg);
            String str = ConfigConstants.getMessage(msg);
            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "privateEncInfoValid() returns " + valid);
        }
        return valid;
    }

    public boolean loginMappingValid(EList loginMappings, LoginConfig loginConfig) throws SoapSecurityException {
        String str;
        String msg;
        String authMethod;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loginMappingValid(" + loginMappings + ", " + loginConfig + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (loginConfig != null) {
            EList authMethods = loginConfig.getAuthMethods();
            if (authMethods != null && !authMethods.isEmpty()) {
                int count = authMethods.size();
                for (int i = 0; i < count; ++i) {
                    com.ibm.xml.soapsec.token.LoginMapping lm;
                    AuthMethod meth = (AuthMethod)authMethods.get(i);
                    authMethod = null;
                    if (meth != null) {
                        authMethod = meth.getText();
                    }
                    if (authMethod == null || authMethod.length() == 0) {
                        valid = false;
                        msg = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                        Tr.error(tc, msg);
                        str = ConfigConstants.getMessage(msg);
                        if (allMessages == null || allMessages.length() == 0) {
                            allMessages = new String(str);
                            continue;
                        }
                        allMessages = new String(allMessages + " ; " + str);
                        continue;
                    }
                    boolean foundAuthMethod = false;
                    if (loginMappings != null && !loginMappings.isEmpty()) {
                        int mcount = loginMappings.size();
                        for (int j = 0; j < mcount; ++j) {
                            LoginMapping lm2 = (LoginMapping)loginMappings.get(j);
                            if (!authMethod.equals(lm2.getAuthMethod())) continue;
                            foundAuthMethod = true;
                            break;
                        }
                    }
                    if (!foundAuthMethod && this.config != null && (lm = this.config.getLoginMapping(authMethod)) != null) {
                        foundAuthMethod = true;
                    }
                    if (foundAuthMethod) continue;
                    valid = false;
                    String msg2 = "security.wssecurity.ConfigValidation.lc.authmethod.invalid";
                    Tr.error(tc, msg2, new Object[]{authMethod});
                    String str2 = MessageFormat.format(ConfigConstants.getMessage(msg2), authMethod);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str2) : new String(allMessages + " ; " + str2);
                }
            } else {
                valid = false;
                String msg3 = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                Tr.error(tc, msg3);
                String str3 = ConfigConstants.getMessage(msg3);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str3) : new String(allMessages + " ; " + str3);
            }
        }
        if (loginMappings != null && !loginMappings.isEmpty()) {
            int count = loginMappings.size();
            for (int i = 0; i < count; ++i) {
                CallbackHandlerFactory chf;
                String configName;
                String str4;
                String msg4;
                String str5;
                String msg5;
                boolean tokenValueTypeRequired = false;
                LoginMapping lm = (LoginMapping)loginMappings.get(i);
                authMethod = lm.getAuthMethod();
                if (authMethod == null || authMethod.length() == 0) {
                    valid = false;
                    msg = "security.wssecurity.ConfigValidation.lm.missing.authmethod";
                    Tr.error(tc, msg);
                    str = ConfigConstants.getMessage(msg);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
                } else if (this.authMethodValid(authMethod)) {
                    if (!this.authMethodKnown(authMethod)) {
                        tokenValueTypeRequired = true;
                    }
                } else {
                    valid = false;
                    msg = "security.wssecurity.ConfigValidation.lm.authmethod.invalid";
                    Tr.error(tc, msg, new Object[]{authMethod});
                    str = MessageFormat.format(ConfigConstants.getMessage(msg), authMethod);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
                }
                if (tokenValueTypeRequired) {
                    TokenValueType tvt = lm.getTokenValueType();
                    if (tvt == null) {
                        valid = false;
                        msg5 = "security.wssecurity.ConfigValidation.lm.missing.tokvaltype";
                        Tr.error(tc, msg5);
                        str5 = ConfigConstants.getMessage(msg5);
                        allMessages = allMessages == null || allMessages.length() == 0 ? new String(str5) : new String(allMessages + " ; " + str5);
                    } else {
                        String uri = tvt.getUri();
                        String localName = tvt.getLocalName();
                        if (uri == null || uri.length() == 0) {
                            valid = false;
                            msg4 = "security.wssecurity.ConfigValidation.tvt.missing.uri";
                            Tr.error(tc, msg4);
                            str4 = ConfigConstants.getMessage(msg4);
                            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str4) : new String(allMessages + " ; " + str4);
                        }
                        if (localName == null || localName.length() == 0) {
                            valid = false;
                            msg4 = "security.wssecurity.ConfigValidation.tvt.missing.localname";
                            Tr.error(tc, msg4);
                            str4 = ConfigConstants.getMessage(msg4);
                            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str4) : new String(allMessages + " ; " + str4);
                        }
                    }
                }
                if ((configName = lm.getConfigName()) == null || configName.length() == 0) {
                    valid = false;
                    msg5 = "security.wssecurity.ConfigValidation.lm.missing.configname";
                    Tr.error(tc, msg5);
                    str5 = ConfigConstants.getMessage(msg5);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str5) : new String(allMessages + " ; " + str5);
                }
                if ((chf = lm.getCallbackHandlerFactory()) == null) {
                    valid = false;
                    String msg6 = "security.wssecurity.ConfigValidation.lm.missing.ch.factory";
                    Tr.error(tc, msg6);
                    String str6 = ConfigConstants.getMessage(msg6);
                    if (allMessages == null || allMessages.length() == 0) {
                        allMessages = new String(str6);
                        continue;
                    }
                    allMessages = new String(allMessages + " ; " + str6);
                    continue;
                }
                String className = chf.getClassname();
                if (className != null && className.length() != 0) continue;
                valid = false;
                msg4 = "security.wssecurity.ConfigValidation.lm.missing.ch.classname";
                Tr.error(tc, msg4);
                str4 = ConfigConstants.getMessage(msg4);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str4) : new String(allMessages + " ; " + str4);
            }
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loginMappingValid() returns " + valid);
        }
        return valid;
    }

    public boolean trustedIDEvaluatorRefValid(TrustedIDEvaluatorRef trustedIDEvaluatorRef) throws SoapSecurityException {
        String ref;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trustedIDEvaluatorRefValid(" + trustedIDEvaluatorRef + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (trustedIDEvaluatorRef != null && ((ref = trustedIDEvaluatorRef.getRef()) == null || ref.length() == 0)) {
            valid = false;
            String msg = "security.wssecurity.ConfigValidation.tier.missing.ref";
            Tr.error(tc, msg);
            String str = ConfigConstants.getMessage(msg);
            allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trustedIDEvaluatorRefValid() returns " + valid);
        }
        return valid;
    }

    public boolean trustedIDEvaluatorValid(TrustedIDEvaluator trustedIDEvaluator) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trustedIDEvaluatorValid(" + trustedIDEvaluator + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (trustedIDEvaluator != null) {
            String str;
            String msg;
            String classname = trustedIDEvaluator.getClassname();
            String name = trustedIDEvaluator.getName();
            if (classname == null || classname.length() == 0) {
                valid = false;
                msg = "security.wssecurity.ConfigValidation.tie.missing.classname";
                Tr.error(tc, msg);
                str = ConfigConstants.getMessage(msg);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
            if (name == null || name.length() == 0) {
                valid = false;
                msg = "security.wssecurity.ConfigValidation.tie.missing.name";
                Tr.error(tc, msg);
                str = ConfigConstants.getMessage(msg);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trustedIDEvaluatorValid() returns " + valid);
        }
        return valid;
    }

    public boolean loginBindingValid(LoginBinding loginBinding, com.ibm.etools.webservice.wscext.LoginConfig loginConfig) throws SoapSecurityException {
        String str;
        String msg;
        String authMethod;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loginBindingValid(" + loginBinding + ", " + loginConfig + ")");
        }
        String allMessages = null;
        boolean valid = true;
        if (loginConfig != null) {
            authMethod = loginConfig.getAuthMethod();
            if (authMethod == null || authMethod.length() == 0) {
                valid = false;
                String msg2 = "security.wssecurity.ConfigValidation.lc.missing.authmethod";
                Tr.error(tc, msg2);
                String str2 = ConfigConstants.getMessage(msg2);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str2) : new String(allMessages + " ; " + str2);
            } else {
                boolean foundAuthMethod = false;
                if (loginBinding != null && authMethod.equals(loginBinding.getAuthMethod())) {
                    foundAuthMethod = true;
                }
                if (!foundAuthMethod) {
                    valid = false;
                    msg = "security.wssecurity.ConfigValidation.lc.authmethod.invalid";
                    Tr.error(tc, msg, new Object[]{authMethod});
                    str = MessageFormat.format(ConfigConstants.getMessage(msg), authMethod);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
                }
            }
        }
        if (loginBinding != null) {
            String cbh;
            String str3;
            String msg3;
            authMethod = loginBinding.getAuthMethod();
            boolean tokenValueTypeRequired = false;
            if (authMethod == null || authMethod.length() == 0) {
                valid = false;
                msg = "security.wssecurity.ConfigValidation.lb.missing.authmethod";
                Tr.error(tc, msg);
                str = ConfigConstants.getMessage(msg);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            } else if (this.authMethodValid(authMethod)) {
                if (!this.authMethodKnown(authMethod)) {
                    tokenValueTypeRequired = true;
                }
            } else {
                valid = false;
                msg = "security.wssecurity.ConfigValidation.lb.authmethod.invalid";
                Tr.error(tc, msg, new Object[]{authMethod});
                str = MessageFormat.format(ConfigConstants.getMessage(msg), authMethod);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str) : new String(allMessages + " ; " + str);
            }
            if (tokenValueTypeRequired) {
                TokenValueType tvt = loginBinding.getTokenValueType();
                if (tvt == null) {
                    valid = false;
                    msg3 = "security.wssecurity.ConfigValidation.lb.missing.tokvaltype";
                    Tr.error(tc, msg3, new Object[]{authMethod});
                    str3 = MessageFormat.format(ConfigConstants.getMessage(msg3), authMethod);
                    allMessages = allMessages == null || allMessages.length() == 0 ? new String(str3) : new String(allMessages + " ; " + str3);
                } else {
                    String str4;
                    String msg4;
                    String uri = tvt.getUri();
                    String localName = tvt.getLocalName();
                    if (uri == null || uri.length() == 0) {
                        valid = false;
                        msg4 = "security.wssecurity.ConfigValidation.tvt.missing.uri";
                        Tr.error(tc, msg4);
                        str4 = ConfigConstants.getMessage(msg4);
                        allMessages = allMessages == null || allMessages.length() == 0 ? new String(str4) : new String(allMessages + " ; " + str4);
                    }
                    if (localName == null || localName.length() == 0) {
                        valid = false;
                        msg4 = "security.wssecurity.ConfigValidation.tvt.missing.localname";
                        Tr.error(tc, msg4);
                        str4 = ConfigConstants.getMessage(msg4);
                        allMessages = allMessages == null || allMessages.length() == 0 ? new String(str4) : new String(allMessages + " ; " + str4);
                    }
                }
            }
            if ((cbh = loginBinding.getCallbackHandler()) == null || cbh.length() == 0) {
                valid = false;
                msg3 = "security.wssecurity.ConfigValidation.lb.missing.callbackhandler";
                Tr.error(tc, msg3);
                str3 = ConfigConstants.getMessage(msg3);
                allMessages = allMessages == null || allMessages.length() == 0 ? new String(str3) : new String(allMessages + " ; " + str3);
            }
        }
        if (!valid) {
            throw new SoapSecurityException(allMessages);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loginBindingValid() returns " + valid);
        }
        return valid;
    }

    private boolean authMethodValid(String authMethod) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authMethodValid(" + authMethod + ")");
        }
        boolean valid = false;
        valid = authMethod != null && authMethod.length() != 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authMethodValid() returns " + valid);
        }
        return valid;
    }

    private boolean authMethodKnown(String authMethod) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authMethodKnown(" + authMethod + ")");
        }
        boolean known = false;
        known = authMethod == null || authMethod.length() == 0 ? false : "BasicAuth".equals(authMethod) || "IDAssertion".equals(authMethod) || "Signature".equals(authMethod);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authMethodKnown() returns " + known);
        }
        return known;
    }

    private void addToSet(Document algoDoc, String algo, Set set) {
        NodeList list;
        int length;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSet(" + algoDoc + ", " + algo + ", " + set + ")");
        }
        if ((length = (list = algoDoc.getElementsByTagNameNS("http://www.ibm.com/xml/soapsec/config", algo)).getLength()) == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No allowed " + algo + " elements found.");
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Element elem = (Element)list.item(i);
                try {
                    set.add(DOMUtil.getAttribute((Element)elem, (String)"algorithm"));
                    continue;
                }
                catch (SoapSecurityException sse) {
                    FFDCFilter.processException((Throwable)sse, clsName + ".addToSet", "1867", this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "\"algorithm\" attribute not found in \"" + algo + "\" element.");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allowed " + algo + " set: ", new Object[]{set});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSet()");
        }
    }

    protected void processAllowedAlgorithms(Document algoDoc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAllowedAlgorithms(" + algoDoc + ")");
        }
        if (algoDoc == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Allowed Algorithms Document is null, exiting.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processAllowedAlgorithms()");
            }
            return;
        }
        if (ConfigValidation.isFipsEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is true; getting FIPS algorithms");
            }
            this.addToSet(algoDoc, "fipsEncryptionMethod", this.allowedEncAlgos);
            this.addToSet(algoDoc, "fipsKeyEncryptionMethod", this.allowedKeyEncAlgos);
            this.addToSet(algoDoc, "fipsSignatureMethod", this.allowedSignAlgos);
            this.addToSet(algoDoc, "fipsDigestMethod", this.allowedDigestAlgos);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isFipsEnabled() is false; getting non-FIPS algorithms");
            }
            this.addToSet(algoDoc, "encryptionMethod", this.allowedEncAlgos);
            this.addToSet(algoDoc, "keyEncryptionMethod", this.allowedKeyEncAlgos);
            this.addToSet(algoDoc, "signatureMethod", this.allowedSignAlgos);
            this.addToSet(algoDoc, "digestMethod", this.allowedDigestAlgos);
        }
        this.addToSet(algoDoc, "canonicalizationMethod", this.allowedC14nAlgos);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAllowedAlgorithms()");
        }
    }

    protected boolean encryptionMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptionMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedEncAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encryptionMethodValid() returns " + valid);
        }
        return valid;
    }

    protected boolean keyEncryptionMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keyEncryptionMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedKeyEncAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keyEncryptionMethodValid() returns " + valid);
        }
        return valid;
    }

    protected boolean canonicalizationMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canonicalizationMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedC14nAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canonicalizationMethodValid() returns " + valid);
        }
        return valid;
    }

    protected boolean signatureMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signatureMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedSignAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signatureMethodValid() returns " + valid);
        }
        return valid;
    }

    protected boolean digestMethodValid(String algo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "digestMethodValid(" + algo + ")");
        }
        boolean valid = this.allowedDigestAlgos.contains(algo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "digestMethodValid() returns " + valid);
        }
        return valid;
    }

    public static boolean isFipsEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFipsEnabled");
        }
        if (isFipsEnabled == null) {
            isFipsEnabled = Security.getProperty("com.ibm.websphere.security.fips.enabled");
            if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase("true")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Read java.security.Security property; FIPS mode is enabled");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Read java.security.Security property; FIPS mode is not enabled");
            }
        }
        if (isFipsEnabled != null && isFipsEnabled.equalsIgnoreCase("true")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFipsEnabled -> true");
            }
            return true;
        }
        isFipsEnabled = "false";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFipsEnabled -> false");
        }
        return false;
    }

    public static boolean isAlgoSupportedByRuntime(String algo) {
        boolean supported = true;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlgoSupportedByRuntime(String algo[" + algo + "])");
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(algo)) {
            supported = ConfigValidation.isRsaoaepSupported(algo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlgoSupportedByRuntime returns " + supported);
        }
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isRsaoaepSupported(String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRsaoaepSupported");
        }
        if (rsaoaepInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRsaoaepSupported returns " + rsaoaepSupported);
            }
            return rsaoaepSupported;
        }
        byte[] byArray = lock;
        synchronized (lock) {
            block16: {
                String algo = "OAEP";
                StringTokenizer tokenizer = null;
                if ("true".equalsIgnoreCase(Security.getProperty("com.ibm.websphere.security.fips.enabled"))) {
                    tokenizer = new StringTokenizer(Security.getProperty("com.ibm.websphere.security.fips.jceProviders"), "|");
                }
                if (tokenizer == null || !tokenizer.hasMoreTokens()) {
                    try {
                        AlgorithmParameters param = AlgorithmParameters.getInstance(algo);
                        AlgorithmParameterSpec spec = (AlgorithmParameterSpec)Class.forName("javax.crypto.spec.OAEPParameterSpec").getField("DEFAULT").get(null);
                        rsaoaepSupported = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Successfully got instance of " + algo + " cipher algorithm with default provider");
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block16;
                        Tr.debug(tc, "Received exception " + e.getMessage() + " while getting instance of " + algo + " cipher algorithm with default provider");
                    }
                } else {
                    while (tokenizer.hasMoreTokens()) {
                        String provider = tokenizer.nextToken();
                        try {
                            AlgorithmParameters param = AlgorithmParameters.getInstance(algo, provider);
                            AlgorithmParameterSpec spec = (AlgorithmParameterSpec)Class.forName("javax.crypto.spec.OAEPParameterSpec").getField("DEFAULT").get(null);
                            rsaoaepSupported = true;
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "Successfully got instance of " + algo + " cipher algorithm with provider " + provider);
                            break;
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Received exception " + e.getMessage() + " while getting instance of " + algo + " cipher algorithm with provider " + provider);
                        }
                    }
                }
            }
            if (!rsaoaepSupported) {
                Tr.warning(tc, "security.wssecurity.WSEC0157W", uri);
            }
            rsaoaepInitialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRsaoaepSupported returns " + rsaoaepSupported);
            }
            return rsaoaepSupported;
        }
    }
}

