/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscommonbnd.AlgorithmMapping;
import com.ibm.etools.webservice.wscommonbnd.AlgorithmURI;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandlerFactory;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.TokenValueType;
import com.ibm.etools.webservice.wscommonbnd.impl.ParameterImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmMappingConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public final class ConfigConstants {
    public static final String TR_GROUP = "Web Services Security";
    public static final String TR_NLSPROPS = "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity";
    public static final String WS_SECURITY_RESOURCE_NAME = "ws-security.xml";
    public static final String WS_SECURITY_DEFAULT_LOCATION = "${USER_INSTALL_ROOT}/properties/ws-security.xml";
    public static final String WS_SECURITY_LOCATION_PROPERTY = "wssecurity.defaultbindings.location";
    public static final String WS_INITIAL_SENDER_ID = "wssecurity.initial.sender.id";
    public static final String BASICAUTH_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce";
    public static final String BASICAUTH_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp";
    public static final String BASICAUTH_NONCE_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired";
    public static final String BASICAUTH_NONCE_TIMESTAMP_REQUIRED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired";
    public static final String BASICAUTH_NONCE_MAX_AGE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge";
    public static final String BASICAUTH_NONCE_CLOCK_SKEW = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew";
    public static final String BASICAUTH_NONCE_CACHE_USED = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.useCache";
    public static final String BASICAUTH_NONCE_CACHE_NAME = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName";
    public static final String BASICAUTH_NONCE_CACHE_SIZE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize";
    public static final String BASICAUTH_NONCE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout";
    public static final String BASICAUTH_NONCE_LENGTH = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.length";
    public static final String DECOUPLE_TOKEN = "com.ibm.websphere.wssecurity.util.decouple.token";
    public static final String HARDWARE_KEYSTORE_NAME = "com.ibm.ws.wssecurity.config.hwKeyStoreName";
    public static final String CERTIFICATE_CACHE_USED = "com.ibm.ws.wssecurity.config.token.certificate.useCache";
    public static final String CERTIFICATE_CACHE_NAME = "com.ibm.ws.wssecurity.config.token.certificate.cacheName";
    public static final String CERTIFICATE_CACHE_SIZE = "com.ibm.ws.wssecurity.config.token.certificate.cacheSize";
    public static final String CERTIFICATE_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout";
    public static final String DISTRIBUTED_CONFIG_CACHE_USED = "com.ibm.ws.wssecurity.handler.useConfigCache";
    public static final String CONFIG_CACHENAME = "com.ibm.ws.wssecurity.handler.configCacheName";
    public static final String DISTRIBUTED_CONFIG_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.configCacheSize";
    public static final String DISTRIBUTED_CONFIG_CACHE_TIMETOLIVE = "com.ibm.ws.wssecurity.handler.configCacheTimeToLive";
    public static final String TOKEN_CACHE_USED = "com.ibm.ws.wssecurity.handler.token.useCache";
    public static final String TOKEN_CACHE_NAME = "com.ibm.ws.wssecurity.handler.token.cacheName";
    public static final String TOKEN_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.token.cacheSize";
    public static final String TOKEN_CACHE_TIMEOUT = "com.ibm.ws.wssecurity.handler.token.cacheTimeout";
    public static final String TOKEN_CACHE_CUSHION = "com.ibm.ws.wssecurity.handler.token.cushion";
    public static final boolean DEFAULT_DISTRIBUTED_CONFIG_CACHE_USED = true;
    public static final String DEFAULT_CONFIG_CACHENAME = "WSSReqGeneratorConfigMap";
    public static final int DEFAULT_DISTRIBUTED_CONFIG_CACHE_SIZE = 128;
    public static final int DEFAULT_DISTRIBUTED_CONFIG_CACHE_TIMETOLIVE = 900;
    public static final String WSSREQGEN_CONFIG_KEY = "com.ibm.ws.wssecurity.handler.GenConfigCacheKey";
    public static final String WSSRESCON_CONFIG_KEY = "com.ibm.ws.wssecurity.handler.ConConfigCacheKey";
    public static final String OFFLOAD_ALL_CRYPTO = "com.ibm.ws.wssecurity.handler.OffloadAllCryptography";
    public static final String OFFLOAD_RSA_PUBKEY_CRYPTO = "com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography";
    public static final String HARDWARE_CACHE_SIZE = "com.ibm.ws.wssecurity.handler.hardwareCacheSize";
    public static final int DEFAULT_HARDWARE_CACHE_SIZE = 1000;
    public static final String HARDWARE_CACHE_ENTRY_REFRESH = "com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours";
    public static final int DEFAULT_HARDWARE_CACHE_ENTRY_REFRESH = 8;
    public static final boolean DEFAULT_NONCE_CACHEUSED = true;
    public static final String DEFAULT_NONCE_CACHENAME = "NonceDistributionCacheMap";
    public static final int DEFAULT_NONCE_CACHESIZE = 1024;
    public static final int MIN_NONCE_CACHESIZE = 16;
    public static final int DEFAULT_NONCE_CACHETIMEOUT = 600;
    public static final int MIN_NONCE_CACHETIMEOUT = 300;
    public static final int DEFAULT_NONCE_LENGTH = 128;
    public static final int MIN_NONCE_LENGTH = 16;
    public static final int DEFAULT_NONCE_MAXAGE = 300;
    public static final int MIN_NONCE_MAXAGE = 300;
    public static final int DEFAULT_NONCE_CLOCKSKEW = 0;
    public static final int MIN_NONCE_CLOCKSKEW = 0;
    public static final boolean DEFAULT_NONCE_DISTRIBUTED = false;
    public static final boolean DEFAULT_CERT_CACHEUSED = true;
    public static final String DEFAULT_CERT_CACHENAME = "WSSCertCache";
    public static final int DEFAULT_CERT_CACHESIZE = 128;
    public static final int MIN_CERT_CACHESIZE = 16;
    public static final int DEFAULT_CERT_CACHETIMEOUT = 900;
    public static final int MIN_CERT_CACHETIMEOUT = 300;
    public static final boolean DEFAULT_TOKEN_CACHEUSED = true;
    public static final String DEFAULT_TOKEN_CACHENAME = "WSSTokenCache";
    public static final int DEFAULT_TOKEN_CACHESIZE = 128;
    public static final int MIN_TOKEN_CACHESIZE = 16;
    public static final int DEFAULT_TOKEN_CACHETIMEOUT = 900;
    public static final int MIN_TOKEN_CACHETIMEOUT = 300;
    public static final int DEFAULT_TOKEN_CUSHION = 600;
    public static final int MIN_TOKEN_CUSHION = 300;
    public static final int DEFAULT_TIMESTAMP_TIMEOUT = 600;
    public static final int MIN_TIMESTAMP_TIMEOUT = 300;
    public static final int DEFAULT_TIMESTAMP_MAXAGE = 300;
    public static final int MIN_TIMESTAMP_MAXAGE = 300;
    public static final int DEFAULT_TIMESTAMP_CLOCKSKEW = 0;
    public static final int MIN_TIMESTAMP_CLOCKSKEW = 0;
    public static final int DEFAULT_NOT_UTILIZED_SOAP_FACTORY = 50;
    public static final String WSSE_NS = "com.ibm.ws.wssecurity.config.WSSE.Namespace";
    public static final String DEFAULT_CONFIG_REF = "DEFAULT";
    public static final String LOCALTEST_MODE = "com.ibm.ws.wssecurity.config.localtest.on";
    private static final TraceComponent tc = Tr.register(ConfigConstants.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public static String getMessage(String key) {
        return ConfigUtil.getMessage((String)key);
    }

    public static com.ibm.xml.soapsec.token.LoginMapping readLoginMapping(LoginMapping loginMapping, VariableMap varMap, ClassLoader appClassLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readLoginMapping", loginMapping);
        }
        if (loginMapping == null) {
            Tr.error(tc, "security.wssecurity.loginmapping.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.loginmapping.is.null"));
        }
        CallbackHandlerFactory cbhFacData = loginMapping.getCallbackHandlerFactory();
        String cbhFacName = cbhFacData.getClassname();
        Map map = ConfigConstants.getProperties(cbhFacData.getProperties(), varMap);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating CallbackHandlerFactory: ", new Object[]{cbhFacName, map});
        }
        com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory cbhFac = (com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory)ConfigUtil.instantiate((String)cbhFacName, com.ibm.wsspi.wssecurity.auth.callback.CallbackHandlerFactory.class, (Map)map, (ClassLoader)appClassLoader);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "CallbackHandlerFactory " + cbhFacName + " created");
        }
        TokenValueType tokenValueType = loginMapping.getTokenValueType();
        QName type = null;
        if (tokenValueType != null) {
            type = new QName(tokenValueType.getUri(), tokenValueType.getLocalName());
        }
        com.ibm.xml.soapsec.token.LoginMapping ret = new com.ibm.xml.soapsec.token.LoginMapping(loginMapping.getAuthMethod(), type, loginMapping.getConfigName(), cbhFac, ConfigConstants.getProperties(loginMapping.getProperties(), varMap));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readLoginMapping", ret);
        }
        return ret;
    }

    public static TrustedIDEvaluator readTrustedIDEvaluator(com.ibm.etools.webservice.wscommonbnd.TrustedIDEvaluator tide, VariableMap varMap, ClassLoader appClassLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readTrustedIDEvaluator", tide);
        }
        if (tide == null) {
            Tr.error(tc, "security.wssecurity.trustedidevaluator.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.trustedidevaluator.is.null"));
        }
        Map map = ConfigConstants.getProperties(tide.getProperties(), varMap);
        String className = tide.getClassname();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating TrustedIDEvaluator: ", new Object[]{className, map});
        }
        TrustedIDEvaluator tie = (TrustedIDEvaluator)ConfigUtil.instantiate((String)className, TrustedIDEvaluator.class, (Map)map, (ClassLoader)appClassLoader);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "TrustedIDEvaluator " + className + " created");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readTrustedIDEvaluator", tie);
        }
        return tie;
    }

    public static com.ibm.wsspi.wssecurity.config.KeyLocator findKeyLocator(EList locators, String locatorRef, VariableMap varMap, WSSecurityDefaultConfiguration config, ClassLoader appClassLoader) throws SoapSecurityException {
        KeyLocatorProxy klproxy;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findKeyLocator(" + locators + "," + locatorRef + ")");
        }
        com.ibm.wsspi.wssecurity.config.KeyLocator ret = null;
        for (int i = 0; i < locators.size(); ++i) {
            KeyLocator locator = (KeyLocator)locators.get(i);
            if (!locatorRef.equals(locator.getName())) continue;
            klproxy = ConfigConstants.readKeyLocator(locator, varMap);
            if (klproxy == null) break;
            ret = klproxy.getKeyLocator5(appClassLoader);
            break;
        }
        if (ret == null && config != null && (klproxy = config.getKeyLocator(locatorRef)) != null) {
            ret = klproxy.getKeyLocator5(appClassLoader);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findKeyLocator(EList locators, String locatorRef) returns " + ret);
        }
        return ret;
    }

    public static KeyLocatorProxy readKeyLocator(KeyLocator keyLocator, VariableMap varMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readKeyLocator", keyLocator);
        }
        if (keyLocator == null) {
            Tr.error(tc, "security.wssecurity.keylocator.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.keylocator.is.null"));
        }
        PrivateCommonConfig.KeyLocatorConfImpl klconfig = new PrivateCommonConfig.KeyLocatorConfImpl();
        klconfig._className = keyLocator.getClassname();
        KeyStore keystore = keyLocator.getKeyStore();
        if (keystore != null) {
            PrivateCommonConfig.KeyStoreConfImpl ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
            ksconfig._type = keystore.getType();
            String value = keystore.getPath();
            if (varMap != null) {
                value = varMap.expand(value);
            }
            ksconfig._path = value;
            ksconfig._password = keystore.getStorepass();
            ksconfig._ksRef = keystore.getKeyStoreRef();
            klconfig._keyStore = ksconfig;
        }
        EList keys = keyLocator.getKeys();
        int iMax = keys.size();
        for (int i = 0; i < iMax; ++i) {
            Key key = (Key)keys.get(i);
            PrivateCommonConfig.KeyInformationConfImpl kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
            kiconfig._alias = key.getAlias();
            kiconfig._keypass = key.getKeypass();
            kiconfig._name = key.getName();
            klconfig._keyInformationList.add(kiconfig);
        }
        ConfigConstants.getProperties(klconfig._properties, keyLocator.getProperties(), varMap);
        KeyLocatorProxy klproxy = new KeyLocatorProxy(klconfig);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KeyLocator loaded [" + klconfig + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readKeyLocator", klproxy);
        }
        return klproxy;
    }

    public static CertStore readLDAPCertStore(LDAPCertStore ldapCertStore, VariableMap varMap) throws SoapSecurityException {
        int port;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readLDAPCertStore", ldapCertStore);
        }
        if (ldapCertStore == null) {
            Tr.error(tc, "security.wssecurity.ldapCertStore.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.ldapCertStore.is.null"));
        }
        LDAPServer ldapServer = ldapCertStore.getLdapServer();
        if (ldapServer == null) {
            Tr.error(tc, "security.wssecurity.ldapserver.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.ldapserver.is.null"));
        }
        String host = ldapServer.getHost();
        try {
            port = Integer.parseInt(ldapServer.getPort());
        }
        catch (NumberFormatException e) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s19", ldapServer.getPort(), (Throwable)e);
        }
        String algorithm = "LDAP";
        String provider = ldapCertStore.getProvider();
        CertStore certStore = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "algorithm=" + algorithm + ", provider=" + provider + ", LDAPServer host=" + host + ", LDAPServer port=" + port);
        }
        LDAPCertStoreParameters params = new LDAPCertStoreParameters(host, port);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LDAPCertStoreParameters: ", new Object[]{params});
        }
        try {
            certStore = "".equals(provider) ? CertStore.getInstance(algorithm, params) : CertStore.getInstance(algorithm, (CertStoreParameters)params, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s20", algorithm);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s21", params.toString());
        }
        catch (NoSuchProviderException e) {
            throw SoapSecurityException.format("security.wssecurity.CommonReceiverConfig.s22", provider);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readLDAPCertStore", certStore);
        }
        return certStore;
    }

    public static AlgorithmMappingConfig readAlgorithmMapping(AlgorithmMapping algorithmMapping, VariableMap varMap) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readAlgorithmMapping", algorithmMapping);
        }
        if (algorithmMapping == null) {
            Tr.error(tc, "security.wssecurity.algorithmMapping.is.null");
            throw new SoapSecurityException(ConfigConstants.getMessage("security.wssecurity.algorithmMapping.is.null"));
        }
        PrivateCommonConfig.AlgorithmMappingConfImpl aconfig = new PrivateCommonConfig.AlgorithmMappingConfImpl();
        aconfig._factoryName = algorithmMapping.getFactoryname();
        ConfigConstants.getProperties(aconfig._properties, algorithmMapping.getProperties(), varMap);
        EList uris = algorithmMapping.getAlgorithmURI();
        int iMax = uris.size();
        for (int i = 0; i < iMax; ++i) {
            AlgorithmURI algorithmUri = (AlgorithmURI)uris.get(i);
            PrivateCommonConfig.AlgorithmConfImpl algo = new PrivateCommonConfig.AlgorithmConfImpl();
            algo._algorithm = algorithmUri.getAlgorithm();
            algo._type = algorithmUri.getType();
            aconfig._algorithmURIs.add(algo._algorithm);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added an algorithmURI[" + algo._algorithm + "] as the type [" + algo._type + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readAlgorithmMapping", aconfig);
        }
        return aconfig;
    }

    public static Map getProperties(EList props, VariableMap varMap) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(EList, VariableMap):", new Object[]{props, varMap});
        }
        HashMap map = new HashMap();
        ConfigConstants.getProperties(map, props, varMap);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(EList, VariableMap)");
        }
        return map;
    }

    public static void getProperties(Map map, EList props, VariableMap varMap) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getProperties(Map, EList, VariableMap):", new Object[]{map, props, varMap});
        }
        if (map != null && props != null && !props.isEmpty()) {
            int size = props.size();
            for (int j = 0; j < size; ++j) {
                String value;
                EObject p;
                Object object = props.get(j);
                if (object instanceof Property) {
                    p = (Property)object;
                    value = varMap == null ? p.getValue() : varMap.expand(p.getValue());
                    map.put(p.getName(), value);
                    continue;
                }
                if (object instanceof com.ibm.etools.webservice.wscommonext.Property) {
                    p = (com.ibm.etools.webservice.wscommonext.Property)object;
                    value = varMap == null ? p.getValue() : varMap.expand(p.getValue());
                    map.put(p.getName(), value);
                    continue;
                }
                if (object instanceof ParameterImpl) {
                    p = (ParameterImpl)object;
                    value = varMap == null ? ((ParameterImpl)p).getValue() : varMap.expand(((ParameterImpl)p).getValue());
                    map.put(((ParameterImpl)p).getName(), value);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.exit(tc, "Property type not recognized");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getProperties(Map, EList, VariableMap)");
        }
    }

    public static int validNonceCacheTimeout(int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceCacheTimeout(int):", new Object[]{new Integer(timeout)});
        }
        if ((ret = timeout) < 300) {
            ret = 300;
            Tr.warning(tc, "security.wssecurity.WSEC0116W", new Object[]{new Integer(ret), new Integer(300)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceCacheTimeout(int) returns " + ret);
        }
        return ret;
    }

    private static int validNonceMaxAge(int maxAge, int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceMaxAge(int, int):", new Object[]{new Integer(maxAge), new Integer(timeout)});
        }
        if ((ret = maxAge) < 300 || ret > timeout) {
            ret = 300;
            Tr.warning(tc, "security.wssecurity.WSEC0118W", new Object[]{new Integer(ret), new Integer(300), new Integer(timeout), new Integer(300)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceMaxAge(int, int) returns " + ret);
        }
        return ret;
    }

    private static int validNonceClockSkew(int clockSkew, int maxAge) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceClockSkew(int, int):", new Object[]{new Integer(clockSkew), new Integer(maxAge)});
        }
        if ((ret = clockSkew) < 0 || ret > maxAge) {
            ret = 0;
            Tr.warning(tc, "security.wssecurity.WSEC0119W", new Object[]{new Integer(ret), new Integer(0), new Integer(maxAge), new Integer(0)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceClockSkew(int, int) returns " + ret);
        }
        return ret;
    }

    private static int validNonceCacheSize(int cacheSize) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceCacheSize(int):", new Object[]{new Integer(cacheSize)});
        }
        if ((ret = cacheSize) < 16) {
            ret = 1024;
            Tr.warning(tc, "security.wssecurity.WSEC0124W", new Object[]{new Integer(ret), new Integer(16), new Integer(1024)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceCacheSize(int) returns " + ret);
        }
        return ret;
    }

    private static int validNonceLength(int length) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validNonceLength(int):", new Object[]{new Integer(length)});
        }
        if ((ret = length) < 16) {
            ret = 128;
            Tr.warning(tc, "security.wssecurity.WSEC0127W", new Object[]{new Integer(ret), new Integer(16), new Integer(128)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validNonceLength(int) returns " + ret);
        }
        return ret;
    }

    public static int processNonceMaxAge(String maxAge, int timeout) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceMaxAge(String, int):", new Object[]{maxAge, new Integer(timeout)});
        }
        int nonceMaxAge = 300;
        if (maxAge != null && (maxAge = maxAge.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(maxAge);
                nonceMaxAge = ConfigConstants.validNonceMaxAge(i, timeout);
            }
            catch (NumberFormatException e) {
                nonceMaxAge = 300;
                FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processNonceMaxAge", "692");
                Tr.warning(tc, "security.wssecurity.WSEC0117W", new Object[]{maxAge, new Integer(300)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceMaxAge(String, int) returns " + nonceMaxAge);
        }
        return nonceMaxAge;
    }

    public static int processNonceClockSkew(String clockSkew, int maxAge) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processNonceClockSkew(String, int):", new Object[]{clockSkew, new Integer(maxAge)});
        }
        int nonceClockSkew = 0;
        if (clockSkew != null && (clockSkew = clockSkew.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(clockSkew);
                nonceClockSkew = ConfigConstants.validNonceClockSkew(i, maxAge);
            }
            catch (NumberFormatException e) {
                nonceClockSkew = 0;
                FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processNonceClockSkew", "720");
                Tr.warning(tc, "security.wssecurity.WSEC0120W", new Object[]{clockSkew, new Integer(0)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceClockSkew(String, int) returns " + nonceClockSkew);
        }
        return nonceClockSkew;
    }

    public static int processNonceCacheSize(String cacheSize) {
        int nonceCacheSize;
        block5: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processNonceCacheSize(String):", new Object[]{cacheSize});
            }
            nonceCacheSize = 1024;
            if (cacheSize != null && (cacheSize = cacheSize.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(cacheSize);
                    nonceCacheSize = ConfigConstants.validNonceCacheSize(i);
                }
                catch (NumberFormatException e) {
                    nonceCacheSize = 1024;
                    FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processNonceCacheSize", "748");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the Nonce (randomly generated value) cache size" + cacheSize + ", default value " + 1024 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceCacheSize(String) returns " + nonceCacheSize);
        }
        return nonceCacheSize;
    }

    public static int processNonceLength(String length) {
        int nonceLength;
        block5: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processNonceLength(String):", new Object[]{length});
            }
            nonceLength = 128;
            if (length != null && (length = length.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(length);
                    nonceLength = ConfigConstants.validNonceCacheSize(i);
                }
                catch (NumberFormatException e) {
                    nonceLength = 128;
                    FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processNonceLength", "779");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the Nonce (randomly generated value) length" + length + ", default value " + 128 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processNonceLength(String) returns " + nonceLength);
        }
        return nonceLength;
    }

    public static int validCertCacheTimeout(int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validCertCacheTimeout(int):", new Object[]{new Integer(timeout)});
        }
        if ((ret = timeout) < 300) {
            ret = 300;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate cache timeout " + ret + " seconds is less than the minimum, the minimum " + 300 + " seconds is used instead.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validCertCacheTimeout(int) returns " + ret);
        }
        return ret;
    }

    public static int validCertCacheSize(int cacheSize) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validCertCacheSize(int):", new Object[]{new Integer(cacheSize)});
        }
        if ((ret = cacheSize) < 16) {
            ret = 128;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified certificate cache size " + ret + " is less than the allowed minimum " + 16 + ", the default " + 128 + " is used.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validCertCacheSize(int) returns " + ret);
        }
        return ret;
    }

    public static int processCertCacheSize(String cacheSize) {
        int certCacheSize;
        block5: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processCertCacheSize(String):", new Object[]{cacheSize});
            }
            certCacheSize = 128;
            if (cacheSize != null && (cacheSize = cacheSize.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(cacheSize);
                    certCacheSize = ConfigConstants.validCertCacheSize(i);
                }
                catch (NumberFormatException e) {
                    certCacheSize = 128;
                    FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processCertCacheSize", "856");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the certificate cache size" + cacheSize + ", default value " + 128 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processCertCacheSize(String) returns " + certCacheSize);
        }
        return certCacheSize;
    }

    public static int validTokenCacheTimeout(int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTokenCacheTimeout(int):", new Object[]{new Integer(timeout)});
        }
        if ((ret = timeout) < 300) {
            ret = 300;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token cache timeout " + ret + " seconds is less than the minimum, the minimum " + 300 + " seconds is used instead.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTokenCacheTimeout(int) returns " + ret);
        }
        return ret;
    }

    public static int validTokenCacheSize(int cacheSize) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTokenCacheSize(int):", new Object[]{new Integer(cacheSize)});
        }
        if ((ret = cacheSize) < 16) {
            ret = 128;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified token cache size " + ret + " is less than the allowed minimum " + 16 + ", the default " + 128 + " is used.");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTokenCacheSize(int) returns " + ret);
        }
        return ret;
    }

    public static int processTokenCacheSize(String cacheSize) {
        int tokenCacheSize;
        block5: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processTokenCacheSize(String):", new Object[]{cacheSize});
            }
            tokenCacheSize = 128;
            if (cacheSize != null && (cacheSize = cacheSize.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(cacheSize);
                    tokenCacheSize = ConfigConstants.validTokenCacheSize(i);
                }
                catch (NumberFormatException e) {
                    tokenCacheSize = 128;
                    FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processTokenCacheSize", "982");
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the token cache size" + cacheSize + ", default value " + 128 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTokenCacheSize(String) returns " + tokenCacheSize);
        }
        return tokenCacheSize;
    }

    public static long validTokenCushion(long cushion) {
        long ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validTokenCushion(long cushion = " + cushion + ")");
        }
        if ((ret = cushion) < 300000L) {
            ret = 300000L;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The token cushion " + cushion + " milliseconds is less than the minimum. The minimum " + ret + " milliseconds is used instead.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validTokenCushion(long) returns " + ret);
        }
        return ret;
    }

    public static int validTimestampTimeout(int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampTimeout(int):", new Object[]{new Integer(timeout)});
        }
        if ((ret = timeout) < 300) {
            ret = 300;
            Tr.warning(tc, "security.wssecurity.WSEC0139W", new Object[]{new Integer(ret), new Integer(300)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampTimeout(int) returns " + ret);
        }
        return ret;
    }

    private static int validTimestampMaxAge(int maxAge, int timeout) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampMaxAge(int, int):", new Object[]{new Integer(maxAge), new Integer(timeout)});
        }
        if ((ret = maxAge) < 300 || ret > timeout) {
            ret = 300;
            Tr.warning(tc, "security.wssecurity.WSEC0141W", new Object[]{new Integer(ret), new Integer(300), new Integer(timeout), new Integer(300)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampMaxAge(int, int) returns " + ret);
        }
        return ret;
    }

    private static int validTimestampClockSkew(int clockSkew, int maxAge) {
        int ret;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "validTimestampClockSkew(int, int):", new Object[]{new Integer(clockSkew), new Integer(maxAge)});
        }
        if ((ret = clockSkew) < 0 || ret > maxAge) {
            ret = 0;
            Tr.warning(tc, "security.wssecurity.WSEC0142W", new Object[]{new Integer(ret), new Integer(0), new Integer(maxAge), new Integer(0)});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "validTimestampClockSkew(int, int) returns " + ret);
        }
        return ret;
    }

    public static int processTimestampMaxAge(String maxAge, int timeout) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTimestampMaxAge(String, int):", new Object[]{maxAge, new Integer(timeout)});
        }
        int timestampMaxAge = 300;
        if (maxAge != null && (maxAge = maxAge.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(maxAge);
                timestampMaxAge = ConfigConstants.validTimestampMaxAge(i, timeout);
            }
            catch (NumberFormatException e) {
                timestampMaxAge = 300;
                FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processTimestampMaxAge", "947");
                Tr.warning(tc, "security.wssecurity.WSEC0140W", new Object[]{maxAge, new Integer(300)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTimestampMaxAge(String, int) returns " + timestampMaxAge);
        }
        return timestampMaxAge;
    }

    public static int processTimestampClockSkew(String clockSkew, int maxAge) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processTimestampClockSkew(String, int):", new Object[]{clockSkew, new Integer(maxAge)});
        }
        int timestampClockSkew = 0;
        if (clockSkew != null && (clockSkew = clockSkew.trim()).length() != 0) {
            try {
                int i = Integer.parseInt(clockSkew);
                timestampClockSkew = ConfigConstants.validTimestampClockSkew(i, maxAge);
            }
            catch (NumberFormatException e) {
                timestampClockSkew = 0;
                FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processTimestampClockSkew", "975");
                Tr.warning(tc, "security.wssecurity.WSEC0143W", new Object[]{clockSkew, new Integer(0)});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processTimestampClockSkew(String, int) returns " + timestampClockSkew);
        }
        return timestampClockSkew;
    }

    public static long processHardwareCacheEntryRefresh(String cacheEntryRefresh) {
        long hardwareCacheEntryRefresh;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processHardwareCacheEntryRefresh(String):", new Object[]{cacheEntryRefresh});
            }
            hardwareCacheEntryRefresh = 0L;
            if (cacheEntryRefresh != null && (cacheEntryRefresh = cacheEntryRefresh.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(cacheEntryRefresh);
                    if (i >= 0) {
                        hardwareCacheEntryRefresh = i;
                    }
                }
                catch (NumberFormatException e) {
                    hardwareCacheEntryRefresh = 0L;
                    FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processHardwareCacheEntryRefresh", "1155");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the hardware cache refresh time" + cacheEntryRefresh + ", cache entry refresh disabled.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processHardwareCacheEntryRefresh(String) returns " + hardwareCacheEntryRefresh);
        }
        return hardwareCacheEntryRefresh;
    }

    public static int processHardwareCacheSize(String cacheSize) {
        int hardwareCacheSize;
        block6: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "processHardwareCacheSize(String):", new Object[]{cacheSize});
            }
            hardwareCacheSize = 1000;
            if (cacheSize != null && (cacheSize = cacheSize.trim()).length() != 0) {
                try {
                    int i = Integer.parseInt(cacheSize);
                    if (i >= 0) {
                        hardwareCacheSize = i;
                    }
                }
                catch (NumberFormatException e) {
                    hardwareCacheSize = 1000;
                    FFDCFilter.processException(e, ConfigConstants.class.getName() + ".processHardwareCacheSize", "1188");
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "WARNING: Exception occurred during parsing the hardware cache size" + cacheSize + ", default value " + 1000 + " is used instead.");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processHardwareCacheSize(String) returns " + hardwareCacheSize);
        }
        return hardwareCacheSize;
    }

    public static String getWSSENS(SOAPMessageContext messageContext) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSENS(SOAPMessageContext)");
        }
        if ((ns = (String)messageContext.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace")) == null || ns.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSSE namespace found in MessageContext, use default");
            }
            ns = Constants.NS_WSSE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSENS(SOAPMessageContext) returns " + ns);
        }
        return ns;
    }

    public static String getWSUNS(SOAPMessageContext messageContext) {
        String ns;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSUNS(SOAPMessageContext)");
        }
        if ((ns = (String)messageContext.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace")) == null || ns.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No WSU namespace found in MessageContext, use default");
            }
            ns = Constants.NS_WSU;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSUNS(SOAPMessageContext) returns " + ns);
        }
        return ns;
    }
}

