/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.token;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.token.UserRegistryProcessor;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.LTPATokenWrapper;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.UsernameToken;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class LoginProcessor
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(LoginProcessor.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LoginProcessor.class.getName();
    private static final String JAASCONFIG_DEFAULT = "WSLogin";
    private static final String JAASCONFIG_IDASSERTION = "system.wssecurity.IDAssertion";
    private static final String JAASCONFIG_SIGNATURE = "system.wssecurity.Signature";
    private static final String CALLBACKHANDLER_FACTORY_DEFAULT = "com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl";
    private boolean _initialized = false;
    private static final String JAAS_LOGINCONFIG = "com.ibm.wsspi.wssecurity.Caller.assertionLoginConfig";
    private static final String JAAS_PASSLOGINSUBJECT = "com.ibm.wsspi.wssecurity.Caller.passSubjectToLogin";
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Element target[" + DOMUtil.getDisplayName((Node)target) + "], " + "Map context)"));
        }
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        Token token = LoginProcessor.checkCaller(gconfig.getCallers(), context);
        this.login(token, context);
        context.remove(JAAS_LOGINCONFIG);
        context.remove(JAAS_PASSLOGINSUBJECT);
        TokenManager.finalizeSubject(context);
        this.cacheInformation(token, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,Map context)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Token checkCaller(Set cconfigs, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkCaller(Set cconfigs[" + cconfigs + "]," + "Map context)"));
        }
        Token token = null;
        context.remove(JAAS_LOGINCONFIG);
        context.remove(JAAS_PASSLOGINSUBJECT);
        if (cconfigs != null) {
            Result[] results = ResultPool.get((Map)context, AuthResult.class);
            int length = results.length;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("results.length=" + results.length), (Object)results);
            }
            if (length == 0) {
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s01");
            }
            if (length > 2) {
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s02");
            }
            AuthResult cresult = null;
            AuthResult tmresult = null;
            if (results.length == 1) {
                cresult = (AuthResult)results[0];
                if (cresult.getToken() == null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s03");
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    AuthResult tresult = (AuthResult)results[i];
                    Token ttoken = tresult.getToken();
                    if (ttoken == null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s03");
                    }
                    if (ttoken.isTrusted()) {
                        if (tmresult != null) {
                            throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s04");
                        }
                        tmresult = tresult;
                        continue;
                    }
                    if (cresult != null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s05");
                    }
                    cresult = tresult;
                }
            }
            if (tc.isDebugEnabled()) {
                if (tmresult == null || tmresult.getToken() == null) {
                    Tr.debug((TraceComponent)tc, (String)("Caller token [" + cresult.getToken().getType() + "]"));
                } else {
                    Tr.debug((TraceComponent)tc, (String)("Caller token [" + cresult.getToken().getType() + "], " + "TrustMethod token [" + tmresult.getToken().getType() + "]"));
                }
            }
            for (WSSConsumerConfig.CallerConfig cconfig : cconfigs) {
                QName qn1;
                boolean processOK = false;
                WSSConsumerConfig.CallerConfig tmconfig = cconfig.getTrustMethod();
                if (tmconfig == null) {
                    if (tmresult != null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s06");
                    }
                    processOK = true;
                } else if (tmresult == null) {
                    if (tmconfig.getTokenType() != null || tmconfig.getPart() != null) throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s07");
                    processOK = true;
                } else {
                    qn1 = tmconfig.getTokenType();
                    if (qn1 == null) {
                        throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s08");
                    }
                    if (tmconfig.equals(tmresult._config)) {
                        processOK = LoginProcessor.checkProperties(tmconfig, tmresult.getToken());
                    }
                }
                if (!processOK) continue;
                processOK = false;
                qn1 = cconfig.getTokenType();
                if (qn1 == null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s09");
                }
                if (cconfig.equals(cresult._config)) {
                    processOK = LoginProcessor.checkProperties(cconfig, cresult.getToken());
                }
                if (!processOK) continue;
                if (token != null) {
                    throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s10");
                }
                token = cresult.getToken();
                if (cconfig.getProperties() == null) break;
                context.put(JAAS_LOGINCONFIG, cconfig.getProperties().get(JAAS_LOGINCONFIG));
                context.put(JAAS_PASSLOGINSUBJECT, cconfig.getProperties().get(JAAS_PASSLOGINSUBJECT));
                break;
            }
        }
        if (!tc.isEntryEnabled()) return token;
        Tr.exit((TraceComponent)tc, (String)("checkCaller(Set cconfigs,Map context) returns Token[" + token + "]"));
        return token;
    }

    private static boolean checkProperties(WSSConsumerConfig.CallerConfig cconfig, Token token) {
        boolean processOK;
        block8: {
            Set keys;
            Map map;
            block9: {
                block7: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)("checkProperties(CallerConfig cconfig[" + cconfig + "]," + "Token token[" + token + "])"));
                    }
                    processOK = true;
                    map = cconfig.getProperties();
                    if (map != null) break block7;
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"properties is null.");
                    break block8;
                }
                keys = map.keySet();
                if (keys != null && !keys.isEmpty()) break block9;
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"CallerConfig's properties has no entry.");
                break block8;
            }
            for (String key : keys) {
                if (com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CALLER_TOKEN_NS.equals(key) || com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CALLER_TOKEN_LN.equals(key) || JAAS_LOGINCONFIG.equals(key) || JAAS_PASSLOGINSUBJECT.equals(key)) continue;
                String value = (String)map.get(key);
                String[] values = token.getAttributes(key);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("key [" + key + "], value [" + value + "], values [" + values + "]."));
                }
                if (values == null || values.length == 0 || values.length > 1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"values is invalid.");
                    }
                    processOK = false;
                    break;
                }
                if (value.equals(values[0])) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("value [" + value + "] is different from values[0] [" + values[0] + "]."));
                }
                processOK = false;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkProperties(CallerConfig cconfig,Token token) returns boolean[" + processOK + "]"));
        }
        return processOK;
    }

    /*
     * Unable to fully structure code
     */
    private void login(Token token, Map context) throws SoapSecurityException {
        block74: {
            block73: {
                block72: {
                    if (LoginProcessor.tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)LoginProcessor.tc, (String)("login(Token token[" + token + "]," + "Map context)"));
                    }
                    contextSubject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
                    ctxMgr = ContextManagerFactory.getInstance();
                    realm = null;
                    if (ctxMgr == null) {
                        Tr.error((TraceComponent)LoginProcessor.tc, (String)"security.wssecurity.ctxmgr.isnull");
                    } else {
                        realm = ctxMgr.getDefaultRealm();
                    }
                    wsCredTokenMapper = null;
                    uniqueID = null;
                    try {
                        wsCredTokenMapper = _wsCredToken._wsCredTokenMapper;
                        if (wsCredTokenMapper != null && contextSubject != null) {
                            uniqueID = wsCredTokenMapper.createSubjectUniqueID(contextSubject);
                        }
                    }
                    catch (Exception e) {
                        Tr.processException((Throwable)e, (String)(LoginProcessor.clsName + ".login"), (String)"434", (Object)this);
                        if (!LoginProcessor.tc.isDebugEnabled()) break block72;
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Caught exception while getting unique ID from subject.", (Object)new Object[]{e});
                    }
                }
                if (LoginProcessor.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Unique ID from tokens in contextSubject: " + uniqueID));
                }
                cache = ContextManagerFactory.getInstance().getSecurityCache();
                loginSubject = null;
                if (cache == null) ** GOTO lbl40
                if (uniqueID == null || uniqueID.length() == 0) {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Unique ID based on tokens is null. Look for Subject in AuthCache using token.");
                    }
                    loginSubject = this.getCachedSubjectUsingToken(cache, token, realm);
                } else {
                    try {
                        loginSubject = cache.getSubject(uniqueID);
                    }
                    catch (CacheException e) {
                        Tr.processException((Throwable)e, (String)(LoginProcessor.clsName + ".login"), (String)"461", (Object)this);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Caught exception while looking up subject from AuthCache.", (Object)new Object[]{e});
                        }
                        break block73;
                    }
lbl40:
                    // 1 sources

                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Not looking Subject in cache because SecurityCache instance is null.");
                    }
                }
            }
            if (loginSubject != null) {
                credential = loginSubject.getPublicCredentials(WSCredential.class).iterator().next();
                if (credential != null) {
                    is_destroyed = credential.isDestroyed();
                    is_forwardable = false;
                    try {
                        is_forwardable = credential.isForwardable();
                    }
                    catch (Exception e) {
                        is_destroyed = true;
                    }
                    isSubjectValid = wsCredTokenMapper.checkCushionValidityOfAllTokens(loginSubject, cache.getCushion());
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        if (is_forwardable) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("credential is forwardable, subject valid = " + isSubjectValid));
                        } else {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"non-forwardable Subject");
                        }
                    }
                    if (is_destroyed || is_forwardable && !isSubjectValid) {
                        loginSubject = null;
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Credential has expired or is destroyed, logging in again.");
                        }
                    } else if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Cached subject is valid.");
                    }
                } else {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"No WSCredential in Subject, logging in again.");
                    }
                    loginSubject = null;
                }
            }
            if (loginSubject != null) break block74;
            if (LoginProcessor.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Subject not found in AuthCache.");
            }
            authMech = this.getLoginConfig(context);
            v0 = useOldBehavior = (Boolean)context.get("com.ibm.wsspi.wssecurity.Caller.passSubjectToLogin") == false;
            if (LoginProcessor.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("useOldBehavior=" + useOldBehavior));
            }
            try {
                block76: {
                    block77: {
                        block75: {
                            if (!(token instanceof UsernameToken)) break block75;
                            unt = (UsernameToken)token;
                            user = unt.getUsername();
                            if (user == null || user.length() == 0) {
                                Tr.error((TraceComponent)LoginProcessor.tc, (String)"security.wssecurity.WSEC6735E", (Object)new Object[]{token.getType().toString(), "Login cancelled: username string is null or empty."});
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s11", "Login cancelled: username string is null or empty.");
                            }
                            untPriv = unt;
                            pwChr = (char[])AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return untPriv.getPassword();
                                }
                            });
                            pwd = null;
                            if (pwChr != null) {
                                pwd = new String(pwChr);
                            }
                            if (pwd == null || pwd.length() == 0) {
                                auditIdName = null;
                                try {
                                    auditIdName = user;
                                    user = this.callingMappingLoginModule("system.wssecurity.IDAssertion", token, contextSubject, user);
                                    loginSubject = this.jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm);
                                }
                                catch (Exception e) {
                                    if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED)) {
                                        auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, e.toString());
                                        messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "IdentityName", auditIdName);
                                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "RoleName", user);
                                        WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                                    }
                                    throw e;
                                }
                                if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
                                    auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                                    messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "IdentityName", auditIdName);
                                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "RoleName", user);
                                    WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                                }
                            } else {
                                loginSubject = this.jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm, pwd);
                            }
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)"UsernameToken found.");
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Username [" + user + "], Password [" + (pwChr == null ? "null" : "not null") + "]."));
                            }
                            break block76;
                        }
                        if (!(token instanceof X509BSToken)) break block77;
                        x509 = (X509BSToken)token;
                        securityName = UserRegistryProcessor.mapCertificate(x509.getCert());
                        if (securityName == null || securityName.length() == 0) {
                            securityName = token.getPrincipal();
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("User security from X509BSToken.getPrincipal() [" + securityName + "]"));
                            }
                        } else if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("User security from UserRegistryProcessor.mapCertificate() [" + securityName + "]"));
                        }
                        securityName = this.callingMappingLoginModule("system.wssecurity.Signature", token, contextSubject, securityName);
                        loginSubject = this.jaasLogin(context, useOldBehavior, authMech, contextSubject, securityName, realm);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"X509BSToken found.");
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Username [" + x509.getCert().getSubjectX500Principal().getName() + "]."));
                        }
                        break block76;
                    }
                    if (!(token instanceof LTPATokenWrapper)) ** GOTO lbl152
                    tokPriv = tok = (LTPATokenWrapper)token;
                    wsCred = (WSCredential)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return tokPriv.getWSCredential();
                        }
                    });
                    wsPrinc = tok.getWSPrincipal();
                    if (wsCred != null) {
                        this.addToSubject(context, wsCred);
                        this.addToSubject(context, wsPrinc);
                        this.addToSubject(context, token);
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"LTPATokenWrapper found.");
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("WSCredential [" + wsCred + "]."));
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("WSPrincipal [" + wsPrinc + "]."));
                        }
                    } else {
                        if (LoginProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"No WSCredential found in LTPATokenWrapper.");
                        }
                        throw SoapSecurityException.format("security.wssecurity.WSEC0168E");
lbl152:
                        // 1 sources

                        if (token instanceof LTPAToken) {
                            tokenPriv = (LTPAToken)token;
                            tokenBytes = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return tokenPriv.getBytes();
                                }
                            });
                            if (tokenBytes == null) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Null credential value found for the LTPA token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s12", "Login cancelled by invalid token.");
                            }
                            loginSubject = this.jaasLogin(context, useOldBehavior, authMech, contextSubject, tokenBytes);
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)"LTPA Token found.");
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Credential [" + tokenBytes + "]."));
                            }
                        } else {
                            securityName = token.getPrincipal();
                            if (securityName == null) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Null principal value found for the custom token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", "Login cancelled by invalid token.");
                            }
                            if ((securityName = securityName.trim()).length() == 0) {
                                if (LoginProcessor.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Principal value is zero length value for the custom token to login.");
                                }
                                throw SoapSecurityException.format("security.wssecurity.LoginProcessor.s13", "Login cancelled by invalid token.");
                            }
                            auditIdName = null;
                            try {
                                auditIdName = securityName;
                                securityName = this.callingMappingLoginModule("system.wssecurity.IDAssertion", token, contextSubject, securityName);
                                loginSubject = this.jaasLogin(context, useOldBehavior, authMech, contextSubject, securityName, realm);
                            }
                            catch (Exception e) {
                                if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.DENIED)) {
                                    auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_DENIED, e.toString());
                                    messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "IdentityName", auditIdName);
                                    WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "RoleName", securityName);
                                    WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                                }
                                throw e;
                            }
                            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
                                auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                                messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "DelegationType", "IDENTITY_ASSERTION");
                                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "IdentityName", auditIdName);
                                WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "RoleName", securityName);
                                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN_DELEGATION, messageContext, context);
                            }
                            if (LoginProcessor.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Token [" + token.getType() + "] found."));
                                Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Principal [" + token.getPrincipal() + "]."));
                            }
                        }
                    }
                }
                if (wsCredTokenMapper == null || loginSubject == null || cache == null) ** GOTO lbl229
                if (useOldBehavior) {
                    this.addTokensToLoginSubject(context, loginSubject);
                } else {
                    contextSubject.getPrincipals().clear();
                    contextSubject.getPublicCredentials().clear();
                    contextSubject.getPrivateCredentials().clear();
                    LoginProcessor.syncSubject(loginSubject, contextSubject, false);
                }
                uniqueID = wsCredTokenMapper.createSubjectUniqueID(loginSubject);
                if (uniqueID == null || uniqueID.length() == 0) {
                    if (LoginProcessor.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Unique ID is null. Adding Subject to AuthCache");
                    }
                    cache.insert(loginSubject);
                }
                if (LoginProcessor.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Adding Subject with ID " + uniqueID + " to AuthCache"));
                }
                cache.insert(loginSubject, new Object[]{uniqueID});
            }
            catch (LoginException le) {
                Tr.processException((Throwable)le, (String)(LoginProcessor.clsName + ".login"), (String)"761", (Object)this);
                Tr.error((TraceComponent)LoginProcessor.tc, (String)"security.wssecurity.WSEC6735E", (Object)new Object[]{token.getType().toString(), le});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s11", (Throwable)le);
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, (String)(LoginProcessor.clsName + ".login"), (String)"766", (Object)this);
                Tr.error((TraceComponent)LoginProcessor.tc, (String)"security.wssecurity.WSEC6735E", (Object)new Object[]{token.getType().toString(), e});
                throw SoapSecurityException.format(Constants.FAILED_AUTHENTICATION, "security.wssecurity.LoginProcessor.s11", (Throwable)e);
            }
        }
        if (LoginProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)LoginProcessor.tc, (String)"Subject found in AuthCache.");
        }
        LoginProcessor.addToSubject(context, loginSubject);
lbl229:
        // 4 sources

        if (LoginProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)LoginProcessor.tc, (String)("Subject after authentication: " + loginSubject));
        }
        token.setUsedToLogin(true);
        if (LoginProcessor.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)LoginProcessor.tc, (String)"login(Token token, Map context)");
        }
    }

    private String callingMappingLoginModule(String jassLoginConfig, Token token, Subject contextSubject, String identity) throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callingMappingLoginModule(jassLoginConfig=[" + jassLoginConfig + "], token=[" + token + "], contextSubject=[" + contextSubject + "], identity=[" + identity + "])"));
        }
        String securityName = null;
        try {
            Tr.debug((TraceComponent)tc, (String)"Normalizing identity");
            securityName = KeyStoreKeyLocator.encodedName(identity);
            Tr.debug((TraceComponent)tc, (String)("securityName=[" + securityName + "]"));
        }
        catch (KeyLocatorException kle) {
            Tr.debug((TraceComponent)tc, (String)("Error normalizing identity, securityName=[" + securityName + "]"));
            securityName = identity;
        }
        WSCallbackHandlerFactoryImpl factory = new WSCallbackHandlerFactoryImpl();
        factory.setXMLToken(token.getElement());
        factory.setUsername(securityName);
        HashMap properties = new HashMap();
        factory.setProperties(properties);
        LoginContext lc = new LoginContext(jassLoginConfig, contextSubject, factory.newCallbackHandler());
        lc.login();
        String returnedSecurityName = (String)properties.get("LoginUsername");
        if (returnedSecurityName != null && (returnedSecurityName = returnedSecurityName.trim()).length() != 0) {
            securityName = returnedSecurityName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("callingMappingLoginModule() returns " + securityName));
        }
        return securityName;
    }

    public static void addToSubject(Map context, Subject loginSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToSubject(context, loginSubject)");
        }
        Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        LoginProcessor.syncSubject(loginSubject, subject, true);
        context.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToSubject(context, loginSubject)");
        }
    }

    private void addToSubject(Map context, final WSCredential wsCred) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToSubject(context, wsCred)");
        }
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!subject.getPublicCredentials().contains(wsCred)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding WSCredential to Subject: " + wsCred));
                    }
                    subject.getPublicCredentials().add(wsCred);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WSCredential already in Subject: " + wsCred));
                }
                return null;
            }
        });
        context.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToSubject(context, wsCred)");
        }
    }

    private void addToSubject(Map context, final Token token) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToSubject(context, token)");
        }
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!subject.getPrivateCredentials().contains(token)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding Token to Subject: " + token));
                    }
                    subject.getPrivateCredentials().add(token);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token already in Subject: " + token));
                }
                return null;
            }
        });
        context.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToSubject(context, token)");
        }
    }

    private void addToSubject(Map context, final WSPrincipal princ) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToSubject(context, princ)");
        }
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!subject.getPrincipals().contains(princ)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Adding WSPrincipal to Subject: " + princ));
                    }
                    subject.getPrincipals().add(princ);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("WSPrincipal already in Subject: " + princ));
                }
                return null;
            }
        });
        context.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToSubject(context, princ)");
        }
    }

    private void addTokensToLoginSubject(Map context, final Subject loginSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTokensToLoginSubject(context, loginSubject)");
        }
        final Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Object privateObject : subject.getPrivateCredentials()) {
                    if (privateObject == null) continue;
                    if (!loginSubject.getPrivateCredentials().contains(privateObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding private object to Subject: " + privateObject));
                        }
                        loginSubject.getPrivateCredentials().add(privateObject);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Private object already in Subject: " + privateObject));
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTokensToLoginSubject(context, loginSubject)");
        }
    }

    private void cacheInformation(Token token, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cacheInformation(Token token[" + token + "]," + "Map context)"));
        }
        Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        ContextManager ctxMgr = ContextManagerFactory.getInstance();
        if (ctxMgr == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.ctxmgr.isnull");
        } else {
            ctxMgr.put("com.ibm.wsspi.wssecurity.username.initialSenderId", subject);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Initial Sender is set.");
            }
            subject = (Subject)ctxMgr.get("com.ibm.wsspi.wssecurity.username.initialSenderId");
            if (token instanceof X509BSToken) {
                X509Certificate cert = ((X509BSToken)token).getCert();
                ctxMgr.put("com.ibm.wsspi.wssecurity.username.initialSenderCert", cert);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initial Cert is set.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cacheInformation(Token token,Map context)");
        }
    }

    private Subject getCachedSubjectUsingToken(SecurityCache cache, Token token, String realm) {
        Subject subject;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getCachedSubjectUsingToken(cache, token, realm)");
            }
            subject = null;
            if (cache != null && token != null) {
                try {
                    if (token instanceof UsernameToken) {
                        UsernameToken unt = (UsernameToken)token;
                        String user = unt.getUsername();
                        if (user != null && user.length() > 0) {
                            char[] pwChr = null;
                            final UsernameToken tokenPriv = unt;
                            pwChr = (char[])AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    return tokenPriv.getPassword();
                                }
                            });
                            String pwd = null;
                            if (pwChr != null) {
                                pwd = new String(pwChr);
                            }
                            subject = pwd == null || pwd.length() == 0 ? cache.getSubject(realm, user) : cache.getSubject(realm, user, pwd);
                        }
                    } else if (token instanceof LTPATokenWrapper) {
                        subject = null;
                    } else if (token instanceof LTPAToken) {
                        final LTPAToken tokenPriv = (LTPAToken)token;
                        byte[] bytes = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return tokenPriv.getBytes();
                            }
                        });
                        if (bytes != null) {
                            subject = cache.getSubject(bytes);
                        }
                    } else if (token instanceof X509BSToken) {
                        X509BSToken x509 = (X509BSToken)token;
                        String securityName = UserRegistryProcessor.mapCertificate(x509.getCert());
                        if (securityName == null || securityName.length() == 0) {
                            securityName = token.getPrincipal();
                        }
                        subject = cache.getSubject(realm, securityName);
                    } else if (token.getPrincipal() != null) {
                        subject = cache.getSubject(realm, token.getPrincipal());
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception looking up Subject from AuthCache: " + e));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCachedSubjectUsingToken: returning Subject = " + subject));
        }
        return subject;
    }

    private Subject jaasLogin(Map context, boolean useOldBehavior, String authMech, Subject contextSubject, String user, String realm) throws LoginException, WSLoginFailedException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm)");
        }
        if ((sm = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
            }
            sm.checkPermission(MAP_CREDENTIAL);
        }
        if (user == null || user.length() == 0) {
            throw new WSLoginFailedException("Username is null.");
        }
        LoginContext lc = this.getLoginContext(useOldBehavior, authMech, contextSubject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(user, realm, (String)null));
        lc.login();
        Subject subject = lc.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        if (useOldBehavior) {
            LoginProcessor.addToSubject(context, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm)");
        }
        return subject;
    }

    private Subject jaasLogin(Map context, boolean useOldBehavior, String authMech, Subject contextSubject, String user, String realm, String password) throws LoginException, WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm, password)");
        }
        if (user == null || user.length() == 0 || password == null || password.length() == 0) {
            throw new WSLoginFailedException("Username and/or password is null.");
        }
        LoginContext lc = this.getLoginContext(useOldBehavior, authMech, contextSubject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(user, realm, password));
        lc.login();
        Subject subject = lc.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        if (useOldBehavior) {
            LoginProcessor.addToSubject(context, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"jaasLogin(context, useOldBehavior, authMech, contextSubject, user, realm, password)");
        }
        return subject;
    }

    private Subject jaasLogin(Map context, boolean useOldBehavior, String authMech, Subject contextSubject, byte[] bytes) throws LoginException, WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"jaasLogin(context, useOldBehavior, authMech, contextSubject, bytes)");
        }
        LoginContext lc = this.getLoginContext(useOldBehavior, authMech, contextSubject, WSCallbackHandlerFactory.getInstance().getCallbackHandler(bytes));
        lc.login();
        Subject subject = lc.getSubject();
        if (subject == null) {
            throw new WSLoginFailedException("Subject returned from login module is null.");
        }
        if (useOldBehavior) {
            LoginProcessor.addToSubject(context, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"jaasLogin(context, useOldBehavior, authMech, contextSubject, bytes)");
        }
        return subject;
    }

    private static void syncSubject(final Subject source, final Subject target, final boolean reportErrors) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("syncSubject(source, target, reportErrors=" + reportErrors + ")"));
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Object publicObject : source.getPublicCredentials()) {
                    if (publicObject == null) continue;
                    if (!target.getPublicCredentials().contains(publicObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding public object to Subject: " + publicObject));
                        }
                        target.getPublicCredentials().add(publicObject);
                        continue;
                    }
                    if (reportErrors) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.LoginProcessor.s15");
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Public object already in Subject: " + publicObject));
                }
                for (Object privateObject : source.getPrivateCredentials()) {
                    if (privateObject == null) continue;
                    if (!target.getPrivateCredentials().contains(privateObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding private object to Subject: " + privateObject));
                        }
                        target.getPrivateCredentials().add(privateObject);
                        continue;
                    }
                    if (reportErrors) {
                        if (privateObject instanceof Token) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("ws-sec Token private object already in Subject: " + privateObject));
                            continue;
                        }
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.LoginProcessor.s16");
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Private object already in Subject: " + privateObject));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Private object already in Subject: " + privateObject));
                }
                for (Principal principalObject : source.getPrincipals()) {
                    if (principalObject == null) continue;
                    if (!target.getPrincipals().contains(principalObject)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding principal object to Subject: " + principalObject));
                        }
                        target.getPrincipals().add(principalObject);
                        continue;
                    }
                    if (reportErrors) {
                        Tr.error((TraceComponent)tc, (String)"security.wssecurity.LoginProcessor.s14");
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Principal object already in Subject: " + principalObject));
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("syncSubject(source, target, reportErrors=" + reportErrors + ")"));
        }
    }

    private String getLoginConfig(Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLoginConfig");
        }
        String authMech = null;
        boolean passLoginSubject = false;
        authMech = (String)context.get(JAAS_LOGINCONFIG);
        if (ConfigUtil.hasValue((String)authMech)) {
            passLoginSubject = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting com.ibm.wsspi.wssecurity.Caller.passSubjectToLogin to " + passLoginSubject));
            }
        } else {
            authMech = SecurityObjectLocator.getCSIv2Config().getString("com.ibm.CSI.authMechAuthAlias");
            passLoginSubject = ConfigUtil.getIsTrueProperty((Map)context, (String)JAAS_PASSLOGINSUBJECT);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("authMech is " + authMech));
            Tr.debug((TraceComponent)tc, (String)("passLoginSubject is " + passLoginSubject));
        }
        context.put(JAAS_LOGINCONFIG, authMech);
        context.put(JAAS_PASSLOGINSUBJECT, new Boolean(passLoginSubject));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLoginConfig");
        }
        return authMech;
    }

    private LoginContext getLoginContext(boolean useOldBehavior, String authMech, Subject contextSubject, CallbackHandler callbackHandler) throws LoginException {
        LoginContext lc;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLoginContext");
        }
        if (useOldBehavior) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"creating LoginContext without Subject");
            }
            lc = new LoginContext(authMech, callbackHandler);
        } else {
            Subject localSubject = new Subject();
            LoginProcessor.syncSubject(contextSubject, localSubject, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"creating LoginContext with Subject");
            }
            lc = new LoginContext(authMech, localSubject, callbackHandler);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLoginContext");
        }
        return lc;
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> wrapperClass = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object wrapperObj = wrapperClass.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)wrapperObj;
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, clsName + "init", "1204");
            }
        }
    }
}

