/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyNameContentConsumer
implements KeyInfoContentConsumerComponent {
    private static final TraceComponent tc = Tr.register(KeyNameContentConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyNameContentConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Element target, Map type, Map context) throws SoapSecurityException {
        KeyLocator klocator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentConsumerConfig config = (KeyInfoContentConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentConsumerConfig [" + config + "]."));
        }
        KeyInfoResult result = new KeyInfoResult(config);
        ResultPool.add((Map)context, (Result)result);
        if (!ConfigUtil.isKeyInfoKeyname((String)config.getKeyInfoType())) {
            String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer buf = new StringBuffer(clsName).append(" expects KeyInfo's type [KEYNAME],");
            buf.append(" but the type requested in the configuration is [").append(config.getKeyInfoType()).append("].");
            buf.append(" Please make sure the KeyInfo used for");
            if ("VerifyingKey".equals(keyType)) {
                buf.append(" siganture verification");
            } else {
                buf.append(" decryption");
            }
            buf.append(" in the");
            if (isServer) {
                buf.append(" request consumer configuration.");
            } else {
                buf.append(" response consumer configuration.");
            }
            throw new SoapSecurityException(buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE, keyType);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The type of a key is [" + keyType + "]."));
        }
        String kname = this.getKeyName(target);
        result.setIdInSubject(kname);
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME, kname);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME, kname);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key name is [" + kname + "]."));
        }
        if ((klocator = config.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        context.put("com.ibm.wsspi.wssecurity.token.x509.keyLocator", config.getKeyLocator());
        context.remove(klocator.getClass());
        if (config.getTokenConsumer() == null) {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        } else {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE, config.getTokenConsumer());
        }
        TokenConsumerConfig tconfig = config.getTokenConsumer();
        if (tconfig != null) {
            TokenConsumerComponent tcon = tconfig.getInstance();
            if (tcon == null) {
                throw SoapSecurityException.format("security.wssecurity.EmbeddedContentConsumer.getKey01");
            }
            context.put("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey", tconfig);
            tcon.invoke(target.getOwnerDocument(), context);
        }
        context.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
        klocator = config.getKeyLocator();
        Key key = klocator.getKey(type, context);
        context.remove(klocator.getClass());
        context.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS) || WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.DENIED)) {
            Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setExtendedAuditData(context, "TokenId", kname);
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "KeyInfoType", type.toString());
            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(auditContext, "Algorithm", key.getAlgorithm());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Element target,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private String getKeyName(Element target) throws SoapSecurityException {
        Element child;
        String kname;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKeyName(Element target[" + DOMUtil.getDisplayName((Node)target) + "])"));
        }
        if ((kname = DOMUtil.getStringValue((Node)(child = DOMUtil.getChildElement((Element)target, (String)Constants.NS_DSIG, (String)"KeyName")))) == null) {
            throw SoapSecurityException.format("security.wssecurity.KeyNameContentConsumer.getKeyName01");
        }
        String kn = KeyInfo.X509Data.encodeDName((String)kname);
        if (kn != null) {
            kname = kn;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyName(Element elem) returns String[" + kname + "]"));
        }
        return kname;
    }
}

