/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.wsspi.wssecurity.config.KeyLocatorConfig;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class KeyLocatorProxy {
    private static final TraceComponent tc = Tr.register(KeyLocatorProxy.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyLocatorProxy.class.getName();
    private KeyLocatorConfig _klocatorConf = null;

    public KeyLocatorProxy(KeyLocatorConfig klocatorConf) {
        this._klocatorConf = klocatorConf;
    }

    public KeyLocatorConfig getKeyLocatorConfig() {
        return this._klocatorConf;
    }

    public com.ibm.wsspi.wssecurity.keyinfo.KeyLocator getKeyLocator6(ClassLoader appClassLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyLocator6(ClassLoader appClassLoader)");
        }
        if (tc.isDebugEnabled() && appClassLoader != null) {
            Tr.debug(tc, "classloader [" + appClassLoader.getClass().getName() + "].");
        }
        com.ibm.wsspi.wssecurity.keyinfo.KeyLocator ret = null;
        if (this._klocatorConf != null) {
            HashMap<String, Object> type = new HashMap<String, Object>();
            HashMap<String, KeyLocatorConfig> properties = new HashMap<String, KeyLocatorConfig>();
            WSSFactory factory = WSSFactory.getInstance("soap");
            type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
            type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", this._klocatorConf.getClassName());
            if (appClassLoader != null) {
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classloader", appClassLoader);
            }
            properties.put("com.ibm.wsspi.wssecurity.config.keyLocator.configKey", this._klocatorConf);
            ret = (com.ibm.wsspi.wssecurity.keyinfo.KeyLocator)factory.createConsumer(type, properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyLocator6() returns KeyLocator[" + ret + "]");
        }
        return ret;
    }

    public KeyLocator getKeyLocator5(ClassLoader appClassLoader) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyLocator5(ClassLoader appClassLoader)");
        }
        KeyLocator ret = null;
        if (this._klocatorConf != null) {
            Map map = this._klocatorConf.getProperties();
            KeyLocatorConfig.KeyStoreConfig kstore = this._klocatorConf.getKeyStore();
            if (kstore != null) {
                String type;
                String storepass;
                String path = kstore.getPath();
                if (path != null) {
                    map.put("path", path);
                }
                if ((storepass = kstore.getPassword()) != null) {
                    map.put("storepass", storepass);
                }
                if ((type = kstore.getType()) != null) {
                    map.put("type", type);
                }
            }
            Iterator i = this._klocatorConf.getKeyInformationList().iterator();
            int suffix = 0;
            while (i.hasNext()) {
                String string;
                String keypass;
                KeyLocatorConfig.KeyInformationConfig ki = (KeyLocatorConfig.KeyInformationConfig)i.next();
                String alias = ki.getAlias();
                while (map.containsKey("name_" + suffix)) {
                    ++suffix;
                }
                if (alias != null) {
                    map.put("alias_" + suffix, alias);
                }
                if ((keypass = ki.getKeyPass()) != null) {
                    map.put("keypass_" + suffix, keypass);
                }
                if ((string = ki.getName()) == null) continue;
                map.put("name_" + suffix, string);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "readKeyLocator() - keystore name_" + suffix + ": " + string);
            }
            String className = this._klocatorConf.getClassName();
            if (tc.isDebugEnabled()) {
                HashMap copyOfMap = new HashMap(map);
                Set entries = copyOfMap.entrySet();
                Object var10_12 = null;
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    if (!key.equals("storepass") && !key.startsWith("keypass_")) continue;
                    entry.setValue("*****");
                }
                Tr.debug(tc, "Creating KeyLocator: ", new Object[]{className, copyOfMap});
            }
            ret = (KeyLocator)ConfigUtil.instantiate((String)className, KeyLocator.class, (Map)map, (ClassLoader)appClassLoader);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyLocator " + className + " created");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyLocator5() returns KeyLocator[" + ret + "]");
        }
        return ret;
    }
}

