/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContext;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestSenderConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseSenderConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSSenderLogin;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.WSSoapSecurityUtil;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecuritySender;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.token.SenderLoginComponent;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.Map;

public class WSSoapSecuritySenderBase
extends SoapSecuritySender {
    public static final String OPTION = GlobalSecurityHandler.class.getName() + ".configPath";
    protected static final String MESSAGE_CONTEXT = GlobalSecurityHandler.class.getName() + ".messageContext";
    private boolean isServer = true;
    private final WSSecurityPlatformContext contextManager = WSSecurityPlatformContextFactory.getInstance();
    private final ThreadLocal threadStore = new ThreadLocal();
    private static final Map globalStore = new HashMap();
    private static final TraceComponent tc = Tr.register(WSSoapSecuritySenderBase.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSoapSecuritySenderBase.class.getName();

    public void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    protected void initConfig(MessageContextProxy context) {
        String value;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initConfig(" + context + ")"));
        }
        if ((value = (String)this.getHandlerOption(GenericHandler.HANDLER_PARAM_ROLE)) != null && value.length() != 0) {
            this.isServer = value.equals(GenericHandler.HANDLER_PARAM_ROLE_SERVER);
        } else {
            boolean bl = this.isServer = !context.getPastPivot();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isServer=" + this.isServer));
        }
        try {
            if (this.isServer) {
                SenderConfig config = (SenderConfig)context.getConfig("ResponseSenderConfig");
                if (config == null) {
                    throw new IllegalArgumentException(ConfigConstants.getMessage("security.wssecurity.response.sender.config.isnull"));
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("SenderConfig class name=");
                    buf.append(config.getClass().getName());
                    buf.append(", source=");
                    if (config instanceof WSEMFResponseSenderConfig) {
                        buf.append(((WSEMFResponseSenderConfig)config).getOrigin());
                    } else {
                        buf.append("unknown");
                    }
                    buf.append(", SenderConfig=").append(config);
                    Tr.debug((TraceComponent)tc, (String)buf.toString());
                }
                this.setMessageOption(CONFIG_KEY, config);
            } else {
                SenderConfig config = (SenderConfig)context.getConfig("RequestSenderConfig");
                if (config == null) {
                    throw new IllegalArgumentException(ConfigConstants.getMessage("security.wssecurity.request.sender.config.isnull"));
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("SenderConfig class name=");
                    buf.append(config.getClass().getName());
                    buf.append(", source=");
                    if (config instanceof WSEMFRequestSenderConfig) {
                        buf.append(((WSEMFRequestSenderConfig)config).getOrigin());
                    } else {
                        buf.append("unknown");
                    }
                    buf.append(", SenderConfig=").append(config);
                    Tr.debug((TraceComponent)tc, (String)buf.toString());
                }
                if (config instanceof WSEMFRequestSenderConfig) {
                    WSEMFRequestSenderConfig xConfig = (WSEMFRequestSenderConfig)config;
                    String tmp = xConfig.getWSSENS();
                    if (tmp != null && tmp.length() != 0) {
                        context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSSENamespace", (Object)tmp);
                    }
                    if ((tmp = xConfig.getWSUNS()) != null && tmp.length() != 0) {
                        context.setConfig("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.requestWSUNamespace", (Object)tmp);
                    }
                }
                this.setMessageOption(CONFIG_KEY, config);
            }
            super.initConfig(context);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            Tr.processException((Throwable)e, (String)(clsName + ".init"), (String)"96", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.FileConfigSSR.init", (Object)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initConfig(MessageContextProxy context)");
        }
    }

    protected SenderLoginComponent createLoginComponent(MessageContextProxy context) {
        return new WSSenderLogin(this, context, this.contextManager.isServer());
    }

    public void invoke(MessageContextProxy context) throws FaultProxy {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(" + context + ")"));
        }
        if (WSSoapSecurityUtil.getServiceHandler((MessageContext)context.get()) != null) {
            super.invoke(context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(MessageContextProxy context)");
        }
    }

    public String toString() {
        return "WSSoapSecuritySenderBase(config=" + this.getMessageOption(CONFIG_KEY) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(Object key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObject(" + key + ")"));
        }
        Object ret = null;
        if (key != null && (ret = this.getThreadStore().get(key)) == null) {
            Map map = globalStore;
            synchronized (map) {
                ret = this.getGlobalStore().get(key);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getObject() " + (ret == null ? "not found" : "found")));
        }
        return ret;
    }

    void saveTempObject(String key, Object value) {
        MessageContextProxy proxy;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("saveTempObject(" + key + ", " + "XXX)"));
        }
        if (!this.contextManager.isServer() && key != null && (proxy = (MessageContextProxy)this.getMessageOption("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.messageContext")) != null) {
            proxy.setConfig(key, value);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Data for " + key + " is saved to temporary store"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveTempObject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveObject(String key, Object value) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("saveObject(" + key + ", " + "XXX)"));
        }
        if (!this.contextManager.isServer() && key != null) {
            Object obj = null;
            Map map = globalStore;
            synchronized (map) {
                obj = globalStore.get(key);
                if (obj == null) {
                    this.getGlobalStore().put(key, value);
                }
            }
            this.getThreadStore().put(key, value);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Data for " + key + " is saved to global store"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"saveObject");
        }
    }

    private Map getThreadStore() {
        HashMap map = (HashMap)this.threadStore.get();
        if (map == null) {
            map = new HashMap();
            this.threadStore.set(map);
        }
        return map;
    }

    private Map getGlobalStore() {
        return globalStore;
    }
}

