/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscext.LoginConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestSenderServiceConfig;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKey;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKey;
import com.ibm.etools.webservice.wscommonbnd.TokenValueType;
import com.ibm.etools.webservice.wscommonext.AddCreatedTimeStamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.ConfidentialPartPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.IDAssertion;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ClientVariableMap;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSEMFRequestSenderConfig
extends PrivateSenderConfig {
    private String wsseNS = com.ibm.xml.soapsec.Constants.NS_WSSE;
    private String wsuNS = com.ibm.xml.soapsec.Constants.NS_WSU;
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register(WSEMFRequestSenderConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFRequestSenderConfig.class.getName();

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig reqSndBnd, SecurityRequestSenderServiceConfig reqSndExt, String actorURI, VariableMap varMap, WSSecurityService service) throws SoapSecurityException {
        this(reqSndBnd, reqSndExt, actorURI, varMap, service, null, null);
    }

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig reqSndBnd, SecurityRequestSenderServiceConfig reqSndExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader) throws SoapSecurityException {
        this(reqSndBnd, reqSndExt, actorURI, varMap, service, null, null);
    }

    public WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig reqSndBnd, SecurityRequestSenderServiceConfig reqSndExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader, PortQnameBinding portQnBnd) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestSenderConfig(SecurityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portQnBnd):", new Object[]{reqSndBnd, reqSndExt, actorURI, varMap, service, appClassLoader});
        }
        this.init(reqSndBnd, reqSndExt, actorURI, varMap, service, appClassLoader, portQnBnd);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFRequestSenderConfig()");
        }
    }

    WSEMFRequestSenderConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFRequestSenderConfig()");
            Tr.exit(tc, "WSEMFRequestSenderConfig()");
        }
    }

    final void init(SecurityRequestSenderBindingConfig reqSndBnd, SecurityRequestSenderServiceConfig reqSndExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader, PortQnameBinding portQnBnd) throws SoapSecurityException {
        String name;
        int i;
        String tmpActor;
        EList p;
        Object dconfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityRequestSenderBindingConfig, SecurityRequestSenderServiceConfig, actorURI, VariableMap, Object, ClassLoader, portQnBnd):", new Object[]{reqSndBnd, reqSndExt, actorURI, varMap, service, appClassLoader});
        }
        AddCreatedTimeStamp addCreatedTimeStamp = null;
        Confidentiality confidentiality = null;
        Integrity integrity = null;
        LoginConfig loginConfig = null;
        IDAssertion idAssertion = null;
        String actor = null;
        if (varMap == null) {
            varMap = ClientVariableMap.getInstance();
        }
        WSSecurityDefaultConfiguration config = null;
        if (service != null && (dconfig = service.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            config = (WSSecurityDefaultConfiguration)dconfig;
        }
        Map defaultProps = null;
        Map extProperties = null;
        Map bndProperties = null;
        Map bndParameters = null;
        this._properties = new HashMap();
        if (config != null) {
            WSSGeneratorConfig dgconfig = config.getDefaultGeneratorBinding();
            if (dgconfig != null) {
                defaultProps = dgconfig.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            } else {
                defaultProps = config.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            }
        }
        if (reqSndExt != null && (p = reqSndExt.getProperties()) != null && (extProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(extProperties);
        }
        if (portQnBnd != null && (p = portQnBnd.getParameters()) != null && (bndParameters = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndParameters);
        }
        if (reqSndBnd != null && (p = reqSndBnd.getProperties()) != null && (bndProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndProperties);
        }
        if (reqSndExt != null) {
            confidentiality = reqSndExt.getConfidentiality();
            integrity = reqSndExt.getIntegrity();
            actor = reqSndExt.getActor();
            loginConfig = reqSndExt.getLoginConfig();
            idAssertion = reqSndExt.getIdAssertion();
            addCreatedTimeStamp = reqSndExt.getAddCreatedTimeStamp();
            if (tc.isDebugEnabled()) {
                if (extProperties != null) {
                    Tr.debug(tc, "Request Sender Service Config(Confidentiality, Integrity, Actor, LoginConfig, IdAssertion, AddCreatedTimeStamp, Properties):", new Object[]{confidentiality, integrity, actor, loginConfig, idAssertion, addCreatedTimeStamp, extProperties});
                } else {
                    Tr.debug(tc, "Request Sender Service Config(Confidentiality, Integrity, Actor, LoginConfig, IdAssertion, AddCreatedTimeStamp):", new Object[]{confidentiality, integrity, actor, loginConfig, idAssertion, addCreatedTimeStamp});
                }
            }
        }
        this.clientSetMustUnderstand = ConfigUtil.getIsFalseProperty((Map)this._properties, (String)Constants.WSSECURITY_SET_MUSTUNDERSTAND);
        ConfigValidation valid = new ConfigValidation(varMap, config);
        if (!valid.confidentialityValid(confidentiality)) {
            throw new SoapSecurityException("Invalid Confidentiality");
        }
        if (!valid.integrityValid(integrity)) {
            throw new SoapSecurityException("Invalid Integrity");
        }
        if (!valid.idAssertionValid(idAssertion)) {
            throw new SoapSecurityException("Invalid IDAssertion");
        }
        if (actorURI != null) {
            tmpActor = actorURI.trim();
            if (tmpActor.length() != 0) {
                this.myactor = tmpActor;
            }
        } else {
            this.myactor = null;
        }
        if (actor != null) {
            tmpActor = actor.trim();
            if (tmpActor.length() != 0) {
                this.targetactor = tmpActor;
            }
        } else {
            this.targetactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor + ", actor = " + this.targetactor);
        }
        if (addCreatedTimeStamp != null) {
            this.enableCreatedTimestamp = addCreatedTimeStamp.isFlag();
            String value = addCreatedTimeStamp.getExpires();
            if (value != null && value.length() > 0) {
                try {
                    this.duration = Duration.parse((String)value);
                }
                catch (ParseException pe) {
                    String msgKey = "security.wssecurity.CommonSenderConfig.sconf07";
                    FFDCFilter.processException((Throwable)pe, clsName + ".WSEMFRequestSenderConfig", "205", (Object)this);
                    Tr.error(tc, msgKey, value);
                    throw SoapSecurityException.format(msgKey, value, (Throwable)pe);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "addCreatedTimeStamp = " + this.enableCreatedTimestamp + ", expires = " + addCreatedTimeStamp.getExpires() + ", duration = " + this.duration);
            }
        }
        if (integrity != null) {
            int count = integrity.getReferences().size();
            for (i = 0; i < count; ++i) {
                Reference ref = (Reference)integrity.getReferences().get(i);
                ReferencePart refPart = ref.getPart();
                name = refPart.getName();
                this.integralParts.add(name);
                if (!name.equals("securitytoken")) continue;
                this.isSecTokenSigned = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "integrity constraints = " + this.integralParts + "signed security token = " + this.isSecTokenSigned);
            }
        }
        if (confidentiality != null) {
            int count = confidentiality.getConfidentialParts().size();
            for (i = 0; i < count; ++i) {
                ConfidentialPart confPart = (ConfidentialPart)confidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confPartPart = confPart.getPart();
                name = confPartPart.getName();
                this.confidentialParts.add(name);
                if (!name.equals("usernametoken")) continue;
                this.isUsernameTokenEncrypted = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "confidentiality constraints = " + this.confidentialParts + "encrypt username token = " + this.isUsernameTokenEncrypted);
            }
        }
        if (idAssertion != null) {
            this.idType = idAssertion.getIdType();
            this.idType = this.idType == null ? this.idType : this.idType.trim();
            this.trustMode = idAssertion.getTrustMode();
            String string = this.trustMode = this.trustMode == null ? this.trustMode : this.trustMode.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IDType = " + this.idType + "Trust Mode = " + this.trustMode);
            }
        }
        this.nonceManager = NonceManagerFactory.getInstance();
        if (loginConfig != null) {
            this.authMethod = loginConfig.getAuthMethod().trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthMethod = " + this.authMethod);
            }
            if (extProperties != null && !extProperties.isEmpty()) {
                String value = (String)extProperties.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce");
                if (value != null) {
                    if ((value = value.trim()).length() != 0) {
                        this.addNonce = Boolean.valueOf(value);
                        if (this.addNonce) {
                            if (!"BasicAuth".equals(this.authMethod)) {
                                this.addNonce = false;
                                this.addNonceTimestamp = false;
                                Tr.warning(tc, "security.wssecurity.WSEC0113W", new Object[]{this.authMethod});
                            } else {
                                this.addNonceTimestamp = true;
                            }
                        }
                    }
                } else {
                    this.addNonce = false;
                    this.addNonceTimestamp = false;
                }
                if ((value = (String)extProperties.get("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp")) != null && (value = value.trim()).length() != 0) {
                    this.addNonceTimestamp = Boolean.valueOf(value);
                    if (this.addNonceTimestamp && !this.addNonce) {
                        this.addNonceTimestamp = false;
                        Tr.warning(tc, "security.wssecurity.WSEC0114W");
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce enabled: " + this.addNonce + ", Nonce timestamp: " + this.addNonceTimestamp);
            }
        }
        EncryptionInfo encryptionInfo = null;
        EList keyLocators = null;
        LoginBinding loginBinding = null;
        SigningInfo signingInfo = null;
        if (reqSndBnd != null) {
            encryptionInfo = reqSndBnd.getEncryptionInfo();
            keyLocators = reqSndBnd.getKeyLocators();
            loginBinding = reqSndBnd.getLoginBinding();
            signingInfo = reqSndBnd.getSigningInfo();
            if (tc.isDebugEnabled()) {
                if (bndProperties != null) {
                    Tr.debug(tc, "Request Sender Service Config (EncryptionInfo, KeyLocators, LoginBinding, SigningInfo, Properties):", new Object[]{encryptionInfo, keyLocators, loginBinding, signingInfo, bndProperties});
                } else {
                    Tr.debug(tc, "Request Sender Service Config (EncryptionInfo, KeyLocators, LoginBinding, SigningInfo):", new Object[]{encryptionInfo, keyLocators, loginBinding, signingInfo});
                }
            }
            if (bndProperties != null || bndProperties.size() != 0) {
                String tmpNS = (String)bndProperties.get("com.ibm.ws.wssecurity.config.WSSE.Namespace");
                if (tmpNS != null && tmpNS.length() != 0) {
                    if (!NamespaceUtil.isWsse((String)tmpNS)) {
                        throw SoapSecurityException.format("security.wssecurity.WSEC0152E", tmpNS);
                    }
                    this.wsseNS = tmpNS;
                    this.wsuNS = NamespaceUtil.getCorrespondingWSUNS((String)this.wsseNS);
                }
                String tmpIN = (String)bndProperties.get(Constants.WSSECURITY_INCLUSIVE_NAMESPACES);
                this.inclusiveNamespaces = ConfigUtil.isTrue((String)tmpIN);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Namespace configured to be used to send the request, wsse=" + this.wsseNS + ", wsu=" + this.wsuNS);
            }
        }
        if (!valid.senderSigningInfoValid(signingInfo, null, null, integrity)) {
            throw new SoapSecurityException("Invalid sender SigningInfo");
        }
        if (!valid.encryptionInfoValid(encryptionInfo, keyLocators, confidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (!valid.loginBindingValid(loginBinding, loginConfig)) {
            throw new SoapSecurityException("Invalid LoginBinding");
        }
        if (encryptionInfo != null) {
            name = encryptionInfo.getName();
            EncryptionKey encryptionKey = encryptionInfo.getEncryptionKey();
            String encKeyName = null;
            String encKeyLocRef = null;
            if (encryptionKey != null) {
                encKeyName = encryptionKey.getName();
                encKeyLocRef = encryptionKey.getLocatorRef();
            }
            DataEncryptionMethod dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
            String dataEncAlg = null;
            if (dataEncryptionMethod != null) {
                dataEncAlg = dataEncryptionMethod.getAlgorithm();
            }
            KeyEncryptionMethod keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
            String keyEncAlg = null;
            if (keyEncryptionMethod != null) {
                keyEncAlg = keyEncryptionMethod.getAlgorithm();
            }
            KeyLocator locator = ConfigConstants.findKeyLocator(keyLocators, encKeyLocRef, varMap, config, appClassLoader);
            if (dataEncAlg == null || encKeyName == null || locator == null) {
                String msgKey = "security.wssecurity.IncompleteEncryptionInfo";
                if (dataEncAlg == null) {
                    Tr.warning(tc, msgKey, "Data Encryption Algorithm");
                }
                if (encKeyName == null) {
                    Tr.warning(tc, msgKey, "Encryption Key Name");
                }
                if (locator == null) {
                    Tr.warning(tc, msgKey, "Key Locator");
                }
            }
            this.encryptionSettings = new EncryptionSettings(dataEncAlg, keyEncAlg, encKeyName, locator);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption Info Name = " + name + "Encryption Key Name = " + encKeyName + "Encryption KeyLocatorRef = " + encKeyLocRef + "Encryption Data Algorithm = " + dataEncAlg + "Encryption Key Algorithm = " + keyEncAlg);
            }
        }
        if (loginBinding != null) {
            TokenValueType tokenValueType;
            String cbhClassName = null;
            String defaultId = null;
            char[] defaultPass = null;
            Map properties = null;
            BasicAuth basicAuth = loginBinding.getBasicAuth();
            if (basicAuth != null) {
                defaultId = basicAuth.getUserid();
                defaultPass = basicAuth.getPassword().toCharArray();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Basic-Auth(" + defaultId + ", XXXXXXXX)");
                }
            }
            if ((tokenValueType = loginBinding.getTokenValueType()) != null) {
                this.tokenValueType = new QName(tokenValueType.getUri(), tokenValueType.getLocalName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TokenValue(" + tokenValueType.getUri() + ", " + tokenValueType.getLocalName() + ")");
                }
            }
            cbhClassName = loginBinding.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CallbackHandler Class Name = " + cbhClassName);
            }
            int count = loginBinding.getProperties().size();
            for (int i2 = 0; i2 < count; ++i2) {
                Property property = (Property)loginBinding.getProperties().get(i2);
                if (varMap == null) {
                    properties.put(property.getName(), property.getValue());
                } else {
                    properties.put(property.getName(), varMap.expand(property.getValue()));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "CallbackHandler Properties = " + properties);
            }
            if (cbhClassName != null) {
                try {
                    Class<?> cls = Class.forName(cbhClassName);
                    Constructor<?> constructor = cls.getConstructor(String.class, char[].class, Map.class);
                    this.callbackHandler = (CallbackHandler)constructor.newInstance(defaultId, defaultPass, properties);
                }
                catch (Exception e) {
                    throw SoapSecurityException.format(com.ibm.xml.soapsec.Constants.getQName((String)this.getWSSENS(), (String)"InvalidSecurity"), "security.wssecurity.RequestSenderConfig.token28", e.toString());
                }
            }
        }
        if (signingInfo != null) {
            SigningKey signingKey;
            CanonicalizationMethod c14nMethod = signingInfo.getCanonicalizationMethod();
            String c14nAlgorithm = null;
            if (c14nMethod == null) {
                Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
            } else {
                c14nAlgorithm = c14nMethod.getAlgorithm();
            }
            this.c14nMethod = c14nAlgorithm;
            SignatureMethod signatureMethod = signingInfo.getSignatureMethod();
            String signatureAlgorithm = null;
            if (signatureMethod == null) {
                Tr.warning(tc, "security.wssecurity.nosignature.algo");
            } else {
                signatureAlgorithm = signatureMethod.getAlgorithm();
            }
            this.signatureMethod = signatureAlgorithm;
            DigestMethod digestMethod = signingInfo.getDigestMethod();
            String digestAlgorithm = null;
            if (digestMethod == null) {
                Tr.warning(tc, "security.wssecurity.nodigest.algo");
            } else {
                digestAlgorithm = digestMethod.getAlgorithm();
            }
            this.digestMethod = digestAlgorithm;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Signature Canonicalization Algorithm = " + this.c14nMethod + "Signature Algorithm = " + this.signatureMethod + "Signature Digest Algorithm = " + this.digestMethod);
            }
            if ((signingKey = signingInfo.getSigningKey()) != null) {
                String signingKeyLocRef = signingKey.getLocatorRef();
                this.keyName = signingKey.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Signature Keyname = " + this.keyName + "Signature KeyLocatorRef = " + signingKeyLocRef);
                }
                this.keyLocator = ConfigConstants.findKeyLocator(keyLocators, signingKeyLocRef, varMap, config, appClassLoader);
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)true));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogProperties(defaultProps, bndParameters, extProperties, bndProperties, "request", "sender"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }

    final String getWSSENS() {
        return this.wsseNS;
    }

    final String getWSUNS() {
        return this.wsuNS;
    }
}

