/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.enc;

import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSAlgorithmFactory;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.config.AlgorithmConfig;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.ResultMessagePool;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.enc.DecryptionResult;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xss4j.enc.DecryptionContext;
import com.ibm.ws.wssecurity.xss4j.enc.ResourceShower;
import com.ibm.ws.wssecurity.xss4j.enc.type.DataReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedData;
import com.ibm.ws.wssecurity.xss4j.enc.type.EncryptedKey;
import com.ibm.ws.wssecurity.xss4j.enc.type.KeyReference;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceList;
import com.ibm.ws.wssecurity.xss4j.enc.type.ReferenceType;
import com.ibm.ws.wssecurity.xss4j.enc.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptionConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(EncryptionConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = EncryptionConsumer.class.getName();
    private IdUtil _idResolver = null;
    private Map _selectors = null;
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._selectors = map;
            this._idResolver = (IdUtil)((Object)map.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver"));
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        int hash = 0;
        if (target == null) {
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s13");
        }
        String ns = target.getNamespaceURI();
        String ln = target.getLocalName();
        hash = ns == null ? 0 : ns.hashCode() * 31;
        if (target.getNodeType() != 1 || (hash += ln == null ? 0 : ln.hashCode()) != Constants.HASH_ENC_ENCRYPTEDKEY && hash != Constants.HASH_ENC_REFERENCELIST) {
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)target));
        }
        Element xenc = (Element)target;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        WSSConsumerConfig gconfig = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        EncryptionConsumerConfig config = (EncryptionConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.encryptionConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("EncryptionConsumerConfig [" + config + "]."));
        }
        if (EncryptedKey.isOfType((Element)xenc)) {
            EncryptionConsumer.checkEncryptedKey(xenc, config);
        } else {
            EncryptionConsumer.checkReferenceList(xenc, config);
        }
        HashMap type = new HashMap();
        Document doc = xenc.getOwnerDocument();
        DecryptionResult dresult = EncryptionConsumer.decrypt(xenc, config, this._idResolver, doc, gconfig, type, this._selectors, nsWsse, nsWsu, context);
        EncryptionConsumer.setDecryptionResult(dresult, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static void checkEncryptedKey(Element enckey, EncryptionConsumerConfig config) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkEncryptedKey(Element enckey[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)enckey) + "]," + "EncryptionConsumerConfig config)"));
        }
        int hash = 0;
        Element el = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getFirstElement((Node)enckey);
        while (el != null) {
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_ENCRYPTIONMETHOD) {
                String algorithm = el.getAttribute("Algorithm");
                if (config.getKeyEncryptionMethod() == null || !config.getKeyEncryptionMethod().getAlgorithm().equals(algorithm)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s15", algorithm);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " [" + algorithm + "] is OK."));
                }
            } else if (hash == Constants.HASH_ENC_REFERENCELIST) {
                EncryptionConsumer.checkReferenceList(el, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (hash == Constants.HASH_ENC_CIPHERDATA || hash == Constants.HASH_DS_KEYINFO) {
                EncryptionConsumer.checkCipherData(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (hash == Constants.HASH_ENC_CARRIEDKEYNAME || hash == Constants.HASH_ENC_ENCRYPTIONPROPS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK. But this consumer ignores it."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: There is unknown element " + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)el) + " in the " + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)enckey) + " element."));
            }
            el = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getNextElement((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkEncryptedKey(Element enckey,EncryptionConsumerConfig config)");
        }
    }

    private static void checkReferenceList(Element reflist, EncryptionConsumerConfig config) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkReferenceList(Element reflist[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)reflist) + "]," + "EncryptionConsumerConfig config)"));
        }
        if (config != null && config.getKeyEncryptionMethod() != null && config.getKeyEncryptionMethod().getAlgorithm().length() > 0) {
            throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.EncryptionConsumer.s12", config.getKeyEncryptionMethod().getAlgorithm());
        }
        int hash = 0;
        Element el = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getFirstElement((Node)reflist);
        while (el != null) {
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_DATAREFERENCE || hash == Constants.HASH_ENC_KEYREFERENCE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: There is unknown element " + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)el) + " in the " + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)reflist) + " element."));
            }
            el = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getNextElement((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkReferenceList(Element reflist,EncryptionConsumerConfig config)");
        }
    }

    private static void checkEncryptedData(Element encdata, EncryptionConsumerConfig config) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkEncryptedKey(Element encdata[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)encdata) + "]," + "EncryptionConsumerConfig config)"));
        }
        int hash = 0;
        Element el = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getFirstElement((Node)encdata);
        while (el != null) {
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_ENCRYPTIONMETHOD) {
                String algorithm = el.getAttribute("Algorithm");
                if (!config.getDataEncryptionMethod().getAlgorithm().equals(algorithm)) {
                    throw SoapSecurityException.format(Constants.UNSUPPORTED_ALGORITHM, "security.wssecurity.PrivateConsumerConfig.s14", algorithm);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " [" + algorithm + "] is OK."));
                }
            } else if (hash == Constants.HASH_ENC_CIPHERDATA) {
                EncryptionConsumer.checkCipherData(el);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (hash == Constants.HASH_DS_KEYINFO) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (hash == Constants.HASH_ENC_ENCRYPTIONPROPS) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK. But this consumer igonores it."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: There is unknown element " + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)el) + " in the " + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)encdata) + " element."));
            }
            el = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getNextElement((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkEncryptedData(Element encdata,EncryptionConsumerConfig config)");
        }
    }

    private static void checkCipherData(Element cipdata) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkCipherData(Element cipdata[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)cipdata) + "])"));
        }
        int hash = 0;
        Element el = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getFirstElement((Node)cipdata);
        while (el != null) {
            String ns = el.getNamespaceURI();
            String ln = el.getLocalName();
            hash = ns == null ? 0 : ns.hashCode() * 31;
            if ((hash += ln == null ? 0 : ln.hashCode()) == Constants.HASH_ENC_CIPHERVALUE || hash == Constants.HASH_ENC_CIPHERREFERENCE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(ln + " is OK."));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING: There is unknown element " + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)el) + " in the " + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getQualifiedName((Node)cipdata) + " element."));
            }
            el = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getNextElement((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCipherData(Element cipdata)");
        }
    }

    private static DecryptionResult decrypt(Element target, EncryptionConsumerConfig config, IdUtil idResolver, Document document, WSSConsumerConfig gconfig, Map type, Map properties, String nsWsse, String nsWsu, Map context) throws SoapSecurityException {
        Token token;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("decrypt(Element target[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)target) + "]," + "EncryptionConsumerConfig config," + "IdUtil idResolver[" + (Object)((Object)idResolver) + "]," + "Document document[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)document) + "]," + "WSSConsumerConfig gconfig," + "Map type," + "Map properties," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)"));
        }
        ArrayList<DecryptionResult.DecryptedPart> parts = new ArrayList<DecryptionResult.DecryptedPart>();
        DecryptionContext dcontext = new DecryptionContext();
        dcontext.setIdResolver((IDResolver)idResolver);
        WSSAlgorithmFactory afactory = gconfig.getAlgorithmFactory();
        dcontext.setAlgorithmFactory((AlgorithmFactory)afactory);
        if (tc.isDebugEnabled()) {
            dcontext.setResourceShower((ResourceShower)ShowerImpl.getInstance());
        }
        Map gprops = gconfig.getProperties();
        dcontext.setHWConfigName((String)gprops.get("HWCONFIG"));
        String cryptoOffload = (String)gprops.get("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        dcontext.setHWKeyStoreName((String)context.remove("com.ibm.ws.wssecurity.config.keystore.keyStoreRef"));
        String encAlgorithm = null;
        AlgorithmConfig encMethod = config.getKeyEncryptionMethod();
        if (encMethod != null) {
            encAlgorithm = encMethod.getAlgorithm();
        }
        dcontext.setEncAlgorithm(encAlgorithm);
        dcontext.setOffload(Boolean.TRUE);
        if (dcontext.shouldChangeProvider()) {
            Provider p;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HARDWARE Acceleration enabled, Key Store Name is: ", (Object)dcontext.getHWConfigName());
            }
            if ((p = ConfigUtil.getHWCryptoProviderInstance((String)dcontext.getHWConfigName())) == null) {
                Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware acceleration, continue processing.");
            } else {
                Integer hardwareCacheSize = (Integer)gprops.get("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
                dcontext.setHWAccelerationProvider(p, hardwareCacheSize);
                dcontext.setCryptoOffloadProperty(cryptoOffload);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for HW Acceleration" + p.getName()));
                }
            }
        }
        List ids = EncryptionConsumer.getIds(target);
        Key kek = null;
        Key dek = null;
        for (String id : ids) {
            Element el = idResolver.resolveID(document, id);
            if (el != null) {
                if (EncryptedData.isOfType((Element)el)) {
                    Provider p2;
                    String defaultHWKSRef;
                    Provider p;
                    EncryptionConsumer.checkEncryptedData(el, config);
                    if (EncryptedKey.isOfType((Element)target)) {
                        if (kek == null) {
                            kek = SignatureConsumer.callKeyInfoConsumer(config.getEncryptionKeyInfo(), "DecryptingKey", type, properties, KeyInfo.searchForKeyInfo((Element)target), context);
                            if (dcontext.useHWKeyStore()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)dcontext.getHWKeyStoreName());
                                }
                                if ((p = ConfigUtil.getHWCryptoProviderInstance((String)dcontext.getHWKeyStoreName())) == null) {
                                    Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                } else {
                                    dcontext.setHWKeyStoreProvider(p);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p.getName()));
                                    }
                                }
                            } else if (kek instanceof PKCS11Key && !dcontext.shouldChangeProvider()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
                                }
                                if ((defaultHWKSRef = (String)gprops.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                                    dcontext.setHWKeyStoreName(defaultHWKSRef);
                                    if (dcontext.useHWKeyStore()) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)dcontext.getHWKeyStoreName());
                                        }
                                        if ((p2 = ConfigUtil.getHWCryptoProviderInstance((String)dcontext.getHWKeyStoreName())) == null) {
                                            Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                        } else {
                                            dcontext.setHWKeyStoreProvider(p2);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p2.getName()));
                                            }
                                        }
                                    } else {
                                        Tr.error((TraceComponent)tc, (String)"Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for encrypt/decrypt");
                                        throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                                    }
                                }
                            }
                        }
                        if (dek == null) {
                            dek = EncryptionConsumer.decryptEncryptedKey(target, dcontext, kek, el);
                        }
                    } else {
                        dek = SignatureConsumer.callKeyInfoConsumer(config.getEncryptionKeyInfo(), "DecryptingKey", type, properties, KeyInfo.searchForKeyInfo((Element)el), context);
                        if (dcontext.useHWKeyStore()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)dcontext.getHWKeyStoreName());
                            }
                            if ((p = ConfigUtil.getHWCryptoProviderInstance((String)dcontext.getHWKeyStoreName())) == null) {
                                Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                            } else {
                                dcontext.setHWKeyStoreProvider(p);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p.getName()));
                                }
                            }
                        } else if (kek instanceof PKCS11Key && !dcontext.shouldChangeProvider()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"PKCS11 Key is in use, but did not find hardware keystore/acceleration in the config");
                            }
                            if ((defaultHWKSRef = (String)gprops.get("com.ibm.ws.wssecurity.config.keystore.DefaultHWKeyStore")) != null) {
                                dcontext.setHWKeyStoreName(defaultHWKSRef);
                                if (dcontext.useHWKeyStore()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"HARDWARE Key Store Name is: ", (Object)dcontext.getHWKeyStoreName());
                                    }
                                    if ((p2 = ConfigUtil.getHWCryptoProviderInstance((String)dcontext.getHWKeyStoreName())) == null) {
                                        Tr.audit((TraceComponent)tc, (String)"Failure to get Hardware crypto provider instance to use hardware keystore, continue processing.");
                                    } else {
                                        dcontext.setHWKeyStoreProvider(p2);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("HW crypto provider instance for the HW KeyStore" + p2.getName()));
                                        }
                                    }
                                } else {
                                    Tr.error((TraceComponent)tc, (String)"Missing Hardware KeyStore Configuration, cannot use the PKCS11 type for encrypt/decrypt");
                                    throw SoapSecurityException.format("Missing Hardware KeyStore Configuration");
                                }
                            }
                        }
                    }
                    DecryptionResult.DecryptedPart dpart = EncryptionConsumer.decryptEncryptedData(el, dcontext, dek, nsWsse, nsWsu, context);
                    parts.add(dpart);
                } else {
                    throw SoapSecurityException.format("security.wssecurity.EncryptionReceiver.enc13", el.getTagName());
                }
            }
            if (!dcontext.useHWKeyStore()) continue;
            ConfigUtil.returnHWCryptoProviderInstance((String)dcontext.getHWKeyStoreName(), (Provider)dcontext.getHWKeyStoreProvider());
            dcontext.setHWKeyStoreProvider(null);
            dcontext.setHWKeyStoreName(null);
        }
        if (dcontext.isHWAccelerationProvider()) {
            ConfigUtil.returnHWCryptoProviderInstance((String)dcontext.getHWConfigName(), (Provider)dcontext.getHWAccelerationProvider());
        }
        if (dcontext.useHWKeyStore()) {
            ConfigUtil.returnHWCryptoProviderInstance((String)dcontext.getHWKeyStoreName(), (Provider)dcontext.getHWKeyStoreProvider());
        }
        dcontext.clearLocalProviderMap();
        DecryptionResult dresult = new DecryptionResult(config, parts);
        dresult._token = token = EncryptionConsumer.getToken(dresult, config, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("decrypt(Element target,EncryptionConsumerConfig config,IdUtil idResolver,Document document,WSSConsumerConfig gconfig,Map type,Map properties,String nsWsse,String nsWsu,Map context) returns DecryptionResult[" + dresult + "]"));
        }
        return dresult;
    }

    private static List getIds(Element target) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getIds(Element target[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)target) + "])"));
        }
        Element refList = null;
        if (EncryptedKey.isOfType((Element)target)) {
            refList = com.ibm.ws.webservices.wssecurity.util.DOMUtil.getChildElement((Element)target, (String)Constants.NS_ENC, (String)"ReferenceList");
        } else if (ReferenceList.isOfType((Element)target)) {
            refList = target;
        }
        ArrayList<String> ids = new ArrayList<String>();
        if (refList != null) {
            ReferenceList refList2 = new ReferenceList(refList);
            for (ReferenceType refType : refList2.getReferences()) {
                if (refType instanceof DataReference) {
                    String uri = ((DataReference)refType).getURI();
                    if (uri == null) {
                        throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s01");
                    }
                    if (uri.length() <= 1 || uri.charAt(0) != '#') continue;
                    ids.add(uri.substring(1));
                    continue;
                }
                if (!(refType instanceof KeyReference)) continue;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getIds(Element target) returns List[" + ids + "]"));
        }
        return ids;
    }

    private static Key decryptEncryptedKey(Element enckey, DecryptionContext dcontext, Key kek, Element encdata) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("decryptEncryptedKey(Element enckey[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)enckey) + "]," + "DecryptionContext dcontext[" + dcontext + "]," + "Key kek[" + kek + "]," + "Element encData[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)encdata) + "])"));
        }
        Key dek = null;
        try {
            dcontext.setEncryptedType(enckey, null, null, null);
            dcontext.setEncryptionMethod(com.ibm.ws.webservices.wssecurity.util.DOMUtil.getChildElement((Element)encdata, (String)Constants.NS_ENC, (String)"EncryptionMethod"));
            if (dcontext.isHWAccelerationProvider()) {
                dcontext.setHWKey(kek);
            } else {
                dcontext.setKey(kek);
            }
            dcontext.decrypt();
            dek = (Key)dcontext.getData();
            dcontext.setEncryptionMethod(null);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception from decrypting the key: ", (Object)e);
            }
            Tr.processException((Throwable)e, (String)(clsName + ".decryptEncryptedKey"), (String)"586");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionConsumer.s11", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("decryptEncryptedKey(Element enckey,DecryptionContext dcontext,Key kek,Element encdata) returns Key[" + dek + "]"));
        }
        return dek;
    }

    private static DecryptionResult.DecryptedPart decryptEncryptedData(Element encdata, DecryptionContext dcontext, Key dek, String nsWsse, String nsWsu, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("decryptEncryptedData(Element encdata[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)encdata) + "]," + "DecryptionContext dcontext[" + dcontext + "]," + "Key kek[" + dek + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "Map context)"));
        }
        DecryptionResult.DecryptedPart dpart = null;
        try {
            Node parent = null;
            if (DOMUtil.hasParentNode((Node)encdata)) {
                parent = encdata.getParentNode();
            }
            dcontext.setEncryptedType(encdata, null, null, null);
            dcontext.setKey(dek);
            dcontext.decrypt();
            dcontext.replace();
            dpart = EncryptionConsumer.createDecryptedPart(encdata, dcontext, nsWsse, nsWsu, context, parent);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, (String)(clsName + ".decryptEncryptedData"), (String)"628");
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.EncryptionConsumer.s11", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.EncryptionConsumer.s11", e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("decryptEncryptedData(Element encdata,DecryptionContext dcontext,Key dek,String nsWsse,String nsWsu,Map context) returns DecryptedPart[" + dpart + "]"));
        }
        return dpart;
    }

    private static DecryptionResult.DecryptedPart createDecryptedPart(Element encdata, DecryptionContext dcontext, String nsWsse, String nsWsu, Map context, Node parent) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createDecryptedPart(Element encdata[" + com.ibm.ws.webservices.wssecurity.util.DOMUtil.getDisplayName((Node)encdata) + "]," + "DecryptionContext dcontext[" + dcontext + "]," + "String nsWsse[" + nsWsse + "]," + "String nsWsu[" + nsWsu + "]," + "Map context," + "Node parent)"));
        }
        boolean noncefirst = false;
        String type = dcontext.getType();
        DecryptionResult.DecryptedPart dpart = null;
        NodeList list = dcontext.getDataAsNodeList();
        int length = list.getLength();
        if (length > 0) {
            Node node = list.item(0);
            if (type.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
                Element elem = (Element)node;
                String id = IdUtil.getInstance().getId(elem);
                Element timestamp = NonceUtil.getTimestamp(elem, nsWsu);
                Element nonce = NonceUtil.getNonce(elem, nsWsse);
                noncefirst = NonceUtil.isNonceFirst(elem, nonce, timestamp);
                dpart = new DecryptionResult.DecryptedPart(type, id, elem, nonce, timestamp, noncefirst);
                ResultMessagePool.addElement(context, encdata, elem);
            } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Content") && (node = node.getParentNode()) != null && node.getNodeType() == 1) {
                Element elem = (Element)node;
                String id = IdUtil.getInstance().getId(elem);
                Element timestamp = NonceUtil.getTimestamp(elem, nsWsu);
                Element nonce = NonceUtil.getNonce(elem, nsWsse);
                noncefirst = NonceUtil.isNonceFirst(elem, nonce, timestamp);
                dpart = new DecryptionResult.DecryptedPart(type, id, elem, nonce, timestamp, noncefirst);
            }
        } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Content") && parent != null && parent.getNodeType() == 1) {
            Element elem = (Element)parent;
            String id = IdUtil.getInstance().getId(elem);
            Element timestamp = NonceUtil.getTimestamp(elem, nsWsu);
            Element nonce = NonceUtil.getNonce(elem, nsWsse);
            noncefirst = NonceUtil.isNonceFirst(elem, nonce, timestamp);
            dpart = new DecryptionResult.DecryptedPart(type, id, elem, nonce, timestamp, noncefirst);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createDecryptedPart(Element encdata,DecryptionContext dcontext,String nsWsse,String nsWsu,Map context,Node parent) returns DecryptedPart[" + dpart + "]"));
        }
        return dpart;
    }

    private static void setDecryptionResult(DecryptionResult dresult, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setDecryptionResult(DecryptionResult dresult[" + dresult + "]," + "Map context)"));
        }
        for (DecryptionResult.DecryptedPart part : dresult._decryptedParts) {
            SignatureConsumer.removeNode(part._timestamp, "weenc");
            SignatureConsumer.removeNode(part._nonce, "weenc");
        }
        ResultPool.add((Map)context, (Result)dresult);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDecryptionResult(DecryptionResult dresult,Map context)");
        }
    }

    private static KeyInfoResult[] getKeyInfoResults(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyInfoResults(Map context)");
        }
        KeyInfoResult[] kresults = null;
        Result[] results = ResultPool.get((Map)context, KeyInfoResult.class);
        if (results != null) {
            kresults = new KeyInfoResult[results.length];
            for (int i = 0; i < results.length; ++i) {
                kresults[i] = (KeyInfoResult)results[i];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyInfoResults(Map context) returns KeyInfoResult[][" + kresults + "]"));
        }
        return kresults;
    }

    private static KeyInfoResult getProcessedResult(DecryptionResult dresult, KeyInfoResult[] results, List kclist) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProcessedResult(DecryptionResult dresult,KeyInfoResult[] results,List kclist");
        }
        KeyInfoResult result = null;
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                if (result == null && kclist.contains(r.getKeyInfoContentConsumer()) && r.getError() == null) {
                    result = r;
                    continue;
                }
                dresult._kresults.put(r.getKeyInfoContentConsumer(), r);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProcessedResult(DecryptionResult vresult,KeyInfoResult[] results,List kclist) returns KeyInfoResult[" + result + "]"));
        }
        return result;
    }

    private static Token getToken(DecryptionResult dresult, EncryptionConsumerConfig econfig, Map context) throws SoapSecurityException {
        List vlist;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getToken(DecryptionResult dresult[" + dresult + "]," + "EncryptionConsumerConfig econfig," + "Map context)"));
        }
        Token token = null;
        Set tokens = null;
        KeyInfoResult[] results = EncryptionConsumer.getKeyInfoResults(context);
        KeyInfoResult kresult = EncryptionConsumer.getProcessedResult(dresult, results, econfig.getEncryptionKeyInfo().getContentConsumers());
        if (kresult != null) {
            String id = kresult.getIdInSubject();
            token = TokenManager.getToken(context, kresult.getKeyInfoContentConsumer().getTokenConsumer(), id);
            if (token != null) {
                if (token.getError() != null) {
                    throw token.getError();
                }
                token.setReferenced(true);
            }
            tokens = TokenManager.getTokens(context, id);
        }
        if ((vlist = econfig.getIdentityList()) != null && vlist.size() > 0) {
            for (EncryptionConsumerConfig config : vlist) {
                block1: for (KeyInfoContentConsumerConfig kiconfig : config.getEncryptionKeyInfo().getContentConsumers()) {
                    for (int k = 0; k < results.length; ++k) {
                        if (!kiconfig.equals(results[k].getKeyInfoContentConsumer())) continue;
                        dresult._identities.put(config, results[k]);
                        continue block1;
                    }
                }
            }
        }
        if (tokens != null && tokens.size() > 0) {
            block3: for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = results[i];
                TokenConsumerConfig tconfig = r.getKeyInfoContentConsumer().getTokenConsumer();
                if (tconfig == null) continue;
                for (Token t : tokens) {
                    if (!tconfig.equals(t.getUsedTokenConsumer())) continue;
                    dresult._kresults.put(r, t);
                    continue block3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(DecryptionResult dresult,EncryptionConsumerConfig econfig,Map context) returns Token[" + token + "]"));
        }
        return token;
    }

    private static class ShowerImpl
    implements ResourceShower {
        private static ShowerImpl _instance = new ShowerImpl();

        private ShowerImpl() {
        }

        private static ShowerImpl getInstance() {
            return _instance;
        }

        public void showEncryptedResource(byte[] content, Object data, Element encType) {
            String dumpData = null;
            try {
                dumpData = EncryptedData.isOfType((Element)encType) ? new String(content, "UTF-8") : Base64.encode((byte[])content);
            }
            catch (Exception e) {
                Tr.debug((TraceComponent)tc, (String)"WARNING: An exception occured while the content is encoded with [UTF-8].");
            }
            if (EncryptedData.isOfType((Element)encType)) {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs decrypt-" + encType.getAttribute("Id") + ": " + dumpData));
            } else {
                Tr.debug((TraceComponent)tc, (String)("ResourceShower logs decrypt-EncryptedKey: " + dumpData));
            }
        }
    }
}

