/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.dsig;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.dsig.Canonicalizer;
import com.ibm.ws.webservices.wssecurity.dsig.ExclusiveCanonicalizer;
import com.ibm.ws.webservices.wssecurity.dsig.STRDTKeyInfoResolver;
import com.ibm.ws.webservices.wssecurity.dsig.WSSSignatureContext;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STRDereferenceTransformer
extends Transform {
    private static final TraceComponent tc = Tr.register(STRDereferenceTransformer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = STRDereferenceTransformer.class.getName();
    public static final String STRT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private String _nsWsse = Constants.NS_WSSE;
    private String _nsWsu = Constants.NS_WSU;
    private Document _document;
    private IDResolver _idResolver;
    private STRDTKeyInfoResolver _kiResolver;
    private String _c14nMethod;
    private Hashtable _prefixList;
    private String _keyInfoSignature;

    public String getURI() {
        return STRT;
    }

    public Element createTransformElement(Document factory, IndentConfig iconf) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createTransformElement(Document factory[" + factory + "]," + "IndentConfig iconf[" + iconf + "])"));
        }
        Element trans = super.createTransformElement(factory, iconf);
        if (this._c14nMethod != null) {
            Element e = null;
            if (("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) && this._prefixList != null) {
                String s = ExclusiveCanonicalizer.serializePrefixList(this._prefixList);
                e = factory.createElementNS("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
                e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2001/10/xml-exc-c14n#");
                e.setAttribute("PrefixList", s);
            }
            Element e2 = factory.createElementNS(Constants.NS_DSIG, "CanonicalizationMethod");
            e2.setAttribute("Algorithm", this._c14nMethod);
            if (e != null) {
                e2.appendChild(e);
            }
            e = e2;
            String prefix = DOMUtil.getNamespacePrefix((Element)trans, (String)this._nsWsse);
            boolean addNsDecl = false;
            if (prefix == null) {
                prefix = "wsse:";
                addNsDecl = true;
            } else if (!"".equals(prefix)) {
                prefix = prefix + ":";
            }
            e2 = factory.createElementNS(this._nsWsse, prefix + "TransformationParameters");
            if (addNsDecl) {
                e2.setAttribute("xmlns:wsse", this._nsWsse);
            }
            e2.appendChild(e);
            trans.appendChild(e2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTransformElement(Document factory,IndentConfig iconf) returns Element[" + trans + "]"));
        }
        return trans;
    }

    public void setParameter(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setParameter(Node node[" + DOMUtil.getDisplayName((Node)node) + "])"));
        }
        this._c14nMethod = null;
        this._prefixList = null;
        for (Node n1 = node; n1 != null; n1 = n1.getNextSibling()) {
            String ln;
            String ns;
            Element e1;
            if (n1.getNodeType() != 1 || !DOMUtil.equals((Node)(e1 = (Element)n1), (String)(ns = this._nsWsse), (String)(ln = "TransformationParameters"))) continue;
            Element e2 = DOMUtil.getFirstElement((Node)e1);
            while (e2 != null) {
                ns = Constants.NS_DSIG;
                ln = "CanonicalizationMethod";
                if (DOMUtil.equals((Node)e2, (String)ns, (String)ln) && e2.hasAttribute("Algorithm")) {
                    this._c14nMethod = e2.getAttribute("Algorithm");
                    if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) {
                        Element e3 = DOMUtil.getFirstElement((Node)e2);
                        while (e3 != null) {
                            ns = "http://www.w3.org/2001/10/xml-exc-c14n#";
                            ln = "InclusiveNamespaces";
                            if (DOMUtil.equals((Node)e3, (String)ns, (String)ln) && e3.hasAttribute("PrefixList")) {
                                String s = e3.getAttribute("PrefixList");
                                this._prefixList = ExclusiveCanonicalizer.parsePrefixList(s);
                            }
                            e3 = DOMUtil.getNextElement((Node)e3);
                        }
                    }
                }
                e2 = DOMUtil.getNextElement((Node)e2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setParameter(Node node)");
        }
    }

    public void transform(TransformContext context) throws TransformException {
        SignatureContext scontext;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("transform(TransformContext context[" + context + "])"));
        }
        if ((scontext = context.getSignatureContext()) instanceof WSSSignatureContext) {
            WSSSignatureContext wsssc = (WSSSignatureContext)scontext;
            this._document = wsssc.getDocument();
            this._idResolver = wsssc.getIDResolver();
            this._kiResolver = wsssc.getSTRDTKeyInfoResolver();
            int wssVersion = wsssc.getWssVersion();
            this._nsWsse = Constants.NAMESPACES[0][wssVersion];
            this._nsWsu = Constants.NAMESPACES[1][wssVersion];
            this._keyInfoSignature = wsssc.getKeyInfoSignature();
        }
        NodeList nodeSet = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nodeSet = XPathCanonicalizer.toNodeset((Node)context.getDocument(), null, (boolean)true);
                break;
            }
            case 3: {
                nodeSet = XPathCanonicalizer.toNodeset((Node)context.getNode(), null, (boolean)true);
                break;
            }
            case 2: {
                nodeSet = context.getNodeset();
            }
        }
        byte[] binary = null;
        if (nodeSet != null) {
            this.typeCheck(nodeSet, this._keyInfoSignature);
            try {
                binary = this.transform(nodeSet);
            }
            catch (RuntimeException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".transform"), (String)"215", (Object)((Object)this));
                throw e;
            }
            catch (Exception e) {
                Tr.processException((Throwable)e, (String)(clsName + ".transform"), (String)"218", (Object)((Object)this));
                throw TransformException.create((Exception)e);
            }
        }
        context.setContent(binary, "UTF-8");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"transform(TransformContext context)");
        }
    }

    private byte[] transform(NodeList nodeSet) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("transform(NodeList nodeSet[" + nodeSet + "])"));
        }
        Map replNodeSets = this.dereferenceSTR(nodeSet);
        byte[] serialized = this.serializeNodeSet(nodeSet, replNodeSets);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"transform(NodeList nodeSet)");
        }
        return serialized;
    }

    private Map dereferenceSTR(NodeList nodeSet) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("dereferenceSTR(NodeList nodeSet[" + nodeSet + "])"));
        }
        HashMap<Node, NodeList> node2Ns = new HashMap<Node, NodeList>();
        int l = nodeSet.getLength();
        for (int i = 0; i < l; ++i) {
            Element e;
            Node n = nodeSet.item(i);
            if (n.getNodeType() != 1 || !DOMUtil.equals((Node)(e = (Element)n), (String)Constants.NS_WSSE, (String)"SecurityTokenReference")) continue;
            NodeList nl = this.dereferenceSTR(e);
            nl = this.convertToNodeSet(nl);
            node2Ns.put(n, nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("dereferenceSTR(NodeList nodeSet), returns Map[" + node2Ns + "]"));
        }
        return node2Ns;
    }

    private byte[] serializeNodeSet(NodeList nodeSet, Map replNodeSets) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("serializeNodeSet(NodeList nodeSet[" + nodeSet + "]," + "Map replNodeSets[" + replNodeSets + "])"));
        }
        byte[] bytes = null;
        if (this._c14nMethod == null) {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s01");
        }
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(this._c14nMethod)) {
            bytes = Canonicalizer.serializeSubset(nodeSet, false, replNodeSets);
        } else if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(this._c14nMethod)) {
            bytes = Canonicalizer.serializeSubset(nodeSet, true, replNodeSets);
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this._c14nMethod)) {
            bytes = ExclusiveCanonicalizer.serializeSubset(this._prefixList, nodeSet, false, replNodeSets);
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this._c14nMethod)) {
            bytes = ExclusiveCanonicalizer.serializeSubset(this._prefixList, nodeSet, true, replNodeSets);
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s02", this._c14nMethod);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serializeNodeSet(NodeList nodeSet,Map replNodeSets)");
        }
        return bytes;
    }

    private NodeList dereferenceSTR(Element secTokenRef) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("dereferenceSTR(Element secTokenRef[" + DOMUtil.getDisplayName((Node)secTokenRef) + "])"));
        }
        Object obj = this.dereferenceToST(secTokenRef);
        NodeList list = this.wrapInNodeList(obj);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dereferenceSTR(Element secTokenRef)");
        }
        return list;
    }

    private Object dereferenceToST(Element secTokenRef) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("dereferenceToST(Element secTokenRef[" + DOMUtil.getDisplayName((Node)secTokenRef) + "])"));
        }
        Object secToken = null;
        Element e = DOMUtil.getFirstElement((Node)secTokenRef);
        if (DOMUtil.equals((Node)e, (String)this._nsWsse, (String)"Embedded")) {
            secToken = this.dereferenceEmbedded(e);
        } else if (DOMUtil.equals((Node)e, (String)this._nsWsse, (String)"Reference")) {
            secToken = this.dereferenceReference(e);
        } else if (DOMUtil.equals((Node)e, (String)this._nsWsse, (String)"KeyIdentifier")) {
            secToken = this.dereferenceOthers(secTokenRef, "KEYID");
        } else if (DOMUtil.equals((Node)e, (String)Constants.NS_DSIG, (String)"X509Data")) {
            secToken = this.dereferenceOthers(secTokenRef, "X509ISSUER");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dereferenceToST(Element secTokenRef)");
        }
        return secToken;
    }

    private Object dereferenceEmbedded(Element embedded) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("dereferenceEmbedded(Element embedded[" + DOMUtil.getDisplayName((Node)embedded) + "])"));
        }
        XPathCanonicalizer.NodeListImpl secToken = null;
        for (Node n = embedded.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (secToken == null) {
                secToken = new XPathCanonicalizer.NodeListImpl();
            }
            ((XPathCanonicalizer.NodeListImpl)secToken).add(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("dereferenceEmbedded(Element embedded) returns Object[" + secToken + "]"));
        }
        return secToken;
    }

    private Object dereferenceReference(Element ref) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("dereferenceReference(Element ref[" + DOMUtil.getDisplayName((Node)ref) + "])"));
        }
        String uri = null;
        if (ref.hasAttribute("URI")) {
            uri = ref.getAttribute("URI");
        }
        QName valType = null;
        if (ref.hasAttribute("ValueType")) {
            valType = DOMUtil.getQName((Element)ref, (String)ref.getAttribute("ValueType"));
        }
        Object object = this.resolveURI(uri, valType);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("dereferenceReference(Element ref) returns Object[" + object + "]"));
        }
        return object;
    }

    private Object resolveURI(String uri, QName valType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolveURI(String uri[" + uri + "]," + "QName valType[" + valType + "])"));
        }
        Element secToken = null;
        if (uri != null) {
            if (uri.length() < 2 || uri.charAt(0) != '#') {
                throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s04", uri);
            }
            String id = uri.substring(1);
            if (this._idResolver == null) {
                throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s03");
            }
            Element e = this._idResolver.resolveID(this._document, id);
            if (e != null) {
                secToken = e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolveURI(String uri,QName valType) returns Object[" + secToken + "]"));
        }
        return secToken;
    }

    private Object dereferenceOthers(Element secTokenRef, String keyInfoType) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("dereferenceOthers(Element secTokenRef[" + DOMUtil.getDisplayName((Node)secTokenRef) + "]," + "String keyInfoType[" + keyInfoType + "])"));
        }
        Element secToken = null;
        if (this._kiResolver != null) {
            secToken = this._kiResolver.resolve(secTokenRef, keyInfoType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("dereferenceOthers(Element secTokenRef,String keyInfoType) returns Object[" + secToken + "]"));
        }
        return secToken;
    }

    private NodeList wrapInNodeList(Object secToken) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("wrapInNodeList(Object secToken[" + secToken + "])"));
        }
        NodeList secToken2 = null;
        if (secToken instanceof Element) {
            XPathCanonicalizer.NodeListImpl nl = new XPathCanonicalizer.NodeListImpl(1);
            nl.add((Node)((Element)secToken));
            secToken2 = nl;
        } else if (secToken instanceof NodeList) {
            secToken2 = (NodeList)secToken;
        } else {
            throw SoapSecurityException.format("security.wssecurity.STRDereferenceTransformer.s05");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("wrapInNodeList(Object secToken) returns NodeList[" + secToken2 + "]"));
        }
        return secToken2;
    }

    private NodeList convertToNodeSet(NodeList apexNodes) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertToNodeSet(NodeList apexNodes[" + apexNodes + "])"));
        }
        XPathCanonicalizer.NodeListImpl nodeSet = new XPathCanonicalizer.NodeListImpl();
        int l = apexNodes.getLength();
        for (int i = 0; i < l; ++i) {
            NodeList nl = XPathCanonicalizer.toNodeset((Node)apexNodes.item(i), null, (boolean)true);
            int l2 = nl.getLength();
            for (int j = 0; j < l2; ++j) {
                nodeSet.add(nl.item(j));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("convertToNodeSet(NodeList apexNodes) returns NodeList[" + nodeSet + "]"));
        }
        return nodeSet;
    }

    private void typeCheck(NodeList nodeset, String kiSign) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("typeIsOk(NodeList nodeset,String kiSign[" + kiSign + "])"));
        }
        if (kiSign == null || IntegralDialectElementSelector.KEYSIGNMETHOD[0].equals(kiSign)) {
            boolean found = false;
            for (int i = 0; i < nodeset.getLength(); ++i) {
                Node node = nodeset.item(i);
                if (node.getNodeType() != 1 || !DOMUtil.equals((Node)node, (String)Constants.NS_DSIG, (String)"KeyInfo")) continue;
                found = true;
                break;
            }
            if (!found && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The nodeset to be signed doesn't include ds:KeyInfo element though the method to sign a key is [" + kiSign + "]."));
            }
        } else if (IntegralDialectElementSelector.KEYSIGNMETHOD[1].equals(kiSign)) {
            boolean found = false;
            for (int i = 0; i < nodeset.getLength(); ++i) {
                Node node = nodeset.item(i);
                if (node.getNodeType() != 1 || !DOMUtil.equals((Node)node, (String)Constants.NS_DSIG, (String)"KeyInfo")) continue;
                found = true;
                break;
            }
            if (found && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The nodeset to be signed includes ds:KeyInfo element though the method to sign a key is [" + kiSign + "]."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"typeIsOk(NodeList nodeset,String kiSign)");
        }
    }
}

