/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandler;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyInfoSignature;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenGenerator;
import com.ibm.etools.webservice.wscommonbnd.TokenReference;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wssecurity.Generator;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.webservices.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class WSSecurityDefaultGeneratorConfig
extends PrivateGeneratorConfig {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultGeneratorConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSecurityDefaultGeneratorConfig.class.getName();

    public WSSecurityDefaultGeneratorConfig(Generator genBnd, VariableMap varMap, WSSecurityDefaultConfiguration config) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityDefaultGeneratorConfig(Generator, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{genBnd, varMap, config});
        }
        this.init(genBnd, varMap, config);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSecurityDefaultGeneratorConfig(Generator, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }

    protected final void init(Generator genBnd, VariableMap varMap, WSSecurityDefaultConfiguration config) throws SoapSecurityException {
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl kigconfig;
        PrivateCommonConfig.AlgorithmConfImpl aconfig;
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl kicgconfig;
        int j;
        int jMax;
        String value;
        int i;
        int iMax;
        Map defProps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Generator, VariableMap, WSSecurityDefaultConfiguration):", new Object[]{genBnd, varMap, config});
        }
        ClassLoader appClassLoader = null;
        boolean fipsMode = false;
        WebServicesSecurityAlgorithmHelper algoHelper = null;
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<String, String> type = new HashMap<String, String>();
        HashMap<String, Configuration> nameMapping = new HashMap<String, Configuration>();
        fipsMode = ConfigValidation.isFipsEnabled();
        if (fipsMode) {
            algoHelper = new WebServicesSecurityAlgorithmHelper();
        }
        EList signingInfos = null;
        EList encryptionInfos = null;
        List keyInfos = null;
        List tokenGenerators = null;
        Map bndProperties = null;
        this._properties = new HashMap();
        if (config != null && (defProps = config.getProperties()) != null) {
            this._properties.putAll(defProps);
        }
        if (genBnd != null) {
            signingInfos = genBnd.getSigningInfo();
            encryptionInfos = genBnd.getEncryptionInfo();
            keyInfos = genBnd.getKeyInfo();
            tokenGenerators = genBnd.getTokenGenerator();
            EList p = genBnd.getProperties();
            if (p != null) {
                bndProperties = ConfigConstants.getProperties(p, varMap);
                this._properties.putAll(bndProperties);
            }
            if (tc.isDebugEnabled()) {
                if (bndProperties != null) {
                    Tr.debug(tc, "Default Generator Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenGenerators, Property):", new Object[]{signingInfos, encryptionInfos, keyInfos, tokenGenerators, bndProperties});
                } else {
                    Tr.debug(tc, "Default Generator Binding (SigningInfos, EncryptionInfos, KeyInfos, TokenGenerators):", new Object[]{signingInfos, encryptionInfos, keyInfos, tokenGenerators});
                }
            }
        }
        if (tokenGenerators != null) {
            iMax = tokenGenerators.size();
            for (i = 0; i < iMax; ++i) {
                CertStoreRef certStoreRef;
                CertPathSettings certPathSettings;
                TokenGenerator tokenGenerator = (TokenGenerator)tokenGenerators.get(i);
                ValueType valueType = tokenGenerator.getValueType();
                if (valueType == null) {
                    throw new SoapSecurityException("The valueType field for the token generator named " + tokenGenerator.getName() + " is missing");
                }
                QName qn = new QName(ConfigUtil.trim((String)valueType.getUri()), ConfigUtil.trim((String)valueType.getLocalName()));
                PartReference pref = tokenGenerator.getPartReference();
                PrivateGeneratorConfig.TokenGeneratorConfImpl tconfig = null;
                if (pref != null && (value = ConfigUtil.trim((String)pref.getPart())) != null && value.length() > 0) {
                    tconfig = (PrivateGeneratorConfig.TokenGeneratorConfImpl)nameMapping.get(value);
                    if (tconfig == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                    }
                    if (!tconfig.getType().equals(qn)) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s30", new Object[]{tconfig.getType().toString(), qn.toString()});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + value);
                    }
                }
                if (tconfig == null) {
                    tconfig = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
                    tconfig._type = qn;
                }
                tconfig._className = ConfigUtil.trim((String)tokenGenerator.getClassname());
                CallbackHandler callbackHandler = tokenGenerator.getCallbackHandler();
                if (callbackHandler != null) {
                    PrivateGeneratorConfig.CallbackHandlerConfImpl cconfig = new PrivateGeneratorConfig.CallbackHandlerConfImpl();
                    cconfig._className = ConfigUtil.trim((String)callbackHandler.getClassname());
                    KeyStore keystore = callbackHandler.getKeyStore();
                    if (keystore != null) {
                        PrivateCommonConfig.KeyStoreConfImpl ksconfig = new PrivateCommonConfig.KeyStoreConfImpl();
                        ksconfig._type = ConfigUtil.trim((String)keystore.getType());
                        ksconfig._path = varMap.expand(ConfigUtil.trim((String)keystore.getPath()));
                        ksconfig._password = ConfigUtil.trim((String)keystore.getStorepass());
                        ksconfig._ksRef = ConfigUtil.trim((String)keystore.getKeyStoreRef());
                        ksconfig.validate();
                        cconfig._keyStoreConfig = ksconfig;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "callbackHandler.getKeyStore() returned null");
                    }
                    EList keys = callbackHandler.getKey();
                    jMax = keys.size();
                    for (j = 0; j < jMax; ++j) {
                        Key key = (Key)keys.get(j);
                        PrivateCommonConfig.KeyInformationConfImpl kiconfig = new PrivateCommonConfig.KeyInformationConfImpl();
                        kiconfig._alias = ConfigUtil.trim((String)key.getAlias());
                        kiconfig._keypass = ConfigUtil.trim((String)key.getKeypass());
                        kiconfig._name = ConfigUtil.trim((String)key.getName());
                        cconfig._keyInformationList.add(kiconfig);
                    }
                    BasicAuth basicAuth = callbackHandler.getBasicAuth();
                    if (basicAuth != null) {
                        value = ConfigUtil.trim((String)basicAuth.getUserid());
                        if (value != null && value.length() > 0) {
                            cconfig._userId = value;
                        }
                        if ((value = ConfigUtil.trim((String)basicAuth.getPassword())) != null && value.length() > 0) {
                            cconfig._userPassword = value.toCharArray();
                        }
                    }
                    ConfigConstants.getProperties(cconfig._properties, callbackHandler.getProperties(), varMap);
                    tconfig._callbackHandler = cconfig;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the callback handler: " + cconfig.getClassName());
                    }
                }
                if ((certPathSettings = tokenGenerator.getCertPathSettings()) != null && (certStoreRef = certPathSettings.getCertStoreRef()) != null) {
                    ArrayList<Object> certStores = new ArrayList<Object>();
                    Object provider = null;
                    if (certStoreRef != null) {
                        Object cs;
                        value = ConfigUtil.trim((String)certStoreRef.getRef());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CertStoreRef = " + value);
                        }
                        if ((cs = config.getWSCertStore(value)) == null) {
                            String msgKey = "security.wssecurity.ConfigValidation.csref.notfound";
                            Tr.warning(tc, msgKey, new Object[]{value});
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found CertStore for " + value);
                            }
                            certStores.add(cs);
                        }
                    }
                    tconfig._provider = provider;
                    tconfig._certStores = certStores;
                }
                type.clear();
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", tconfig._className);
                HashMap properties = new HashMap();
                try {
                    tconfig._instance = (TokenGeneratorComponent)factory.createGenerator(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{tconfig._className});
                }
                ConfigConstants.getProperties(tconfig._properties, tokenGenerator.getProperties(), varMap);
                this._tokenGenerators.add(tconfig);
                value = ConfigUtil.trim((String)tokenGenerator.getName());
                if (value == null || value.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s26");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding token consumer: " + value);
                }
                nameMapping.put(value, tconfig);
            }
        }
        if (keyInfos != null) {
            iMax = keyInfos.size();
            for (i = 0; i < iMax; ++i) {
                TokenReference tokenReference;
                KeyInfo keyInfo = (KeyInfo)keyInfos.get(i);
                kicgconfig = new PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl();
                kicgconfig._className = ConfigUtil.trim((String)keyInfo.getClassname());
                kicgconfig._keyInfoType = ConfigUtil.trim((String)keyInfo.getType());
                KeyLocatorMapping keyLocatorMapping = keyInfo.getKeyLocatorMapping();
                if (keyLocatorMapping != null) {
                    value = ConfigUtil.trim((String)keyLocatorMapping.getLocatorRef());
                    if (value != null && value.length() > 0) {
                        KeyLocatorProxy klproxy = config.getKeyLocator(value);
                        if (klproxy == null) {
                            Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                        } else {
                            try {
                                kicgconfig._keyLocator = klproxy.getKeyLocator6(appClassLoader);
                            }
                            catch (SoapSecurityException sse) {
                                Tr.warning(tc, "security.wssecurity.keylocator.is.null", new Object[]{sse});
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the key locator mapping: " + value);
                            }
                        }
                    }
                    kicgconfig._keyName = keyLocatorMapping.getKeynameRef();
                }
                if ((tokenReference = keyInfo.getTokenReference()) != null && (value = ConfigUtil.trim((String)tokenReference.getTokenRef())) != null && value.length() > 0) {
                    kicgconfig._tokenGenerator = (PrivateGeneratorConfig.TokenGeneratorConfImpl)nameMapping.get(value);
                    if (kicgconfig._tokenGenerator == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the token reference: " + value);
                    }
                }
                ConfigConstants.getProperties(kicgconfig._properties, keyInfo.getProperties(), varMap);
                type.clear();
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.custom");
                type.put("com.ibm.wsspi.wssecurity.core.wssfactory.classname", kicgconfig._className);
                HashMap properties = new HashMap();
                try {
                    kicgconfig._instance = (KeyInfoContentGeneratorComponent)factory.createGenerator(type, properties);
                }
                catch (SoapSecurityException sse) {
                    Tr.warning(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{kicgconfig._className});
                }
                value = ConfigUtil.trim((String)keyInfo.getName());
                if (value == null || value.length() == 0) {
                    Tr.warning(tc, "security.wssecurity.PrivateGeneratorConfig.s28");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding key info: " + value);
                }
                nameMapping.put(value, kicgconfig);
            }
        }
        if (encryptionInfos != null) {
            iMax = encryptionInfos.size();
            for (i = 0; i < iMax; ++i) {
                EncryptionKeyInfo encryptionKey;
                EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfos.get(i);
                PrivateGeneratorConfig.EncryptionGeneratorConfImpl econfig = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
                DataEncryptionMethod dataEncryption = encryptionInfo.getEncryptionMethod();
                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                aconfig._algorithm = ConfigUtil.trim((String)dataEncryption.getAlgorithm());
                if (!fipsMode || algoHelper.getFipsDataEncryptionAlgorithms().contains(aconfig._algorithm)) {
                    ConfigConstants.getProperties(aconfig._properties, dataEncryption.getProperties(), varMap);
                    econfig._dataEncryptionMethod = aconfig;
                } else {
                    Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DataEncryptionMethod", aconfig._algorithm});
                }
                KeyEncryptionMethod keyEncryption = encryptionInfo.getKeyEncryptionMethod();
                if (keyEncryption != null) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)keyEncryption.getAlgorithm());
                    if (!fipsMode || algoHelper.getFipsKeyEncryptionAlgorithms().contains(aconfig._algorithm)) {
                        ConfigConstants.getProperties(aconfig._properties, keyEncryption.getProperties(), varMap);
                        econfig._keyEncryptionMethod = aconfig;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"KeyEncryptionMethod", aconfig._algorithm});
                    }
                }
                kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                EList encryptionKeys = encryptionInfo.getEncryptionKeyInfo();
                if (encryptionKeys != null && encryptionKeys.size() == 1 && (value = ConfigUtil.trim((String)(encryptionKey = (EncryptionKeyInfo)encryptionKeys.get(0)).getKeyinfoRef())) != null && value.length() > 0) {
                    kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)nameMapping.get(value);
                    if (kicgconfig == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                    kigconfig._contentGenerator = kicgconfig;
                }
                econfig._encryptionKeyInfo = kigconfig;
                PartReference pref = encryptionInfo.getPartReference();
                if (pref != null && (value = ConfigUtil.trim((String)pref.getPart())) != null && value.length() > 0) {
                    econfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameMapping.get(value);
                    if (econfig._reference == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the part reference: " + value);
                    }
                }
                ConfigConstants.getProperties(econfig._properties, encryptionInfo.getProperties(), varMap);
                this._operationGenerators.add(econfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding encryption generator.");
            }
        }
        if (signingInfos != null) {
            iMax = signingInfos.size();
            for (i = 0; i < iMax; ++i) {
                SigningKeyInfo signingKey;
                SigningInfo signingInfo = (SigningInfo)signingInfos.get(i);
                PrivateGeneratorConfig.SignatureGeneratorConfImpl sconfig = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
                CanonicalizationMethod c14n = signingInfo.getCanonicalizationMethod();
                if (c14n == null) {
                    Tr.warning(tc, "security.wssecurity.nocanonicalization.algo");
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)c14n.getAlgorithm());
                    ConfigConstants.getProperties(aconfig._properties, c14n.getProperties(), varMap);
                    sconfig._canonicalizationMethod = aconfig;
                }
                SignatureMethod signature = signingInfo.getSignatureMethod();
                if (c14n == null) {
                    Tr.warning(tc, "security.wssecurity.nosignature.algo");
                } else {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)signature.getAlgorithm());
                    if (!fipsMode || algoHelper.getFipsSignatureAlgorithms().contains(aconfig._algorithm)) {
                        ConfigConstants.getProperties(aconfig._properties, signature.getProperties(), varMap);
                        sconfig._signatureMethod = aconfig;
                    } else {
                        Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"SignatureMethod", aconfig._algorithm});
                    }
                }
                KeyInfoSignature kiSignature = signingInfo.getKeyInfoSignature();
                if (kiSignature != null) {
                    aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                    aconfig._algorithm = ConfigUtil.trim((String)kiSignature.getType());
                    ConfigConstants.getProperties(aconfig._properties, kiSignature.getProperties(), varMap);
                    sconfig._keyInfoSignature = aconfig;
                }
                kigconfig = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
                EList signingKeys = signingInfo.getSigningKeyInfo();
                if ((signingKeys != null || signingKeys.size() == 1) && (value = ConfigUtil.trim((String)(signingKey = (SigningKeyInfo)signingKeys.get(0)).getKeyinfoRef())) != null && value.length() > 0) {
                    kicgconfig = (PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)nameMapping.get(value);
                    if (kicgconfig == null) {
                        Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got the key info reference: " + value);
                    }
                    kigconfig._contentGenerator = kicgconfig;
                }
                sconfig._signingKeyInfo = kigconfig;
                EList prefs = signingInfo.getPartReference();
                if (prefs != null) {
                    jMax = prefs.size();
                    for (j = 0; j < jMax; ++j) {
                        DigestMethod digest;
                        PartReference pref = (PartReference)prefs.get(j);
                        PrivateCommonConfig.SigningReferenceConfImpl srconfig = new PrivateCommonConfig.SigningReferenceConfImpl();
                        value = ConfigUtil.trim((String)pref.getPart());
                        if (value != null && value.length() > 0) {
                            srconfig._reference = (PrivateCommonConfig.ReferencePartConfImpl)nameMapping.get(value);
                            if (srconfig._reference == null) {
                                Tr.warning(tc, "security.wssecurity.PrivateConsumerConfig.s31", new Object[]{value});
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Got the part reference: " + value);
                            }
                        }
                        if ((digest = pref.getDigestMethod()) == null) {
                            Tr.warning(tc, "security.wssecurity.nodigest.algo");
                        } else {
                            aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                            aconfig._algorithm = ConfigUtil.trim((String)digest.getAlgorithm());
                            if (!fipsMode || algoHelper.getFipsDigestAlgorithms().contains(aconfig._algorithm)) {
                                ConfigConstants.getProperties(aconfig._properties, digest.getProperties(), varMap);
                                srconfig._digestMethod = aconfig;
                            } else {
                                Tr.error(tc, "security.wssecurity.WSEC0148E", new Object[]{"DigestMethod", aconfig._algorithm});
                            }
                        }
                        EList transforms = pref.getTransform();
                        if (transforms != null) {
                            int kMax = transforms.size();
                            for (int k = 0; k < kMax; ++k) {
                                Transform transform = (Transform)transforms.get(k);
                                if (transform == null) continue;
                                aconfig = new PrivateCommonConfig.AlgorithmConfImpl();
                                aconfig._algorithm = ConfigUtil.trim((String)transform.getAlgorithm());
                                ConfigConstants.getProperties(aconfig._properties, transform.getProperties(), varMap);
                                srconfig._transforms.add(aconfig);
                            }
                        }
                        sconfig._references.add(srconfig);
                    }
                }
                sconfig.putInclusiveNsProperty(this._properties);
                ConfigConstants.getProperties(sconfig._properties, signingInfo.getProperties(), varMap);
                this._operationGenerators.add(sconfig);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding signature generator.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Generator, VariableMap, WSSecurityDefaultConfiguration)");
        }
    }
}

