/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSConsumerComponent;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.EncryptionConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.TimestampConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.core.ResultMessagePool;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.dsig.VerificationResult;
import com.ibm.ws.webservices.wssecurity.dsig.VerifiedPartChecker;
import com.ibm.ws.webservices.wssecurity.enc.DecryptedPartChecker;
import com.ibm.ws.webservices.wssecurity.enc.DecryptionResult;
import com.ibm.ws.webservices.wssecurity.enc.EncryptionConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.time.TimestampChecker;
import com.ibm.ws.webservices.wssecurity.time.TimestampConsumer;
import com.ibm.ws.webservices.wssecurity.token.AuthResult;
import com.ibm.ws.webservices.wssecurity.token.CertCacheManager;
import com.ibm.ws.webservices.wssecurity.token.LoginProcessor;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.IDAssertionUsernameTokenConsumer;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSConsumer
implements WSSConsumerComponent {
    private static final TraceComponent tc = Tr.register(WSSConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSConsumer.class.getName();
    private Map _handlerOption = new HashMap();
    private Map _properties = new HashMap();
    private boolean _initialized = false;

    public void setHandlerOption(String key, Object value) {
        this._handlerOption.put(key, value);
    }

    public Object getHandlerOption(String key) {
        return this._handlerOption.get(key);
    }

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this.setInitialProperties();
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(Node target, Map context) throws SoapSecurityException {
        SOAPPart soapPart;
        SOAPMessageContext messageContext;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        if ((messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext")) == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
        }
        ResultPool.initialize((Map)context);
        WSSConsumer.adjustContext(messageContext, context);
        TokenManager.initializeSubject(context);
        ResultMessagePool.initialize(context);
        WSSConsumerConfig config = (WSSConsumerConfig)context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WSSConsumerConfig [" + config + "]."));
        }
        TimestampConsumerConfig tsconfig = config.getTimestampConsumer();
        HashMap properties = new HashMap(this._properties);
        context.put(NonceManager.class, config.getNonceManager());
        context.put(CertCacheManager.class, config.getCertManager());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Finished initializing the subject.");
        }
        boolean requiredSecurity = config.isTokenRequired() || config.isVerificationRequired() || config.isDecryptionRequired() || config.isLoginRequired() || config.isTimestampRequired();
        SOAPMessage message = messageContext.getMessage();
        SOAPPart doc = soapPart = message.getSOAPPart();
        SOAPEnvelope soapEnv = null;
        try {
            soapEnv = soapPart.getEnvelope();
        }
        catch (SOAPException e) {
            Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"229", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s01", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s01", e);
        }
        catch (Exception e) {
            Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"235", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s02", (Object)new Object[]{e});
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s02", e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The original message to be processed by WSSConsumer: " + DOMUtil.toString((Node)doc)));
        }
        if (!requiredSecurity) {
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"invoke(Element target,Map context)");
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Starts WS-Security operation.");
        }
        HashMap type = new HashMap();
        Element root = doc.getDocumentElement();
        Element header = WSSGenerator.getHeader((Document)doc, false);
        if (header == null) {
            throw SoapSecurityException.format("security.wssecurity.DOMUtil.sconf11", "SOAP Header");
        }
        int soapVersion = NamespaceUtil.isSoap(header.getNamespaceURI());
        if (tc.isDebugEnabled()) {
            String msg = null;
            msg = soapVersion == 0 ? "The spec of SOAP is SOAP1.1." : (soapVersion == 1 ? "The spec of SOAP is SOAP1.2." : "Unknown spec of SOAP: " + header.getNamespaceURI());
            Tr.debug((TraceComponent)tc, (String)msg);
        }
        NodeList secList = WSSConsumer.getSecurityHeaders(header, soapVersion, config.isUltimateReceiver(), config.getMyActor());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(secList.getLength() + " security headers found"));
        }
        if (secList.getLength() == 0) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s38", (Object)config.getMyActor());
        }
        boolean requireIdCheck = false;
        String skipId = (String)messageContext.getProperty("com.ibm.ws.webservices.wssecurity.constants.checkIdUniqueness");
        if (skipId != null && skipId.equals("true")) {
            requireIdCheck = true;
        }
        if (!requireIdCheck) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Skipping the Id uniqueness check.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing the Id uniqueness check.");
            }
            IdUtil.getInstance().checkIdUniqueness((Document)doc);
        }
        int wssVersion = -1;
        if (requiredSecurity && secList.getLength() == 0 && WSSConsumer.countSecurityHeaders(header) > 0) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, WSSAuditService.WSSAuditOutcome.DENIED)) {
                WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.SEC_HEADER_MISSING, null);
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, messageContext, context);
            }
            if (config.getMyActor() == null || config.getMyActor().trim().length() == 0) {
                if (!tc.isDebugEnabled()) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s39");
                Tr.debug((TraceComponent)tc, (String)("The Application Server expected a Security header with the " + Constants.NS_WSSE + " namespace, but it was not found."));
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s39");
            }
            if (!tc.isDebugEnabled()) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s40", config.getMyActor());
            Tr.debug((TraceComponent)tc, (String)("The Application Server expected a Security header with the " + Constants.NS_WSSE + " namespace and the " + config.getMyActor() + " actor, but it was not found."));
            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s40", config.getMyActor());
        }
        if (config.isTimestampRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Processing the timestamp.");
            }
            NodeList list = null;
            list = WSSConsumer.getTimestampHeader(header, -1, false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(list.getLength() + " timestamp headers found."));
            }
            if (list.getLength() > 0) {
                wssVersion = NamespaceUtil.isWsu(((Element)list.item(0)).getNamespaceURI());
                context.put("com.ibm.ws.webservices.wssecurity.constants.wssVersion", new Integer(wssVersion));
                messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.wssVersion", new Integer(wssVersion));
                for (int i = 0; i < list.getLength(); ++i) {
                    Element timestamp = (Element)list.item(i);
                    WSSConsumer.callTimestampConsumer(tsconfig, properties, timestamp, context);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Checking the required timestamp.");
                }
                WSSConsumer.checkRequiredTimestamp((Document)doc, config.getTimestampConsumer(), properties, context);
            }
        }
        for (int i = 0; i < secList.getLength(); ++i) {
            Element security2 = (Element)secList.item(i);
            boolean mustUnderstand = false;
            String value = security2.getAttributeNS(header.getNamespaceURI(), "mustUnderstand");
            if (value != null && !"".equals(value)) {
                mustUnderstand = ConfigUtil.isTrue((String)value);
            }
            ConfigUtil.setMustUnderstand((SOAPMessageContext)messageContext, (boolean)mustUnderstand);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mustUnderstand attribute is " + mustUnderstand));
            }
            try {
                int version = NamespaceUtil.isWsse(security2.getNamespaceURI());
                if (wssVersion < 0) {
                    wssVersion = version;
                    context.put("com.ibm.ws.webservices.wssecurity.constants.wssVersion", new Integer(wssVersion));
                    messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.wssVersion", new Integer(wssVersion));
                } else if (version != wssVersion) {
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s06");
                }
                if (tc.isDebugEnabled()) {
                    String msg = null;
                    msg = wssVersion == 0 ? "The spec of WS-Security is 2004/01 ver." : "Unknown spec of WS-Security: " + security2.getNamespaceURI();
                    Tr.debug((TraceComponent)tc, (String)msg);
                }
                Element el = DOMUtil.getFirstElement((Node)security2);
                while (el != null) {
                    String ln = el.getLocalName();
                    String ns = el.getNamespaceURI();
                    version = NamespaceUtil.isWsu(ns);
                    if (version >= 0) {
                        if (version != wssVersion) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s05", ns);
                        if (!ln.equals("Timestamp")) {
                            throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtil.getQualifiedName((Node)el), DOMUtil.getQualifiedName((Node)security2));
                        }
                    } else {
                        version = NamespaceUtil.isWsse(ns);
                        if (version >= 0) {
                            if (version != wssVersion) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s05", ns);
                            if (ln.equals("UsernameToken")) {
                                WSSConsumer.callTokenConsumer(config.getCallers(), config.getTokenConsumers(), root, security2, el, context, true, false, wssVersion);
                            } else {
                                if (!ln.equals("BinarySecurityToken")) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtil.getQualifiedName((Node)el), DOMUtil.getQualifiedName((Node)security2));
                                WSSConsumer.callTokenConsumer(config.getCallers(), config.getTokenConsumers(), root, security2, el, context, false, true, wssVersion);
                            }
                        } else if (Constants.NS_DSIG.equals(ns)) {
                            if (!ln.equals("Signature")) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtil.getQualifiedName((Node)el), DOMUtil.getQualifiedName((Node)security2));
                            boolean copiedDOMTree = false;
                            Element tel = DOMUtil.getNextElement((Node)el);
                            while (tel != null) {
                                String tns = tel.getNamespaceURI();
                                String tln = tel.getLocalName();
                                if (Constants.NS_ENC.equals(tns) && ("EncryptedKey".equals(tln) || "ReferenceList".equals(tln))) {
                                    copiedDOMTree = true;
                                }
                                tel = DOMUtil.getNextElement((Node)tel);
                            }
                            WSSConsumer.callSignatureConsumer(config.getSignatureConsumers(), properties, el, copiedDOMTree, context, security2);
                        } else if (Constants.NS_ENC.equals(ns)) {
                            if (!ln.equals("EncryptedKey") && !ln.equals("ReferenceList")) throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s04", DOMUtil.getQualifiedName((Node)el), DOMUtil.getQualifiedName((Node)security2));
                            WSSConsumer.callEncryptionConsumer(config.getEncryptionConsumers(), properties, el, context, security2);
                        } else {
                            WSSConsumer.callTokenConsumer(config.getCallers(), config.getTokenConsumers(), root, security2, el, context, false, false, wssVersion);
                        }
                    }
                    el = DOMUtil.getNextElement((Node)el);
                }
                continue;
            }
            catch (SoapSecurityException e) {
                Tr.processException((Throwable)e, (String)(clsName + ".invoke"), (String)"516", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s23", (Object)e);
                if (mustUnderstand) throw e;
                Tr.debug((TraceComponent)tc, (String)"An exception has occurred when mustUnderstand=0.");
                Tr.debug((TraceComponent)tc, (String)"The mustUnderstand=0 attribute may be honored when there is no inbound WSSecurity configuration for the elements being processed.");
                throw e;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"All security handlers is processed.");
        }
        WSSConsumer.cleanSubject(context);
        if (config.isVerificationRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the required integrity.");
            }
            WSSConsumer.checkRequiredIntegrity((Document)doc, properties, context);
        }
        if (config.isDecryptionRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the required confidentiality.");
            }
            WSSConsumer.checkRequiredConfidentiality((Document)doc, properties, context);
        }
        if (config.isTokenRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the required security token.");
            }
            WSSConsumer.checkRequiredSecurityToken(config.getRequiredSecurityTokens(), config.getCallers(), context);
        }
        if (config.isLoginRequired()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Checking the caller.");
            }
            WSSConsumer.checkCaller(properties, context);
        }
        WSSConsumer.copyContextSubjectToMessageContext(messageContext, context);
        WSSConsumer.mapTokenToMessageContext(messageContext, context);
        SOAPHeaderElement sh = NamespaceUtil.getWsseHeaderByName(soapEnv, "Security");
        if (sh != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security header is processed.");
            }
            sh.setProcessed(true);
        }
        if ((sh = NamespaceUtil.getWsuHeaderByName(soapEnv, "Timestamp")) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Timestamp header is processed.");
            }
            sh.setProcessed(true);
        }
        ResultPool.finalize((Map)context);
        ResultMessagePool.finalize(context);
        WSSConsumer.cleanContext(context);
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
    }

    public void onFault(SOAPMessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onFault(SOAPMessageContext context)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onFault(SOAPMessageContext context)");
        }
    }

    private void setInitialProperties() throws SoapSecurityException {
        this._properties.put(ConfidentialDialectElementSelector.class, new ConfidentialDialectElementSelector());
        this._properties.put(IntegralDialectElementSelector.class, new IntegralDialectElementSelector());
        this._properties.put(TimestampDialectElementSelector.class, new TimestampDialectElementSelector());
        this._properties.put(WSPFunctionElementSelector.class, new WSPFunctionElementSelector());
        this._properties.put(XPathElementSelector.class, new XPathElementSelector());
        this._properties.put("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver", IdUtil.getInstance());
        this._properties.put(NonceUtil.class, new NonceUtil());
        WSSFactory factory = WSSFactory.getInstance("soap");
        HashMap<String, String> type = new HashMap<String, String>();
        type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.timestamp");
        this._properties.put(TimestampConsumer.class, factory.createConsumer(type, this._properties));
        type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.signature");
        this._properties.put(SignatureConsumer.class, factory.createConsumer(type, this._properties));
        type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.encryption");
        this._properties.put(EncryptionConsumer.class, factory.createConsumer(type, this._properties));
        type.put("com.ibm.wsspi.wssecurity.core.wssfactory.type", "com.ibm.wsspi.wssecurity.core.wssfactory.keyinfo");
        this._properties.put(KeyInfoConsumer.class, factory.createConsumer(type, this._properties));
        WSSConsumerComponent component2 = new VerifiedPartChecker();
        component2.init(this._properties);
        this._properties.put(VerifiedPartChecker.class, component2);
        component2 = new DecryptedPartChecker();
        component2.init(this._properties);
        this._properties.put(DecryptedPartChecker.class, component2);
        component2 = new TimestampChecker();
        component2.init(this._properties);
        this._properties.put(TimestampChecker.class, component2);
        component2 = new LoginProcessor();
        component2.init(this._properties);
        this._properties.put(LoginProcessor.class, component2);
    }

    private static boolean adjustContext(SOAPMessageContext context, Map ccontext) throws SoapSecurityException {
        return false;
    }

    public static NodeList getSecurityHeaders(Element header, int soapVersion, boolean ultimateReceiver, String actor) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSecurityHeaders(Element header[" + DOMUtil.getDisplayName((Node)header) + "]," + "int soapVersion[" + soapVersion + "]," + "boolean untimateReceiver[" + ultimateReceiver + "]," + "String actor[" + actor + "])"));
        }
        XPathCanonicalizer.NodeListImpl list = new XPathCanonicalizer.NodeListImpl();
        Element el = DOMUtil.getFirstElement((Node)header);
        while (el != null) {
            block11: {
                block13: {
                    String act;
                    block12: {
                        String ns = el.getNamespaceURI();
                        String ln = el.getLocalName();
                        if (NamespaceUtil.isWsse(ns) < 0 || !"Security".equals(ln)) break block11;
                        if (soapVersion == 1) {
                            act = el.getAttributeNS(Constants.NS_SOAP12, "role");
                        } else if (soapVersion == 0) {
                            act = el.getAttributeNS(Constants.NS_SOAP, "actor");
                        } else {
                            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s11", Integer.toString(soapVersion));
                        }
                        if (act != null && act.trim().length() != 0) break block12;
                        if (actor != null && actor.trim().length() != 0) break block11;
                        break block13;
                    }
                    if (soapVersion == 1 ? Constants.SOAP12_ROLE_NONE.equals(act) || (Constants.SOAP12_ROLE_RECEIVER.equals(act) ? !act.equals(actor) : !Constants.SOAP12_ROLE_NEXT.equals(act) && !act.equals(actor)) : !Constants.SOAP11_ACTOR_NEXT.equals(act) && !act.equals(actor)) break block11;
                }
                list.add((Node)el);
            }
            el = DOMUtil.getNextElement((Node)el);
        }
        if (list.getLength() > 1) {
            throw new SoapSecurityException("There are more than one wsse:Security elements to be processed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecurityHeaders(Element header,int soapVersion,int wssVersion,String actor) returns NodeList[" + list + "]"));
        }
        return list;
    }

    private static int countSecurityHeaders(Element header) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("countSecurityHeaders(Element header[" + DOMUtil.getDisplayName((Node)header) + "])"));
        }
        int count = 0;
        Element el = DOMUtil.getFirstElement((Node)header);
        while (el != null) {
            if ("Security".equals(el.getLocalName())) {
                ++count;
            }
            el = DOMUtil.getNextElement((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("countSecurityHeaders(Element header, returns " + count));
        }
        return count;
    }

    public static String getId(Node node) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getId(Node node[" + DOMUtil.getDisplayName((Node)node) + "])"));
        }
        String s = null;
        if (node.getNodeType() == 1) {
            Element e = (Element)node;
            s = IdUtil.getInstance().getIdAttributeName(e);
            if (s != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getNode(Node node) returns " + s));
                }
                return s;
            }
        }
        for (Node n = node.getFirstChild(); n != null && (n.getNodeType() != 1 && n.getNodeType() != 5 || (s = WSSConsumer.getId(n)) == null); n = n.getNextSibling()) {
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNode(Node node) returns " + s));
        }
        return s;
    }

    private static NodeList getTimestampHeader(Element root, int wssVersion, boolean trace) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestampHeader(Element root[" + DOMUtil.getDisplayName((Node)root) + "],"), (Object)("int wssVersion" + wssVersion + "]," + "boolean trace[" + trace + "])"));
        }
        String elemName = trace ? "TimestampTrace" : "Timestamp";
        XPathCanonicalizer.NodeListImpl ret = new XPathCanonicalizer.NodeListImpl();
        NodeList list = wssVersion < 0 ? NamespaceUtil.getWsuElementsByTagName(root, elemName) : DOMUtil.getOneOrMoreElements((Element)root, (String)Constants.NAMESPACES[1][wssVersion], (String)elemName);
        for (int i = 0; i < list.getLength(); ++i) {
            Element el = (Element)list.item(i);
            if (el.hasAttribute("wasextention")) continue;
            ret.add((Node)el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimestampHeader(Element root,int wssVersion,boolean trace) returns NodeList[" + ret + "]"));
        }
        return ret;
    }

    private static void callTimestampConsumer(TimestampConsumerConfig config, Map selectors, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestampConsumer(TimestampConsumerConfig config,Map selectors,Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        TimestampConsumer con = (TimestampConsumer)selectors.get(TimestampConsumer.class);
        context.put("com.ibm.wsspi.wssecurity.config.timestampConsumer.configKey", config);
        con.invoke(target, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTimestampConsumer(TimestampConsumerConfig config,Map selectors,Element target,Map context)");
        }
    }

    public static void callTokenConsumer(Set cconfigs, Set tconfigs, Element envelope, Element security2, Element target, Map context, boolean isUT, boolean isBST, int wssVersion) throws SoapSecurityException {
        QName vt;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callTokenConsumer(Set cconfigs,Set tconfigs,Element envelope[" + DOMUtil.getDisplayName((Node)envelope) + "]," + "Element security[" + DOMUtil.getDisplayName((Node)security2) + "]," + "Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context," + "boolean isUT[" + isUT + "]," + "boolean isBST[" + isBST + "]," + "int wssVersion" + wssVersion + "])"));
        }
        QName valueType = null;
        if (target.hasAttribute("ValueType")) {
            String vts = target.getAttribute("ValueType");
            valueType = DOMUtil.getQName(target, vts, wssVersion);
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        String id = ConfigUtil.trim((String)IdUtil.getInstance().getId(target));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Target's value type is [" + valueType + "]."));
            Tr.debug((TraceComponent)tc, (String)("UsernameToken flag is [" + isUT + "]."));
            Tr.debug((TraceComponent)tc, (String)("BinarySecurityToken flag is [" + isBST + "]."));
            Tr.debug((TraceComponent)tc, (String)("The identifier is [" + id + "]."));
        }
        HashSet<TokenConsumerConfig> configs = new HashSet<TokenConsumerConfig>();
        boolean isDecryption = true;
        boolean isVerification = true;
        int usedFor = 0;
        if (envelope != null && security2 != null && (isBST || isUT)) {
            isDecryption = false;
            isVerification = false;
            usedFor = WSSConsumer.getUsedFor(envelope, security2, nsWsse, id);
            if (usedFor == 1) {
                isVerification = true;
            } else if (usedFor == 2) {
                isDecryption = true;
            }
            if (tc.isDebugEnabled()) {
                if (isVerification) {
                    Tr.debug((TraceComponent)tc, (String)"The token is used for signature verification.");
                } else if (isDecryption) {
                    Tr.debug((TraceComponent)tc, (String)"The token is used for decryption.");
                } else {
                    Tr.debug((TraceComponent)tc, (String)"The token is maybe stand-alone.");
                }
            }
            for (TokenConsumerConfig tconfig : tconfigs) {
                if (tc.isDebugEnabled()) {
                    if (tconfig.isUsedForVerification()) {
                        Tr.debug((TraceComponent)tc, (String)"The configuration of token consumers is used for signature verification.");
                    } else if (tconfig.isUsedForDecryption()) {
                        Tr.debug((TraceComponent)tc, (String)"The configuration of token consumers is used for decryption.");
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"The configuration of token consumers is maybe used for stand-alone tokens.");
                    }
                }
                if (!(isVerification && tconfig.isUsedForVerification() || isDecryption && tconfig.isUsedForDecryption()) && (isVerification || tconfig.isUsedForVerification() || isDecryption || tconfig.isUsedForDecryption())) continue;
                vt = tconfig.getType();
                if (isUT) {
                    if (!Constants.UNTOKEN.equals(vt)) continue;
                    boolean isIDAssertionConsumer = false;
                    TokenConsumerComponent con = tconfig.getInstance();
                    if (con != null && con instanceof IDAssertionUsernameTokenConsumer) {
                        isIDAssertionConsumer = true;
                    }
                    Element elem = DOMUtil.getZeroOrOneElement((Element)target, (String)nsWsse, (String)"Password");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("isIDAssertionConsumer = " + isIDAssertionConsumer));
                        if (elem == null) {
                            Tr.debug((TraceComponent)tc, (String)"password elem is null. (IDAssertion token)");
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"password elem is not null. (Username token)");
                        }
                    }
                    if (isIDAssertionConsumer && elem != null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Not adding config for [" + vt + "] at this time. Token consumer " + "is IDAssertionUsernameTokenConsumer and token contains a password."));
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added a config for [" + vt + "]."));
                    }
                    configs.add(tconfig);
                    continue;
                }
                if (isBST) {
                    if (!NamespaceUtil.equals(valueType, vt)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added a config for [" + vt + "]."));
                    }
                    configs.add(tconfig);
                    continue;
                }
                if (!vt.equals(new QName(target.getNamespaceURI(), target.getLocalName()))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added a config for [" + vt + "]."));
                }
                configs.add(tconfig);
            }
        }
        if (configs.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Since it can't select configuration of token cosumers based on the message, it uses all candidates.");
            }
            for (TokenConsumerConfig tconfig : tconfigs) {
                vt = tconfig.getType();
                if (isUT) {
                    if (!Constants.UNTOKEN.equals(vt)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added a config for [" + vt + "]."));
                    }
                    configs.add(tconfig);
                    continue;
                }
                if (isBST) {
                    if (!NamespaceUtil.equals(valueType, vt)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Added a config for [" + vt + "]."));
                    }
                    configs.add(tconfig);
                    continue;
                }
                if (!vt.equals(new QName(target.getNamespaceURI(), target.getLocalName()))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Added a config for [" + vt + "]."));
                }
                configs.add(tconfig);
            }
        }
        if (configs.isEmpty()) {
            if (ConfigUtil.getMustUnderstand((Map)context)) {
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s03", DOMUtil.getQualifiedName((Node)target));
            }
            Tr.debug((TraceComponent)tc, (String)ConfigUtil.getMessage((String)"security.wssecurity.WSSConsumer.s03", (String[])new String[]{DOMUtil.getQualifiedName((Node)target)}));
            Tr.debug((TraceComponent)tc, (String)"mustUnderstand=0.  Ignoring unexpected element.");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(configs.size() + " TokenConsumerConfig candidates found."));
            }
            context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE);
            boolean succeeded = false;
            boolean checkCaller = false;
            Exception[] exceptions2 = new Exception[configs.size()];
            int exPos = 0;
            SoapSecurityException throwException = null;
            Iterator i = configs.iterator();
            while (i.hasNext()) {
                TokenConsumerConfig tconfig;
                tconfig = (TokenConsumerConfig)i.next();
                try {
                    WSSConsumer.callTokenConsumer(tconfig, target, context);
                    Token token = TokenManager.getUnprocessedToken(context);
                    if (token != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Unprocessed token [" + token + "] found."));
                        }
                        token.setProcessed(true);
                        if (!checkCaller && cconfigs != null) {
                            WSSConsumer.checkCaller(cconfigs, tconfig, token, context);
                            checkCaller = token.getCallerChecked();
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"All tokens are processed.");
                        }
                        if (cconfigs != null) {
                            WSSConsumer.checkCaller(cconfigs, tconfig, context);
                        }
                    }
                    succeeded = true;
                    if (isDecryption || isVerification) continue;
                    break;
                }
                catch (Exception e) {
                    exceptions2[exPos++] = e;
                    throwException = e instanceof SoapSecurityException ? (SoapSecurityException)e : SoapSecurityException.format("security.wssecurity.WSSConsumer.s34", e);
                    Token token = TokenManager.getUnprocessedToken(context);
                    if (token != null) {
                        if (!isDecryption && !isVerification) {
                            TokenManager.removeToken(context, token);
                            continue;
                        }
                        token.setError(throwException);
                        token.setProcessed(true);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"getUnprocessedToken returned null");
                }
            }
            if (!succeeded) {
                if (configs.size() == 1) {
                    throw throwException;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(exPos + " exceptions were catched."));
                    for (int j = 0; j < exPos; ++j) {
                        Tr.debug((TraceComponent)tc, (String)("No." + i + "'s exception: " + exceptions2[j]));
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s13", exceptions2[exPos - 1]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callTokenConsumer(Set cconfigs,Set tconfigs,Element envelope,Element security,Element target,Map context,boolean isUT,boolean isBST,int wssVersion");
        }
    }

    private static void callTokenConsumer(TokenConsumerConfig config, Element target, Map context) throws SoapSecurityException {
        TokenConsumerComponent gen;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callTokenConsumer(TokenConsumerConfig config,Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        if ((gen = config.getInstance()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to get the TokenConsumer object: [" + config + "]."));
            }
        } else {
            context.put("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey", config);
            gen.invoke(target, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callTokenConsumer(TokenConsumerConfig config,Element target,Map context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callSignatureConsumer(Set sconfig, Map selectors, Element target, boolean copiedDOMTree, Map context, Element security2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callSignatureConsumer(Set sconfig,Map selectors,Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "boolean copiedDOMTree[" + copiedDOMTree + "]," + "Map context)"));
        }
        if (sconfig.size() <= 0) {
            if (ConfigUtil.getMustUnderstand((Map)context)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"An XML Digital signature was found in the security header, but there is no inbound signature configuration.");
                }
                String msg1 = ConfigUtil.getMessage((String)"security.wssecurity.WSSConsumer.s15");
                String msg2 = Messages.getMessage("noUnderstand00", DOMUtil.getDisplayName((Node)security2, (boolean)false));
                throw new SoapSecurityException(msg1 + ": " + msg2);
            }
        } else {
            boolean succeeded = false;
            Exception[] exceptions2 = new Exception[sconfig.size()];
            int exPos = 0;
            WSSConsumer.lockResults(context, true, true);
            SignatureConsumerConfig config = null;
            Iterator i = sconfig.iterator();
            while (i.hasNext()) {
                config = (SignatureConsumerConfig)i.next();
                try {
                    WSSConsumer.callSignatureConsumer(config, selectors, target, copiedDOMTree, context);
                    succeeded = true;
                    if (!WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS)) break;
                    SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.VALID_SIGNATURE, null);
                    WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, messageContext, context);
                    break;
                }
                catch (Exception e) {
                    exceptions2[exPos++] = e;
                    if (!WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.ERROR)) continue;
                    SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.INVALID_SIGNATURE, e.toString());
                    WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, messageContext, context);
                }
                finally {
                    WSSConsumer.removeKeyInfoResults(context);
                    if (succeeded) continue;
                    WSSConsumer.restoreResults(context, true);
                }
            }
            if (!succeeded) {
                if (sconfig.size() == 1) {
                    if (exceptions2[0] instanceof SoapSecurityException) {
                        throw (SoapSecurityException)exceptions2[0];
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s15", exceptions2[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(exPos + " exceptions were catched."));
                    for (int j = 0; j < exPos; ++j) {
                        Tr.debug((TraceComponent)tc, (String)("No." + i + "'s exception: " + exceptions2[j]));
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s11", exceptions2[exPos - 1]);
            }
            WSSConsumer.lockResults(context, true, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callSignatureConsumer(Set sconfig,Map selectors,Element target,boolean copiedDOMTree,Map context)");
        }
    }

    private static void callSignatureConsumer(SignatureConsumerConfig config, Map selectors, Element target, boolean copiedDOMTree, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callSignatureConsumer(SignatureConsumerConfig config,Map properties,Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "boolean copiedDOMTree[" + copiedDOMTree + "]," + "Map context)"));
        }
        SignatureConsumer con = (SignatureConsumer)selectors.get(SignatureConsumer.class);
        context.put("com.ibm.wsspi.wssecurity.config.signatureConsumer.configKey", config);
        if (copiedDOMTree) {
            context.put("com.ibm.ws.webservices.wssecurity.constants.copiedDOMTree", "true");
        } else {
            context.remove("com.ibm.ws.webservices.wssecurity.constants.copiedDOMTree");
        }
        con.invoke(target, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callSignatureConsumer(SignatureConsumerConfig config,Map selectors,Element target,boolean copiedDOMTree,Map context)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void callEncryptionConsumer(Set econfig, Map selectors, Element target, Map context, Element security2) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callEncryptionConsumer(Set econfig,Map selectors,Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        boolean succeeded = false;
        Exception[] exceptions2 = new Exception[econfig.size()];
        int exPos = 0;
        if (econfig.size() <= 0) {
            if (ConfigUtil.getMustUnderstand((Map)context)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Encryption information was found in the security header, but there is no inbound encryption configuration.");
                }
                String msg1 = ConfigUtil.getMessage((String)"security.wssecurity.WSSConsumer.s16");
                String msg2 = Messages.getMessage("noUnderstand00", DOMUtil.getDisplayName((Node)security2, (boolean)false));
                throw new SoapSecurityException(msg1 + ": " + msg2);
            }
        } else {
            WSSConsumer.lockResults(context, false, true);
            EncryptionConsumerConfig config = null;
            Iterator i = econfig.iterator();
            int resultCounter = 0;
            while (i.hasNext()) {
                ++resultCounter;
                config = (EncryptionConsumerConfig)i.next();
                try {
                    WSSConsumer.callEncryptionConsumer(config, selectors, target, context);
                    succeeded = true;
                    break;
                }
                catch (Exception e) {
                    KeyInfoResult[] kresults;
                    exceptions2[exPos++] = e;
                    if (!WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, WSSAuditService.WSSAuditOutcome.ERROR)) continue;
                    SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                    Map<String, Object> auditContext = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.DECRYPTION_ERROR, e.getMessage());
                    Result[] results = ResultPool.get((Map)context, KeyInfoResult.class);
                    KeyInfoResult result = null;
                    if (results != null && results.length > 0) {
                        if (resultCounter == results.length) {
                            result = (KeyInfoResult)results[results.length - 1];
                        } else {
                            kresults = new KeyInfoResult[results.length];
                            for (int count = 0; count < results.length; ++count) {
                                kresults[count] = (KeyInfoResult)results[count];
                            }
                            for (int j = count; j < resultCounter; ++j) {
                                kresults[j] = new KeyInfoResult(null);
                            }
                        }
                    } else {
                        kresults = new KeyInfoResult[resultCounter];
                        for (int j = 0; j < resultCounter; ++j) {
                            kresults[j] = new KeyInfoResult(null);
                            ResultPool.add((Map)context, (Result)kresults[j]);
                        }
                    }
                    WSSAuditEventGeneratorImpl.getInstance().addEncryptionEventData(auditContext, result);
                    WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, messageContext, context);
                }
                finally {
                    WSSConsumer.removeKeyInfoResults(context);
                    if (succeeded) continue;
                    WSSConsumer.restoreResults(context, false);
                }
            }
            if (!succeeded) {
                if (econfig.size() == 1) {
                    if (exceptions2[0] instanceof SoapSecurityException) {
                        throw (SoapSecurityException)exceptions2[0];
                    }
                    throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s16", exceptions2[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(exPos + " exceptions were catched."));
                    for (int j = 0; j < exPos; ++j) {
                        Tr.debug((TraceComponent)tc, (String)("No." + i + "'s exception: " + exceptions2[j]));
                    }
                }
                throw SoapSecurityException.format("security.wssecurity.WSSConsumer.s12", exceptions2[exPos - 1]);
            }
            WSSConsumer.lockResults(context, false, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callEncryptionConsumer(Set econfig,Map selectors,Element target,Map context)");
        }
    }

    private static void callEncryptionConsumer(EncryptionConsumerConfig config, Map selectors, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("callEncryptionConsumer(EncryptionConsumerConfig config,Map selectors,Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map context)"));
        }
        EncryptionConsumer con = (EncryptionConsumer)selectors.get(EncryptionConsumer.class);
        context.put("com.ibm.wsspi.wssecurity.config.encryptionConsumer.configKey", config);
        con.invoke(target, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callEncryptionConsumer(EncryptionConsumerConfig config,Map selectors,Element target,Map context)");
        }
    }

    private static void checkRequiredIntegrity(Document doc, Map selectors, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkRequiredIntegrity(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "WSSConsumerConfig config," + "Map selectors," + "Map context)"));
        }
        try {
            WSSConsumerComponent component2 = (WSSConsumerComponent)selectors.get(VerifiedPartChecker.class);
            component2.invoke(doc, context);
        }
        catch (SoapSecurityException e) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.DENIED)) {
                SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.INTEGRITY_BAD, e.toString());
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, messageContext, context);
            }
            throw e;
        }
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.INTEGRITY, null);
            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_SIGNING, messageContext, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredIntegrity(Document doc,Map selectors,Map context)");
        }
    }

    private static void checkRequiredConfidentiality(Document doc, Map selectors, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkRequiredConfidentiality(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Map selectors," + "Map context)"));
        }
        try {
            WSSConsumerComponent component2 = (WSSConsumerComponent)selectors.get(DecryptedPartChecker.class);
            component2.invoke(doc, context);
        }
        catch (SoapSecurityException e) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, WSSAuditService.WSSAuditOutcome.DENIED)) {
                SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.CONFIDENTIALITY_BAD, e.getMessage());
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, messageContext, context);
            }
            throw e;
        }
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.CONFIDENTIALITY, null);
            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_ENCRYPTION, messageContext, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredConfidentiality(Document doc,Map selectors,Map context)");
        }
    }

    private static void checkRequiredSecurityToken(Set tokens, Set callers, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkRequiredSecurityToken(Set tokens[" + tokens + "]," + "Set callers[" + callers + "]," + "Map context)"));
        }
        Set set = TokenManager.getTokens(context);
        if (tc.isDebugEnabled()) {
            if (set == null) {
                Tr.debug((TraceComponent)tc, (String)"The subject has no Token object.");
            } else {
                Tr.debug((TraceComponent)tc, (String)(set.size() + " tokens found in the subject."));
            }
        }
        boolean typeCheck = false;
        for (TokenConsumerConfig tconfig : tokens) {
            if (!ConfigUtil.isUsageRequired((String)tconfig.getUsage())) continue;
            typeCheck = false;
            QName config_qn = tconfig.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking the value type [" + config_qn + "]..."));
            }
            if (callers != null) {
                for (WSSConsumerConfig.CallerConfig cconfig : callers) {
                    if (cconfig.getTokenConsumerType().equals(cconfig.getTokenType()) || !config_qn.equals(cconfig.getTokenConsumerType())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Remapped the value type [" + config_qn + "] to the value type [" + cconfig.getTokenType() + "]."));
                    }
                    config_qn = cconfig.getTokenType();
                }
            }
            if (set != null) {
                for (Token token : set) {
                    QName token_qn = token.getType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Comparing with the value type of the Token [" + token_qn + "]..."));
                    }
                    if (!config_qn.equals(token_qn)) continue;
                    typeCheck = true;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"A corresponding token found.");
                    break;
                }
            }
            if (typeCheck) continue;
            throw SoapSecurityException.format(Constants.FAILED_CHECK, "security.wssecurity.WSSConsumer.s14", tconfig.getType().toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredSecurityToken(Set tokens,Set callers,Map context)");
        }
    }

    private static void checkRequiredTimestamp(Document doc, TimestampConsumerConfig config, Map selectors, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkRequiredTimestamp(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "TimestampConsumerConfig config," + "Map selectors," + "Map context)"));
        }
        try {
            WSSConsumerComponent component2 = (WSSConsumerComponent)selectors.get(TimestampChecker.class);
            context.put("com.ibm.wsspi.wssecurity.config.timestampConsumer.configKey", config);
            component2.invoke(doc, context);
        }
        catch (SoapSecurityException e) {
            if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, WSSAuditService.WSSAuditOutcome.DENIED)) {
                SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.TIMESTAMP_BAD, e.getMessage());
                WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, messageContext, context);
            }
            throw e;
        }
        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(context, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.TIMESTAMP, null);
            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_RESOURCE_ACCESS, messageContext, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRequiredTimestamp(Document doc,TimestampConsumerConfig config,Map selectors,Map context)");
        }
    }

    private static void checkCaller(Set cconfigs, TokenConsumerConfig tconfig, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCaller(Set cconfigs,TokenConsumerConfig tconfig,Map context)");
        }
        if (tconfig != null && cconfigs != null) {
            Set tokens = TokenManager.getTokens(context);
            if (tokens.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(tokens.size() + " tokens found."));
                }
            } else {
                tokens = null;
            }
            QName config_cqn = tconfig.getType();
            for (WSSConsumerConfig.CallerConfig cconfig : cconfigs) {
                WSSConsumerConfig.CallerConfig tmconfig;
                if (cconfig.getPart() == null) {
                    QName caller_tqn = cconfig.getTokenType();
                    QName caller_cqn = cconfig.getTokenConsumerType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("TokenConsumer type in the Caller [" + caller_cqn + "], " + "TokenConsumer type [" + config_cqn + "]."));
                    }
                    if (config_cqn.equals(caller_cqn) && tokens != null) {
                        for (Token token : tokens) {
                            boolean checked = token.getCallerChecked();
                            boolean trusted = token.isTrusted();
                            QName token_tqn = token.getType();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Token type in the Caller [" + caller_tqn + "] and " + "Token type [" + token_tqn + "]."));
                                Tr.debug((TraceComponent)tc, (String)("Caller checked [" + checked + "]."));
                                Tr.debug((TraceComponent)tc, (String)("Token trusted [" + trusted + "]."));
                            }
                            if (checked || trusted || !caller_tqn.equals(token_tqn)) continue;
                            AuthResult aresult = new AuthResult(token, cconfig);
                            token.setCallerChecked(true);
                            ResultPool.add((Map)context, (Result)aresult);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Added AuthResult[" + aresult + "] into the ResultPool."));
                        }
                    }
                }
                if ((tmconfig = cconfig.getTrustMethod()) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"TrustMethod configuration found.");
                }
                if (tmconfig.getPart() != null) continue;
                QName tm_tqn = tmconfig.getTokenType();
                QName tm_cqn = tmconfig.getTokenConsumerType();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TokenConsumer type in the TrustMethod [" + tm_cqn + "], " + "TokenConsumer type [" + config_cqn + "]."));
                }
                if (!config_cqn.equals(tm_cqn) || tokens == null) continue;
                for (Token token : tokens) {
                    boolean checked = token.getCallerChecked();
                    boolean trusted = token.isTrusted();
                    QName token_tqn = token.getType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Token type in the TrustMethod [" + tm_tqn + "] and " + "Token type [" + token_tqn + "]."));
                        Tr.debug((TraceComponent)tc, (String)("TrustMethod checked [" + checked + "]."));
                        Tr.debug((TraceComponent)tc, (String)("Token trusted [" + trusted + "]."));
                    }
                    if (checked || !trusted || !tm_tqn.equals(token_tqn)) continue;
                    AuthResult aresult = new AuthResult(token, tmconfig);
                    token.setCallerChecked(true);
                    ResultPool.add((Map)context, (Result)aresult);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Added AuthResult[" + aresult + "] into the ResultPool."));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(Set cconfig,TokenConsumerConfig tconfig,Map context)");
        }
    }

    private static void checkCaller(Set cconfigs, TokenConsumerConfig tconfig, Token token, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCaller(Set cconfigs,TokenConsumerConfig tconfig,Token token,Map context)");
        }
        if (tconfig != null && cconfigs != null) {
            QName config_cqn = tconfig.getType();
            for (WSSConsumerConfig.CallerConfig cconfig : cconfigs) {
                WSSConsumerConfig.CallerConfig tmconfig;
                if (cconfig.getPart() == null) {
                    QName caller_tqn = cconfig.getTokenType();
                    QName caller_cqn = cconfig.getTokenConsumerType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("TokenConsumer type in the Caller [" + caller_cqn + "], " + "TokenConsumer type [" + config_cqn + "]."));
                    }
                    if (config_cqn.equals(caller_cqn)) {
                        boolean checked = token.getCallerChecked();
                        boolean trusted = token.isTrusted();
                        QName token_tqn = token.getType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Token type in the Caller [" + caller_tqn + "] and " + "Token type [" + token_tqn + "]."));
                            Tr.debug((TraceComponent)tc, (String)("Caller checked [" + checked + "]."));
                            Tr.debug((TraceComponent)tc, (String)("Token trusted [" + trusted + "]."));
                        }
                        if (!checked && !trusted && caller_tqn.equals(token_tqn)) {
                            AuthResult aresult = new AuthResult(token, cconfig);
                            token.setCallerChecked(true);
                            ResultPool.add((Map)context, (Result)aresult);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Added AuthResult[" + aresult + "] into the ResultPool."));
                            }
                        }
                    }
                }
                if ((tmconfig = cconfig.getTrustMethod()) == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"TrustMethod configuration found.");
                }
                if (tmconfig.getPart() != null) continue;
                QName tm_tqn = tmconfig.getTokenType();
                QName tm_cqn = tmconfig.getTokenConsumerType();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TokenConsumer type in the TrustMethod [" + tm_cqn + "], " + "TokenConsumer type [" + config_cqn + "]."));
                }
                if (!config_cqn.equals(tm_cqn)) continue;
                boolean checked = token.getCallerChecked();
                boolean trusted = token.isTrusted();
                QName token_tqn = token.getType();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token type in the TrustMethod [" + tm_tqn + "] and " + "Token type [" + token_tqn + "]."));
                    Tr.debug((TraceComponent)tc, (String)("TrustMethod checked [" + checked + "]."));
                    Tr.debug((TraceComponent)tc, (String)("Token trusted [" + trusted + "]."));
                }
                if (checked || !trusted || !tm_tqn.equals(token_tqn)) continue;
                AuthResult aresult = new AuthResult(token, tmconfig);
                token.setCallerChecked(true);
                ResultPool.add((Map)context, (Result)aresult);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Added AuthResult[" + aresult + "] into the ResultPool."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(Set cconfig,TokenConsumerConfig tconfig,Token token,Map context)");
        }
    }

    private static void checkCaller(Map selectors, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCaller(Map selectors,Map context)");
        }
        WSSConsumerComponent component2 = (WSSConsumerComponent)selectors.get(LoginProcessor.class);
        component2.invoke(null, context);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCaller(Map selectors, Map context)");
        }
    }

    private static void cleanSubject(Map context) throws SoapSecurityException {
        Set tokens;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanSubject(Map context)");
        }
        if ((tokens = TokenManager.getTokens(context)) != null && tokens.size() > 0) {
            String uid;
            Token t;
            Object result;
            int i;
            HashMap<String, Token> id2token = new HashMap<String, Token>();
            Result[] results = ResultPool.get((Map)context, VerificationResult.class);
            if (results != null) {
                for (i = 0; i < results.length; ++i) {
                    result = (VerificationResult)results[i];
                    t = ((VerificationResult)result).getToken();
                    if (t == null) continue;
                    uid = t.getUniqueID();
                    if (id2token.containsKey(uid)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("WARNING: The token that has the same unique id [" + uid + "] exists."));
                        Tr.debug((TraceComponent)tc, (String)("The already stored token is [" + id2token.get(uid) + "] and this is keeped."));
                        Tr.debug((TraceComponent)tc, (String)("A newly found token is [" + t + "] and this is ignored."));
                        continue;
                    }
                    id2token.put(uid, t);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("The token whose unique id is [" + uid + "]: <<<" + t + ">>>."));
                }
            }
            if ((results = ResultPool.get((Map)context, DecryptionResult.class)) != null) {
                for (i = 0; i < results.length; ++i) {
                    result = (DecryptionResult)results[i];
                    t = ((DecryptionResult)result).getToken();
                    if (t == null) continue;
                    uid = t.getUniqueID();
                    if (id2token.containsKey(uid)) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("WARNING: The token that has the same unique id [" + uid + "] exists."));
                        Tr.debug((TraceComponent)tc, (String)("The already stored token is [" + id2token.get(uid) + "] and this is keeped."));
                        Tr.debug((TraceComponent)tc, (String)("A newly found token is [" + t + "] and this is ignored."));
                        continue;
                    }
                    id2token.put(uid, t);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("The token whose unique id is [" + uid + "]: <<<" + t + ">>>."));
                }
            }
            for (Token t2 : tokens) {
                String uid2;
                if (t2.getError() != null || id2token.containsKey(uid2 = t2.getUniqueID())) continue;
                id2token.put(uid2, t2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("The token whose unique id is [" + uid2 + "]: <<<" + t2 + ">>>."));
            }
            TokenManager.removeAllTokens(context);
            if (id2token.size() > 0) {
                TokenManager.setTokens(context, id2token.values());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanSubject(Map context)");
        }
    }

    private static void cleanContext(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanSubject(Map context)");
        }
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING);
        context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE);
        context.remove("com.ibm.wsspi.wssecurity.token.x509.keyLocator");
        context.remove("com.ibm.wsspi.wssecurity.token.x509.certificate");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanSubject(Map context)");
        }
    }

    private static void mapTokenToMessageContext(SOAPMessageContext messageContext, Map context) {
        block23: {
            Token token2;
            block26: {
                Result[] results;
                block25: {
                    VerificationResult result;
                    Token t;
                    block24: {
                        boolean isServer;
                        if (tc.isEntryEnabled()) {
                            Tr.entry((TraceComponent)tc, (String)"mapTokenToMessageContext(SOAPMessageContext messageContext,Map context)");
                        }
                        int number = 0;
                        Set tokens = TokenManager.getTokens(context);
                        if (tokens != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(tokens.size() + " tokens found."));
                            }
                            if (tokens.size() > 0) {
                                Hashtable<String, Token> table = new Hashtable<String, Token>();
                                for (Token token2 : tokens) {
                                    String id = token2.getId();
                                    if (id == null) {
                                        id = IdUtil.getInstance().makeUniqueId(null, "Token_") + "_" + ++number;
                                    }
                                    table.put(id, token2);
                                }
                                messageContext.setProperty(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TOKEN_PROPERGATION, table);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"A table of tokens is copied to the property in the MessageContext.");
                                }
                            }
                        }
                        if (!(isServer = WSSecurityPlatformContextFactory.getInstance().isServer())) break block23;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"This is server process. So the runtime is storing a signer certificate...");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Checking verification results...");
                        }
                        if ((results = ResultPool.get((Map)context, VerificationResult.class)) != null && results.length != 0) break block24;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No signer X509 certificate was found in the request message.");
                        }
                        break block23;
                    }
                    token2 = null;
                    if (results.length != 1) break block25;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Only one verification token found.");
                    }
                    if (!((t = (result = (VerificationResult)results[0]).getToken()) instanceof X509BSToken)) break block26;
                    token2 = (X509BSToken)t;
                    break block26;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"More than one verification tokens found.");
                }
                for (int i = 0; i < results.length; ++i) {
                    VerificationResult result = (VerificationResult)results[i];
                    Token t = result.getToken();
                    if (!(t instanceof X509BSToken) || !t.getUsedToLogin()) continue;
                    token2 = (X509BSToken)t;
                    break;
                }
            }
            if (token2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to specify the one of X509 certificates in the request message.");
                }
                messageContext.removeProperty("com.ibm.xml.soapsec.RequestCert");
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The X509 token that includes a signer certificate [" + token2 + "]."));
                }
                X509Certificate cert = null;
                try {
                    cert = ((X509BSToken)token2).getCert();
                }
                catch (SoapSecurityException e) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s32", (Object)new Object[]{e});
                }
                if (cert == null) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSSConsumer.s33");
                    messageContext.removeProperty("com.ibm.xml.soapsec.RequestCert");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Signer certificate is stored in the message context [" + cert + "]."));
                    }
                    messageContext.setProperty("com.ibm.xml.soapsec.RequestCert", cert);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapTokenToMessageContext(SOAPMessageContext messageContext,Map context)");
        }
    }

    private static void copyContextSubjectToMessageContext(SOAPMessageContext messageContext, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"copyContextSubjectToMessageContext(SOAPMessageContext messageContext, Map context)");
        }
        Subject subject = (Subject)context.get("com.ibm.wsspi.wssecurity.core.subject");
        messageContext.setProperty(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TOKEN_WSSSUBJECT, subject);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyContextSubjectToMessageContext(SOAPMessageContext messageContext, Map context)");
        }
    }

    private static void lockResults(Map context, boolean signature, boolean locked) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("lockResults(Map context,boolean signature[" + signature + "]," + "boolean locked[" + locked + "])"));
        }
        if (signature) {
            Result[] results = ResultPool.get((Map)context, VerificationResult.class);
            if (results != null && results.length > 0) {
                for (int i = 0; i < results.length; ++i) {
                    VerificationResult result = (VerificationResult)results[i];
                    result.setLocked(locked);
                }
            }
        } else {
            Result[] results = ResultPool.get((Map)context, DecryptionResult.class);
            if (results != null && results.length > 0) {
                for (int i = 0; i < results.length; ++i) {
                    DecryptionResult result = (DecryptionResult)results[i];
                    result.setLocked(locked);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lockResults(Map context,boolean signature,boolean locked)");
        }
    }

    private static void removeKeyInfoResults(Map context) {
        Result[] results;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeKeyInfoResults(Map context)");
        }
        if ((results = ResultPool.get((Map)context, KeyInfoResult.class)) != null && results.length > 0) {
            ResultPool.remove((Map)context, (Result[])results);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeKeyInfoResults(Map context)");
        }
    }

    private static void restoreResults(Map context, boolean signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("restoreResults(Map context,boolean signature[" + signature + "])"));
        }
        if (signature) {
            VerificationResult result;
            Result[] results = ResultPool.get((Map)context, VerificationResult.class);
            if (results != null && results.length > 0 && !(result = (VerificationResult)results[results.length - 1]).getLocked()) {
                List list;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Restoring a verification result [" + result + "]..."));
                }
                if ((list = result.getVerifiedParts()) != null) {
                    int iMax = list.size();
                    for (int i = 0; i < iMax; ++i) {
                        VerificationResult.VerifiedPart part = (VerificationResult.VerifiedPart)list.get(i);
                        if (part.getNonce() == null && part.getTimestamp() == null) continue;
                        if (part.getNonceFirst()) {
                            part.getParent().appendChild(part.getNonce());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Nonce is restored into the node[" + DOMUtil.getDisplayName((Node)part.getParent()) + "]."));
                            }
                            if (part.getNonce() == null) continue;
                            part.getParent().appendChild(part.getTimestamp());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Timestmap is restored into the node[" + DOMUtil.getDisplayName((Node)part.getParent()) + "]."));
                            continue;
                        }
                        part.getParent().appendChild(part.getTimestamp());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Timestamp is restored into the node[" + DOMUtil.getDisplayName((Node)part.getParent()) + "]."));
                        }
                        if (part.getNonce() == null) continue;
                        part.getParent().appendChild(part.getNonce());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Nonce is restored into the node[" + DOMUtil.getDisplayName((Node)part.getParent()) + "]."));
                    }
                }
                ResultPool.remove((Map)context, (Result)result);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Removed the verification result.");
                }
            }
        } else {
            DecryptionResult result;
            Result[] results = ResultPool.get((Map)context, DecryptionResult.class);
            if (results != null && results.length > 0 && !(result = (DecryptionResult)results[results.length - 1]).getLocked()) {
                List list;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Restoring a decryption result [" + result + "]..."));
                }
                if ((list = result.getDecryptedParts()) != null) {
                    int iMax = list.size();
                    for (int i = 0; i < iMax; ++i) {
                        DecryptionResult.DecryptedPart part = (DecryptionResult.DecryptedPart)list.get(i);
                        if (part.getNonce() == null && part.getTimestamp() == null) continue;
                        if (part.getNonceFirst()) {
                            part.getParent().appendChild(part.getNonce());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Nonce is restored into the node[" + DOMUtil.getDisplayName((Node)part.getParent()) + "]."));
                            }
                            if (part.getNonce() == null) continue;
                            part.getParent().appendChild(part.getTimestamp());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Timestmap is restored into the node[" + DOMUtil.getDisplayName((Node)part.getParent()) + "]."));
                            continue;
                        }
                        part.getParent().appendChild(part.getTimestamp());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Timestamp is restored into the node[" + DOMUtil.getDisplayName((Node)part.getParent()) + "]."));
                        }
                        if (part.getNonce() == null) continue;
                        part.getParent().appendChild(part.getNonce());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Nonce is restored into the node[" + DOMUtil.getDisplayName((Node)part.getParent()) + "]."));
                    }
                }
                ResultPool.remove((Map)context, (Result)result);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Removed the decryption result.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreResults(Map context,boolean signature)");
        }
    }

    private static int getUsedFor(Element envelope, Element security2, String nsWsse, String id) {
        int ret;
        block10: {
            NodeList list;
            block11: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)("getUsedFor(Element envelope[" + DOMUtil.getDisplayName((Node)envelope) + "]," + "Element security[" + DOMUtil.getDisplayName((Node)security2) + "]," + "String nsWsse[" + nsWsse + "]," + "String id[" + id + "])"));
                }
                ret = 0;
                if (id == null || id.length() <= 0) break block10;
                id = "#" + id;
                list = envelope.getElementsByTagNameNS(nsWsse, "Reference");
                if (list != null && list.getLength() != 0) break block11;
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"No wsse:Reference element found.");
                break block10;
            }
            int len = list.getLength();
            if (tc.isDebugEnabled()) {
                if (len == 1) {
                    Tr.debug((TraceComponent)tc, (String)(len + " wsse:Reference element found."));
                } else {
                    Tr.debug((TraceComponent)tc, (String)(len + " wsse:Reference elements found."));
                }
            }
            for (int i = 0; i < len; ++i) {
                Node parent;
                Element sec2;
                Element elem = (Element)list.item(i);
                String refUri = elem.getAttribute("URI");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing URI [" + refUri + "]..."));
                }
                if (!id.equals(refUri) || !DOMUtil.equals((Node)(sec2 = DOMUtil.getAncestorElement((Element)elem, (String)nsWsse, (String)"Security")), (Node)security2)) continue;
                Element keyInfo = DOMUtil.getAncestorElement((Element)elem, (String)Constants.NS_DSIG, (String)"KeyInfo");
                if (keyInfo == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"ds:KeyInfo is not found as an ancestor.");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ds:KeyInfo is found as an ancestor.");
                }
                if ((parent = keyInfo.getParentNode()) == null || parent.getNodeType() != 1) continue;
                if (DOMUtil.equals((Node)parent, (String)Constants.NS_DSIG, (String)"Signature")) {
                    ret = 1;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"The token is used for signature verification.");
                    break;
                }
                if (!DOMUtil.equals((Node)parent, (String)Constants.NS_ENC, (String)"EncryptedKey") && !DOMUtil.equals((Node)parent, (String)Constants.NS_ENC, (String)"EncryptedData")) continue;
                ret = 2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"The token is used for decryption.");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getUsedFor(Element envelope,Element security,String nsWsse,String id) returns int[" + ret + "]"));
        }
        return ret;
    }
}

