/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ws.webservices.wssecurity.enc.PartList;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RequestMessagePool {
    private static final TraceComponent tc = Tr.register(RequestMessagePool.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = RequestMessagePool.class.getName();

    private static void clear(Map context) {
        StoredMessage smes = (StoredMessage)context.get(RequestMessagePool.class);
        if (smes == null) {
            return;
        }
        smes.clear();
    }

    public static void addDocument(Map context, Document doc, List list, boolean cloneDoc) {
        StoredMessage smes;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addDocument(Map context,Docment doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "List list," + "boolean cloneDoc[" + cloneDoc + "]"));
        }
        if ((smes = (StoredMessage)context.get(RequestMessagePool.class)) == null) {
            smes = new StoredMessage();
            context.put(RequestMessagePool.class, smes);
        }
        smes.addDocument(doc, list, cloneDoc);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addDocument(Map context,Docment doc,List list,boolean cloneDoc[" + cloneDoc + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addElement(Map context, Element objToBeEncrypted, Element encryptedData, Element headerInfo) {
        StoredMessage smes;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addElement(Map context,Element objToBeEncrypted[" + DOMUtil.getDisplayName((Node)objToBeEncrypted) + "]," + "Element encryptedData[" + DOMUtil.getDisplayName((Node)encryptedData) + "]," + "Element headerInfo[" + DOMUtil.getDisplayName((Node)headerInfo) + "])"));
        }
        if ((smes = (StoredMessage)context.get(RequestMessagePool.class)) == null) {
            smes = new StoredMessage();
            context.put(RequestMessagePool.class, smes);
        }
        StoredMessage storedMessage = smes;
        synchronized (storedMessage) {
            smes.addElement(objToBeEncrypted, encryptedData, headerInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addElement(Map context,Element objToBeEncrypted,Element encryptedData,Element headerInfo)");
        }
    }

    public static Document getDocument(Map context, int order) {
        StoredMessage smes;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDocument(Map context,int order[" + order + "])"));
        }
        if ((smes = (StoredMessage)context.get(RequestMessagePool.class)) == null) {
            smes = new StoredMessage();
            context.put(RequestMessagePool.class, smes);
        }
        Document ret = smes.getDocument(order);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDocument(Map context,int order) returns Document[" + DOMUtil.getDisplayName((Node)ret) + "]"));
        }
        return ret;
    }

    public static EncryptedObject convertElement(Map context, Element object, int order) {
        StoredMessage smes;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertElement(Map context,Element object[" + DOMUtil.getDisplayName((Node)object) + "]," + "int order[" + order + "])"));
        }
        if ((smes = (StoredMessage)context.get(RequestMessagePool.class)) == null) {
            smes = new StoredMessage();
            context.put(RequestMessagePool.class, smes);
        }
        EncryptedObject ret = smes.convertElement(object, order);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("convertElement(Map context,Element object,int order) returns EncryptedObject[" + ret + "]"));
        }
        return ret;
    }

    public static void initialize(Map context) {
        RequestMessagePool.clear(context);
    }

    public static void finalize(Map context) {
        RequestMessagePool.clear(context);
        context.remove(RequestMessagePool.class);
    }

    public static class EncryptedObject {
        private Element _headerInfo;
        private Element _encryptedData;

        public Element getHeaderInfo() {
            return this._headerInfo;
        }

        public Element getEncryptedData() {
            return this._encryptedData;
        }

        public void setEncryptedData(Element encryptedData) {
            this._encryptedData = encryptedData;
        }

        public String toString() {
            return "Element headerInfo[" + DOMUtil.getDisplayName((Node)this._headerInfo) + "]," + "Element encryptedData[" + DOMUtil.getDisplayName((Node)this._encryptedData) + "]";
        }
    }

    private static class StoredMessage {
        private ArrayList _messageList = new ArrayList();
        private ArrayList _objectList = new ArrayList();
        private ArrayList _edataList = new ArrayList();

        private StoredMessage() {
        }

        private void clear() {
            this._messageList.clear();
            this._objectList.clear();
            this._edataList.clear();
        }

        private void addDocument(Document doc, List list, boolean cloneDoc) {
            long lMilli = System.currentTimeMillis();
            String attr = "Attr" + lMilli;
            String valueBase = "dummy_";
            HashMap<String, Element> av2el = new HashMap<String, Element>();
            int count = 0;
            for (PartList parts : list) {
                for (int j = 0; j < parts.getLength(); ++j) {
                    Node node = parts.item(j);
                    if (node.getNodeType() != 1) continue;
                    Element el = (Element)node;
                    String value = valueBase + count++;
                    el.setAttribute(attr, value);
                    av2el.put(value, el);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Set attribute[" + attr + "=" + value + "] to the element[" + DOMUtil.getDisplayName((Node)el) + "]"));
                }
            }
            Document doc2 = cloneDoc ? (Document)doc.cloneNode(true) : doc;
            HashMap object = new HashMap();
            Element root = doc2.getDocumentElement();
            if (root != null) {
                this.putElement(root, object, av2el, attr);
            }
            this._messageList.add(doc2);
            this._objectList.add(object);
            this._edataList.add(new HashMap());
            for (PartList parts : list) {
                for (int j = 0; j < parts.getLength(); ++j) {
                    Node node = parts.item(j);
                    if (node.getNodeType() != 1) continue;
                    Element el = (Element)node;
                    el.removeAttribute(attr);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Removed attribute[" + attr + "] from the element[" + DOMUtil.getDisplayName((Node)el) + "]"));
                }
            }
        }

        private void putElement(Element root, Map object, Map av2el, String attr) {
            Element el = DOMUtil.getFirstElement((Node)root);
            while (el != null) {
                String value;
                if (el.hasAttribute(attr) && (value = el.getAttribute(attr)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found attribute[" + attr + "=" + value + "] at the element[" + DOMUtil.getDisplayName((Node)el) + "]"));
                    }
                    object.put(av2el.get(value), el);
                }
                this.putElement(el, object, av2el, attr);
                el = DOMUtil.getNextElement((Node)el);
            }
        }

        private void addElement(Element objToBeEncrypted, Element encryptedData, Element headerInfo) {
            int pos = this._messageList.size() - 1;
            if (pos >= 0) {
                HashMap object = (HashMap)this._objectList.get(pos);
                HashMap edata = (HashMap)this._edataList.get(pos);
                Object obj = object.get(objToBeEncrypted);
                if (obj != null) {
                    EncryptedObject eobj = new EncryptedObject();
                    eobj._headerInfo = headerInfo;
                    eobj._encryptedData = encryptedData;
                    edata.put(obj, eobj);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set EncryptedData and HeaderInfo(EncryptedKey or ReferenceList) for the element [" + DOMUtil.getDisplayName((Node)((Element)obj)) + "]."));
                    }
                }
            }
        }

        private Document getDocument(int order) {
            Document doc = null;
            int pos = this._messageList.size() - 1 - order;
            if (pos >= 0) {
                doc = (Document)this._messageList.get(pos);
            }
            return doc;
        }

        private EncryptedObject convertElement(Element object, int order) {
            EncryptedObject eobj = null;
            if (order >= 0) {
                int pos = this._messageList.size() - 1 - order;
                if (pos >= 0) {
                    HashMap edata = (HashMap)this._edataList.get(pos);
                    eobj = (EncryptedObject)edata.get(object);
                }
            } else {
                for (int pos = this._messageList.size() - 1; pos >= 0; --pos) {
                    HashMap edata = (HashMap)this._edataList.get(pos);
                    HashMap objects = (HashMap)this._objectList.get(pos);
                    for (Element key : objects.keySet()) {
                        if (!DOMUtil.equalsc14n(key, object, false)) continue;
                        eobj = (EncryptedObject)edata.get(objects.get(key));
                        break;
                    }
                    if (eobj != null) break;
                }
            }
            return eobj;
        }
    }
}

