/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.wssecurity.KRBContext;
import com.ibm.ws.webservices.wssecurity.config.KRBConfig;
import com.ibm.ws.webservices.wssecurity.config.KRBConfigException;
import com.ibm.ws.webservices.wssecurity.core.KRBCredential;
import java.util.HashMap;
import java.util.Map;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class KRBCredentialsFactory {
    private static GSSManager gssMgr;
    private static Map serverCredentials;
    private static TraceComponent tc;

    public static boolean initializeServer(KRBConfig serverConfig) throws KRBConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServer");
        }
        String serviceName = serverConfig.getServiceName();
        boolean success = false;
        try {
            KRBCredential credential = new KRBCredential(serverConfig);
            serverCredentials.put(serviceName, credential);
            if (tc.isAuditEnabled()) {
                Tr.audit(tc, "security.wssecurity.kerberos.spn.init.success", new Object[]{serviceName});
            }
            success = true;
        }
        catch (GSSException e) {
            Tr.error(tc, "security.wssecurity.kerberos.spn.init.failed", new Object[]{serviceName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeServer");
        }
        return success;
    }

    public static void initialize() {
        gssMgr = GSSManager.getInstance();
        serverCredentials = new HashMap(16);
    }

    public static KRBContext createContext(String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createContext for " + serverName);
        }
        KRBContext result = null;
        KRBCredential credential = (KRBCredential)serverCredentials.get(serverName);
        GSSCredential gssCred = credential.getGssCred();
        result = new KRBContext(gssCred);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createContext");
        }
        return result;
    }

    public static boolean hasServerCredentialsFor(String serverName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "KRBCredentialsFactory.hasServerCredentialsFor(" + serverName + ") = " + serverCredentials.containsKey(serverName));
        }
        return serverCredentials.containsKey(serverName);
    }

    public static GSSManager getMgr() {
        return gssMgr;
    }

    static {
        tc = Tr.register(KRBCredentialsFactory.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

