/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCache;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCacheImpl;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Permission;

public class DistributedConfigCacheFactory {
    private static final TraceComponent tc = Tr.register(DistributedConfigCacheFactory.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = DistributedConfigCacheFactory.class.getName();
    private static final String comp = "security.wssecurity";
    private static final Permission INIT_PERMISSION = new WebSphereRuntimePermission("wssecurity.DistributedConfigCacheFactory.init");
    private static final Permission GET_INSTANCE_PERMISSION = new WebSphereRuntimePermission("wssecurity.DistributedConfigCacheFactory.getInstance");
    private static DistributedConfigCache _instance;
    private static boolean _initialized;
    private static boolean _useCache;
    private static String _cacheName;
    private static int _cacheSize;
    private static int _cacheTimeToLive;

    private DistributedConfigCacheFactory() {
    }

    public static DistributedConfigCache getInstance() throws SoapSecurityException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstance()");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GET_INSTANCE_PERMISSION);
        }
        DistributedConfigCache instance = null;
        if (!_initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"security.wssecurity.DistributedConfigCacheFactory.s01");
            }
        } else {
            instance = _instance;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInstance() returns config cache[" + instance + "]"));
        }
        return instance;
    }

    protected static void init_boot(boolean useCache, String cacheName, int cacheSize, int cacheTimeToLive) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("init_boot(boolean useCache[" + useCache + "]," + "String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeToLive[" + cacheTimeToLive + "])"));
        }
        _useCache = useCache;
        _cacheName = cacheName;
        _cacheSize = cacheSize;
        _cacheTimeToLive = cacheTimeToLive;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init_boot(boolean useCache, String cacheName, int cacheSize, int cacheTimeToLive)");
        }
    }

    public static synchronized void init() {
        Tr.entry((TraceComponent)tc, (String)"init()");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(INIT_PERMISSION);
        }
        if (!_initialized) {
            _instance = _useCache ? new DistributedConfigCacheImpl(_cacheName, _cacheSize, _cacheTimeToLive) : null;
            _initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    public String toString() {
        return clsName;
    }

    static {
        _initialized = false;
    }
}

