/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.wssecurity.config.KRBConfigException;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class KRBConfig {
    private static final short STR_LENGTH = 200;
    private static final String kerbModuleLabel = "Kerberos LoginModule";
    private boolean enableCredDelegate;
    private Oid gssNameType;
    private int gssCredType;
    private int gssCredDuration;
    private String realm;
    private String serviceName;
    private static TraceComponent tc = Tr.register(KRBConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public KRBConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBConfig()");
        }
        this.enableCredDelegate = false;
        this.gssNameType = GSSName.NT_USER_NAME;
        this.gssCredType = 2;
        this.gssCredDuration = Integer.MAX_VALUE;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBConfig()");
        }
    }

    public int getGssCredDuration() {
        return this.gssCredDuration;
    }

    public int getGssCredType() {
        return this.gssCredType;
    }

    public Oid getGssNameType() {
        return this.gssNameType;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isEnableCredDelegate() {
        return this.enableCredDelegate;
    }

    public void setEnableCredDelegate(String b) {
        this.enableCredDelegate = Boolean.valueOf(b);
    }

    public void setGssCredDuration(String string) {
        this.gssCredDuration = string.trim().equalsIgnoreCase("DEFAULT") ? 0 : Integer.MAX_VALUE;
    }

    public void setGssCredType(String string) {
        this.gssCredType = (string = string.trim()).equalsIgnoreCase("INITIATE") ? 1 : (string.equalsIgnoreCase("BOTH") ? 0 : 2);
    }

    public void setGssNameType(String string) {
        this.gssNameType = string.trim().equalsIgnoreCase("NT_HOSTBASED_SERVICE") ? GSSName.NT_HOSTBASED_SERVICE : GSSName.NT_USER_NAME;
    }

    public void setRealm(String string) throws KRBConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRealm " + string);
        }
        if (string == null) {
            throw new KRBConfigException(KRB5Util.getFormattedMessage(KRB5Util.getNLS(), "security.wssecurity.kerberos.property.notset", new Object[]{"com.ibm.wsspi.wssecurity.auth.KerberosRealm", kerbModuleLabel}));
        }
        this.realm = string.toUpperCase().trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRealm exit");
        }
    }

    public void setServiceName(String string) throws KRBConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceName " + string);
        }
        if (string == null) {
            throw new KRBConfigException(KRB5Util.getFormattedMessage(KRB5Util.getNLS(), "security.wssecurity.kerberos.property.notset", new Object[]{"com.ibm.wsspi.wssecurity.auth.ServiceName", kerbModuleLabel}));
        }
        StringBuffer result = new StringBuffer();
        result.append(string);
        result.append("@");
        result.append(this.realm);
        this.serviceName = result.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serviceName = " + this.serviceName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceName exit");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("\t[KRBConfig: serviceName=").append(this.getServiceName());
        sb.append("\trealm=").append(this.getRealm());
        sb.append("]\n");
        return sb.toString();
    }
}

