/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.HashSet;
import java.util.Set;

public final class CollectionCertStore {
    private String _algorithm = null;
    private CollectionCertStoreParameters _params = null;
    private Set _certNames = null;
    private String _provider = null;
    private String _name = null;
    private CertStore _certStore = null;
    private static final String comp = "security.wssecurity";
    private static final String clsName = CollectionCertStore.class.getName();
    private static final TraceComponent tc = Tr.register(CollectionCertStore.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public CollectionCertStore(String algorithm, CollectionCertStoreParameters params, String provider, String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CollectionCertStore(algorithm, params, provider, name):", new Object[]{algorithm, params, provider, name});
        }
        this._algorithm = algorithm;
        this._params = params;
        this._provider = provider;
        this._name = name;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CollectionCertStore()");
        }
    }

    public CollectionCertStore(String algorithm, Set certNames, String provider, String name) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CollectionCertStore(algorithm, certNames, provider, name):", new Object[]{algorithm, certNames, provider, name});
        }
        this._algorithm = algorithm;
        this._certNames = certNames;
        this._provider = provider;
        this._name = name;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CollectionCertStore()");
        }
    }

    public synchronized CertStore getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if (this._certStore == null) {
            HashSet<X509Extension> set = new HashSet<X509Extension>();
            if (this._params == null && this._certNames != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing CollectionCertStoreParameters");
                }
                try {
                    CertificateFactory cfac = ConfigUtil.createCertificateFactory((String)"");
                    X509Certificate cert = null;
                    X509CRL crl = null;
                    for (String href : this._certNames) {
                        block20: {
                            cert = null;
                            crl = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Creating certificate or CRL: " + href);
                            }
                            try {
                                cert = ConfigUtil.getX509Certificate((File)new File(href), (CertificateFactory)cfac);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Created certificate: " + href);
                                }
                            }
                            catch (Exception e) {
                                crl = ConfigUtil.getX509CRL((File)new File(href), (CertificateFactory)cfac);
                                if (!tc.isDebugEnabled()) break block20;
                                Tr.debug(tc, "Created CRL: " + href);
                            }
                        }
                        if (crl != null) {
                            set.add(crl);
                            continue;
                        }
                        set.add(cert);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating CollectionCertStoreParameters");
                    }
                    this._params = new CollectionCertStoreParameters(set);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, clsName + ".getInstance", "120", this);
                    Tr.error(tc, "security.wssecurity.load.collectioncertstore.failed", new Object[]{this._name, e});
                }
                this._certNames = null;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Opening CollectionCertStore \"" + this._name + "\" with algorithm \"" + this._algorithm + "\" and provider \"" + this._provider + "\"");
                }
                this._certStore = this._provider == null || "".equals(this._provider) ? CertStore.getInstance(this._algorithm, this._params) : CertStore.getInstance(this._algorithm, (CertStoreParameters)this._params, this._provider);
            }
            catch (NoSuchAlgorithmException e) {
                FFDCFilter.processException((Throwable)e, clsName + ".getInstance", "134", this);
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s20", new Object[]{this._algorithm});
            }
            catch (InvalidAlgorithmParameterException e) {
                FFDCFilter.processException((Throwable)e, clsName + ".getInstance", "137", this);
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s21", new Object[]{this._params == null || this._params.toString() == null ? "" : this._params.toString()});
            }
            catch (NoSuchProviderException e) {
                FFDCFilter.processException((Throwable)e, clsName + ".getInstance", "140", this);
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s22", new Object[]{this._provider});
            }
            catch (Throwable e) {
                FFDCFilter.processException(e, clsName + ".getInstance", "143", this);
                Tr.error(tc, "security.wssecurity.load.collectioncertstore.failed", new Object[]{this._name == null ? "" : this._name, e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance() returns " + this._certStore);
        }
        return this._certStore;
    }
}

