/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.audit;

import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGenerator;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.audit.ContextObj;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSAuditEventGeneratorImpl
implements WSSAuditEventGenerator {
    private static final TraceComponent tc = Tr.register(WSSAuditEventGeneratorImpl.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static WSSAuditEventGenerator generator = null;
    private static final String MSG_ID = "MsgId";
    private static final String REQ_MSG_ID = "ReqMsgId";
    private static final String SVC_ENDPOINT = "SvcEndPoint";
    private static final String SOAP_ACTION = "SoapAction";
    private static final String WSA_ACTION = "WsaAction";
    private static final String ALGORITHM = "Algorithm";
    private static final String KEY_FORMAT = "KeyFormat";
    private static final String KEY_LENGTH = "KeyLength";
    private static final String KEY_NAME = "KeyName";
    private static final String PROVIDER = "Provider";
    private static final String PROVIDER_STATUS = "ProviderStatus";
    private static final String EXTENDED_EVENT_DATA = "EXTENDED_EVENT_DATA";

    private WSSAuditEventGeneratorImpl() {
    }

    public static WSSAuditEventGenerator getInstance() {
        if (generator == null) {
            generator = new WSSAuditEventGeneratorImpl();
        }
        return generator;
    }

    @Override
    public void sendEvent(WSSAuditService.WSSAuditEventType eventType, SOAPMessageContext msgContext, Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sendEvent: " + (Object)((Object)eventType)));
        }
        if (msgContext == null || context == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("messageContext = " + msgContext + "  context = " + context));
            }
            return;
        }
        HashMap auditContext = (HashMap)context.get("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
        if (auditContext == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"auditContext does not exist");
            }
            return;
        }
        try {
            AuditService auditService = ContextManagerFactory.getInstance().getAuditService();
            ContextHandler contextHandler = auditService.getContextHandler();
            this.buildCommonEventData(msgContext, context, auditService, contextHandler, auditContext);
            this.buildExtendedEventData(msgContext, context, auditService, contextHandler, auditContext);
            String outcome = auditContext.get("Outcome") == null ? null : ((AuditOutcome)auditContext.remove("Outcome")).getOutcomeStr();
            Long reason_code = auditContext.get("ReasonCode") == null ? null : Long.valueOf((Long)auditContext.remove("ReasonCode"));
            ConcurrentHashMap auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(-1), new Integer(-1), outcome, reason_code);
            WSSAuditService wssAuditService = WSSAuditServiceImpl.getInstance();
            wssAuditService.sendEvent(eventType, auditOutcome);
        }
        catch (Exception e) {
            Tr.warning((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s02", (Object)new Object[]{e});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendEvent");
        }
    }

    @Override
    public Map<String, Object> setAuditEventContext(Map context, WSSAuditService.WSSAuditOutcome outcome, WSSAuditService.WSSAuditReason reason, String description) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAuditEventContext reason = " + WSSAuditServiceImpl.getReason(reason)));
        }
        if (context != null) {
            HashMap<String, Object> auditContext = (HashMap<String, Object>)context.get("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
            if (auditContext == null) {
                auditContext = new HashMap<String, Object>();
                context.put("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT", auditContext);
            }
            auditContext.put("Outcome", WSSAuditServiceImpl.getAuditOutcome(outcome));
            auditContext.put("Reason", WSSAuditServiceImpl.getReason(reason));
            if (auditContext.get("ReasonCode") == null) {
                auditContext.put("ReasonCode", WSSAuditServiceImpl.getReasonCode(reason));
            }
            auditContext.put("Description", description);
            return auditContext;
        }
        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
        return null;
    }

    @Override
    public void setAuditOutcomeReasonCode(Map context, WSSAuditService.WSSAuditReason reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAuditOutcomeReasonCode reason = " + WSSAuditServiceImpl.getReason(reason)));
        }
        if (context != null) {
            HashMap<String, Long> auditContext = (HashMap<String, Long>)context.get("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
            if (auditContext == null) {
                auditContext = new HashMap<String, Long>();
                context.put("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT", auditContext);
            }
            auditContext.put("ReasonCode", WSSAuditServiceImpl.getReasonCode(reason));
        } else {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
        }
    }

    @Override
    public Map<String, Object> setExtendedAuditData(Map context, String key, String value) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setExtendedAuditData key[" + key + "] + value[" + value + "]"));
        }
        if (context != null) {
            HashMap<String, String> extendedAuditContext;
            HashMap<String, Object> auditContext = (HashMap<String, Object>)context.get("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT");
            if (auditContext == null) {
                auditContext = new HashMap<String, Object>();
                context.put("com.ibm.ws.wssecurity.platform.audit.Constants.WSSECURITY_AUDIT_EVENT_CONTEXT", auditContext);
            }
            if ((extendedAuditContext = (HashMap<String, String>)auditContext.get(EXTENDED_EVENT_DATA)) == null) {
                extendedAuditContext = new HashMap<String, String>();
                auditContext.put(EXTENDED_EVENT_DATA, extendedAuditContext);
            }
            extendedAuditContext.put(key, value);
            return auditContext;
        }
        Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
        return null;
    }

    @Override
    public void addExtendedAuditData(Map<String, Object> auditContext, String key, String value) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setExtendedAuditData key[" + key + "] + value[" + value + "]"));
        }
        if (auditContext == null || key == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            return;
        }
        HashMap<String, String> extendedAuditContext = (HashMap<String, String>)auditContext.get(EXTENDED_EVENT_DATA);
        if (extendedAuditContext == null) {
            extendedAuditContext = new HashMap<String, String>();
            auditContext.put(EXTENDED_EVENT_DATA, extendedAuditContext);
        }
        extendedAuditContext.put(key, value);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addExtendedAuditData");
        }
    }

    @Override
    public void addEncryptionEventData(Map<String, Object> auditContext, KeyInfoResult result) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addEncryptionEventData result = " + result));
        }
        if (auditContext == null || result == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            return;
        }
        HashMap<String, Object> extendedAuditContext = (HashMap<String, Object>)auditContext.get(EXTENDED_EVENT_DATA);
        if (extendedAuditContext == null) {
            extendedAuditContext = new HashMap<String, Object>();
            auditContext.put(EXTENDED_EVENT_DATA, extendedAuditContext);
        }
        Key key = result.getKey();
        KeyInfoContentConsumerConfig keyConfig = result.getKeyInfoContentConsumer();
        if (key != null) {
            extendedAuditContext.put(ALGORITHM, key.getAlgorithm());
            extendedAuditContext.put(KEY_FORMAT, key.getFormat());
            byte[] keyData = key.getEncoded();
            if (keyData != null) {
                extendedAuditContext.put(KEY_LENGTH, keyData.length);
            }
        }
        if (keyConfig != null) {
            extendedAuditContext.put(KEY_NAME, keyConfig.getKeyName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addEncryptionEventData");
        }
    }

    @Override
    public void addProviderData(Map<String, Object> auditContext, String provider, String providerStatus) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addProviderData provider [" + provider + "] providerStatus [" + providerStatus + "]"));
        }
        if (auditContext == null || provider == null) {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
            return;
        }
        HashMap<String, String> extendedAuditContext = (HashMap<String, String>)auditContext.get(EXTENDED_EVENT_DATA);
        if (extendedAuditContext == null) {
            extendedAuditContext = new HashMap<String, String>();
            auditContext.put(EXTENDED_EVENT_DATA, extendedAuditContext);
        }
        extendedAuditContext.put(PROVIDER, provider);
        extendedAuditContext.put(PROVIDER_STATUS, providerStatus);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addProviderData");
        }
    }

    private void buildCommonEventData(SOAPMessageContext msgContext, Map<Object, Object> context, AuditService auditService, ContextHandler contextHandler, HashMap<String, Object> auditContext) {
        HttpServletRequest req = null;
        HttpSession session = null;
        String uriName = null;
        Object obj = msgContext.getProperty("transport.http.servletRequest");
        if (obj != null && obj instanceof HttpServletRequest) {
            req = (HttpServletRequest)obj;
            uriName = req.getServletPath() + req.getPathInfo();
            session = req.getSession();
            if (tc.isDebugEnabled()) {
                if (session != null) {
                    Tr.debug((TraceComponent)tc, (String)("HTTP session is " + session.getId()));
                } else {
                    Tr.debug((TraceComponent)tc, (String)"HTTP session is null");
                }
            }
        }
        HashMap data = null;
        if (session != null) {
            data = DataHelper.buildSessionData(req.getSession().getId(), req.getRemoteAddr(), req.getRemoteHost(), new Integer(req.getRemotePort()).toString());
            contextHandler.buildContextObject("SESSION_CONTEXT", data);
        }
        String[] eventTrailIds = auditService.getEventTrailIds();
        String lastTrailId = "";
        data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
        contextHandler.buildContextObject("EVENT_CONTEXT", data);
        String method2 = req == null ? null : req.getMethod();
        String outcome = (AuditOutcome)auditContext.get("Outcome") == null ? null : ((AuditOutcome)auditContext.get("Outcome")).getOutcomeStr();
        data = DataHelper.buildAccessData(uriName, "resourceAccess", null, null, outcome, method2, "soap", new Long(0L), null, null, null, null);
        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
        data = new HashMap();
        if (WSSAuditServiceImpl.getInstance().isVerbose()) {
            data.put("Reason", auditContext.get("Reason"));
            auditContext.remove("Reason");
            if (auditContext.get("Description") != null) {
                data.put("Description", auditContext.get("Description"));
                auditContext.remove("Description");
            }
        }
        data = DataHelper.buildCustomData(data);
        contextHandler.buildContextObject("CUSTOM_PROPERTY_CONTEXT", data);
        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
        data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        String activeUserRegistry = security2.getActiveUserRegistry().getType();
        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(activeUserRegistry));
        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
    }

    private void buildExtendedEventData(SOAPMessageContext msgContext, Map<Object, Object> context, AuditService auditService, ContextHandler contextHandler, HashMap<String, Object> auditContext) {
        if (context != null) {
            HashMap extendedAuditContext = null;
            if (auditContext != null && (extendedAuditContext = (HashMap)auditContext.get(EXTENDED_EVENT_DATA)) == null) {
                return;
            }
            ContextObj contextObj = (ContextObj)contextHandler.getContextObject("CUSTOM_PROPERTY_CONTEXT");
            if (contextObj != null) {
                Set keySet = extendedAuditContext.keySet();
                for (String key : keySet) {
                    contextObj.setEntry(key, extendedAuditContext.get(key));
                }
                auditContext.remove(EXTENDED_EVENT_DATA);
            } else {
                HashMap massagedCustomDataMap = DataHelper.buildCustomData(extendedAuditContext);
                auditContext.remove(EXTENDED_EVENT_DATA);
                contextHandler.buildContextObject("CUSTOM_PROPERTY_CONTEXT", massagedCustomDataMap);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Created custom context with extendedAuditContext [" + massagedCustomDataMap + "]"));
                }
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.wssecurity.WSSAuditEventGeneratorImpl.s03");
        }
    }
}

