/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntryComparator;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;

public class JavaStubWriter
extends JavaClassWriter
implements StubGenerator {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;
    private int suffixId = 0;
    private HashMap op_getter = new HashMap();
    private boolean callStaticInit = false;
    private int methodNumber = 0;

    public JavaStubWriter(Emitter emitter, BindingEntry bEntry, SymbolTable symbolTable) {
        super(emitter, bEntry.getName() + "Stub", "stub");
        this.bEntry = bEntry;
        this.binding = bEntry.getBinding();
        this.symbolTable = symbolTable;
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        return "extends com.ibm.ws.webservices.engine.client.Stub ";
    }

    protected String getImplementsText() {
        return "implements " + this.bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME) + " ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        PortType portType = this.binding.getPortType();
        ArrayList types2 = JavaStubWriter.getTypesInPortType(portType, this.bEntry, this.symbolTable);
        boolean hasMIME = Utils.hasMIME(this.bEntry);
        boolean hasTypes = types2.size() > 0 || hasMIME;
        this.writeConstructors(pw, hasTypes);
        if (hasTypes) {
            this.writeInitTypeMapping(pw, types2, hasMIME);
        }
        List operations = this.binding.getBindingOperations();
        for (int i = 0; i < operations.size(); ++i) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            BindingOperationEntry boe = this.bEntry.getOperation(operation.getOperation());
            String soapAction = (String)boe.getDynamicVar(BindingOperationEntry.SOAP_ACTION_URI);
            soapAction = soapAction == null ? "" : soapAction;
            Operation ptOperation = operation.getOperation();
            OperationType type = ptOperation.getStyle();
            if (type == OperationType.NOTIFICATION || type == OperationType.SOLICIT_RESPONSE) {
                pw.println(boe.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                pw.println();
                continue;
            }
            this.writeGetOperation(pw, boe, soapAction);
            this.writeGetInvoke(pw, boe, soapAction, hasMIME);
            this.writeOperation(pw, boe, type == OperationType.ONE_WAY);
            ++this.methodNumber;
        }
        this.writePrivateStaticInitMethod(pw);
        this.writeStaticInit(pw);
    }

    protected void writePrivateStaticInitMethod(PrintWriter pw) {
        if (this.op_getter != null && this.op_getter.size() > 0) {
            this.callStaticInit = true;
            Iterator iter = this.op_getter.keySet().iterator();
            pw.println("    private static void _staticInit() {");
            while (iter.hasNext()) {
                String opDescVar_key = (String)iter.next();
                String opDescGetter_value = null;
                opDescGetter_value = (String)this.op_getter.get(opDescVar_key);
                opDescVar_key = opDescVar_key == null ? "null" : opDescVar_key;
                opDescGetter_value = opDescGetter_value == null ? "null" : opDescGetter_value;
                pw.println("        " + opDescVar_key + " = " + opDescGetter_value + ";");
            }
            pw.println("    }");
            pw.println();
            this.op_getter.clear();
        }
    }

    protected void writeStaticInit(PrintWriter pw) {
        if (this.callStaticInit) {
            pw.println("    static {");
            pw.println("       _staticInit();");
            pw.println("    }");
        }
    }

    protected void writeConstructors(PrintWriter pw, boolean hasTypes) {
        pw.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws com.ibm.ws.webservices.engine.WebServicesFault {");
        pw.println("        if (service == null) {");
        pw.println("            super.service = new com.ibm.ws.webservices.engine.client.Service();");
        pw.println("        }");
        pw.println("        else {");
        pw.println("            super.service = service;");
        pw.println("        }");
        pw.println("        super.engine = ((com.ibm.ws.webservices.engine.client.Service) super.service).getEngine();");
        if (hasTypes) {
            pw.println("        initTypeMapping();");
        }
        pw.println("        super.cachedEndpoint = endpointURL;");
        pw.println("        super.connection = ((com.ibm.ws.webservices.engine.client.Service) super.service).getConnection(endpointURL);");
        pw.println("        super.messageContexts = new com.ibm.ws.webservices.engine.MessageContext[" + this.binding.getBindingOperations().size() + "];");
        pw.println("    }");
        pw.println();
    }

    protected void writeInitTypeMapping(PrintWriter pw, ArrayList types2, boolean hasMIME) throws IOException {
        String encoding = this.bEntry.hasLiteral() ? "com.ibm.ws.webservices.engine.Constants.URI_LITERAL_ENC" : "com.ibm.ws.webservices.engine.Constants.URI_SOAP11_ENC";
        pw.println("    private void initTypeMapping() {");
        pw.println("        javax.xml.rpc.encoding.TypeMapping tm = super.getTypeMapping(" + encoding + ");");
        this.writeMappingHeader(pw);
        int mappingCount = 0;
        int mappingMethodCount = 1;
        Iterator it = types2.iterator();
        while (it.hasNext()) {
            TypeEntry type = (TypeEntry)it.next();
            if (!JavaStubWriter.needTypeMapping(type, this.emitter) || !(type instanceof Type)) continue;
            if (mappingCount < 150) {
                this.writeSerializationInit(pw, (Type)type);
                ++mappingCount;
                continue;
            }
            pw.println("        initTypeMapping" + ++mappingMethodCount + "(tm);");
            pw.println("    }");
            pw.println("");
            pw.println("    private void initTypeMapping" + mappingMethodCount + "(javax.xml.rpc.encoding.TypeMapping tm) {");
            this.writeMappingHeader(pw);
            this.writeSerializationInit(pw, (Type)type);
            mappingCount = 0;
        }
        pw.println("    }");
        pw.println();
    }

    private void writeMappingHeader(PrintWriter pw) throws IOException {
        pw.println("        java.lang.Class javaType = null;");
        pw.println("        javax.xml.namespace.QName xmlType = null;");
        pw.println("        javax.xml.namespace.QName compQName = null;");
        pw.println("        javax.xml.namespace.QName compTypeQName = null;");
        pw.println("        com.ibm.ws.webservices.engine.encoding.SerializerFactory sf = null;");
        pw.println("        com.ibm.ws.webservices.engine.encoding.DeserializerFactory df = null;");
    }

    protected void writeGetOperation(PrintWriter pw, BindingOperationEntry boe, String soapAction) throws IOException {
        String opName = boe.getName();
        String opDescName = "_" + opName + "Operation" + this.methodNumber;
        String getterOpDescName = "_get" + opName + "Operation" + this.methodNumber + "()";
        this.op_getter.put(opDescName, getterOpDescName);
        pw.println("    private static com.ibm.ws.webservices.engine.description.OperationDesc " + opDescName + " = null;");
        pw.println("    private static com.ibm.ws.webservices.engine.description.OperationDesc " + getterOpDescName + " {");
        OperationDescBuilder odb = OperationDescBuilder.create(boe, this.bEntry, this.symbolTable);
        odb.writeOperationDesc(pw, false, "        ", opDescName, this.suffixId++);
        pw.println("        return " + opDescName + ";");
        pw.println();
        pw.println("    }");
        pw.println();
    }

    protected void writeGetInvoke(PrintWriter pw, BindingOperationEntry boe, String soapAction, boolean hasMIME) throws IOException {
        String opName = boe.getName();
        String mcIndex = "_" + opName + "Index" + this.methodNumber;
        pw.println("    private int " + mcIndex + " = " + this.methodNumber + ";");
        pw.println("    private synchronized com.ibm.ws.webservices.engine.client.Stub.Invoke _get" + opName + "Invoke" + this.methodNumber + "(Object[] parameters) throws com.ibm.ws.webservices.engine.WebServicesFault  {");
        pw.println("        com.ibm.ws.webservices.engine.MessageContext mc = super.messageContexts[" + mcIndex + "];");
        pw.println("        if (mc == null) {");
        pw.println("            mc = new com.ibm.ws.webservices.engine.MessageContext(super.engine);");
        pw.println("            mc.setOperation(" + this.className + "._" + opName + "Operation" + this.methodNumber + ");");
        if (soapAction == null) {
            soapAction = "";
        }
        pw.println("            mc.setUseSOAPAction(true);");
        pw.println("            mc.setSOAPActionURI(\"" + soapAction + "\");");
        Use use = boe.getInputBodyUse();
        if (use == Use.LITERAL) {
            pw.println("            mc.setEncodingStyle(com.ibm.ws.webservices.engine.Constants.URI_LITERAL_ENC);");
            pw.println("            mc.setProperty(com.ibm.wsspi.webservices.Constants.SEND_TYPE_ATTR_PROPERTY, Boolean.FALSE);");
            pw.println("            mc.setProperty(com.ibm.wsspi.webservices.Constants.ENGINE_DO_MULTI_REFS_PROPERTY, Boolean.FALSE);");
        }
        pw.println("            super.primeMessageContext(mc);");
        pw.println("            super.messageContexts[" + mcIndex + "] = mc;");
        pw.println("        }");
        pw.println("        try {");
        pw.println("            mc = (com.ibm.ws.webservices.engine.MessageContext) mc.clone();");
        pw.println("        }");
        pw.println("        catch (CloneNotSupportedException cnse) {");
        pw.println("            throw com.ibm.ws.webservices.engine.WebServicesFault.makeFault(cnse);");
        pw.println("        }");
        pw.println("        return new com.ibm.ws.webservices.engine.client.Stub.Invoke(connection, mc, parameters);");
        pw.println("    }");
        pw.println();
    }

    public static ArrayList getTypesInPortType(PortType portType, BindingEntry bEntry, SymbolTable symbolTable) {
        TreeSet<TypeEntry> types2 = new TreeSet<TypeEntry>(new SymTabEntryComparator());
        TreeSet firstPassTypes = new TreeSet(new SymTabEntryComparator());
        List operations = portType.getOperations();
        for (int i = 0; i < operations.size(); ++i) {
            Operation op = (Operation)operations.get(i);
            firstPassTypes.addAll(JavaStubWriter.getTypesInOperation(op, bEntry));
        }
        Iterator i = firstPassTypes.iterator();
        while (i.hasNext()) {
            TypeEntry type = (TypeEntry)i.next();
            if (types2.contains(type)) continue;
            types2.add(type);
            types2.addAll(Utils.getNestedTypes(type, symbolTable));
        }
        return new ArrayList(types2);
    }

    public static Set getTypesInOperation(Operation operation, BindingEntry bEntry) {
        int i;
        TreeSet types2 = new TreeSet(new SymTabEntryComparator());
        Vector<TypeEntry> v = new Vector<TypeEntry>();
        BindingOperationEntry boe = bEntry.getOperation(operation);
        for (i = 0; i < boe.numParameters(); ++i) {
            BindingParamEntry p = boe.getParameter(i);
            v.add(p.getType());
        }
        if (boe.getReturn() != null) {
            v.add(boe.getReturn().getType());
        }
        if (boe.numFaults() > 0) {
            for (i = 0; i < boe.numFaults(); ++i) {
                MessageEntry me = boe.getFault(i).getMessageEntry();
                for (int j = 0; j < me.getFaultParts().size(); ++j) {
                    ChildFaultPartEntry cfp = (ChildFaultPartEntry)me.getFaultParts().elementAt(j);
                    v.add(cfp.getType());
                }
            }
        }
        for (i = 0; i < v.size(); ++i) {
            types2.add(v.get(i));
        }
        return types2;
    }

    private void writeSerializationInit(PrintWriter pw, Type type) throws IOException {
        String javaType = type.getName();
        if (javaType.endsWith("[]")) {
            String wrapper = JavaUtils.getWrapper(javaType = javaType.substring(0, javaType.length() - 2));
            if (wrapper != null) {
                this.writeSerializationInit(pw, type, wrapper + "[]");
            }
        } else {
            String wrapper = JavaUtils.getWrapper(javaType);
            if (wrapper != null) {
                this.writeSerializationInit(pw, type, wrapper);
            }
        }
        this.writeSerializationInit(pw, type, type.getName());
    }

    private void writeSerializationInit(PrintWriter pw, Type type, String javaType) {
        QName qname = type.getQName();
        pw.println("        javaType = " + javaType + ".class;");
        pw.println("        xmlType = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
        String sfString = JavaStubWriter.getSerializerFactoryName(type, javaType, this.emitter) + ".class";
        String dfString = JavaStubWriter.getDeserializerFactoryName(type, javaType, this.emitter) + ".class";
        String compArgs = "";
        if (type.getDynamicVar("CustomBinderName") != null) {
            compArgs = ", \"" + type.getDynamicVar("CustomBinderName") + "\"";
        } else if (type.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN) != null) {
            qname = ((Entry)type.getChildren().get(0)).getQName();
            pw.println("        compQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
            qname = ((TypeEntry)type.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN)).getQName();
            pw.println("        compTypeQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
            compArgs = ", compQName, compTypeQName";
        } else if (type.isList()) {
            Type listType = type;
            while (listType.getRefType() != null && ((Type)listType.getRefType()).isList()) {
                listType = (Type)listType.getRefType();
            }
            qname = listType.getRefType().getQName();
            pw.println("        compTypeQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
            compArgs = ", null, compTypeQName";
        } else if (type.getDimensions().length() > 0 && sfString.equals("com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory.class")) {
            TypeEntry compType = type.getRefType();
            if (compType != null) {
                while (compType.getRefType() != null && !(compType instanceof Type)) {
                    compType = compType.getRefType();
                }
                qname = compType.getQName();
                pw.println("        compTypeQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
                compArgs = ", null, compTypeQName";
            }
        } else if (type.isSimpleType()) {
            Type resType;
            for (resType = type.getRestrictionBase(); resType != null && resType.getRestrictionBase() != null; resType = resType.getRestrictionBase()) {
            }
            if (resType != null) {
                qname = resType.getQName();
                pw.println("        compTypeQName = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\");");
                compArgs = ", null, compTypeQName";
            }
        }
        pw.println("        sf = com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory.createFactory(" + sfString + ", javaType, xmlType" + compArgs + ");");
        pw.println("        df = com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory.createFactory(" + dfString + ", javaType, xmlType" + compArgs + ");");
        pw.println("        if (sf != null || df != null) {");
        pw.println("            tm.register(javaType, xmlType, sf, df);");
        pw.println("        }");
        pw.println();
    }

    private void writeOperation(PrintWriter pw, BindingOperationEntry boe, boolean oneway) throws IOException {
        this.writeComment(pw, boe.getBindingOperation().getOperation().getDocumentationElement());
        String signature = (String)boe.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
        pw.println(signature + " {");
        pw.println("        if (super.cachedEndpoint == null) {");
        pw.println("            throw new com.ibm.ws.webservices.engine.NoEndPointException();");
        pw.println("        }");
        if (boe.numOuts() > 0 || boe.numInOuts() > 0) {
            pw.println("        java.util.Vector _resp = null;");
        }
        String opName = boe.getName();
        String invokeName = "_get" + opName + "Invoke" + this.methodNumber;
        pw.println("        try {");
        pw.print("            ");
        if (boe.numOuts() > 0 || boe.numInOuts() > 0) {
            pw.print("_resp = ");
        }
        pw.print(invokeName + "(new java.lang.Object[] {");
        this.writeParameters(pw, boe);
        pw.println("}).invoke();");
        pw.println();
        boolean catchSFE = false;
        pw.println("        } catch (com.ibm.ws.webservices.engine.WebServicesFault wsf) {");
        pw.println("            Exception e = wsf.getUserException();");
        if (this.emitter.getNoDataBinding()) {
            pw.println("                if (e instanceof javax.xml.rpc.soap.SOAPFaultException) {");
            pw.println("                    throw (javax.xml.rpc.soap.SOAPFaultException) e;");
            pw.println("                }");
            catchSFE = true;
        }
        if (boe.numFaults() > 0) {
            pw.println("            if (e != null) {");
            for (int i = 0; i < boe.numFaults(); ++i) {
                BindingFaultRefEntry faultRef = boe.getFault(i);
                MessageEntry me = faultRef.getMessageEntry();
                SymTabEntry faultEntry = (SymTabEntry)me.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
                String faultClass = faultEntry.getName();
                if ("javax.xml.soap.SOAPElement".equals(faultEntry.getName())) {
                    faultClass = "javax.xml.rpc.soap.SOAPFaultException";
                    if (catchSFE) continue;
                    catchSFE = true;
                }
                pw.println("                if (e instanceof " + faultClass + ") {");
                pw.println("                    throw (" + faultClass + ") e;");
                pw.println("                }");
            }
            pw.println("            }");
        }
        pw.println("            throw wsf;");
        pw.println("        } ");
        if (!oneway) {
            this.writeResponseHandling(pw, boe);
        }
        pw.println("    }");
        pw.println();
    }

    private void writeParameters(PrintWriter pw, BindingOperationEntry boe) {
        boolean needComma = false;
        for (int i = 0; i < boe.numParameters(); ++i) {
            BindingParamEntry p = boe.getParameter(i);
            if (p.getMode() == 2) continue;
            if (needComma) {
                pw.print(", ");
            } else {
                needComma = true;
            }
            String paramName = p.getName();
            if (p.getMode() != 1) {
                paramName = paramName + ".value";
            }
            if (p.getMIMEType() == null) {
                paramName = Utils.wrapPrimitiveType(p.getType().getQName(), paramName, (String)p.getDynamicVar("parameterType"));
            }
            pw.print(paramName);
        }
    }

    private void writeResponseHandling(PrintWriter pw, BindingOperationEntry boe) {
        int allOuts = boe.numOuts() + boe.numInOuts();
        if (allOuts > 0) {
            if (allOuts == 1) {
                if (boe.getReturn() != null) {
                    this.writeOutputAssign(pw, "        ", "return ", boe.getReturn(), "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                } else {
                    int i = 0;
                    BindingParamEntry p = boe.getParameter(i);
                    while (p.getMode() == 1) {
                        p = boe.getParameter(++i);
                    }
                    String javifiedName = p.getName();
                    this.writeOutputAssign(pw, "            ", javifiedName + ".value = ", p, "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                }
            } else {
                if (boe.getReturn() != null) {
                    pw.println("        Object _returnObj = null;");
                }
                pw.println("        for (int _i = 0; _i < _resp.size(); ++_i) {");
                pw.println("            com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue _param = (com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(_i);");
                String ifClause = "if";
                for (int i = 0; i < boe.numParameters(); ++i) {
                    BindingParamEntry p = boe.getParameter(i);
                    if (p.getMode() == 1) continue;
                    String javifiedName = p.getName();
                    String qnameName = Utils.getNewQName((QName)p.getDynamicVar("parameterWireQName"));
                    pw.println("            " + ifClause + " (" + qnameName + ".equals(_param.getQName())) {");
                    this.writeOutputAssign(pw, "                ", javifiedName + ".value = ", p, "_param.getValue()");
                    pw.println("            }");
                    ifClause = "else if";
                }
                if (boe.getReturn() != null) {
                    pw.println("            else {");
                    pw.println("                _returnObj = _param.getValue();");
                    pw.println("            }");
                }
                pw.println("        }");
                if (boe.getReturn() != null) {
                    this.writeOutputAssign(pw, "        ", "return ", boe.getReturn(), "_returnObj");
                }
            }
        }
    }

    private void writeOutputAssign(PrintWriter pw, String indent, String target, BindingParamEntry param, String source) {
        TypeEntry type = param.getType();
        String mimeType = param.getMIMEType();
        while (type instanceof Element && !type.isCollectionTypeEntry()) {
            type = type.getRefType();
        }
        if (type != null && type.getName() != null) {
            pw.println(indent + "try {");
            pw.println(indent + "    " + target + Utils.getResponseString(param, source));
            pw.println(indent + "} catch (java.lang.Exception _exception) {");
            String realType = mimeType == null ? type.getName() : JavaUtils.mimeToJava(mimeType);
            pw.println(indent + "    " + target + Utils.getResponseString(param, "super.convert(" + source + ", " + Utils.realType(param) + ".class)"));
            pw.println(indent + "}");
        } else {
            pw.println(indent + target + Utils.getResponseString(param, source));
        }
    }

    static boolean needTypeMapping(TypeEntry typeEntry, Emitter emitter) {
        boolean process = true;
        if (!typeEntry.isReferenced() || typeEntry.isOnlyWrappedLiteralReferenced() || emitter.getNoDataBinding() || typeEntry.isBaseType() && typeEntry.getRefType() == null || typeEntry.isCollectionTypeEntry() || !(typeEntry instanceof Type)) {
            process = false;
        }
        return process;
    }

    static String getSerializerFactoryName(Type type, String javaType, Emitter em) {
        Type resType;
        String serializerFactory = null;
        for (resType = type.getRestrictionBase(); resType != null && resType.getRestrictionBase() != null; resType = resType.getRestrictionBase()) {
        }
        QName resQName = resType != null ? resType.getQName() : null;
        String binderName = (String)type.getDynamicVar("CustomBinderName");
        serializerFactory = binderName != null ? "com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory" : (javaType.equals("org.w3c.dom.Element") ? "com.ibm.ws.webservices.engine.encoding.ser.ElementSerializerFactory" : (javaType.equals("javax.xml.soap.SOAPElement") ? "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementSerializerFactory" : (type.isList() ? "com.ibm.ws.webservices.engine.encoding.ser.ListSerializerFactory" : (javaType.equals("byte[]") && Constants.equals(Constants.XSD_BASE64, resQName) ? "com.ibm.ws.webservices.engine.encoding.ser.Base64SerializerFactory" : (javaType.equals("byte[]") && Constants.equals(Constants.XSD_HEXBIN, resQName) ? "com.ibm.ws.webservices.engine.encoding.ser.HexSerializerFactory" : (javaType.endsWith("[]") ? "com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory" : (type.getNode() != null && type.isEnumeration() ? "com.ibm.ws.webservices.engine.encoding.ser.EnumSerializerFactory" : (javaType.equals("java.util.Calendar") ? "com.ibm.ws.webservices.engine.encoding.ser.CalendarSerializerFactory" : (javaType.equals("javax.xml.namespace.QName") ? "com.ibm.ws.webservices.engine.encoding.ser.QNameSerializerFactory" : (javaType.equals("java.util.Date") ? "com.ibm.ws.webservices.engine.encoding.ser.DateSerializerFactory" : (type.isSimpleContent() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanSerializerFactory" : (type.isSimpleType() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializerFactory" : "com.ibm.ws.webservices.engine.encoding.ser.BeanSerializerFactory"))))))))))));
        return serializerFactory;
    }

    static String getDeserializerFactoryName(Type type, String javaType, Emitter em) {
        Type resType;
        String deserializerFactory = null;
        for (resType = type.getRestrictionBase(); resType != null && resType.getRestrictionBase() != null; resType = resType.getRestrictionBase()) {
        }
        QName resQName = resType != null ? resType.getQName() : null;
        String binderName = (String)type.getDynamicVar("CustomBinderName");
        deserializerFactory = binderName != null ? "com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializerFactory" : (javaType.equals("org.w3c.dom.Element") ? "com.ibm.ws.webservices.engine.encoding.ser.ElementDeserializerFactory" : (javaType.equals("javax.xml.soap.SOAPElement") ? "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializerFactory" : (type.isList() ? "com.ibm.ws.webservices.engine.encoding.ser.ListDeserializerFactory" : (javaType.equals("byte[]") && Constants.equals(Constants.XSD_BASE64, resQName) ? "com.ibm.ws.webservices.engine.encoding.ser.Base64DeserializerFactory" : (javaType.equals("byte[]") && Constants.equals(Constants.XSD_HEXBIN, resQName) ? "com.ibm.ws.webservices.engine.encoding.ser.HexDeserializerFactory" : (javaType.endsWith("[]") ? "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializerFactory" : (type.getNode() != null && type.isEnumeration() ? "com.ibm.ws.webservices.engine.encoding.ser.EnumDeserializerFactory" : (javaType.equals("java.util.Calendar") ? "com.ibm.ws.webservices.engine.encoding.ser.CalendarDeserializerFactory" : (javaType.equals("javax.xml.namespace.QName") ? "com.ibm.ws.webservices.engine.encoding.ser.QNameDeserializerFactory" : (javaType.equals("java.util.Date") ? "com.ibm.ws.webservices.engine.encoding.ser.DateDeserializerFactory" : (type.isSimpleContent() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanDeserializerFactory" : (type.isSimpleType() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializerFactory" : "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory"))))))))))));
        return deserializerFactory;
    }
}

