/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.tools.resource.FileWriteDenialException;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.DuplicateFileException;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;

public class JavaServiceIfaceWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;
    static /* synthetic */ Class class$javax$xml$rpc$ServiceException;

    protected JavaServiceIfaceWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName(), "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        String file = this.getFileName();
        if (this.isFileGenerated(file)) {
            throw new DuplicateFileException(Messages.getMessage("duplicateFile00", file), file);
        }
        try {
            String msg;
            PrintWriter pw = this.getPrintWriter(file);
            this.registerFile(file);
            if (this.emitter.isVerbose() && (msg = this.verboseMessage(file)) != null) {
                this.emitter.getToolEnv().report(msg);
            }
            this.writeFileHeader(pw);
            this.writeFileBody(pw);
            this.writeFileFooter(pw);
            this.closePrintWriter(pw);
        }
        catch (FileWriteDenialException e) {
            this.emitter.getToolEnv().report(Messages.getMessage("FileWriteDenied", file));
        }
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getExtendsText() {
        return "extends javax.xml.rpc.Service ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        this.writeComment(pw, service.getDocumentationElement());
        for (int i = 0; i < this.sEntry.numPorts(); ++i) {
            PortEntry pe = this.sEntry.getPort(i);
            Port p = pe.getPort();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            Boolean nonBoundWSDL = (Boolean)this.sEntry.getDynamicVar(SymbolTable.NON_BOUND_WSDL);
            boolean isNonBoundWSDL = nonBoundWSDL != null && nonBoundWSDL != false;
            String address = pe.getAddress();
            if (address == null && !isNonBoundWSDL) continue;
            String portName = JavaUtils.xmlNameToJavaClass(pe.getQName().getLocalPart());
            String sei = (String)bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
            pw.println("    public " + sei + " get" + portName + "() throws " + (class$javax$xml$rpc$ServiceException == null ? JavaServiceIfaceWriter.class$("javax.xml.rpc.ServiceException") : class$javax$xml$rpc$ServiceException).getName() + ";");
            if (isNonBoundWSDL) continue;
            pw.println();
            pw.println("    public java.lang.String get" + portName + "Address();");
            pw.println();
            pw.println("    public " + sei + " get" + portName + "(java.net.URL portAddress) throws " + (class$javax$xml$rpc$ServiceException == null ? JavaServiceIfaceWriter.class$("javax.xml.rpc.ServiceException") : class$javax$xml$rpc$ServiceException).getName() + ";");
        }
    }
}

