/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;

public class JavaBeanFaultProxyWriter
extends JavaBeanWriter {
    static final String SUFFIX = "_DeserProxy";

    protected JavaBeanFaultProxyWriter(Emitter emitter, Type type) {
        super(emitter, type, type.getName() + SUFFIX, "proxy");
        this.enableDefaultConstructor = true;
        this.enableSetters = true;
        this.setDeployPhaseOnly(true);
    }

    protected String getExtendsText() {
        String extendsText = super.getExtendsText();
        extendsText = extendsText.equals("") ? " extends java.lang.Exception " : " " + extendsText.trim() + SUFFIX + " ";
        return extendsText;
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        super.writeFileBody(pw);
        this.writeConvertMethod(pw);
    }

    protected void writeConvertMethod(PrintWriter pw) throws IOException {
        pw.println("    public java.lang.Object convert() {");
        this.startTolerateCheckedException(pw, "     ");
        if (this.type.isAbstract()) {
            pw.println("      return null;");
            pw.println("    }");
            return;
        }
        String indent = "      ";
        String indent2 = "        ";
        pw.println(indent + this.type.getName() + " _e;");
        Vector childEntrys = new Vector();
        Vector paramNames = new Vector();
        this.getTypesAndNames(this.type, childEntrys, paramNames, false, false, false);
        List initStyles = (List)this.type.getDynamicVar("ExceptionInitStyles");
        if (initStyles == null) {
            if (childEntrys.size() == 0) {
                this.writeInitJAXRPC_NOARG(pw, this.type, childEntrys, paramNames, indent);
            } else {
                this.writeInitJAXRPC_NORMAL(pw, this.type, childEntrys, paramNames, indent);
            }
        } else if (initStyles.contains("JAXRPC-NoArg")) {
            this.writeInitJAXRPC_NOARG(pw, this.type, childEntrys, paramNames, indent);
        } else if (initStyles.contains("JAXRPC-Normal")) {
            this.writeInitJAXRPC_NORMAL(pw, this.type, childEntrys, paramNames, indent);
            boolean noArg = initStyles.contains("Non-JAXRPC-NoArg");
            boolean messageArg = initStyles.contains("Non-JAXRPC-MessageArg");
            if (noArg || messageArg) {
                this.writeCheckInit(pw, this.type, childEntrys, paramNames, indent);
                if (noArg) {
                    this.writeInitNOARG(pw, this.type, childEntrys, paramNames, indent2);
                } else {
                    this.writeInitMESSAGEARG(pw, this.type, childEntrys, paramNames, indent2);
                }
                pw.println("      }");
            }
        } else if (initStyles.contains("Non-JAXRPC-NoArg")) {
            this.writeInitNOARG(pw, this.type, childEntrys, paramNames, indent);
        } else if (initStyles.contains("Non-JAXRPC-MessageArg")) {
            this.writeInitMESSAGEARG(pw, this.type, childEntrys, paramNames, indent);
        } else if (childEntrys.size() == 0) {
            this.writeInitJAXRPC_NOARG(pw, this.type, childEntrys, paramNames, indent);
        } else {
            this.writeInitJAXRPC_NORMAL(pw, this.type, childEntrys, paramNames, indent);
        }
        pw.println(indent + "return _e;");
        this.endTolerateCheckedException(pw, "     ");
        pw.println("    }");
    }

    protected void writeInitJAXRPC_NORMAL(PrintWriter pw, Type type, Vector childEntrys, Vector paramNames, String indent) {
        pw.println(indent + "_e = new " + type.getName() + "(");
        for (int i = 0; i < childEntrys.size(); ++i) {
            ChildEntry cEntry = (ChildEntry)childEntrys.elementAt(i);
            if (!JavaBeanFaultProxyWriter.isDataMember(cEntry)) {
                pw.print(indent + "  " + JavaBeanFaultProxyWriter.getterMethodName(cEntry) + "()");
            } else {
                pw.print(indent + "  " + cEntry.getName());
            }
            if (i + 1 >= childEntrys.size()) continue;
            pw.println(",");
        }
        pw.println(");");
    }

    protected void writeInitJAXRPC_NOARG(PrintWriter pw, Type type, Vector childEntrys, Vector paramNames, String indent) {
        pw.println(indent + "_e = new " + type.getName() + "();");
    }

    protected void writeInitNOARG(PrintWriter pw, Type type, Vector childEntrys, Vector paramNames, String indent) {
        pw.println(indent + "_e = new " + type.getName() + "();");
        for (int i = 0; i < childEntrys.size(); ++i) {
            ChildEntry cEntry = (ChildEntry)childEntrys.elementAt(i);
            if (!JavaBeanFaultProxyWriter.isDataMember(cEntry)) {
                pw.println(indent + "_e." + JavaBeanFaultProxyWriter.setterMethodName(cEntry) + "(" + JavaBeanFaultProxyWriter.getterMethodName(cEntry) + "());");
                continue;
            }
            pw.println(indent + "_e." + cEntry.getName() + " = " + cEntry.getName() + ";");
        }
    }

    protected void writeInitMESSAGEARG(PrintWriter pw, Type type, Vector childEntrys, Vector paramNames, String indent) {
        int i;
        ChildEntry message = null;
        for (i = 0; i < paramNames.size(); ++i) {
            if (!paramNames.elementAt(i).equals("message")) continue;
            message = (ChildEntry)childEntrys.elementAt(i);
        }
        pw.println(indent + "_e = new " + type.getName() + "(");
        if (!JavaBeanFaultProxyWriter.isDataMember(message)) {
            pw.println(JavaBeanFaultProxyWriter.getterMethodName(message) + "());");
        } else {
            pw.println(message.getName() + ");");
        }
        for (i = 0; i < childEntrys.size(); ++i) {
            ChildEntry cEntry = (ChildEntry)childEntrys.elementAt(i);
            if (cEntry == message) continue;
            if (!JavaBeanFaultProxyWriter.isDataMember(cEntry)) {
                pw.println(indent + "_e." + JavaBeanFaultProxyWriter.setterMethodName(cEntry) + "(" + JavaBeanFaultProxyWriter.getterMethodName(cEntry) + "());");
                continue;
            }
            pw.println(indent + "_e." + cEntry.getName() + " = " + cEntry.getName() + ";");
        }
    }

    protected void writeCheckInit(PrintWriter pw, Type type, Vector childEntrys, Vector paramNames, String indent) {
        pw.print(indent + "if (");
        for (int i = 0; i < childEntrys.size(); ++i) {
            ChildEntry cEntry = (ChildEntry)childEntrys.elementAt(i);
            String name = !JavaBeanFaultProxyWriter.isDataMember(cEntry) ? JavaBeanFaultProxyWriter.getterMethodName(cEntry) + "()" : cEntry.getName();
            String typeName = (String)cEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
            if (Utils.isPrimitiveType(typeName) || typeName.endsWith("[]")) {
                pw.print("(" + name + "!= _e." + name + ")");
            } else {
                pw.print("!((" + name + "== null && " + name + "== _e." + name + ") || " + "(" + name + "!= null && " + name + ".equals(_e." + name + ")))");
            }
            if (i + 1 >= childEntrys.size()) continue;
            pw.println(" || ");
        }
        pw.println(indent + ") {");
    }
}

