/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.query;

import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.Namespaces;
import java.io.InputStream;

public class ImportResolverDelegate
implements ImportResolver {
    private Emitter emitter;
    private boolean lookForResolver = true;
    private ImportResolver resolver = null;

    public ImportResolverDelegate(Emitter emitter) {
        this.emitter = emitter;
    }

    public InputStream resolve(String location) {
        if (this.lookForResolver) {
            this.lookForResolver();
        }
        if (this.resolver != null) {
            return this.resolver.resolve(location);
        }
        return null;
    }

    private void lookForResolver() {
        this.lookForResolver = false;
        try {
            String targetNamespace = this.emitter.getSymbolTable().getDefinition().getTargetNamespace();
            Namespaces namespaces = this.emitter.getNamespaces();
            String packageName = namespaces.getCreate(targetNamespace);
            Class resolverClass = ClassUtils.forName(packageName + "._AbsoluteImportResolver");
            this.resolver = (ImportResolver)resolverClass.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

