/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import javax.xml.namespace.QName;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.internal.impl.FieldImpl;

public class Utils {
    public static JavaHelpers getHolderValueType(JavaHelpers type, ClassFactory classFactory) {
        if (type != null) {
            FieldImpl field;
            JavaHelpers holderClass = classFactory.forName("javax.xml.rpc.holders.Holder");
            if (holderClass == null) {
                throw new InternalException(new ClassNotFoundException("javax.xml.rpc.holders.Holder"));
            }
            if (!holderClass.isAssignableFrom(type)) {
                return null;
            }
            JavaClass typeClass = (JavaClass)type;
            try {
                field = (FieldImpl)typeClass.getField("value");
            }
            catch (Exception e) {
                field = null;
            }
            if (field != null) {
                return field.getJavaType();
            }
        }
        return null;
    }

    public static QName getTypeQName(JavaHelpers javaType, TypeMapping tm, CustomRegistry customRegistry, ClassFactory classFactory) {
        JavaHelpers collectionClass = classFactory.forName("java.util.Collection");
        if (collectionClass == null) {
            throw new InternalException(new ClassNotFoundException("java.util.Collection"));
        }
        QName xmlType = null;
        if (customRegistry != null) {
            xmlType = customRegistry.getQName(javaType.getJavaName());
        }
        if (xmlType == null) {
            xmlType = tm.getRegisteredQName(JavaUtils.getLoadableClassName(javaType.getJavaName()));
        }
        if (xmlType != null && Constants.equals(Constants.XSD_ANY, xmlType)) {
            xmlType = Constants.XSD_ANYTYPE;
        }
        if (xmlType == null && (javaType.isArray() || collectionClass.isAssignableFrom(javaType))) {
            xmlType = Constants.SOAP_ARRAY;
        }
        return xmlType;
    }

    static String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return new String(sb);
    }

    public static String getInitialValue(Field field) {
        Block block;
        String value = null;
        if (field.getJavaClass().isPublic() && field.isStatic() && field.isFinal() && (block = field.getInitializer()) != null && ((value = block.getSource()).charAt(0) == '\"' || value.charAt(0) == '\'')) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }
}

