/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultSOAP12TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingBase;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.custom.CustomRegistry;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerSerializerFactory;
import com.ibm.ws.webservices.engine.enumtype.MIMEStyle;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.utils.OptionDescriptor;
import com.ibm.ws.webservices.wsdl.fromJava.BeanWriter;
import com.ibm.ws.webservices.wsdl.fromJava.Namespaces;
import com.ibm.ws.webservices.wsdl.fromJava.Style;
import com.ibm.ws.webservices.wsdl.fromJava.Types;
import com.ibm.ws.webservices.wsdl.fromJava.description.FaultDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.OperationDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.ParameterDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.PortDesc;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.mail.internet.MimeMultipart;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaPackage;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Emitter {
    private static String binaryCopyright = Version.getBinaryCopyright();
    private static final String FUL = "file:undefined_location";
    protected static Log log = LogFactory.getLog(Emitter.class.getName());
    private static OptionDescriptor[] commonOptions = new OptionDescriptor[]{new OptionDescriptor("servicePortName", false, null), new OptionDescriptor("portTypeName", false, null), new OptionDescriptor("bindingName", false, null), new OptionDescriptor("location", false, null), new OptionDescriptor("soapAction", false, null), new OptionDescriptor("style", false, null), new OptionDescriptor("use", false, null), new OptionDescriptor("wrapped", false, null), new OptionDescriptor("verbose", false, null), new OptionDescriptor("debug", false, null), new OptionDescriptor("encodingStyle", false, null), new OptionDescriptor("MIMEStyle", false, null), new OptionDescriptor("intfNS", false, null), new OptionDescriptor("elementFormDefault", false, null), new OptionDescriptor("attributeFormDefault", false, null)};
    public static final int MODE_ALL = 0;
    public static final int MODE_INTERFACE = 1;
    public static final int MODE_IMPLEMENTATION = 2;
    private static final int REQUEST = 0;
    private static final int RESPONSE = 1;
    private static final int FAULT = 2;
    private static final String BINDING_TYPE_HTTP = "http";
    private static final String BINDING_TYPE_DELIMITERS = " ,;";
    private static final String CBP_NS_WSA = "http://www.w3.org/2005/08/addressing";
    private static final String CBP_SL_WSA = "http://www.w3.org/2005/08/addressing/ws-addr.xsd";
    private static final String CBP_NS_WSAW = "http://www.w3.org/2006/05/addressing/wsdl";
    private static final String CBP_SL_WSAW = "http://www.w3.org/2006/05/addressing/wsdl/ws-addr-wsdl.xsd";
    private static final String CBP_NS_WSAW_O = "http://www.w3.org/2006/02/addressing/wsdl";
    private static final String CBP_SL_WSAW_O = "http://www.w3.org/2006/02/addressing/wsdl/ws-addr-wsdl.xsd";
    private static final String CBP_NS_WSRF_R = "http://docs.oasis-open.org/wsrf/r-2";
    private static final String CBP_SL_WSRF_R = "http://docs.oasis-open.org/wsrf/r-2.xsd";
    private static final String CBP_NS_WSRF_RP = "http://docs.oasis-open.org/wsrf/rp-2";
    private static final String CBP_SL_WSRF_RP = "http://docs.oasis-open.org/wsrf/rp-2.xsd";
    private static final String CBP_NS_WSRF_RL = "http://docs.oasis-open.org/wsrf/rl-2";
    private static final String CBP_SL_WSRF_RL = "http://docs.oasis-open.org/wsrf/rl-2.xsd";
    private static final String CBP_NS_WSRF_BF = "http://docs.oasis-open.org/wsrf/bf-2";
    private static final String CBP_SL_WSRF_BF = "http://docs.oasis-open.org/wsrf/bf-2.xsd";
    private static final String CBP_NS_WSRF_SG = "http://docs.oasis-open.org/wsrf/sg-2";
    private static final String CBP_SL_WSRF_SG = "http://docs.oasis-open.org/wsrf/sg-2.xsd";
    private static final String CBP_NS_WSN_B = "http://docs.oasis-open.org/wsn/b-2";
    private static final String CBP_SL_WSN_B = "http://docs.oasis-open.org/wsn/b-2.xsd";
    private static final String CBP_NS_WSN_BR = "http://docs.oasis-open.org/wsn/br-2";
    private static final String CBP_SL_WSN_BR = "http://docs.oasis-open.org/wsn/br-2.xsd";
    private static final String CBP_NS_WSN_T = "http://docs.oasis-open.org/wsn/t-1";
    private static final String CBP_SL_WSN_T = "http://docs.oasis-open.org/wsn/t-1.xsd";
    private static final String CBP_NS_WSAT = "http://schemas.xmlsoap.org/ws/2004/10/wsat";
    private static final String CBP_SL_WSAT = "http://schemas.xmlsoap.org/ws/2004/10/wsat/wsat.xsd";
    private static final String CBP_NS_WSCOOR = "http://schemas.xmlsoap.org/ws/2004/10/wscoor";
    private static final String CBP_SL_WSCOOR = "http://schemas.xmlsoap.org/ws/2004/10/wscoor/wscoor.xsd";
    private static final String CBP_NS_WSBA = "http://schemas.xmlsoap.org/ws/2004/10/wsba";
    private static final String CBP_SL_WSBA = "http://schemas.xmlsoap.org/ws/2004/10/wsba/wsba.xsd";
    protected HashMap ns2Location = new HashMap();
    private String clsString = null;
    private JavaClass cls;
    private ArrayList extraClassesStrings = null;
    private JavaClass[] extraClasses;
    private String implClsString = null;
    private JavaClass implCls;
    private ArrayList stopClasses = new ArrayList();
    private ArrayList methods = null;
    private String intfNS;
    private String implNS;
    private String inputWSDL;
    private String locationUrl;
    private String importUrl;
    private String servicePortName;
    private String serviceElementName;
    private MIMEStyle mimeStyle = MIMEStyle.WSDL11;
    private Style style = Style.DOCUMENT;
    private Use use = null;
    private boolean wrappedSpecified = false;
    private boolean wrapped = true;
    private TypeMapping defaultTM = null;
    private String voidReturn = null;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean removeBinding = false;
    private Namespaces namespaces;
    private Map exceptionMsg = null;
    private boolean elementFormDefault = false;
    private boolean elementFormDefaultOption = false;
    private boolean attributeFormDefault = false;
    private boolean attributeFormDefaultOption = false;
    private String encodingList = null;
    private Types types;
    private String clsName;
    private String portTypeName;
    private String bindingName;
    private ArrayList bindingTypes = null;
    private PortDesc portDesc;
    private PortDesc portDesc2;
    private String soapAction = "DEFAULT";
    private Map commonNSMap = new Hashtable();
    private String classpath = null;
    protected String propertiesFilename = "extraOptions.properties";
    private HashMap validOptions = null;
    protected ToolEnv env = null;
    protected HashMap availableBindingGenerators = new HashMap();
    private ArrayList useBindingGenerators = new ArrayList();
    private Properties XProperties = new Properties();
    private boolean parsed = false;
    private Namespaces editedNamespaces = null;
    private HashMap oldNewNSs = null;
    private Document intfDoc;
    private Document implDoc;
    private String implFileName = null;
    private String intfFileName = null;
    private CustomRegistry customRegistry = null;

    public Emitter() {
        this.namespaces = new Namespaces();
        this.exceptionMsg = new HashMap();
        this.stopClasses.add("javax.ejb.EJBObject");
        this.stopClasses.add("javax.ejb.SessionBean");
        this.stopClasses.add("javax.ejb.EntityBean");
        this.stopClasses.add("javax.ejb.EnterpriseBean");
        this.stopClasses.add("javax.rmi.RemoteException");
        this.initPluggableBindings();
    }

    public void preEmit(String filename1, String filename2) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Definition intf = this.getIntfWSDL();
        Definition impl = this.getImplWSDL();
        if (filename1 == null) {
            filename1 = this.getServicePortName() + "_interface.wsdl";
        }
        if (filename2 == null) {
            filename2 = this.getServicePortName() + "_implementation.wsdl";
        }
        for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
            this.types.writeTypeForPart(this.extraClasses[i], null);
        }
        this.intfDoc = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(intf);
        this.types.insertTypesFragment(this.intfDoc);
        this.intfFileName = filename1;
        this.implDoc = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(impl);
        this.implFileName = filename2;
        this.parsed = true;
    }

    public void emit(String filename1, String filename2) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (!this.parsed) {
            this.preEmit(filename1, filename2);
        }
        this.intfDoc = this.updateNamespacesInDOM(this.intfDoc);
        this.prettyDocumentToFile(this.intfDoc, this.intfFileName);
        this.implDoc = this.updateNamespacesInDOM(this.implDoc);
        this.prettyDocumentToFile(this.implDoc, this.implFileName);
    }

    private void preEmit(String filename, int mode) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.implDoc = this.emit(mode);
        if (filename == null) {
            filename = this.getServicePortName();
            switch (mode) {
                case 0: {
                    filename = filename + ".wsdl";
                    break;
                }
                case 1: {
                    filename = filename + "_interface.wsdl";
                    break;
                }
                case 2: {
                    filename = filename + "_implementation.wsdl";
                }
            }
        }
        this.implFileName = filename;
        this.parsed = true;
    }

    private void emit(String filename, int mode) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (!this.parsed) {
            this.preEmit(filename, mode);
        }
        this.implDoc = this.updateNamespacesInDOM(this.implDoc);
        this.prettyDocumentToFile(this.implDoc, this.implFileName);
    }

    public void preEmit(String filename) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.preEmit(filename, 0);
    }

    public void emit(String filename) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.emit(filename, 0);
    }

    private Document emit(int mode) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document doc = null;
        Definition def = null;
        switch (mode) {
            case 0: {
                def = this.getWSDL();
                for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
                    this.types.writeTypeForPart(this.extraClasses[i], null);
                }
                doc = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(def);
                this.types.insertTypesFragment(doc);
                break;
            }
            case 1: {
                def = this.getIntfWSDL();
                for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
                    this.types.writeTypeForPart(this.extraClasses[i], null);
                }
                doc = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(def);
                this.types.insertTypesFragment(doc);
                break;
            }
            case 2: {
                def = this.getImplWSDL();
                doc = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(def);
            }
        }
        return doc;
    }

    private String emitToString(int mode) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document doc = this.emit(mode);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        XMLUtils.PrettyDocumentToWriter(doc, bw);
        bw.close();
        return sw.getBuffer().toString();
    }

    public Definition getWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(0);
        Definition def = this.createDefinition();
        this.addDefinitionHeader(def, this.intfNS);
        this.types = this.createTypes(def);
        PortType portType = this.addPortType(def);
        this.checkPortType(def, portType);
        for (int i = 0; i < this.useBindingGenerators.size(); ++i) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(i);
            Binding binding = this.addBinding(def, portType, bindingGenerator);
            this.addService(def, binding, bindingGenerator);
        }
        return def;
    }

    public Definition getIntfWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(1);
        Definition def = this.createDefinition();
        this.addDefinitionHeader(def, this.intfNS);
        this.types = this.createTypes(def);
        PortType portType = this.addPortType(def);
        this.checkPortType(def, portType);
        for (int i = 0; i < this.useBindingGenerators.size(); ++i) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(i);
            this.addBinding(def, portType, bindingGenerator);
        }
        return def;
    }

    public Definition getImplWSDL() throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.init(2);
        Definition def = this.createDefinition();
        this.addDefinitionHeader(def, this.implNS);
        this.addImport(def, this.intfNS, this.importUrl);
        for (int i = 0; i < this.useBindingGenerators.size(); ++i) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(i);
            Binding binding = def.createBinding();
            binding.setUndefined(false);
            QName bindingQName = QNameTable.createQName(this.intfNS, bindingGenerator.getBindingName(this.XProperties));
            binding.setQName(bindingQName);
            this.addService(def, binding, bindingGenerator);
        }
        return def;
    }

    private void init(int mode) throws IOException {
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        if (this.classpath != null && this.env instanceof DefaultToolEnv) {
            ((DefaultToolEnv)this.env).setIntrospectionClassPath(this.classpath);
        }
        try {
            this.findCls();
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.fromJava.Emitter.init", "725", this);
            log.error(Messages.getMessage("j2werror00", e.toString()));
            throw new IOException(e.toString());
        }
        try {
            this.findImplCls();
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.fromJava.Emitter.init", "733", this);
            log.error(Messages.getMessage("j2werror00", e.toString()));
            throw new IOException(e.toString());
        }
        try {
            this.findExtraClasses();
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.wsdl.fromJava.Emitter.init", "740", this);
            log.error(Messages.getMessage("j2woptBadClass00", e.toString()));
            throw new IOException(e.toString());
        }
        if (this.voidReturn == null) {
            this.voidReturn = "TWOWAY";
        }
        if (this.use == null) {
            this.use = this.style == Style.RPC ? Use.ENCODED : Use.LITERAL;
        }
        if (this.style == Style.DOCUMENT && this.use == Use.ENCODED) {
            this.env.reportWarning(Messages.getMessage("invalidDocEnc00", this.style.getName(), this.use.getName()));
            this.use = Use.LITERAL;
        }
        if (this.use == Use.ENCODED || this.style == Style.RPC) {
            if (this.wrappedSpecified && this.wrapped) {
                this.env.reportWarning(Messages.getMessage("j2woptBadWrapped00"));
            }
            this.wrapped = false;
        }
        this.initCustomBindingRegistry();
        this.initNs2Location();
        this.defaultTM = this.use == Use.ENCODED ? DefaultSOAP12TypeMappingImpl.getSingleton() : DefaultTypeMappingImpl.getSingleton();
        this.defaultTM = this.mimeTypeMapping((TypeMappingBase)this.defaultTM);
        if (this.bindingTypes == null) {
            this.initBindingTypes();
        }
        if (this.portDesc == null) {
            this.portDesc = new PortDesc(this);
            this.portDesc.setUniqueParamNames(this.style == Style.DOCUMENT && this.use == Use.LITERAL && !this.wrapped);
            this.portDesc.setImplClass(this.cls);
            this.portDesc.setTypeMapping(this.defaultTM);
            this.portDesc.setStopClasses(this.stopClasses);
            this.portDesc.setMethods(this.methods);
            if (this.implCls != null && this.implCls != this.cls && this.portDesc2 == null) {
                this.portDesc2 = new PortDesc(this);
                this.portDesc2.setUniqueParamNames(this.style == Style.DOCUMENT && this.use == Use.LITERAL && !this.wrapped);
                this.portDesc2.setImplClass(this.implCls);
                this.portDesc2.setTypeMapping(this.defaultTM);
                this.portDesc2.setStopClasses(this.stopClasses);
                this.portDesc2.setMethods(this.methods);
            }
        }
        if (this.encodingList == null) {
            this.clsName = this.cls.getName();
            if (this.getPortTypeName() == null) {
                this.setPortTypeName(JavaUtils.java2NCName(this.clsName));
            }
            if (this.getServiceElementName() == null) {
                this.setServiceElementName(this.getPortTypeName() + "Service");
            }
            if (this.getServicePortName() == null) {
                this.initServicePortName();
            }
            this.encodingList = Constants.URI_DEFAULT_SOAP_ENC;
            if (this.intfNS == null) {
                JavaPackage pkg = this.cls.getJavaPackage();
                this.intfNS = this.namespaces.getCreate(pkg == null ? null : pkg.getPackageName());
            }
            if (this.getBindingName() == null) {
                this.setBindingName(this.getServicePortName());
            }
            if (this.implNS == null) {
                int index;
                this.implNS = mode == 0 ? this.intfNS : ((index = this.intfNS.indexOf("://")) > 0 ? this.intfNS.substring(0, index += 3) + "impl." + this.intfNS.substring(index) : this.intfNS + "-impl");
            }
            this.namespaces.put(this.cls.getJavaName(), this.intfNS, "intf");
            this.namespaces.putPrefix(this.implNS, "impl");
        }
        this.initLocation();
        this.seedProperties();
        this.validatePluginOptions();
    }

    private void initCustomBindingRegistry() {
        if (this.customRegistry == null) {
            List customProviders = null;
            try {
                customProviders = this.env.getCustomBindingProviders(this.classpath);
            }
            catch (PrivilegedActionException e) {
                e.printStackTrace();
            }
            if (customProviders != null) {
                this.customRegistry = new CustomRegistry();
                this.customRegistry.populate(customProviders);
            }
        }
    }

    private TypeMapping mimeTypeMapping(TypeMappingBase defaultTM) {
        if (this.mimeStyle == MIMEStyle.SWAREF) {
            defaultTM = new TypeMappingImpl(defaultTM);
            if (JavaUtils.isAttachmentSupported()) {
                defaultTM.register(Image.class, Constants.WSI_SWAREF, new JAFDataHandlerSerializerFactory(Image.class, Constants.WSI_SWAREF), new JAFDataHandlerDeserializerFactory(Image.class, Constants.WSI_SWAREF));
                defaultTM.register(MimeMultipart.class, Constants.WSI_SWAREF, new JAFDataHandlerSerializerFactory(MimeMultipart.class, Constants.WSI_SWAREF), new JAFDataHandlerDeserializerFactory(MimeMultipart.class, Constants.WSI_SWAREF));
                defaultTM.register(Source.class, Constants.WSI_SWAREF, new JAFDataHandlerSerializerFactory(Source.class, Constants.WSI_SWAREF), new JAFDataHandlerDeserializerFactory(Source.class, Constants.WSI_SWAREF));
                defaultTM.register(DataHandler.class, Constants.WSI_SWAREF, new JAFDataHandlerSerializerFactory(DataHandler.class, Constants.WSI_SWAREF), new JAFDataHandlerDeserializerFactory(DataHandler.class, Constants.WSI_SWAREF));
            }
        } else if (this.mimeStyle == MIMEStyle.AXIS) {
            defaultTM = new TypeMappingImpl(defaultTM);
            if (JavaUtils.isAttachmentSupported()) {
                defaultTM.register(DataHandler.class, Constants.MIME_DATA_HANDLER, new JAFDataHandlerSerializerFactory(DataHandler.class, Constants.MIME_DATA_HANDLER), new JAFDataHandlerDeserializerFactory(DataHandler.class, Constants.MIME_DATA_HANDLER));
            }
        }
        return defaultTM;
    }

    private Definition createDefinition() throws WSDLException, SAXException, IOException, ParserConfigurationException {
        Definition def;
        if (this.inputWSDL == null) {
            def = new ServiceProviderManager(null).getWSDLFactory().newDefinition();
        } else {
            WSDLReader reader = new ServiceProviderManager(null).getWSDLFactory().newWSDLReader();
            Document doc = XMLUtils.newDocument(this.inputWSDL);
            def = reader.readWSDL(this.inputWSDL, doc);
            def.setTypes(null);
        }
        return def;
    }

    private Types createTypes(Definition def) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.types = new Types(this, def, this.defaultTM, this.namespaces, this.intfNS, this.stopClasses, this.style, this.use, this.verbose, this.elementFormDefault, this.attributeFormDefault);
        if (this.inputWSDL != null) {
            this.types.loadInputTypes(this.inputWSDL);
        }
        return this.types;
    }

    private void addDefinitionHeader(Definition def, String tns) {
        def.setTargetNamespace(tns);
        def.addNamespace("intf", this.intfNS);
        def.addNamespace("impl", this.implNS);
        def.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
        def.addNamespace("wsi", "http://ws-i.org/profiles/basic/1.1/xsd");
        this.namespaces.putPrefix("http://ws-i.org/profiles/basic/1.1/xsd", "wsi");
        def.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        this.commonNSMap.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        if (this.use != Use.LITERAL) {
            def.addNamespace("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
            this.namespaces.putPrefix(Constants.URI_DEFAULT_SOAP_ENC, "soapenc");
            this.commonNSMap.put("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
        }
        def.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.putPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
        this.commonNSMap.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    Map getCommonNSMap() {
        return this.commonNSMap;
    }

    private void addImport(Definition def, String tns, String loc) {
        Import imp2 = def.createImport();
        imp2.setNamespaceURI(tns);
        if (loc != null && !loc.equals("")) {
            imp2.setLocationURI(loc);
        }
        def.addImport(imp2);
    }

    private PortType addPortType(Definition def) throws WSDLException {
        PortType portType;
        QName portTypeQName = QNameTable.createQName(this.intfNS, this.getPortTypeName());
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "portType", portTypeQName.toString()));
        }
        if ((portType = def.getPortType(portTypeQName)) != null) {
            return portType;
        }
        portType = def.createPortType();
        portType.setUndefined(false);
        portType.setQName(portTypeQName);
        def.addPortType(portType);
        ArrayList operations = this.portDesc.getOperations();
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            OperationDesc[] operSameNameArray;
            OperationDesc thisOper;
            OperationDesc operDesc = thisOper = (OperationDesc)i.next();
            if (this.style == Style.DOCUMENT && this.use == Use.LITERAL && this.wrapped && (operSameNameArray = this.portDesc.getOperationsByName(thisOper.getName())) != null && operSameNameArray.length > 1) {
                this.env.reportFatalErr(Messages.getMessage("DocLitWrappedOverloaded", thisOper.getName()));
            }
            if (this.portDesc2 != null) {
                OperationDesc[] operArray = this.portDesc2.getOperationsByName(thisOper.getName());
                boolean found = false;
                if (operArray != null) {
                    for (int j = 0; j < operArray.length && !found; ++j) {
                        OperationDesc tryOper = operArray[j];
                        if (tryOper.getParameters().size() != thisOper.getParameters().size()) continue;
                        boolean parmsMatch = true;
                        for (int k = 0; k < thisOper.getParameters().size() && parmsMatch; ++k) {
                            if (tryOper.getParameter(k).getMode() == thisOper.getParameter(k).getMode() && tryOper.getParameter(k).getJavaType().equals(thisOper.getParameter(k).getJavaType())) continue;
                            parmsMatch = false;
                        }
                        if (!parmsMatch) continue;
                        operDesc = tryOper;
                        found = true;
                    }
                }
            }
            this.addOperation(def, portType, operDesc);
        }
        return portType;
    }

    private Operation addOperation(Definition def, PortType portType, OperationDesc operDesc) throws WSDLException {
        Operation oper = def.createOperation();
        oper.setName(operDesc.getName());
        oper.setUndefined(false);
        portType.addOperation(oper);
        Message msg = this.addRequestMessage(def, operDesc);
        Input input = def.createInput();
        input.setMessage(msg);
        String name = msg.getQName().getLocalPart();
        input.setName(name);
        oper.setInput(input);
        msg = this.addResponseMessage(def, operDesc);
        Output output = def.createOutput();
        output.setMessage(msg);
        name = msg.getQName().getLocalPart();
        output.setName(name);
        oper.setOutput(output);
        ArrayList exceptions2 = operDesc.getFaults();
        for (int i = 0; exceptions2 != null && i < exceptions2.size(); ++i) {
            FaultDesc faultDesc = (FaultDesc)exceptions2.get(i);
            msg = this.addFaultMessage(def, faultDesc);
            Fault fault = def.createFault();
            fault.setMessage(msg);
            fault.setName(JavaUtils.java2NCName(faultDesc.getJavaClass().getName()));
            oper.addFault(fault);
        }
        ArrayList parameters = operDesc.getParameters();
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < parameters.size(); ++i) {
            ParameterDesc param = (ParameterDesc)parameters.get(i);
            names.add(param.getName());
        }
        if (names.size() > 0 && !this.isWrapped()) {
            oper.setParameterOrdering(names);
        }
        return oper;
    }

    private Message addRequestMessage(Definition def, OperationDesc operDesc) throws WSDLException {
        Message msg = def.createMessage();
        QName qName = this.createMessageName(def, operDesc.getName(), "Request");
        msg.setQName(qName);
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
        }
        msg.setUndefined(false);
        ArrayList parameters = operDesc.getParameters();
        if (this.isWrapped() && parameters.size() == 0) {
            QName wrapperQName = QNameTable.createQName(msg.getQName().getNamespaceURI(), msg.getQName().getLocalPart().substring(0, msg.getQName().getLocalPart().lastIndexOf("Request")));
            if (this.types.writeWrapperForPart(wrapperQName, null, null, false, false)) {
                Part part = def.createPart();
                part.setName("parameters");
                part.setElementName(wrapperQName);
                msg.addPart(part);
            }
        } else {
            for (int i = 0; i < parameters.size(); ++i) {
                ParameterDesc parameter = (ParameterDesc)parameters.get(i);
                this.addPartToMessage(def, msg, 0, parameter);
            }
        }
        def.addMessage(msg);
        return msg;
    }

    private Message addResponseMessage(Definition def, OperationDesc operDesc) throws WSDLException {
        Message msg = def.createMessage();
        QName qName = this.createMessageName(def, operDesc.getName(), "Response");
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
        }
        msg.setQName(qName);
        msg.setUndefined(false);
        JavaHelpers returnClass = operDesc.getReturnClass();
        if (this.isWrapped() && (returnClass == null || returnClass.getJavaName().equals("void"))) {
            this.types.writeWrapperForPart(qName, null, null, false, false);
            Part part = def.createPart();
            part.setName("parameters");
            part.setElementName(qName);
            msg.addPart(part);
        } else {
            ParameterDesc retParam = new ParameterDesc();
            retParam.setName(operDesc.getName() + "Return");
            retParam.setMode((byte)2);
            retParam.setIsReturn(true);
            retParam.setJavaType(operDesc.getReturnClass(), this);
            this.addPartToMessage(def, msg, 1, retParam);
        }
        ArrayList parameters = operDesc.getParameters();
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            ParameterDesc param = (ParameterDesc)i.next();
            this.addPartToMessage(def, msg, 1, param);
        }
        def.addMessage(msg);
        return msg;
    }

    private Message addFaultMessage(Definition def, FaultDesc faultDesc) throws WSDLException {
        String pkg = faultDesc.getJavaClass().getJavaPackage().getName();
        String clsName = JavaUtils.java2NCName(faultDesc.getJavaClass().getName());
        Message msg = (Message)this.exceptionMsg.get(faultDesc.getJavaClass().getJavaName());
        if (msg == null) {
            msg = def.createMessage();
            QName qName = this.createMessageName(def, clsName, "");
            if (this.verbose) {
                this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
            }
            msg.setQName(qName);
            msg.setUndefined(false);
            ParameterDesc parameter = new ParameterDesc(QNameTable.createQName("", "fault"), 1, this.types.getTypeQName(faultDesc.getJavaClass()), faultDesc.getJavaClass(), false, false);
            this.addPartToMessage(def, msg, 2, parameter);
            this.exceptionMsg.put(faultDesc.getJavaClass().getJavaName(), msg);
            def.addMessage(msg);
        }
        return msg;
    }

    public Part addPartToMessage(Definition def, Message msg, int kind, ParameterDesc param) throws WSDLException {
        if (param == null || param != null && param.getJavaType() != null && param.getJavaType().getJavaName().equals("void")) {
            return null;
        }
        if (kind == 2 && param.getMode() != 1) {
            return null;
        }
        if (kind == 0 && param.getMode() == 2) {
            return null;
        }
        if (kind == 1 && param.getMode() == 1) {
            return null;
        }
        Part part = def.createPart();
        JavaHelpers javaType = param.getHeldJavaType(this);
        if (this.isWrapped() && kind != 2) {
            boolean isUnbounded = false;
            JavaHelpers tempJavaType = javaType;
            QName typeQName = this.types.writeTypeForPart(tempJavaType, param.getTypeQName());
            QName wrapperQName = null;
            wrapperQName = kind == 0 ? QNameTable.createQName(msg.getQName().getNamespaceURI(), msg.getQName().getLocalPart().substring(0, msg.getQName().getLocalPart().lastIndexOf("Request"))) : msg.getQName();
            if (typeQName != null && this.types.writeWrapperForPart(wrapperQName, param.getName(), typeQName, isUnbounded, this.types.isNullable(tempJavaType))) {
                part.setName("parameters");
                part.setElementName(wrapperQName);
                msg.addPart(part);
            }
        } else if (this.use == Use.ENCODED || this.style == Style.RPC) {
            QName typeQName = this.types.writeTypeForPart(javaType, param.getTypeQName());
            this.types.writeElementForPart(javaType, param.getTypeQName(), param.getName());
            if (typeQName != null) {
                part.setName(param.getName());
                part.setTypeName(typeQName);
                msg.addPart(part);
            }
        } else if (this.use == Use.LITERAL) {
            QName typeQName = this.types.writeTypeForPart(javaType, param.getTypeQName());
            QName elemQName = this.types.writeElementForPart(javaType, param.getTypeQName(), param.getName());
            if (!BeanWriter.isMIMEType(javaType.getJavaName())) {
                if (elemQName != null) {
                    part.setName(param.getName());
                    part.setElementName(elemQName);
                    msg.addPart(part);
                } else if (typeQName != null) {
                    part.setName(param.getName());
                    part.setTypeName(typeQName);
                    msg.addPart(part);
                }
            } else if (typeQName != null) {
                part.setName(param.getName());
                part.setTypeName(typeQName);
                msg.addPart(part);
            } else if (elemQName != null) {
                part.setName(param.getName());
                part.setElementName(elemQName);
                msg.addPart(part);
            }
        }
        return part;
    }

    private Binding addBinding(Definition def, PortType portType, BindingGenerator bindingGenerator) {
        if (bindingGenerator == null) {
            return null;
        }
        QName bindingQName = QNameTable.createQName(this.intfNS, bindingGenerator.getBindingName(this.XProperties));
        Binding binding = def.getBinding(bindingQName);
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "binding", bindingQName.toString()));
        }
        if (binding != null) {
            this.env.reportWarning(Messages.getMessage("duplicateBinding", bindingQName.toString()));
            return binding;
        }
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "binding", bindingQName.toString()));
        }
        if (bindingGenerator != null) {
            binding = bindingGenerator.makeBinding(def, portType, bindingQName, this.XProperties);
            def.addBinding(binding);
        }
        return binding;
    }

    private void addService(Definition def, Binding binding, BindingGenerator bindingGenerator) {
        QName serviceElementQName = QNameTable.createQName(this.implNS, this.getServiceElementName());
        Service service = def.getService(serviceElementQName);
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "service", serviceElementQName.toString()));
        }
        if (service == null) {
            service = def.createService();
            service.setQName(serviceElementQName);
            def.addService(service);
        }
        Port port = def.createPort();
        port.setBinding(binding);
        if (bindingGenerator != null) {
            ExtensibilityElement address;
            port.setName(bindingGenerator.getPortName(this.XProperties));
            if (this.verbose) {
                this.env.report(Messages.getMessage("j2wGen00", "port", port.getName()));
            }
            if ((address = bindingGenerator.makePortAddress(def, port, this.XProperties)) != null) {
                port.addExtensibilityElement(address);
            }
        }
        service.addPort(port);
    }

    private void checkPortType(Definition def, PortType portType) {
        if (this.voidReturn.equals("TWOWAY")) {
            return;
        }
        if (portType.getOperations() != null) {
            Iterator ops = portType.getOperations().iterator();
            while (ops.hasNext()) {
                Map faults;
                Operation op = (Operation)ops.next();
                if (this.isWrapped()) {
                    OperationDesc opDesc = null;
                    boolean foundMatch = false;
                    ArrayList operations = this.portDesc.getOperations();
                    Iterator i = operations.iterator();
                    while (i.hasNext() && !foundMatch) {
                        OperationDesc tryOpDesc = (OperationDesc)i.next();
                        if (!tryOpDesc.getName().equals(op.getName())) continue;
                        opDesc = tryOpDesc;
                        foundMatch = true;
                    }
                    if (opDesc != null && (opDesc.getReturnClass() == null || opDesc.getReturnClass().getJavaName().equals("void"))) {
                        op.setOutput(null);
                    }
                } else if (op.getOutput() == null || op.getOutput().getMessage() == null || op.getOutput().getMessage().getParts() == null || op.getOutput().getMessage().getParts().size() <= 0) {
                    op.setOutput(null);
                }
                if (op.getOutput() != null || (faults = op.getFaults()) == null || faults.size() <= 0) continue;
                log.warn(Messages.getMessage("j2wonewayfaulterr00", op.getName(), portType.getQName().toString()));
                this.env.reportWarning(Messages.getMessage("j2wonewayfaulterr00", op.getName(), portType.getQName().toString()));
                op.setOutput(null);
                if (faults == null) continue;
                faults.clear();
            }
        }
        if (def.getBindings() != null) {
            Iterator bindings = def.getBindings().values().iterator();
            while (bindings.hasNext()) {
                Binding binding = (Binding)bindings.next();
                if (binding.getPortType() != portType || binding.getBindingOperations() == null) continue;
                Iterator ops = binding.getBindingOperations().iterator();
                while (ops.hasNext()) {
                    BindingOperation op = (BindingOperation)ops.next();
                    if (op.getOperation() == null || op.getOperation().getOutput() != null) continue;
                    Map faults = op.getBindingFaults();
                    if (op.getBindingOutput() == null && (faults == null || faults.size() <= 0)) continue;
                    op.setBindingOutput(null);
                    if (faults == null) continue;
                    faults.clear();
                }
            }
        }
    }

    private QName createMessageName(Definition def, String methodName, String suffix) {
        QName qName = QNameTable.createQName(this.intfNS, methodName.concat(suffix));
        int messageNumber = 1;
        while (def.getMessage(qName) != null) {
            StringBuffer namebuf = new StringBuffer(methodName.concat(suffix));
            namebuf.append(messageNumber);
            qName = QNameTable.createQName(this.intfNS, namebuf.toString());
            ++messageNumber;
        }
        return qName;
    }

    private void prettyDocumentToFile(Document doc, String filename) throws IOException {
        OutputStream os2 = this.env.getOutputStream(filename);
        if (os2 != null) {
            XMLUtils.PrettyDocumentToStream(doc, os2);
            os2.close();
        }
    }

    public void setMIMEStyle(String mimeStyle) {
        this.mimeStyle = MIMEStyle.getMIMEStyle(mimeStyle);
    }

    public void setMIMEStyle(MIMEStyle mimeStyle) {
        this.mimeStyle = mimeStyle;
    }

    public MIMEStyle getMIMEStyle() {
        return this.mimeStyle;
    }

    public void setCls(String className) {
        this.clsString = className;
    }

    private void findCls() throws ClassNotFoundException {
        if (this.clsString != null) {
            this.cls = (JavaClass)this.env.getClassFactory().forName(this.clsString);
            if (this.cls == null) {
                throw new ClassNotFoundException(this.clsString);
            }
        }
    }

    public void setImplCls(String className) {
        this.implClsString = className;
    }

    private void findImplCls() throws ClassNotFoundException {
        if (this.implClsString != null) {
            this.implCls = (JavaClass)this.env.getClassFactory().forName(this.implClsString);
            if (this.implCls == null) {
                throw new ClassNotFoundException(this.implClsString);
            }
        }
    }

    public String getIntfNamespace() {
        return this.intfNS;
    }

    public void setIntfNamespace(String ns) {
        this.intfNS = ns;
    }

    public String getImplNamespace() {
        return this.implNS;
    }

    public void setImplNamespace(String ns) {
        this.implNS = ns;
    }

    public void setStopClasses(ArrayList stopClasses) {
        if (this.stopClasses == null) {
            this.stopClasses = new ArrayList();
        }
        this.stopClasses.addAll(stopClasses);
    }

    public void setStopClasses(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, " ,+");
            if (this.stopClasses == null) {
                this.stopClasses = new ArrayList();
            }
            while (tokenizer.hasMoreTokens()) {
                this.stopClasses.add(tokenizer.nextToken());
            }
        }
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setMethods(ArrayList methods) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        this.methods.addAll(methods);
    }

    public void setMethods(String text) {
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, " ,+");
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            while (tokenizer.hasMoreTokens()) {
                this.methods.add(tokenizer.nextToken());
            }
        }
    }

    public ArrayList getMethods() {
        return this.methods;
    }

    public Map getNamespaceMap() {
        return this.namespaces;
    }

    public void setNamespaceMap(Map map) {
        if (map != null) {
            this.namespaces.putAll(map);
        }
    }

    public HashMap getPkg2NSMap() {
        return this.namespaces;
    }

    public void setPkg2NSMap(HashMap map) {
        if (map != null) {
            this.editedNamespaces = new Namespaces();
            this.editedNamespaces.putAll((Map)map);
        }
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String inputWSDL) {
        this.inputWSDL = inputWSDL;
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }

    public void setLocationUrl(String locationUrl) {
        this.locationUrl = locationUrl;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String importUrl) {
        this.importUrl = importUrl;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String servicePortName) {
        this.servicePortName = servicePortName;
    }

    public String getServiceElementName() {
        return this.serviceElementName;
    }

    public void setServiceElementName(String serviceElementName) {
        this.serviceElementName = serviceElementName;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public void setBindingTypes(String btypes) {
        this.bindingTypes = new ArrayList();
        this.useBindingGenerators.clear();
        if (btypes != null) {
            StringTokenizer st = new StringTokenizer(btypes, BINDING_TYPE_DELIMITERS);
            while (st.hasMoreTokens()) {
                String thisToken = st.nextToken();
                BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(thisToken);
                if (bindingGenerator == null) {
                    this.env.reportFatalErr(Messages.getMessage("noGenerator", thisToken));
                    continue;
                }
                this.addBindingGenerator(bindingGenerator);
                this.bindingTypes.add(thisToken);
                if (!this.verbose) continue;
                this.env.report(Messages.getMessage("foundGenerator", thisToken));
            }
        }
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String value) {
        this.soapAction = value;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(String value) {
        this.style = Style.getStyle(value);
    }

    public void setStyle(Style value) {
        this.style = value;
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(String value) {
        this.use = Use.getUse(value);
    }

    public void setUse(Use value) {
        this.use = value;
    }

    public void setWrapped(boolean value) {
        this.wrappedSpecified = true;
        this.wrapped = value;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setTransport(String value) {
        if (value == null || value.length() == 0) {
            value = BINDING_TYPE_HTTP;
        }
        this.setBindingTypes(value);
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setElementFormDefault(boolean value) {
        this.elementFormDefault = value;
    }

    public boolean getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefaultOption(boolean value) {
        this.elementFormDefaultOption = value;
    }

    public boolean getElementFormDefaultOption() {
        return this.elementFormDefaultOption;
    }

    public void setAttributeFormDefault(boolean value) {
        this.attributeFormDefault = value;
    }

    public boolean getAttributeFormDefault() {
        return this.attributeFormDefault;
    }

    public void setAttributeFormDefaultOption(boolean value) {
        this.attributeFormDefaultOption = value;
    }

    public boolean getAttributeFormDefaultOption() {
        return this.attributeFormDefaultOption;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setToolEnv(ToolEnv env) {
        this.env = env;
    }

    public ToolEnv getToolEnv() {
        return this.env;
    }

    public void setVoidReturn(String arg) {
        if (arg.equalsIgnoreCase("ONEWAY")) {
            this.voidReturn = "ONEWAY";
        } else if (arg.equalsIgnoreCase("TWOWAY")) {
            this.voidReturn = "TWOWAY";
        } else {
            log.error(Messages.getMessage("j2voidreturnerr00"));
            this.env.reportFatalErr(Messages.getMessage("j2wvoidreturnerr00"));
        }
    }

    public void setExtraClasses(String text) {
        boolean startNewIndex = false;
        if (text != null) {
            if (this.extraClassesStrings == null) {
                this.extraClassesStrings = new ArrayList();
            }
            StringTokenizer tokenizer = new StringTokenizer(text, " ,");
            while (tokenizer.hasMoreTokens()) {
                String clsName = tokenizer.nextToken();
                this.extraClassesStrings.add(clsName);
            }
        }
    }

    private void findExtraClasses() throws ClassNotFoundException {
        if (this.extraClassesStrings != null) {
            JavaClass c;
            JavaClass[] ec;
            ArrayList<JavaClass> clsList = new ArrayList<JavaClass>();
            for (int i = 0; i < this.extraClassesStrings.size(); ++i) {
                String clsName = (String)this.extraClassesStrings.get(i);
                JavaClass cls = (JavaClass)this.env.getClassFactory().forName(clsName);
                if (cls == null) {
                    throw new ClassNotFoundException(clsName);
                }
                clsList.add(cls);
            }
            int startNewIndex = 0;
            if (this.extraClasses != null) {
                ec = new JavaClass[clsList.size() + this.extraClasses.length];
                for (int i = 0; i < this.extraClasses.length; ++i) {
                    ec[i] = c = this.extraClasses[i];
                }
                startNewIndex = this.extraClasses.length;
            } else {
                ec = new JavaClass[clsList.size()];
            }
            for (int i = 0; i < clsList.size(); ++i) {
                ec[i + startNewIndex] = c = (JavaClass)clsList.get(i);
            }
            this.extraClasses = ec;
        }
    }

    public void setPropertiesFile(String filename) throws ClassNotFoundException {
        if (filename != null) {
            this.propertiesFilename = filename;
        }
        try {
            Properties extraOptions = new Properties();
            extraOptions.load(this.env.getInputStream(this.propertiesFilename));
            int hasMoreThanExtraClasses = 0;
            if (extraOptions.size() > 0) {
                String value = null;
                value = extraOptions.getProperty("extraClasses");
                if (value != null) {
                    this.setExtraClasses(value);
                    hasMoreThanExtraClasses = 1;
                }
                if (extraOptions.size() > hasMoreThanExtraClasses) {
                    this.setXProperties(extraOptions);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Document updateNamespacesInDOM(Document DOM) {
        if (this.editedNamespaces != null && !this.editedNamespaces.isEmpty()) {
            this.oldNewNSs = new HashMap();
            Iterator i = this.editedNamespaces.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String newPkg = (String)entry.getKey();
                String newNS = (String)entry.getValue();
                String oldNS = (String)this.namespaces.get(newPkg);
                if (oldNS == null || oldNS.equals(newNS)) continue;
                this.oldNewNSs.put(oldNS, newNS);
            }
            if (this.oldNewNSs != null && !this.oldNewNSs.isEmpty()) {
                this.walkDOM(DOM);
            }
        }
        return DOM;
    }

    private void walkDOM(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                Document document = (Document)node;
                this.walkDOM(document.getDocumentElement());
                break;
            }
            case 1: {
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String newNS;
                        Node attrNode = attrs.item(i);
                        String attrName = attrNode.getNodeName();
                        String attrValue = attrNode.getNodeValue();
                        if (attrName == null || attrValue == null || !attrName.equals("targetNamespace") && !attrName.equals("namespace") && !attrName.equals("xmlns") && !attrName.startsWith("xmlns:") || (newNS = (String)this.oldNewNSs.get(attrValue)) == null) continue;
                        attrNode.setNodeValue(newNS);
                    }
                }
            }
            case 5: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.walkDOM(child);
                }
                break;
            }
        }
    }

    public void setClasspath(String value) {
        this.classpath = value;
    }

    public String getClasspath() {
        return this.classpath;
    }

    private void initLocation() {
        if (this.locationUrl == null) {
            this.locationUrl = FUL;
            if (this.bindingTypes.size() == 1) {
                if (this.XProperties.getProperty(this.bindingTypes.get(0) + ".location") == null) {
                    this.env.reportWarning(Messages.getMessage("java2wsdl.UndefinedLocation", FUL));
                }
            } else {
                for (int i = 0; i < this.bindingTypes.size(); ++i) {
                    if (this.XProperties.getProperty(this.bindingTypes.get(i) + ".location") != null) continue;
                    this.env.reportWarning(Messages.getMessage("missingLocation", (String)this.bindingTypes.get(i), FUL));
                }
            }
        } else if (this.bindingTypes.size() > 1) {
            this.locationUrl = FUL;
            this.env.reportWarning(Messages.getMessage("genericLocation"));
        }
    }

    private void initServicePortName() {
        if (this.getServicePortName() == null) {
            String name = this.getLocationUrl();
            if (name != null) {
                if ((name = name.lastIndexOf(47) > 0 ? name.substring(name.lastIndexOf(47) + 1) : (name.lastIndexOf(92) > 0 ? name.substring(name.lastIndexOf(92) + 1) : null)) != null && name.endsWith(".jws")) {
                    name = name.substring(0, name.length() - ".jws".length());
                }
                if (name != null && name.length() > 0) {
                    name = Character.isUpperCase(name.charAt(0)) ? JavaUtils.xmlNameToJavaClass(name) : JavaUtils.xmlNameToJava(name);
                }
            }
            if ((name == null || name.equals("")) && Character.isLowerCase((name = JavaUtils.java2NCName(this.clsName)).charAt(0))) {
                JavaUtils.capitalizeFirstChar(name);
            }
            this.setServicePortName(name);
        }
    }

    private void initBindingTypes() throws IOException {
        if (this.bindingTypes == null) {
            this.bindingTypes = new ArrayList();
            this.bindingTypes.add(BINDING_TYPE_HTTP);
            BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(BINDING_TYPE_HTTP);
            if (bindingGenerator != null) {
                this.addBindingGenerator(bindingGenerator);
            } else {
                throw new IOException(Messages.getMessage("noGenerator", BINDING_TYPE_HTTP));
            }
        }
    }

    protected void initPluggableBindings() {
        ServiceProviderManager spm = new ServiceProviderManager(null);
        Iterator i = spm.getAllServiceProviders();
        while (i.hasNext()) {
            ServiceProvider serviceProvider = (ServiceProvider)i.next();
            BindingGenerator[] bindingGenerators = serviceProvider.getBindingGenerators();
            if (bindingGenerators == null) continue;
            for (int j = 0; j < bindingGenerators.length; ++j) {
                if (this.verbose) {
                    this.env.report(Messages.getMessage("foundGenerator", bindingGenerators[j].getBindingTypeName()));
                }
                this.availableBindingGenerators.put(bindingGenerators[j].getBindingTypeName(), bindingGenerators[j]);
            }
        }
    }

    public void addBindingGenerator(BindingGenerator bindingGenerator) {
        this.useBindingGenerators.add(bindingGenerator);
    }

    public ArrayList getAvailableBindingGeneratorsTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = this.availableBindingGenerators.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (name == null || name.equals("")) continue;
            list.add(name);
        }
        return list;
    }

    public void setXProperties(String text) {
        if (text != null) {
            StringTokenizer tupleTokenizer = new StringTokenizer(text, BINDING_TYPE_DELIMITERS);
            while (tupleTokenizer.hasMoreTokens()) {
                String tuple = tupleTokenizer.nextToken();
                int equals = tuple.indexOf(61);
                if (equals == -1) {
                    this.XProperties.setProperty(tuple, "");
                    continue;
                }
                this.XProperties.setProperty(tuple.substring(0, equals), tuple.substring(equals + 1));
            }
        }
    }

    public void setXProperties(Properties extraOptions) {
        this.makeValidOptions();
        Iterator iter = this.validOptions.values().iterator();
        while (iter.hasNext()) {
            OptionDescriptor optionDesc = (OptionDescriptor)iter.next();
            if (!extraOptions.containsKey(optionDesc.getName()) || this.XProperties.containsKey(optionDesc.getName())) continue;
            this.XProperties.setProperty(optionDesc.getName(), (String)extraOptions.get(optionDesc.getName()));
        }
    }

    public Properties getXProperties() {
        return this.XProperties;
    }

    private void seedProperties() {
        this.XProperties.setProperty("servicePortName", this.getServicePortName());
        this.XProperties.setProperty("portTypeName", this.getPortTypeName());
        this.XProperties.setProperty("bindingName", this.getBindingName());
        this.XProperties.setProperty("location", this.getLocationUrl());
        this.XProperties.setProperty("soapAction", this.getSoapAction());
        this.XProperties.setProperty("style", this.getStyle().toString().toLowerCase());
        this.XProperties.setProperty("use", this.getUse().toString());
        this.XProperties.setProperty("wrapped", this.isWrapped() ? "true" : "false");
        this.XProperties.setProperty("verbose", this.verbose ? "true" : "false");
        this.XProperties.setProperty("debug", this.debug ? "true" : "false");
        this.XProperties.setProperty("encodingStyle", this.encodingList);
        this.XProperties.setProperty("MIMEStyle", this.getMIMEStyle().toString());
        this.XProperties.setProperty("intfNS", this.intfNS);
        if (this.verbose) {
            this.env.report(Messages.getMessage("bsProps1", this.XProperties.toString()));
        }
    }

    public String getPluggableHelpInfo() {
        StringBuffer returnString = new StringBuffer();
        Iterator it = this.availableBindingGenerators.keySet().iterator();
        while (it.hasNext()) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(it.next());
            OptionDescriptor[] odList = bindingGenerator.getOptionDescriptors();
            if (odList == null) continue;
            returnString.append("\n    ");
            returnString.append(Messages.getMessage("bsProps2", bindingGenerator.getBindingTypeName()));
            returnString.append("\n");
            for (int i = 0; i < odList.length; ++i) {
                String optionName = odList[i].getName();
                String optionDesc = odList[i].getDescription();
                returnString.append("        ");
                returnString.append(optionName);
                returnString.append("\n");
                returnString.append("            ");
                returnString.append(optionDesc == null ? "" : optionDesc);
                returnString.append("\n");
            }
        }
        return returnString.toString();
    }

    private void makeValidOptions() {
        if (this.validOptions == null) {
            int i;
            this.validOptions = new HashMap();
            for (i = 0; i < commonOptions.length; ++i) {
                this.validOptions.put(commonOptions[i].getName(), commonOptions[i]);
            }
            for (i = 0; i < this.useBindingGenerators.size(); ++i) {
                BindingGenerator bg = (BindingGenerator)this.useBindingGenerators.get(i);
                OptionDescriptor[] odList = bg.getOptionDescriptors();
                if (odList == null) continue;
                for (int j = 0; j < odList.length; ++j) {
                    this.validOptions.put(odList[j].getName(), odList[j]);
                }
            }
        }
    }

    private void validatePluginOptions() throws IOException {
        this.makeValidOptions();
        int numErrors = 0;
        Enumeration<?> propNames = this.XProperties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            OptionDescriptor od = (OptionDescriptor)this.validOptions.get(propName);
            if (od != null) continue;
            ++numErrors;
            if (propName.equalsIgnoreCase("jms.location")) {
                this.env.reportFatalErr(Messages.getMessage("jms.location.error", propName));
            }
            if (propName.equalsIgnoreCase("http.location")) {
                this.env.reportFatalErr(Messages.getMessage("http.location.error", propName));
            }
            if (!propName.equalsIgnoreCase("ejb.location")) continue;
            this.env.reportFatalErr(Messages.getMessage("ejb.location.error", propName));
        }
        Iterator iter = this.validOptions.values().iterator();
        while (iter.hasNext()) {
            OptionDescriptor optionDesc = (OptionDescriptor)iter.next();
            if (!optionDesc.isRequired() || this.XProperties.containsKey(optionDesc.getName())) continue;
            this.env.reportFatalErr(Messages.getMessage("missingRequiredProperty", optionDesc.getName()));
            ++numErrors;
        }
        String value = this.XProperties.getProperty("elementFormDefault");
        if (value != null) {
            if (value.equalsIgnoreCase("QUALIFIED") || value.equalsIgnoreCase("TRUE")) {
                this.setElementFormDefault(true);
                this.setElementFormDefaultOption(true);
            } else if (value.equalsIgnoreCase("UNQUALIFIED") || value.equalsIgnoreCase("FALSE")) {
                this.setElementFormDefault(false);
                this.setElementFormDefaultOption(true);
            } else {
                this.setElementFormDefaultOption(false);
                this.env.reportWarning(Messages.getMessage("j2wInvalidElementFormDefaultArg00", value));
            }
        }
        if ((value = this.XProperties.getProperty("attributeFormDefault")) != null) {
            if (value.equalsIgnoreCase("QUALIFIED") || value.equalsIgnoreCase("TRUE")) {
                this.setAttributeFormDefault(true);
                this.setAttributeFormDefaultOption(true);
            } else if (value.equalsIgnoreCase("UNQUALIFIED") || value.equalsIgnoreCase("FALSE")) {
                this.setAttributeFormDefault(false);
                this.setAttributeFormDefaultOption(true);
            } else {
                this.setAttributeFormDefaultOption(false);
                this.env.reportWarning(Messages.getMessage("j2wInvalidAttributeFormDefaultArg00", value));
            }
        }
        if (numErrors > 0) {
            throw new IOException(Messages.getMessage("propValidationError"));
        }
    }

    JavaClass getSEIClass() {
        return this.cls;
    }

    JavaClass getImplClass() {
        return this.implCls;
    }

    public CustomRegistry getCustomRegistry() {
        return this.customRegistry;
    }

    public void setCustomRegistry(CustomRegistry registry) {
        this.customRegistry = registry;
    }

    private void initNs2Location() {
        this.setNs2Location(CBP_NS_WSA, CBP_SL_WSA);
        this.setNs2Location(CBP_NS_WSAW, CBP_SL_WSAW);
        this.setNs2Location(CBP_NS_WSAW_O, CBP_SL_WSAW_O);
        this.setNs2Location(CBP_NS_WSRF_R, CBP_SL_WSRF_R);
        this.setNs2Location(CBP_NS_WSRF_RP, CBP_SL_WSRF_RP);
        this.setNs2Location(CBP_NS_WSRF_RL, CBP_SL_WSRF_RL);
        this.setNs2Location(CBP_NS_WSRF_BF, CBP_SL_WSRF_BF);
        this.setNs2Location(CBP_NS_WSRF_SG, CBP_SL_WSRF_SG);
        this.setNs2Location(CBP_NS_WSAT, CBP_SL_WSAT);
        this.setNs2Location(CBP_NS_WSCOOR, CBP_SL_WSCOOR);
        this.setNs2Location(CBP_NS_WSBA, CBP_SL_WSBA);
        this.setNs2Location(CBP_NS_WSN_B, CBP_SL_WSN_B);
        this.setNs2Location(CBP_NS_WSN_BR, CBP_SL_WSN_BR);
        this.setNs2Location(CBP_NS_WSN_T, CBP_SL_WSN_T);
    }

    public void setNs2Location(String ns, String sl) {
        this.ns2Location.put(ns, sl);
    }

    public String getNs2Location(String ns) {
        return (String)this.ns2Location.get(ns);
    }
}

