/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.extensions.agnostic;

import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.extensions.models.ModelExtensibilityElement;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;

public class AgnosticAddress
extends ModelExtensibilityElement {
    protected String urlProtocol;
    protected String urlHost;
    protected String urlPath;
    protected String urlQuery;
    protected Map urlQueryProperties;
    protected static final String LOCATION_ATTRIBUTE = "location";
    protected static final String URL_QUERY_PROPERTY_DELIMITERS = "|&";
    public static final QName AGNOSTIC_ADDRESS_ELEMENT_QNAME = QNameTable.createQName("http://www.ibm.com/ns/2003/06/wsdl/mp", "address");

    public AgnosticAddress() {
        super(Port.class, AGNOSTIC_ADDRESS_ELEMENT_QNAME);
    }

    protected String[] getAttributeNames() {
        return new String[]{LOCATION_ATTRIBUTE};
    }

    public void setLocationURI(String locationURI) {
        this.setAttribute(LOCATION_ATTRIBUTE, locationURI);
        this.urlProtocol = null;
        this.urlHost = null;
        this.urlPath = null;
        this.urlQuery = null;
        this.urlQueryProperties = null;
    }

    public String getLocationURI() {
        String location = this.getAttribute(LOCATION_ATTRIBUTE);
        return location;
    }

    public String getURLProtocol() throws WSDLException {
        String locationURI = this.getLocationURI();
        if (this.urlProtocol == null && locationURI != null) {
            int protocolEnd = locationURI.indexOf(58);
            if (protocolEnd < 1) {
                throw new WSDLException("INVALID_WSDL", Messages.getMessage((String)"invalidUrlProtocol", (String)locationURI));
            }
            this.urlProtocol = locationURI.substring(0, protocolEnd);
        }
        return this.urlProtocol;
    }

    public String getURLHost() throws WSDLException {
        String locationURI = this.getLocationURI();
        if (this.urlHost == null && locationURI != null) {
            String protocol = this.getURLProtocol();
            int urlHostStart = protocol.length() + 2;
            int urlHostEnd = locationURI.indexOf(47, urlHostStart);
            int queryStart = locationURI.indexOf(63);
            if (urlHostEnd > -1 && urlHostEnd < queryStart) {
                this.urlHost = locationURI.substring(urlHostStart, urlHostEnd);
            } else {
                this.urlHost = locationURI.substring(urlHostStart);
                queryStart = this.urlHost.indexOf(63);
                if (queryStart > -1) {
                    this.urlHost = this.urlHost.substring(0, queryStart);
                }
            }
        }
        return this.urlHost;
    }

    public String getURLPath() throws WSDLException {
        String locationURI = this.getLocationURI();
        if (this.urlPath == null && locationURI != null) {
            int urlPathEnd;
            int urlPathStart;
            String host = this.getURLHost();
            if (host.length() == 0) {
                String protocol = this.getURLProtocol();
                urlPathStart = protocol.length() + 3;
            } else {
                urlPathStart = locationURI.indexOf(host) + host.length() + 1;
            }
            this.urlPath = urlPathStart > locationURI.length() || locationURI.charAt(urlPathStart - 1) == '?' ? "" : ((urlPathEnd = locationURI.indexOf(63, urlPathStart)) > -1 ? locationURI.substring(urlPathStart, urlPathEnd) : locationURI.substring(urlPathStart));
        }
        return this.urlPath;
    }

    public String getURLQuery() throws WSDLException {
        String locationURI = this.getLocationURI();
        if (this.urlQuery == null && locationURI != null) {
            this.getURLPath();
            int urlQueryStart = locationURI.indexOf(63) + 1;
            this.urlQuery = urlQueryStart > 0 ? locationURI.substring(urlQueryStart) : "";
        }
        return this.urlQuery;
    }

    public Map getURLQueryProperties() throws WSDLException {
        if (this.urlQueryProperties == null && this.getLocationURI() != null) {
            this.urlQueryProperties = new HashMap();
            String query = this.getURLQuery();
            if (query.length() > 0) {
                StringTokenizer st = new StringTokenizer(query, URL_QUERY_PROPERTY_DELIMITERS);
                while (st.hasMoreTokens()) {
                    String property = st.nextToken();
                    int delim = property.indexOf(61);
                    if (delim < 1) {
                        throw new WSDLException("INVALID_WSDL", Messages.getMessage((String)"missingEquals", (String)this.getLocationURI()));
                    }
                    String name = property.substring(0, delim);
                    String value = delim == property.length() ? "" : property.substring(delim + 1);
                    this.urlQueryProperties.put(name, value);
                }
            }
        }
        return this.urlQueryProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        String locationURI = this.getLocationURI();
        if (locationURI != null) {
            sb.append("\n   url protocol=").append(this.urlProtocol);
            sb.append("\n   url host=").append(this.urlHost);
            sb.append("\n   url path=").append(this.urlPath);
            sb.append("\n   url query=").append(this.urlQuery);
            sb.append("\n");
        }
        return sb.toString();
    }
}

