/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.modutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessor;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessorDD13;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessorEJB;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessorWeb;
import com.ibm.wsspi.webservices.models.WSModels;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class ModuleServiceRefAccessorFactory {
    private static final TraceComponent _tc = Tr.register(ModuleServiceRefAccessorFactory.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");

    public static ModuleServiceRefAccessor createModuleServiceRefAccessorWeb(ResourceSet resourceSet, String moduleName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createModuleServiceRefAccessorWeb");
        }
        ModuleServiceRefAccessor moduleServiceRefAccessor = null;
        if (resourceSet != null) {
            WebApp webApp;
            String webAppUri = "WEB-INF/web.xml";
            if (moduleName != null) {
                webAppUri = moduleName + "/" + webAppUri;
            }
            if ((webApp = ModuleServiceRefAccessorFactory.getWebApp(resourceSet, webAppUri)) != null) {
                int version = webApp.getJ2EEVersionID();
                if (version < 14) {
                    String uriName = "WEB-INF/webservicesclient.xml";
                    if (moduleName != null) {
                        uriName = moduleName + "/" + uriName;
                    }
                    moduleServiceRefAccessor = new ModuleServiceRefAccessorDD13(resourceSet, uriName);
                } else {
                    moduleServiceRefAccessor = new ModuleServiceRefAccessorWeb(webApp);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createModuleServiceRefAccessorWeb");
        }
        return moduleServiceRefAccessor;
    }

    public static ModuleServiceRefAccessor createModuleServiceRefAccessorEJB(ResourceSet resourceSet, String moduleName, String enterpriseBean) {
        ModuleServiceRefAccessor moduleServiceRefAccessor = null;
        if (resourceSet != null) {
            EJBJar ejbJar;
            String ejbJarUri = "META-INF/ejb-jar.xml";
            if (moduleName != null) {
                ejbJarUri = moduleName + "/" + ejbJarUri;
            }
            if ((ejbJar = ModuleServiceRefAccessorFactory.getEJBJar(resourceSet, ejbJarUri)) != null) {
                int version = ejbJar.getJ2EEVersionID();
                if (version < 14) {
                    String uriName = "META-INF/webservicesclient.xml";
                    if (moduleName != null) {
                        uriName = moduleName + "/" + uriName;
                    }
                    moduleServiceRefAccessor = new ModuleServiceRefAccessorDD13(resourceSet, uriName, enterpriseBean);
                } else {
                    moduleServiceRefAccessor = new ModuleServiceRefAccessorEJB(ejbJar, enterpriseBean);
                }
            }
        }
        return moduleServiceRefAccessor;
    }

    private static EJBJar getEJBJar(ResourceSet resourceSet, String ejbJarUri) {
        EJBJar ejbJar = null;
        if (resourceSet != null && ejbJarUri != null) {
            try {
                ejbJar = WSModels.getEJBJarFromResourceSet(resourceSet, ejbJarUri);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.modutils.ModuleServiceRefAccessorFactory.getEJBJar", "138");
            }
        }
        return ejbJar;
    }

    private static WebApp getWebApp(ResourceSet resourceSet, String webAppUri) {
        WebApp webApp = null;
        if (resourceSet != null && webAppUri != null) {
            try {
                webApp = WSModels.getWebAppFromResourceSet(resourceSet, webAppUri);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.modutils.ModuleServiceRefAccessorFactory.getWebApp", "160");
            }
        }
        return webApp;
    }
}

