/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.IgnoreSoapBodyException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.utils.WebServicesParserFactory;
import com.ibm.ws.webservices.utils.BAIS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class WebServicesParser
extends SAXParser {
    protected static Log log = LogFactory.getLog(WebServicesParser.class.getName());
    protected WebServicesParserFactory parserFactory;
    protected SAXParser saxParser;
    protected Exception parseException = null;
    protected int parserUsageCounter = 0;

    WebServicesParser(WebServicesParserFactory parserFactory, final SAXParserFactory saxParserFactory) throws ParserConfigurationException, SAXException, Exception {
        this.parserFactory = parserFactory;
        try {
            this.saxParser = (SAXParser)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ParserConfigurationException, SAXException {
                    return saxParserFactory.newSAXParser();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        this.saxParser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        if (log.isDebugEnabled()) {
            log.debug("WebSphere - XLXP Parser: " + (String)this.saxParser.getProperty("http://ibm.com/xlxp/properties/build-time-stamp"));
        }
    }

    public void recycle() {
        boolean pushed;
        try {
            if (this.saxParser.getXMLReader() == null) {
                return;
            }
        }
        catch (SAXException e) {
            log.debug("saxParser.getXMLReader exception:" + e);
            return;
        }
        if (this.parseException == null && !(pushed = this.parserFactory.recycle(this))) {
            try {
                this.saxParser.getXMLReader().setContentHandler(null);
                this.saxParser.getXMLReader().setEntityResolver(null);
                this.saxParser.getXMLReader().setErrorHandler(null);
                this.saxParser.getXMLReader().setDTDHandler(null);
            }
            catch (SAXException e) {
                log.debug("saxParser.getXMLReader exception:" + e);
                return;
            }
        }
        this.parseException = null;
    }

    public void parse(InputStream is, HandlerBase handlerBase) throws SAXException, IOException {
        try {
            this.setLexicalHandler(handlerBase);
            this.saxParser.parse(is, handlerBase);
        }
        catch (IgnoreSoapBodyException e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
            }
        }
        catch (SAXException e) {
            this.parseException = e;
            throw e;
        }
        catch (IOException e) {
            this.parseException = e;
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream is, HandlerBase handlerBase, String value) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(handlerBase);
                this.saxParser.parse(is, handlerBase, value);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var6_5 = null;
                this.resetLexicalHandler(handlerBase);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.resetLexicalHandler(handlerBase);
            throw throwable;
        }
        this.resetLexicalHandler(handlerBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream is, DefaultHandler defaultHandler) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(defaultHandler);
                this.saxParser.parse(is, defaultHandler);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var5_4 = null;
                this.resetLexicalHandler(defaultHandler);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetLexicalHandler(defaultHandler);
            throw throwable;
        }
        this.resetLexicalHandler(defaultHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream is, DefaultHandler defaultHandler, String value) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(defaultHandler);
                this.saxParser.parse(is, defaultHandler, value);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var6_5 = null;
                this.resetLexicalHandler(defaultHandler);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.resetLexicalHandler(defaultHandler);
            throw throwable;
        }
        this.resetLexicalHandler(defaultHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(String text, HandlerBase handlerBase) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(handlerBase);
                this.saxParser.parse(text, handlerBase);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var5_4 = null;
                this.resetLexicalHandler(handlerBase);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetLexicalHandler(handlerBase);
            throw throwable;
        }
        this.resetLexicalHandler(handlerBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(String text, DefaultHandler defaultHandler) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(defaultHandler);
                this.saxParser.parse(text, defaultHandler);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var5_4 = null;
                this.resetLexicalHandler(defaultHandler);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetLexicalHandler(defaultHandler);
            throw throwable;
        }
        this.resetLexicalHandler(defaultHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(File file, HandlerBase handlerBase) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(handlerBase);
                this.saxParser.parse(file, handlerBase);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var5_4 = null;
                this.resetLexicalHandler(handlerBase);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetLexicalHandler(handlerBase);
            throw throwable;
        }
        this.resetLexicalHandler(handlerBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(File file, DefaultHandler defaultHandler) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(defaultHandler);
                this.saxParser.parse(file, defaultHandler);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var5_4 = null;
                this.resetLexicalHandler(defaultHandler);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetLexicalHandler(defaultHandler);
            throw throwable;
        }
        this.resetLexicalHandler(defaultHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputSource inputSource, HandlerBase handlerBase) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(handlerBase);
                this.saxParser.parse(inputSource, handlerBase);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var5_4 = null;
                this.resetLexicalHandler(handlerBase);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetLexicalHandler(handlerBase);
            throw throwable;
        }
        this.resetLexicalHandler(handlerBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        try {
            try {
                this.setLexicalHandler(defaultHandler);
                this.saxParser.parse(inputSource, defaultHandler);
            }
            catch (IgnoreSoapBodyException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught IgnoreSoapBodyException; bypassing parse of SOAP body.");
                }
                Object var5_4 = null;
                this.resetLexicalHandler(defaultHandler);
                return;
            }
            catch (SAXException e) {
                this.parseException = e;
                throw e;
            }
            catch (IOException e) {
                this.parseException = e;
                throw e;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetLexicalHandler(defaultHandler);
            throw throwable;
        }
        this.resetLexicalHandler(defaultHandler);
    }

    public InputStream getSubTreeAsStream() throws SAXException {
        if (this.saxParser == null) {
            return null;
        }
        try {
            InputStream is = null;
            try {
                is = (InputStream)this.saxParser.getProperty("http://ibm.com/xlxp/properties/subtree-as-stream");
            }
            catch (SAXException se) {
                is = (InputStream)this.saxParser.getProperty("http://w3.xml.ibm.com/b2b/properties/subtree-as-stream");
            }
            if (is != null) {
                try {
                    byte[] buf = new byte[is.available()];
                    is.read(buf);
                    is.close();
                    if (log.isDebugEnabled()) {
                        String contents = new String(buf);
                        log.debug("lazy parsed contents:" + contents);
                    }
                    is = BAIS.create((byte[])buf);
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.utils.Parser.getSubTreeAsStream", "244", this);
                    throw new SAXException(e);
                }
            }
            return is;
        }
        catch (SAXException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.utils.Parser", "250", this);
            return null;
        }
    }

    private void setLexicalHandler(Object handler) throws SAXException {
        if (handler instanceof LexicalHandler) {
            this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
    }

    private void resetLexicalHandler(Object handler) throws SAXException {
        if (handler instanceof P2DConverter) {
            ((P2DConverter)handler).release();
        }
        if (handler instanceof LexicalHandler) {
            this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", null);
        }
    }

    public Parser getParser() throws SAXException {
        return this.saxParser.getParser();
    }

    public XMLReader getXMLReader() throws SAXException {
        return this.saxParser.getXMLReader();
    }

    public boolean isNamespaceAware() {
        return this.saxParser.isNamespaceAware();
    }

    public boolean isValidating() {
        return this.saxParser.isValidating();
    }

    public void setProperty(String property, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.saxParser.setProperty(property, value);
    }

    public Object getProperty(String property) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.saxParser.getProperty(property);
    }

    public int getUsageCounter() {
        return this.parserUsageCounter;
    }

    public void incrementUsageCounter() {
        ++this.parserUsageCounter;
    }
}

